/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import java.util.Objects;
import jp.ne.sk_mine.util.andr_applet.DummyScroll;
import jp.ne.sk_mine.util.andr_applet.Restorer;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMCheckBox;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMMap;
import jp.ne.sk_mine.util.andr_applet.SKMStringFuncs;
import jp.ne.sk_mine.util.andr_applet.SKMTextField;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.ScrollCallback;
import jp.ne.sk_mine.util.andr_applet.game.MyFrameButton;
import jp.ne.sk_mine.util.andr_applet.game.event.EventBase;
import jp.ne.sk_mine.util.andr_applet.game.event.NameRow;
import jp.ne.sk_mine.util.andr_applet.game.event.SettingChangeArrowButton;

public class NameSettingPage
extends EventBase {
    private static final int PHASE_DEFAULT = 0;
    private static final int PHASE_PROCESSING = 1;
    private boolean mIsRowGrabbed;
    private boolean mIsChanged;
    private int mListX;
    private int mListY;
    private int mListW;
    private int mListH;
    private int mRowH;
    private int mCategoryCenterY;
    private int mUiX;
    private int mSelectedCategoryIndex;
    private int mSelectedRowIndex;
    private int mListOffsetY;
    private int mMaxCategoryLen;
    private String mMessage;
    private String mNotAvailableMessage;
    private String mDecideSound;
    private String mNameSettingAvailableKey;
    private String mNameSettingCheckKey;
    private DummyScroll mListScroll;
    private SKMArray<String> mCategories;
    private SKMArray<String> mExplanationLines;
    private SKMArray<String[]> mDefaultNameKeys;
    private SKMArray<String[]> mExplanationKeys;
    private SKMArray<NameRow> mRows;
    private SKMMap<String, String[]> mKeyAliasMap;
    private SKMCheckBox mNameSettingOnCheck;
    private SKMColor mTitleColor;
    private SKMFont mTitleFont;
    private SKMFont mUiFont;
    private SettingChangeArrowButton mChangeCategoryUpButton;
    private SettingChangeArrowButton mChangeCategoryDownButton;
    private SKMTextField mNameField;
    private MyFrameButton mApplyButton;
    private MyFrameButton mDefaultButton;
    private MyFrameButton mDefaultAllButton;
    private MyFrameButton mRestoreButton;

    public NameSettingPage() {
        this.init();
    }

    @Override
    protected void myInit() {
        this.mDw = this.mGameManager.getBaseDrawWidth();
        this.mDh = this.mGameManager.getBaseDrawHeight();
        SKMI18N i18nCommon = SKM.getI18NCommon();
        this.mListX = 90;
        this.mListY = 140;
        this.mListW = this.mDw / 2 - 110;
        this.mListH = 240;
        this.mRowH = 30;
        this.mCategoryCenterY = this.mListY - 40;
        this.mSelectedRowIndex = -1;
        this.mNotAvailableMessage = SKM.getI18NCommon().getReplacedString("iap_option_disabled_message", i18nCommon);
        this.mNameSettingAvailableKey = "nsava";
        this.mNameSettingCheckKey = this.mGameManager.getNameSettingCheckKey();
        this.mCategories = new SKMArray();
        this.mExplanationLines = new SKMArray();
        this.mDefaultNameKeys = new SKMArray();
        this.mExplanationKeys = new SKMArray();
        this.mKeyAliasMap = new SKMMap();
        this.mRows = new SKMArray();
        this.mTitleColor = new SKMColor(230, 230, 230);
        this.mTitleFont = new SKMFont(SKMFont.BOLD, 28);
        this.mUiFont = new SKMFont(14);
        this.mChangeCategoryUpButton = new SettingChangeArrowButton(true);
        this.mChangeCategoryDownButton = new SettingChangeArrowButton(false);
        boolean isNameSettingAvailable = this.mGameManager.isNameSettingAvailable();
        String baseImagePath = SKMImage.getBasePath();
        SKMImage.setBasePath("jp/ne/sk_mine/util/andr_applet/res/image/");
        SKMImage checkOnImage = new SKMImage("w_check_on.png");
        SKMImage checkOffImage = new SKMImage("w_check_off.png");
        SKMImage.setBasePath(baseImagePath);
        this.mNameSettingOnCheck = new SKMCheckBox(i18nCommon.getString("enable_check").replace("$s", i18nCommon.getString("name_settings")), 0, 0, true, this.mUiFont);
        this.mNameSettingOnCheck.setEnabled(isNameSettingAvailable);
        this.mNameSettingOnCheck.setTextColor(SKMColor.WHITE);
        this.mNameSettingOnCheck.setDisabledTextColor(SKMColor.GRAY);
        this.mNameSettingOnCheck.setImages(checkOnImage, checkOffImage);
        this.mNameField = new SKMTextField();
        this.mNameField.setBackgroundColor(SKMColor.WHITE);
        this.mApplyButton = new MyFrameButton(i18nCommon.getString("apply"), this.mUiFont);
        this.mDefaultButton = new MyFrameButton(i18nCommon.getString("default_"), this.mUiFont);
        this.mDefaultAllButton = new MyFrameButton(i18nCommon.getString("default_all"), this.mUiFont);
        this.mRestoreButton = new MyFrameButton(i18nCommon.getString("iap_restore"), this.mUiFont);
        this.mRestoreButton.setVisible(false);
        this.addUi(this.mChangeCategoryUpButton);
        this.addUi(this.mChangeCategoryDownButton);
        this.addUi(this.mNameSettingOnCheck);
        this.addUi(this.mNameField);
        this.addUi(this.mApplyButton);
        this.addUi(this.mDefaultButton);
        this.addUi(this.mRestoreButton);
        this.addUi(this.mDefaultAllButton);
        this.setActive(false);
    }

    @Override
    protected void myUpdateButtonPositions() {
        if (this.mChangeCategoryUpButton == null) {
            return;
        }
        this.mDw = this.mGameManager.getBaseDrawWidth();
        this.mListW = this.mDw / 2 - 110;
        int listCenterX = this.mListX + this.mListW / 2;
        this.mChangeCategoryUpButton.setCenterXY(listCenterX + this.mMaxCategoryLen / 2 + this.mChangeCategoryUpButton.getWidth(), this.mCategoryCenterY);
        this.mChangeCategoryDownButton.setCenterXY(listCenterX - this.mMaxCategoryLen / 2 - this.mChangeCategoryDownButton.getWidth(), this.mCategoryCenterY);
        this.mUiX = this.mDw / 2 + 30;
        int uiLineH = 50;
        this.mNameSettingOnCheck.setXY(this.mUiX, this.mListY);
        this.mNameField.setSize(200, 32);
        this.mNameField.setXY(this.mUiX, this.mListY + 50);
        SKMUI.layoutHorizontalLeft(this.mUiX, this.mListY + 100, 20, this.mApplyButton, this.mDefaultButton);
        this.mDefaultAllButton.setXY(this.mUiX, this.mListY + 150);
        this.mRestoreButton.setCenterXY(70 + this.mRestoreButton.getWidth() / 2, 440);
        if (this.mListScroll != null) {
            this.mListScroll.setXY(this.mListX + this.mListW - 20, this.mListY);
        }
    }

    @Override
    protected void mySetPhase(int phase) {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            ((SKMUI)this.mUis.get(i)).setVisible(phase == 0);
        }
    }

    public boolean isChanged() {
        return this.mIsChanged;
    }

    public void setRestorer(Restorer restorer) {
    }

    public void setSettingAvailable() {
        this.setSettingAvailable(this.mGameManager.getBooleanSetting(this.mNameSettingAvailableKey, false));
    }

    public void setSettingAvailable(boolean f) {
        this.mNameSettingOnCheck.setEnabled(f);
        this.mGameManager.setSetting(this.mNameSettingAvailableKey, f);
        this.mGameManager.saveSettings();
        this.setSettingUiEnabled(this.mNameSettingOnCheck.isSelected());
    }

    private void setSettingUiEnabled(boolean f) {
        this.mNameField.setEnabled(f);
        this.mApplyButton.setEnabled(f);
        this.mDefaultButton.setEnabled(f);
        this.mDefaultAllButton.setEnabled(f);
    }

    public void setNotAvailableMessage(String message) {
        this.mNotAvailableMessage = message;
    }

    public void setNameSettingAvailableKey(String key) {
        this.mNameSettingAvailableKey = key;
        this.setSettingAvailable(this.mGameManager.getBooleanSetting(key, false));
    }

    public void addNameSet(String category, String[] defaultNameKeys, String[] explanations) {
        this.mCategories.add(category);
        this.mDefaultNameKeys.add(defaultNameKeys);
        this.mExplanationKeys.add(explanations);
    }

    public void setKeyAliases(String key, String[] aliases) {
        this.mKeyAliasMap.put(key, aliases);
    }

    public void setTitleColor(SKMColor color) {
        this.mTitleColor = color;
    }

    public void setTitleFont(SKMFont font) {
        this.mTitleFont = font;
    }

    public void setUiFont(SKMFont font) {
        this.mUiFont = font;
    }

    public void setDecideSound(String name) {
        this.mDecideSound = name;
    }

    private void playDecideSound() {
        if (this.mDecideSound != null) {
            this.mGameManager.playSound(this.mDecideSound);
        }
    }

    public void makeList() {
        this.mListOffsetY = 0;
        this.mSelectedRowIndex = -1;
        this.mExplanationLines.clear();
        this.mNameField.setText("");
        this.mRows.clear();
        SKMGraphics g = SKM.getGraphics();
        g.setFont(this.mUiFont);
        this.mMaxCategoryLen = 0;
        for (int i = this.mCategories.size() - 1; 0 <= i; --i) {
            int len = g.stringWidth(this.mCategories.get(i));
            if (this.mMaxCategoryLen >= len) continue;
            this.mMaxCategoryLen = len;
        }
        boolean tmpIsExtensionEnabled = SKMI18N.isExtensionEnabled();
        SKMI18N.setExtensionEnabled(true);
        String[] keys = this.mDefaultNameKeys.get(this.mSelectedCategoryIndex);
        SKMI18N i18n = SKM.getI18N();
        for (int i = 0; i < keys.length; ++i) {
            String name = i18n.getReplacedString(keys[i]);
            NameRow row = new NameRow(name, this.mListX, this.mListY + i * this.mRowH, this.mListW, this.mRowH);
            this.mRows.add(row);
        }
        SKMI18N.setExtensionEnabled(tmpIsExtensionEnabled);
        if (this.mListScroll != null) {
            this.removeUi(this.mListScroll);
        }
        this.mListScroll = new DummyScroll();
        this.mListScroll.setCallback(new ScrollCallback(this){
            final /* synthetic */ NameSettingPage this$0;
            {
                NameSettingPage nameSettingPage = this$0;
                Objects.requireNonNull(nameSettingPage);
                this.this$0 = nameSettingPage;
            }

            @Override
            public void scrolled(int x, int y) {
                for (int i = this.this$0.mRows.size() - 1; 0 <= i; --i) {
                    this.this$0.mRows.get(i).setOffsetXY(-x, -y);
                }
            }
        });
        this.mListScroll.setSize(20, this.mListH);
        this.mListScroll.setInnerSize(40, this.mRows.size() * this.mRowH);
        this.mListScroll.setVisible(true);
        this.addUi(this.mListScroll);
        this.updateButtonPositions();
    }

    @Override
    public void setActive(boolean f) {
        if (!f && this.mPhase == 1) {
            this.setPhase(0);
        }
        super.setActive(f);
        if (this.mListScroll != null) {
            this.mListScroll.setVisible(f);
        }
        this.mChangeCategoryUpButton.setVisible(f);
        this.mChangeCategoryDownButton.setVisible(f);
        if (f) {
            this.mNameSettingOnCheck.setSelected(this.mGameManager.isNameSettingAvailable() && this.mGameManager.getBooleanSetting(this.mNameSettingCheckKey, false));
            this.setSettingUiEnabled(this.mNameSettingOnCheck.isSelected());
            this.makeList();
            this.updateButtonPositions();
            this.mIsChanged = false;
        }
    }

    @Override
    protected void myRun() {
        if (this.mPhase == 1) {
            if (this.mMessage == null) {
                --this.mCount;
            } else if (this.mCount == 140) {
                this.setPhase(0);
            }
        }
    }

    @Override
    public boolean mousePressed(double mx, double my, int button) {
        if (this.mChangeCategoryUpButton.isHit(mx, my)) {
            if (this.mCategories.size() <= ++this.mSelectedCategoryIndex) {
                this.mSelectedCategoryIndex = 0;
            }
            this.makeList();
            this.playDecideSound();
            return true;
        }
        if (this.mChangeCategoryDownButton.isHit(mx, my)) {
            if (--this.mSelectedCategoryIndex < 0) {
                this.mSelectedCategoryIndex = this.mCategories.size() - 1;
            }
            this.makeList();
            this.playDecideSound();
            return true;
        }
        if (this.mNameSettingOnCheck.isHit(mx, my, false, true)) {
            if (this.mNameSettingOnCheck.isEnabled()) {
                this.mNameSettingOnCheck.isHit(mx, my);
                boolean isSettingOn = this.mNameSettingOnCheck.isSelected();
                this.setSettingUiEnabled(isSettingOn);
                SKMI18N.setExtensionEnabled(this.mGameManager.isNameSettingAvailable() && isSettingOn);
                this.mGameManager.setSetting(this.mNameSettingCheckKey, isSettingOn);
                this.mGameManager.saveSettings();
            } else {
                this.mGameManager.showAlertDialog("", this.mNotAvailableMessage);
                this.mGameManager.playSound("beep");
            }
            return true;
        }
        if (this.mApplyButton.isHit(mx, my)) {
            if (this.mSelectedRowIndex == -1) {
                return false;
            }
            String newName = this.mNameField.getText();
            String nameKey = this.mDefaultNameKeys.get(this.mSelectedCategoryIndex)[this.mSelectedRowIndex];
            String keyPrefix = SKMI18N.getExtensionPrefix();
            String[] keyAliases = this.mKeyAliasMap.get(nameKey);
            if (SKM.getI18N().getString(nameKey, false).equals(newName)) {
                this.mGameManager.removeSetting(keyPrefix + nameKey);
                if (keyAliases != null) {
                    for (int i = keyAliases.length - 1; 0 <= i; --i) {
                        this.mGameManager.removeSetting(keyPrefix + keyAliases[i]);
                    }
                }
            } else {
                this.mGameManager.setSetting(keyPrefix + nameKey, newName);
                if (keyAliases != null) {
                    for (int i = keyAliases.length - 1; 0 <= i; --i) {
                        this.mGameManager.setSetting(keyPrefix + keyAliases[i], newName);
                    }
                }
            }
            this.mGameManager.saveSettings();
            this.makeList();
            this.playDecideSound();
            this.mIsChanged = true;
            return true;
        }
        if (this.mDefaultButton.isHit(mx, my)) {
            if (this.mSelectedRowIndex == -1) {
                return false;
            }
            this.mNameField.setText(SKM.getI18N().getReplacedString(this.mDefaultNameKeys.get(this.mSelectedCategoryIndex)[this.mSelectedRowIndex], false));
            this.playDecideSound();
            this.mIsChanged = true;
            return true;
        }
        if (this.mDefaultAllButton.isHit(mx, my)) {
            String keyPrefix = SKMI18N.getExtensionPrefix();
            String[] keys = this.mDefaultNameKeys.get(this.mSelectedCategoryIndex);
            for (int i = keys.length - 1; 0 <= i; --i) {
                String[] keyAliases = this.mKeyAliasMap.get(keys[i]);
                this.mGameManager.removeSetting(keyPrefix + keys[i]);
                if (keyAliases == null) continue;
                for (int j = keyAliases.length - 1; 0 <= j; --j) {
                    this.mGameManager.removeSetting(keyPrefix + keyAliases[j]);
                }
            }
            this.mGameManager.saveSettings();
            this.makeList();
            this.playDecideSound();
            this.mIsChanged = true;
            return true;
        }
        if ((double)this.mListX < mx && mx < (double)(this.mListX + this.mListW) && (double)this.mListY < my && my < (double)(this.mListY + this.mListH)) {
            this.mMousePressedX = this.mMousePrevX = mx;
            this.mMousePressedY = this.mMousePrevY = my;
            this.mIsRowGrabbed = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mx, double my) {
        if (this.mIsRowGrabbed) {
            int maxScrollSize = -(this.mRows.size() * this.mRowH - this.mListH);
            if (-maxScrollSize < 0) {
                return true;
            }
            this.mListOffsetY += SKMUtil.toInt(my - this.mMousePrevY);
            this.mMousePrevY = my;
            if (0 < this.mListOffsetY) {
                this.mListOffsetY = 0;
            } else if (this.mListOffsetY < maxScrollSize) {
                this.mListOffsetY = maxScrollSize;
            }
            for (int i = this.mRows.size() - 1; 0 <= i; --i) {
                this.mRows.get(i).setOffsetXY(0, this.mListOffsetY);
            }
        }
        return true;
    }

    @Override
    public boolean mouseReleased(double mx, double my, int button) {
        if (this.mIsRowGrabbed) {
            this.mIsRowGrabbed = false;
            double dx = mx - this.mMousePressedX;
            double dy = my - this.mMousePressedY;
            if (dx * dx + dy * dy < 100.0) {
                for (int i = this.mRows.size() - 1; 0 <= i; --i) {
                    if (!this.mRows.get(i).isHit(mx, my)) continue;
                    this.selectRow(i);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean mouseWheelMoved(int rotation) {
        this.mListScroll.scroll(0, rotation * this.mRowH);
        return true;
    }

    private void selectRow(int rowIndex) {
        if (this.mSelectedRowIndex != -1) {
            this.mRows.get(this.mSelectedRowIndex).setSelected(false);
        }
        this.mSelectedRowIndex = rowIndex;
        if (rowIndex == -1) {
            return;
        }
        this.mNameField.setText(this.mRows.get(rowIndex).getText());
        String[] explanationKeys = this.mExplanationKeys.get(this.mSelectedCategoryIndex);
        if (explanationKeys != null && this.mSelectedRowIndex < explanationKeys.length) {
            SKMI18N i18n = SKM.getI18N();
            String explanation = i18n.getReplacedString(explanationKeys[this.mSelectedRowIndex]);
            this.mExplanationLines = SKMStringFuncs.getCutString(explanation, this.mDw / 2 - 40, this.mUiFont);
        }
        this.mRows.get(rowIndex).setSelected(true);
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        SKMI18N i18nCommon = SKM.getI18NCommon();
        g.setColor(SKMColor.BLACK);
        g.fillRect(0, 0, this.mDw + 1, this.mDh + 1);
        g.setFont(this.mTitleFont);
        g.setColor(this.mTitleColor);
        g.drawCenteringString(i18nCommon.getString("name_settings"), this.mDw / 2, 40);
        if (this.mPhase == 0) {
            g.setFont(this.mUiFont);
            g.drawCenteringString(this.mCategories.get(this.mSelectedCategoryIndex), this.mListX + this.mListW / 2, this.mCategoryCenterY);
            g.clipRect(this.mListX, this.mListY, this.mListW - this.mListScroll.getWidth(), this.mListH);
            try {
                for (int i = this.mRows.size() - 1; 0 <= i; --i) {
                    this.mRows.get(i).paint(g);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            g.clearClip();
            g.setColor(this.mTitleColor);
            g.saveStroke();
            g.setStroke(4.0f);
            g.drawRect(this.mListX, this.mListY, this.mListW - this.mListScroll.getWidth(), this.mListH);
            g.restoreStroke();
            if (this.mExplanationLines.size() != 0) {
                int explanationY = this.mDefaultAllButton.getY() + this.mDefaultAllButton.getHeight() + 30;
                for (int i = this.mExplanationLines.size() - 1; 0 <= i; --i) {
                    g.drawString(this.mExplanationLines.get(i), this.mUiX, explanationY + i * 30);
                }
            }
        } else if (this.mPhase == 1) {
            if (this.mMessage == null) {
                this.mGameManager.paintConnecting(g, this.mCount, SKMColor.WHITE, SKMColor.BLACK);
            } else {
                g.setColor(SKMColor.BLACK);
                g.fillRect(0, 0, this.mDw + 1, this.mDh + 1);
                g.setFont(new SKMFont(24));
                g.setColor(this.mTitleColor);
                g.drawCenteringString(this.mMessage, this.mDw / 2, this.mDh / 2);
            }
        }
    }
}

