/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;

public class PageButton
extends SKMButton {
    private boolean mIsToRight;
    private int mAlpha;
    private SKMColor mColor;
    private SKMColor mPressedColor;

    public PageButton(boolean isToRight) {
        super("", -100, -100, true, null);
        this.mIsToRight = isToRight;
        this.setPadSize(10, 0);
        this.mWidth = 30;
        this.mHeight = 100;
        this.mColor = SKMColor.WHITE;
        this.mPressedColor = SKMColor.GRAY;
    }

    public void setColor(SKMColor color) {
        this.mColor = color;
    }

    public void setPressedColor(SKMColor color) {
        this.mPressedColor = color;
    }

    public void setRemark() {
        this.mAlpha = 0;
    }

    @Override
    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    @Override
    public void move() {
        if (this.mAlpha < 255) {
            this.mAlpha += 2;
            if (255 < this.mAlpha) {
                this.mAlpha = 255;
            }
        }
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        int x = this.mX + this.mWidth / 2;
        int y = this.mY + this.mHeight / 2;
        if (this.mIsToRight) {
            g.saveTransform();
            g.rotate(Math.PI, x, y);
        }
        if (this.mIsEnabled) {
            if (this.mIsPressed) {
                g.setColor(this.mPressedColor);
            } else if (this.mAlpha == 255) {
                g.setColor(this.mColor);
            } else {
                g.setColor(new SKMColor(this.mColor.getRed(), this.mColor.getGreen(), this.mColor.getBlue(), this.mAlpha));
            }
        } else {
            g.setColor(sDisabledColor);
        }
        int[][] triXys = new int[][]{{11, -this.mWidth / 2, 11}, {-this.mHeight / 2, 0, this.mHeight / 2}};
        int i = 0;
        while (i < triXys[0].length) {
            int[] nArray = triXys[0];
            int n = i;
            nArray[n] = nArray[n] + x;
            int[] nArray2 = triXys[1];
            int n2 = i++;
            nArray2[n2] = nArray2[n2] + y;
        }
        g.fillPolygon(triXys[0], triXys[1]);
        g.fillRect(x + 13, y - this.mHeight / 2, 2, this.mHeight);
        if (this.mIsToRight) {
            g.restoreTransform();
        }
    }
}

