/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.game.GameView;
import jp.ne.sk_mine.util.andr_applet.game.MyFrameButton;
import jp.ne.sk_mine.util.andr_applet.game.event.EventBase;
import jp.ne.sk_mine.util.andr_applet.game.event.TutorialArrow;

public class RecommendOtherGamesEvent
extends EventBase {
    private int mMessageStartY;
    private String[] mMessages;
    private SKMButton mHelpButton;
    private SKMButton mTargetButton;
    private MyFrameButton mNextButton;
    private SKMFont mFont;
    private TutorialArrow mArrow;
    private GameView mManager;

    public RecommendOtherGamesEvent(SKMButton helpButton) {
        this.mHelpButton = helpButton;
        this.init();
    }

    @Override
    protected void myInit() {
        this.mManager = SKM.getManager();
        this.mFont = new SKMFont(16);
        this.mNextButton = new MyFrameButton(SKM.getI18NCommon().getString("next"));
        this.mNextButton.setVisible(true);
        this.addUi(this.mNextButton);
        this.setPhase(0);
        this.updateButtonPositions();
    }

    @Override
    protected void myUpdateButtonPositions() {
        SKMUI.layoutHorizontalRight(this.mManager.getBaseDrawWidth() - 10, 10, 20, this.mNextButton);
    }

    @Override
    protected void mySetPhase(int phase) {
        this.mTargetButton = this.mHelpButton;
        this.mMessages = SKM.getI18NCommon().getString("recommend_other_games").split("\n");
        this.mMessageStartY = this.mHelpButton.getY() - 60 - this.mMessages.length * 28;
        this.mArrow = new TutorialArrow(this.mHelpButton.getCenterX(), this.mHelpButton.getY() - 40, false);
        this.mTargetButton.setVisible(true);
    }

    @Override
    protected void myRun() {
        if (this.mPhase == 0 && this.mCount == 1) {
            this.mDw = this.mManager.getBaseDrawWidth();
            this.mDh = this.mManager.getBaseDrawHeight();
        }
        this.mArrow.move();
    }

    @Override
    public boolean mousePressed(double mx, double my, int button) {
        this.finish();
        return true;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        g.setColor(new SKMColor(0, 0, 0, 180));
        g.fillRect(0, 0, this.mDw + 1, this.mDh + 1);
        this.mTargetButton.paint(g);
        g.setColor(SKMColor.WHITE);
        g.setFont(this.mFont);
        for (int i = 0; i < this.mMessages.length; ++i) {
            g.drawString(this.mMessages[i], 80, this.mMessageStartY + i * 28);
        }
        this.mArrow.paint(g);
    }

    @Override
    public void finish() {
        this.mManager.setSetting("recommend_other_games_done", true);
        this.mManager.saveSettings();
        super.finish();
    }
}

