/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMMath;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.event.Painter;

public class TutorialArrow
extends Painter {
    private boolean mIsToUp;
    private boolean mIsMoveUpDown;
    private boolean mIsBlink;
    private int mX;
    private int mY;
    private int mStartY;
    private int[][] mArrowXys;
    private double mRad;
    private SKMColor mColor;

    public TutorialArrow(int x, int y, boolean isToUp) {
        this.mX = x;
        this.mStartY = this.mY = y + (isToUp ? 1 : -1) * 10;
        this.mIsToUp = isToUp;
        this.mIsMoveUpDown = true;
        this.mArrowXys = new int[][]{{20, 0, 0, -20, -20, 0, 0}, {0, -20, -8, -8, 8, 8, 20}};
        this.mRad = (double)(isToUp ? -1 : 1) * Math.PI / 2.0;
        this.mColor = SKMColor.WHITE;
    }

    public TutorialArrow(int fromX, int fromY, int toX, int toY, int width) {
        this.mX = (fromX + toX) / 2;
        this.mStartY = this.mY = (fromY + toY) / 2;
        this.mIsBlink = true;
        this.mRad = SKMMath.getRad(fromX, fromY, toX, toY);
        int len = SKMUtil.toInt(SKMMath.distance(fromX, fromY, toX, toY));
        this.mArrowXys = new int[][]{{len / 2, len / 2 - 5 * width, len / 2 - 5 * width, -len / 2, -len / 2, len / 2 - 5 * width, len / 2 - 5 * width}, {0, -width * 3, -width, -width, width, width, width * 3}};
        this.mColor = SKMColor.WHITE;
    }

    public void setBlink(boolean f) {
        this.mIsBlink = f;
    }

    public void setColor(SKMColor color) {
        this.mColor = color;
    }

    @Override
    public void move() {
        super.move();
        if (this.mIsMoveUpDown) {
            if (this.mCount % 3 == 0) {
                this.mY += this.mIsToUp ? -1 : 1;
            }
            if (this.mCount == 60) {
                this.mCount = 0;
                this.mY = this.mStartY;
            }
        }
    }

    @Override
    public void paint(SKMGraphics g) {
        if (this.mIsBlink && 75 < this.mCount % 80) {
            return;
        }
        g.setColor(this.mColor);
        g.saveTransform();
        g.translate(this.mX, this.mY);
        if (this.mRad != 0.0) {
            g.rotate(this.mRad, 0.0, 0.0);
        }
        g.fillPolygon(this.mArrowXys);
        g.restoreTransform();
    }
}

