/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import jp.ne.sk_mine.util.andr_applet.SKMStringFuncs;
import jp.ne.sk_mine.util.sound.MidiPlayer;
import jp.ne.sk_mine.util.sound.Mp3Player;
import jp.ne.sk_mine.util.sound.Player;

public class BgmPlayer
extends Player {
    private MidiPlayer mMidiPlayer;
    private Mp3Player mMp3Player;
    private Player mLastPlayer;
    private String mBasePath;

    public BgmPlayer() {
        this(true);
    }

    public BgmPlayer(boolean isSaveLastBgm) {
        this.mMidiPlayer = new MidiPlayer(isSaveLastBgm);
        this.mMp3Player = new Mp3Player(isSaveLastBgm);
    }

    public void setBasePath(String path) {
        this.mBasePath = path;
    }

    public String getBasePath() {
        return this.mBasePath;
    }

    @Override
    public boolean loadFromList(String listFilename) {
        if (this.mBasePath != null && listFilename.indexOf(this.mBasePath) != 0) {
            return this.loadFromList(this.mBasePath + listFilename, this.mBasePath);
        }
        return super.loadFromList(listFilename);
    }

    @Override
    public boolean load(String name, String resourceName) {
        String extension = SKMStringFuncs.getExtensionLowerCase(resourceName);
        Player player = null;
        if (extension.equals("mid")) {
            player = this.mMidiPlayer;
        } else if (extension.equals("mp3")) {
            player = this.mMp3Player;
        } else {
            return false;
        }
        return ((Player)player).load(name, resourceName);
    }

    @Override
    public boolean load(String name, String resourceName, int loopStartPos) {
        String extension = SKMStringFuncs.getExtensionLowerCase(resourceName);
        Player player = null;
        if (extension.equals("mid")) {
            player = this.mMidiPlayer;
        } else if (extension.equals("mp3")) {
            player = this.mMp3Player;
        } else {
            return false;
        }
        return ((Player)player).load(name, resourceName, loopStartPos);
    }

    @Override
    public void preload() {
        this.mMidiPlayer.preload();
        this.mMp3Player.preload();
    }

    @Override
    public void preload(String name) {
        Player player = this.getSuitablePlayer(name);
        if (player != null) {
            player.preload(name);
        }
    }

    @Override
    public boolean hasName(String name) {
        if (this.mMidiPlayer.hasName(name)) {
            return true;
        }
        return this.mMp3Player.hasName(name);
    }

    private final Player getSuitablePlayer(String name) {
        Player player = null;
        if (this.mMidiPlayer.hasName(name)) {
            player = this.mMidiPlayer;
        } else if (this.mMp3Player.hasName(name)) {
            player = this.mMp3Player;
        } else {
            return null;
        }
        return player;
    }

    @Override
    public boolean isPlayable() {
        return this.mMidiPlayer.isPlayable();
    }

    @Override
    public void setPlayable(boolean f) {
        this.mMidiPlayer.setPlayable(f);
        this.mMp3Player.setPlayable(f);
    }

    @Override
    public boolean isEnabled() {
        return this.isPlayable();
    }

    @Override
    public void setEnabled(boolean f) {
        this.setPlayable(f);
    }

    @Override
    public void play(String name) {
        this.play(name, false, Player.PlayMode.SINGLE);
    }

    @Override
    public void play(String name, boolean isLoop) {
        this.play(name, isLoop, Player.PlayMode.SINGLE);
    }

    @Override
    public void play(String name, boolean isLoop, Player.PlayMode playMode) {
        Player player = this.getSuitablePlayer(name);
        if (player != null) {
            player.play(name, isLoop, playMode);
            this.mLastPlayer = player;
        }
    }

    public void play() {
        if (this.mLastPlayer == this.mMidiPlayer) {
            this.mMidiPlayer.play();
        } else if (this.mLastPlayer == this.mMp3Player) {
            this.mMp3Player.play();
        }
    }

    public void pause(String name) {
        Player player = this.getSuitablePlayer(name);
        if (player == this.mMidiPlayer) {
            this.mMidiPlayer.pause(name);
        } else if (player == this.mMp3Player) {
            this.mMp3Player.pause(name);
        }
    }

    public void pause() {
        if (this.mLastPlayer == this.mMidiPlayer) {
            this.mMidiPlayer.pause();
        } else if (this.mLastPlayer == this.mMp3Player) {
            this.mMp3Player.pause();
        }
    }

    @Override
    public void stop(String name) {
        Player player = this.getSuitablePlayer(name);
        if (player != null) {
            player.stop(name);
        }
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean isReset) {
        if (this.mLastPlayer == this.mMidiPlayer) {
            this.mMidiPlayer.stop();
            if (isReset) {
                this.mMidiPlayer.reset();
            }
        } else if (this.mLastPlayer == this.mMp3Player) {
            this.mMp3Player.stop();
            if (isReset) {
                this.mMp3Player.reset();
            }
        }
    }

    @Override
    public void stopAll() {
        this.mMidiPlayer.stopAll();
        this.mMp3Player.stopAll();
        this.reset();
    }

    public void reset() {
        this.mMidiPlayer.reset();
        this.mMp3Player.reset();
    }

    @Override
    public void cleanUp() {
        this.mMidiPlayer.cleanUp();
        this.mMp3Player.cleanUp();
    }
}

