/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import java.io.InputStream;
import java.util.Objects;
import javazoom.jl.player.advanced.PlaybackListener;
import jp.ne.sk_mine.util.sound.MyMp3Player;

class Mp3PlayThread {
    private boolean mIsLoop;
    private boolean mIsPlaying;
    private boolean mIsPausing;
    private boolean mIsLoopPlay;
    private int mLoopStartPos;
    private MyMp3Player mPlayer;
    private String mResourceName;
    private Mp3Thread mThread;

    Mp3PlayThread(String resourceName) {
        this.mResourceName = resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        if (this.mIsPausing) {
            this.mIsPausing = false;
            if (this.mThread != null) {
                Mp3Thread mp3Thread = this.mThread;
                synchronized (mp3Thread) {
                    this.mThread.notify();
                }
            }
            return;
        }
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.mResourceName);
            this.mPlayer = new MyMp3Player(in);
            if (this.mIsLoopPlay) {
                for (int i = 0; i < this.mLoopStartPos; ++i) {
                    this.mPlayer.skipFrame();
                }
            }
            this.mPlayer.setPlayBackListener(new PlaybackListener(this){
                {
                    Objects.requireNonNull(this$0);
                }
            });
        }
        catch (Exception e) {
            return;
        }
        if (this.mThread != null) {
            this.mThread.stopThread();
            this.mThread = null;
        }
        this.mThread = new Mp3Thread(this);
        this.mThread.start();
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public boolean isPausing() {
        return this.mIsPausing;
    }

    public void setLoop(boolean isLoop) {
        this.mIsLoop = isLoop;
    }

    public void setLoop(boolean isLoop, int loopStartPos) {
        this.mIsLoop = isLoop;
        this.mLoopStartPos = loopStartPos;
    }

    public boolean isLoop() {
        return this.mIsLoop;
    }

    public void pause() {
        this.mIsPausing = true;
    }

    public void stop() {
        this.mIsPlaying = false;
        this.mIsLoopPlay = false;
        if (this.mThread != null) {
            this.mThread.stopThread();
            this.mThread = null;
        }
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer = null;
        }
    }

    public void cleanUp() {
        try {
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Mp3Thread
    extends Thread {
        private boolean mIsRunning;
        final /* synthetic */ Mp3PlayThread this$0;

        Mp3Thread(Mp3PlayThread this$0) {
            Mp3PlayThread mp3PlayThread = this$0;
            Objects.requireNonNull(mp3PlayThread);
            this.this$0 = mp3PlayThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mIsRunning = true;
            this.this$0.mIsPlaying = true;
            boolean ret = true;
            while (ret && this.mIsRunning) {
                Mp3Thread mp3Thread = this;
                synchronized (mp3Thread) {
                    while (this.this$0.mIsPausing) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (this.this$0.mPlayer == null) continue;
                ret = this.this$0.mPlayer.decode();
            }
            if (this.this$0.mIsPlaying && this.this$0.mIsLoop) {
                this.this$0.mIsLoopPlay = true;
                this.this$0.play();
            } else {
                this.this$0.mIsPlaying = false;
            }
            this.mIsRunning = false;
        }

        public void stopThread() {
            this.this$0.mIsPlaying = false;
            this.mIsRunning = false;
        }
    }
}

