/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import java.io.File;
import jp.ne.sk_mine.util.ResourceUtil;

public abstract class Player {
    private boolean isPlayable_ = true;

    Player() {
    }

    public abstract boolean load(String var1, String var2);

    public abstract boolean load(String var1, String var2, int var3);

    public boolean loadFromList(String listFilename) {
        File file = new File(listFilename);
        return this.loadFromList(listFilename, file.getParent());
    }

    public boolean loadFromList(String listFilename, String baseDirname) {
        String[] bgmInfos = ResourceUtil.loadFile(listFilename);
        if (bgmInfos == null) {
            System.err.println("Error: Player.loadFromList(): list file not found.");
            return false;
        }
        if (bgmInfos.length == 0) {
            return false;
        }
        if (!((String)baseDirname).endsWith("/")) {
            baseDirname = (String)baseDirname + "/";
        }
        for (int i = 0; i < bgmInfos.length; ++i) {
            String[] tokens = bgmInfos[i].split("[ \t]+");
            if (3 <= tokens.length) {
                this.load(tokens[0], (String)baseDirname + tokens[1], Integer.parseInt(tokens[2]));
                continue;
            }
            if (2 > tokens.length) continue;
            this.load(tokens[0], (String)baseDirname + tokens[1]);
        }
        return true;
    }

    public abstract void preload();

    public abstract void preload(String var1);

    public abstract boolean hasName(String var1);

    public boolean isPlayable() {
        return this.isPlayable_;
    }

    public void setPlayable(boolean f) {
        this.isPlayable_ = f;
    }

    public boolean isEnabled() {
        return this.isPlayable_;
    }

    public void setEnabled(boolean f) {
        this.isPlayable_ = f;
    }

    public void play(String name) {
        this.play(name, false, PlayMode.NORMAL);
    }

    public void play(String name, boolean isLoop) {
        this.play(name, isLoop, PlayMode.NORMAL);
    }

    public void play(String name, PlayMode playMode) {
        this.play(name, false, playMode);
    }

    public abstract void play(String var1, boolean var2, PlayMode var3);

    public abstract void stop(String var1);

    public abstract void stopAll();

    public void cleanUp() {
    }

    public static enum PlayMode {
        NORMAL,
        SINGLE,
        STOP_PREVIOUS;

    }
}

