/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.JPasswordField;
import jp.ne.sk_mine.util.ui.LimitDocument;

public class ExJPasswordField
extends JPasswordField {
    private LimitDocument mDoc;
    private String mHint;

    public ExJPasswordField(int col) {
        super(col);
        this.init();
    }

    public ExJPasswordField(String text) {
        super(text);
        this.init();
    }

    public ExJPasswordField(String text, int col) {
        super(text, col);
        this.init();
    }

    private final void init() {
        this.mDoc = new LimitDocument(this);
        this.mHint = "";
        try {
            this.mDoc.insertString(0, new String(this.getPassword()), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDocument(this.mDoc);
        this.setCaretPosition(this.getPassword().length);
        this.addFocusListener(new FocusListener(this){
            final /* synthetic */ ExJPasswordField this$0;
            {
                ExJPasswordField exJPasswordField = this$0;
                Objects.requireNonNull(exJPasswordField);
                this.this$0 = exJPasswordField;
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.this$0.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.this$0.repaint();
            }
        });
    }

    public int getMaxLength() {
        return this.mDoc.getMaxLength();
    }

    public void setMaxLength(int max) {
        this.mDoc.setMaxLength(max);
    }

    public void setHint(String hint) {
        this.mHint = hint;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getPassword().length != 0 || this.mHint.length() == 0) {
            return;
        }
        Font preFont = g.getFont();
        Color preColor = g.getColor();
        g.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        g.setColor(Color.LIGHT_GRAY);
        Insets insets = this.getBorder().getBorderInsets(this);
        int h = g.getFontMetrics().getAscent();
        g.drawString(this.mHint, insets.left, insets.top + h);
        g.setColor(preColor);
        g.setFont(preFont);
    }
}

