/*
 * Decompiled with CFR 0.152.
 */
package score;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import score.ConfigManager;
import score.DisplayWindow;
import score.ScoreController;
import score.ScoreData;
import score.SettingsWindow;
import score.SoundPlayer;

public class ScoreBoardUI
extends JFrame {
    private ScoreData data = new ScoreData();
    private ScoreController ctrl = new ScoreController(this.data);
    private DisplayWindow displayWindow;
    private Timer gameTimer;
    private JPanel centerPanel = new JPanel(new GridLayout(1, 2, 5, 0));
    private JLabel lblTimer = new JLabel("00:00", 0);
    private JLabel lblAO = new JLabel("0", 0);
    private JLabel lblAKA = new JLabel("0", 0);
    private JLabel[] lblCountsAO = new JLabel[3];
    private JLabel[] lblCountsAKA = new JLabel[3];
    private JLabel lblPAO = new JLabel("Penalty: 0", 0);
    private JLabel lblPAKA = new JLabel("Penalty: 0", 0);
    private JLabel lblSAO = new JLabel(" ", 0);
    private JLabel lblSAKA = new JLabel(" ", 0);
    private JTextField txtNameAO = new JTextField("\u9752");
    private JTextField txtNameAKA = new JTextField("\u8d64");
    private JButton btnVRAO = new JButton("VR: \u6709");
    private JButton btnVRAKA = new JButton("VR: \u6709");
    private JButton btnStart = new JButton("\u30b9\u30bf\u30fc\u30c8");

    public ScoreBoardUI() {
        SoundPlayer.init(this.data);
        int i = 0;
        while (i < 3) {
            this.lblCountsAO[i] = new JLabel("", 2);
            this.lblCountsAKA[i] = new JLabel("", 2);
            ++i;
        }
        ConfigManager.load(this.data);
        this.setupUI();
        this.setupShortcuts();
        this.gameTimer = new Timer(1000, e -> this.tick());
        this.gameTimer.setInitialDelay(0);
        this.data.reset();
        this.syncSettings();
    }

    private void setupUI() {
        this.setTitle("Karate Scoreboard - Controller");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout(0, 0));
        JPanel top = new JPanel(new BorderLayout());
        this.lblTimer.setOpaque(true);
        this.lblTimer.setBackground(Color.BLACK);
        this.lblTimer.setForeground(Color.YELLOW);
        this.btnStart.setFont(new Font("MS UI Gothic", 1, 22));
        this.btnStart.addActionListener(e -> this.toggleTimer());
        top.add((Component)this.lblTimer, "Center");
        top.add((Component)this.btnStart, "South");
        this.add((Component)top, "North");
        this.centerPanel.setBackground(Color.BLACK);
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.add(this.createPlayerPanel("AO", Color.BLUE, this.lblAO, this.lblPAO, this.lblSAO, this.btnVRAO, this.txtNameAO, this.lblCountsAO));
        this.centerPanel.add(this.createPlayerPanel("AKA", Color.RED, this.lblAKA, this.lblPAKA, this.lblSAKA, this.btnVRAKA, this.txtNameAKA, this.lblCountsAKA));
        JPanel bottom = new JPanel(new FlowLayout(1, 5, 2));
        JButton btnSet = new JButton("\u8a2d\u5b9a");
        btnSet.addActionListener(e -> new SettingsWindow(this.data, () -> this.syncSettings()).setVisible(true));
        JButton btnT1 = new JButton("1\u79d2+");
        btnT1.addActionListener(e -> {
            this.ctrl.adjustTime(1);
            this.refresh();
        });
        JButton btnT2 = new JButton("1\u79d2-");
        btnT2.addActionListener(e -> {
            this.ctrl.adjustTime(-1);
            this.refresh();
        });
        JButton btnReset = new JButton("RESET");
        btnReset.addActionListener(e -> this.resetMatch());
        bottom.add(btnSet);
        bottom.add(btnT1);
        bottom.add(btnT2);
        bottom.add(btnReset);
        this.add((Component)bottom, "South");
        this.setupNameListeners();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScoreBoardUI.this.adjustFontSize();
            }
        });
        this.pack();
        this.setSize(1100, 700);
        this.setLocationRelativeTo(null);
    }

    private void setupShortcuts() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            if (!this.data.isEnableShortcuts() || e.getID() != 401) {
                return false;
            }
            if (e.getSource() instanceof JTextField) {
                return false;
            }
            if (e.getKeyCode() == 32) {
                this.toggleTimer();
                return true;
            }
            if (e.getKeyCode() == 82) {
                this.resetMatch();
                return true;
            }
            return false;
        });
    }

    private JPanel createPlayerPanel(String side, Color color, JLabel score, JLabel pen, JLabel senshu, JButton vrBtn, JTextField nameTxt, JLabel[] counts) {
        JPanel p = new JPanel(new BorderLayout());
        p.setBackground(color);
        p.setBorder(BorderFactory.createLineBorder(Color.WHITE, 1));
        JPanel header = new JPanel(new BorderLayout());
        header.setOpaque(false);
        nameTxt.setFont(new Font("SansSerif", 1, 16));
        header.add((Component)new JLabel(" \u9078\u624b\u540d:", 2), "West");
        header.add((Component)nameTxt, "Center");
        p.add((Component)header, "North");
        JPanel info = new JPanel(new GridBagLayout());
        info.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 10;
        score.setForeground(Color.WHITE);
        pen.setForeground(Color.WHITE);
        senshu.setForeground(Color.YELLOW);
        gbc.gridy = 0;
        info.add((Component)senshu, gbc);
        JPanel scoreContainer = new JPanel(new FlowLayout(1, 10, 0));
        scoreContainer.setOpaque(false);
        scoreContainer.add(score);
        JPanel countBox = new JPanel(new GridLayout(3, 1));
        countBox.setOpaque(false);
        JLabel[] jLabelArray = counts;
        int n = counts.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel lbl = jLabelArray[n2];
            lbl.setForeground(Color.WHITE);
            countBox.add(lbl);
            ++n2;
        }
        scoreContainer.add(countBox);
        gbc.gridy = 1;
        info.add((Component)scoreContainer, gbc);
        gbc.gridy = 2;
        info.add((Component)pen, gbc);
        p.add((Component)info, "Center");
        JPanel btns = new JPanel(new GridLayout(6, 2, 1, 0));
        String[] t = new String[]{"\u6709\u52b9(1P)", "\u6280\u6709(2P)", "\u4e00\u672c(3P)"};
        int[] pts = new int[]{1, 2, 3};
        int i = 0;
        while (i < 3) {
            int pVal = pts[i];
            JButton bA = new JButton(t[i] + "+");
            bA.addActionListener(e -> {
                this.ctrl.manageScore(side, pVal);
                this.handleStateChange();
            });
            JButton bS = new JButton(t[i] + "-");
            bS.addActionListener(e -> {
                this.ctrl.manageScoreSub(side, pVal);
                this.handleStateChange();
            });
            btns.add(bA);
            btns.add(bS);
            ++i;
        }
        JButton bPA = new JButton("\u53cd\u5247+");
        bPA.addActionListener(e -> {
            this.ctrl.penaltyProcess(side, 1);
            this.handleStateChange();
        });
        JButton bPS = new JButton("\u53cd\u5247-");
        bPS.addActionListener(e -> {
            this.ctrl.penaltyProcess(side, -1);
            this.handleStateChange();
        });
        btns.add(bPA);
        btns.add(bPS);
        JButton bSn = new JButton("\u5148\u53d6");
        bSn.addActionListener(e -> {
            this.ctrl.toggleSenshu(side);
            this.refresh();
        });
        btns.add(bSn);
        vrBtn.addActionListener(e -> {
            this.ctrl.toggleVR(side);
            this.refresh();
        });
        btns.add(vrBtn);
        p.add((Component)btns, "South");
        return p;
    }

    private void setupNameListeners() {
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                ScoreBoardUI.this.data.setNameAO(ScoreBoardUI.this.txtNameAO.getText());
                ScoreBoardUI.this.data.setNameAKA(ScoreBoardUI.this.txtNameAKA.getText());
                if (ScoreBoardUI.this.displayWindow != null) {
                    ScoreBoardUI.this.displayWindow.updateDisplay();
                }
            }
        };
        this.txtNameAO.getDocument().addDocumentListener(dl);
        this.txtNameAKA.getDocument().addDocumentListener(dl);
    }

    private void resetMatch() {
        if (this.gameTimer.isRunning()) {
            this.gameTimer.stop();
        }
        this.data.reset();
        this.btnStart.setText("\u30b9\u30bf\u30fc\u30c8");
        this.refresh();
    }

    private void handleStateChange() {
        this.refresh();
        String winner = this.ctrl.checkVictoryState();
        if (winner != null) {
            this.gameTimer.stop();
            this.btnStart.setText("\u30b9\u30bf\u30fc\u30c8");
            SoundPlayer.play("finish.wav");
            JOptionPane.showMessageDialog(this, winner + " \u52dd\u5229\uff01");
        }
    }

    private void syncSettings() {
        if (this.data.isShowDisplayWindow()) {
            if (this.displayWindow == null) {
                this.displayWindow = new DisplayWindow(this.data);
            }
            this.displayWindow.setupPanels();
            this.displayWindow.setVisible(true);
        } else if (this.displayWindow != null) {
            this.displayWindow.setVisible(false);
        }
        this.refresh();
    }

    private void adjustFontSize() {
        int h = this.getHeight();
        Font scoreFont = new Font("Arial", 1, h / 6);
        Font countFont = new Font("SansSerif", 1, h / 35);
        Font sFont = new Font("Arial", 1, h / 9);
        Font penFont = new Font("MS UI Gothic", 1, h / 20);
        Font timerFont = new Font("Monospaced", 1, h / 10);
        this.lblAO.setFont(scoreFont);
        this.lblAKA.setFont(scoreFont);
        this.lblSAO.setFont(sFont);
        this.lblSAKA.setFont(sFont);
        int i = 0;
        while (i < 3) {
            this.lblCountsAO[i].setFont(countFont);
            this.lblCountsAKA[i].setFont(countFont);
            ++i;
        }
        this.lblPAO.setFont(penFont);
        this.lblPAKA.setFont(penFont);
        this.lblTimer.setFont(timerFont);
        this.revalidate();
    }

    private void toggleTimer() {
        if (this.gameTimer.isRunning()) {
            this.gameTimer.stop();
            this.btnStart.setText("\u30b9\u30bf\u30fc\u30c8");
            SoundPlayer.play("stop.wav");
        } else {
            if (this.data.getRemainingSeconds() <= 0) {
                return;
            }
            this.gameTimer.start();
            this.btnStart.setText("\u30b9\u30c8\u30c3\u30d7");
            SoundPlayer.play("start.wav");
        }
    }

    private void tick() {
        int current = this.data.getRemainingSeconds();
        if (current > 0) {
            int next = current - 1;
            this.data.setRemainingSeconds(next);
            if (next == this.data.getAtoshiSeconds()) {
                SoundPlayer.play("atoshibara.wav");
            }
            this.refresh();
            if (next == 0) {
                this.gameTimer.stop();
                this.btnStart.setText("\u30b9\u30bf\u30fc\u30c8");
                SoundPlayer.play("finish.wav");
                JOptionPane.showMessageDialog(this, "\u8a66\u5408\u7d42\u4e86\uff01");
            }
        } else {
            this.gameTimer.stop();
        }
    }

    private void refresh() {
        this.lblAO.setText(String.valueOf(this.data.getScoreAO()));
        this.lblAKA.setText(String.valueOf(this.data.getScoreAKA()));
        String[] labels = new String[]{"\u6709\u52b9\uff1a", "\u6280\u6709\uff1a", "\u4e00\u672c\uff1a"};
        int i = 0;
        while (i < 3) {
            this.lblCountsAO[i].setText(labels[i] + this.data.getCountAO()[i]);
            this.lblCountsAKA[i].setText(labels[i] + this.data.getCountAKA()[i]);
            ++i;
        }
        this.lblPAO.setText("P: " + ScoreData.P_LIST[this.data.getPIdxAO()]);
        this.lblPAKA.setText("P: " + ScoreData.P_LIST[this.data.getPIdxAKA()]);
        this.lblSAO.setText(this.data.isSenshuAO() ? "S" : " ");
        this.lblSAKA.setText(this.data.isSenshuAKA() ? "S" : " ");
        this.lblTimer.setText(String.format("%02d:%02d", this.data.getRemainingSeconds() / 60, this.data.getRemainingSeconds() % 60));
        this.btnVRAO.setText(this.data.isVrAO() ? "VR: \u6709" : "VR: \u6d88\u8cbb");
        this.btnVRAKA.setText(this.data.isVrAKA() ? "VR: \u6709" : "VR: \u6d88\u8cbb");
        if (this.displayWindow != null && this.displayWindow.isVisible()) {
            this.displayWindow.updateDisplay();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new ScoreBoardUI().setVisible(true));
    }
}

