/*
 * Decompiled with CFR 0.152.
 */
package score;

import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import score.ScoreData;

public class SoundPlayer {
    private static ScoreData dataRef;

    public static void init(ScoreData data) {
        dataRef = data;
    }

    public static void play(String fileName) {
        if (dataRef == null) {
            return;
        }
        boolean shouldPlay = false;
        if (fileName.equals("score.wav") || fileName.equals("start.wav") || fileName.equals("stop.wav")) {
            if (dataRef.isEnableOpSound()) {
                shouldPlay = true;
            }
        } else if (fileName.equals("atoshibara.wav")) {
            if (dataRef.isEnableAtoshiSound()) {
                shouldPlay = true;
            }
        } else if (fileName.equals("finish.wav") && dataRef.isEnableFinishSound()) {
            shouldPlay = true;
        }
        if (!shouldPlay) {
            return;
        }
        try {
            File soundFile = new File("Sound/" + fileName);
            if (!soundFile.exists()) {
                return;
            }
            AudioInputStream audioStream = AudioSystem.getAudioInputStream(soundFile);
            Clip clip = AudioSystem.getClip();
            clip.open(audioStream);
            clip.start();
            clip.addLineListener(event -> {
                if (event.getType() == LineEvent.Type.STOP) {
                    clip.close();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

