/*
 * Decompiled with CFR 0.152.
 */
package score;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import score.ScoreData;

public class ConfigManager {
    private static final String FILE = "score_config.properties";

    public static void save(ScoreData data) {
        Properties prop = new Properties();
        prop.setProperty("defaultMinutes", String.valueOf(data.getDefaultMinutes()));
        prop.setProperty("defaultSeconds", String.valueOf(data.getDefaultSeconds()));
        prop.setProperty("atoshiSeconds", String.valueOf(data.getAtoshiSeconds()));
        prop.setProperty("winPointDiff", String.valueOf(data.getWinPointDiff()));
        prop.setProperty("maxPoint", String.valueOf(data.getMaxPoint()));
        prop.setProperty("useSenshu", String.valueOf(data.isUseSenshu()));
        prop.setProperty("showDisplayWindow", String.valueOf(data.isShowDisplayWindow()));
        prop.setProperty("isReverseLayout", String.valueOf(data.isReverseLayout()));
        prop.setProperty("enableOpSound", String.valueOf(data.isEnableOpSound()));
        prop.setProperty("enableAtoshiSound", String.valueOf(data.isEnableAtoshiSound()));
        prop.setProperty("enableFinishSound", String.valueOf(data.isEnableFinishSound()));
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(FILE);){
                prop.store(out, "Karate Scoreboard Java Config");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load(ScoreData data) {
        File file = new File(FILE);
        if (!file.exists()) {
            return;
        }
        Properties prop = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream in = new FileInputStream(FILE);){
                prop.load(in);
                data.setDefaultMinutes(Integer.parseInt(prop.getProperty("defaultMinutes", "3")));
                data.setDefaultSeconds(Integer.parseInt(prop.getProperty("defaultSeconds", "0")));
                data.setAtoshiSeconds(Integer.parseInt(prop.getProperty("atoshiSeconds", "15")));
                data.setWinPointDiff(Integer.parseInt(prop.getProperty("winPointDiff", "8")));
                data.setMaxPoint(Integer.parseInt(prop.getProperty("maxPoint", "8")));
                data.setUseSenshu(Boolean.parseBoolean(prop.getProperty("useSenshu", "true")));
                data.setShowDisplayWindow(Boolean.parseBoolean(prop.getProperty("showDisplayWindow", "true")));
                data.setReverseLayout(Boolean.parseBoolean(prop.getProperty("isReverseLayout", "true")));
                data.setEnableOpSound(Boolean.parseBoolean(prop.getProperty("enableOpSound", "true")));
                data.setEnableAtoshiSound(Boolean.parseBoolean(prop.getProperty("enableAtoshiSound", "true")));
                data.setEnableFinishSound(Boolean.parseBoolean(prop.getProperty("enableFinishSound", "true")));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("Config load error.");
        }
    }
}

