/*
 * Decompiled with CFR 0.152.
 */
package score;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import score.ScoreData;

public class DisplayWindow
extends JFrame {
    private ScoreData data;
    private JPanel mainContainer = new JPanel(new GridLayout(1, 2, 10, 0));
    private JLabel lblTimer = new JLabel("", 0);
    private JLabel lblNameAO = new JLabel("", 0);
    private JLabel lblNameAKA = new JLabel("", 0);
    private JLabel lblAO = new JLabel("", 0);
    private JLabel lblAKA = new JLabel("", 0);
    private JLabel[] lblCountsAO = new JLabel[3];
    private JLabel[] lblCountsAKA = new JLabel[3];
    private JLabel lblPAO = new JLabel("", 0);
    private JLabel lblPAKA = new JLabel("", 0);
    private JLabel lblSAO = new JLabel(" ", 0);
    private JLabel lblSAKA = new JLabel(" ", 0);
    private JLabel lScoreAO = new JLabel("\u5f97\u70b9");
    private JLabel lScoreAKA = new JLabel("\u5f97\u70b9");
    private JLabel lPenAO = new JLabel("\u53cd\u5247");
    private JLabel lPenAKA = new JLabel("\u53cd\u5247");

    public DisplayWindow(ScoreData data) {
        this.data = data;
        int i = 0;
        while (i < 3) {
            this.lblCountsAO[i] = new JLabel("", 2);
            this.lblCountsAKA[i] = new JLabel("", 2);
            ++i;
        }
        this.setTitle("Viewer Mode");
        this.setSize(1000, 750);
        this.getContentPane().setBackground(Color.BLACK);
        this.setLayout(new BorderLayout());
        this.lblTimer.setOpaque(true);
        this.lblTimer.setBackground(Color.BLACK);
        this.lblTimer.setForeground(Color.YELLOW);
        this.add((Component)this.lblTimer, "North");
        this.add((Component)this.mainContainer, "Center");
        this.setupPanels();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DisplayWindow.this.adjustFontSize();
            }
        });
    }

    public void setupPanels() {
        this.mainContainer.removeAll();
        JPanel pAO = this.createMirrorPanel(Color.BLUE, this.lblAO, this.lblPAO, this.lblSAO, this.lScoreAO, this.lPenAO, this.lblNameAO, this.lblCountsAO);
        JPanel pAKA = this.createMirrorPanel(Color.RED, this.lblAKA, this.lblPAKA, this.lblSAKA, this.lScoreAKA, this.lPenAKA, this.lblNameAKA, this.lblCountsAKA);
        if (this.data.isReverseLayout()) {
            this.mainContainer.add(pAKA);
            this.mainContainer.add(pAO);
        } else {
            this.mainContainer.add(pAO);
            this.mainContainer.add(pAKA);
        }
        this.mainContainer.revalidate();
        this.adjustFontSize();
    }

    private JPanel createMirrorPanel(Color bg, JLabel score, JLabel penalty, JLabel s, JLabel lScore, JLabel lPen, JLabel name, JLabel[] counts) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(bg);
        p.setBorder(new EmptyBorder(0, 0, 20, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 10;
        name.setForeground(Color.WHITE);
        s.setForeground(Color.YELLOW);
        lScore.setForeground(Color.WHITE);
        score.setForeground(Color.WHITE);
        lPen.setForeground(Color.WHITE);
        penalty.setForeground(Color.WHITE);
        gbc.gridy = 0;
        p.add((Component)name, gbc);
        gbc.gridy = 1;
        p.add((Component)s, gbc);
        gbc.gridy = 2;
        p.add((Component)lScore, gbc);
        JPanel scoreContainer = new JPanel(new FlowLayout(1, 15, 0));
        scoreContainer.setOpaque(false);
        scoreContainer.add(score);
        JPanel countBox = new JPanel(new GridLayout(3, 1));
        countBox.setOpaque(false);
        JLabel[] jLabelArray = counts;
        int n = counts.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel lbl = jLabelArray[n2];
            lbl.setForeground(Color.WHITE);
            countBox.add(lbl);
            ++n2;
        }
        scoreContainer.add(countBox);
        gbc.gridy = 3;
        p.add((Component)scoreContainer, gbc);
        gbc.gridy = 4;
        p.add((Component)lPen, gbc);
        gbc.gridy = 5;
        p.add((Component)penalty, gbc);
        return p;
    }

    private void adjustFontSize() {
        int h = this.getHeight();
        Font timerFont = new Font("Monospaced", 1, h / 8);
        Font nameFont = new Font("SansSerif", 1, h / 12);
        Font scoreFont = new Font("Arial", 1, h / 3);
        Font countFont = new Font("SansSerif", 1, h / 25);
        Font sFont = new Font("Arial", 1, h / 11);
        Font labelFont = new Font("SansSerif", 1, h / 25);
        Font penFont = new Font("Arial", 1, h / 10);
        this.lblTimer.setFont(timerFont);
        this.lblNameAO.setFont(nameFont);
        this.lblNameAKA.setFont(nameFont);
        this.lblAO.setFont(scoreFont);
        this.lblAKA.setFont(scoreFont);
        this.lblSAO.setFont(sFont);
        this.lblSAKA.setFont(sFont);
        this.lScoreAO.setFont(labelFont);
        this.lScoreAKA.setFont(labelFont);
        this.lPenAO.setFont(labelFont);
        this.lPenAKA.setFont(labelFont);
        int i = 0;
        while (i < 3) {
            this.lblCountsAO[i].setFont(countFont);
            this.lblCountsAKA[i].setFont(countFont);
            ++i;
        }
        this.lblPAO.setFont(penFont);
        this.lblPAKA.setFont(penFont);
    }

    public void updateDisplay() {
        this.lblNameAO.setText(this.data.getNameAO());
        this.lblNameAKA.setText(this.data.getNameAKA());
        this.lblAO.setText(String.valueOf(this.data.getScoreAO()));
        this.lblAKA.setText(String.valueOf(this.data.getScoreAKA()));
        String[] labels = new String[]{"\u6709\u52b9\uff1a", "\u6280\u6709\uff1a", "\u4e00\u672c\uff1a"};
        int i = 0;
        while (i < 3) {
            this.lblCountsAO[i].setText(labels[i] + this.data.getCountAO()[i]);
            this.lblCountsAKA[i].setText(labels[i] + this.data.getCountAKA()[i]);
            ++i;
        }
        this.lblPAO.setText(ScoreData.P_LIST[this.data.getPIdxAO()]);
        this.lblPAKA.setText(ScoreData.P_LIST[this.data.getPIdxAKA()]);
        this.lblSAO.setText(this.data.isSenshuAO() ? "S" : " ");
        this.lblSAKA.setText(this.data.isSenshuAKA() ? "S" : " ");
        this.lblTimer.setText(String.format("%02d:%02d", this.data.getRemainingSeconds() / 60, this.data.getRemainingSeconds() % 60));
    }
}

