/*
 * Decompiled with CFR 0.152.
 */
package score;

import score.ScoreData;
import score.SoundPlayer;

public class ScoreController {
    private ScoreData data;

    public ScoreController(ScoreData data) {
        this.data = data;
    }

    public String checkVictoryState() {
        if (Math.abs(this.data.getScoreAO() - this.data.getScoreAKA()) >= this.data.getWinPointDiff()) {
            return this.data.getScoreAO() > this.data.getScoreAKA() ? "\u9752 (AO)" : "\u8d64 (AKA)";
        }
        if (this.data.getScoreAO() >= this.data.getMaxPoint()) {
            return "\u9752 (AO)";
        }
        if (this.data.getScoreAKA() >= this.data.getMaxPoint()) {
            return "\u8d64 (AKA)";
        }
        if (this.data.getPIdxAO() >= 5) {
            return "\u8d64 (AKA)";
        }
        if (this.data.getPIdxAKA() >= 5) {
            return "\u9752 (AO)";
        }
        return null;
    }

    public void manageScore(String side, int pts) {
        SoundPlayer.play("score.wav");
        int idx = pts - 1;
        if (side.equals("AO")) {
            this.data.setScoreAO(this.data.getScoreAO() + pts);
            int[] nArray = this.data.getCountAO();
            int n = idx;
            nArray[n] = nArray[n] + 1;
            if (this.data.isUseSenshu() && this.data.getScoreAO() + this.data.getScoreAKA() == pts && !this.data.isSenshuAKA()) {
                this.data.setSenshuAO(true);
            }
        } else {
            this.data.setScoreAKA(this.data.getScoreAKA() + pts);
            int[] nArray = this.data.getCountAKA();
            int n = idx;
            nArray[n] = nArray[n] + 1;
            if (this.data.isUseSenshu() && this.data.getScoreAO() + this.data.getScoreAKA() == pts && !this.data.isSenshuAO()) {
                this.data.setSenshuAKA(true);
            }
        }
    }

    public void manageScoreSub(String side, int pts) {
        SoundPlayer.play("score.wav");
        int idx = pts - 1;
        if (side.equals("AO")) {
            if (this.data.getCountAO()[idx] > 0) {
                this.data.setScoreAO(this.data.getScoreAO() - pts);
                int[] nArray = this.data.getCountAO();
                int n = idx;
                nArray[n] = nArray[n] - 1;
            }
        } else if (this.data.getCountAKA()[idx] > 0) {
            this.data.setScoreAKA(this.data.getScoreAKA() - pts);
            int[] nArray = this.data.getCountAKA();
            int n = idx;
            nArray[n] = nArray[n] - 1;
        }
        if (this.data.getScoreAO() == 0 && this.data.getScoreAKA() == 0) {
            this.data.setSenshuAO(false);
            this.data.setSenshuAKA(false);
        }
    }

    public void penaltyProcess(String side, int direction) {
        SoundPlayer.play("score.wav");
        if (side.equals("AO")) {
            this.data.setPIdxAO(this.data.getPIdxAO() + direction);
        } else {
            this.data.setPIdxAKA(this.data.getPIdxAKA() + direction);
        }
    }

    public void toggleVR(String side) {
        if (side.equals("AO")) {
            this.data.setVrAO(!this.data.isVrAO());
        } else {
            this.data.setVrAKA(!this.data.isVrAKA());
        }
    }

    public void toggleSenshu(String side) {
        if (side.equals("AO")) {
            this.data.setSenshuAO(!this.data.isSenshuAO());
        } else {
            this.data.setSenshuAKA(!this.data.isSenshuAKA());
        }
    }

    public void adjustTime(int seconds) {
        this.data.setRemainingSeconds(this.data.getRemainingSeconds() + seconds);
    }
}

