﻿// <auto-generated/>
using System;
using System.Runtime.InteropServices;

namespace SwPlcComSdk
{
    /// <summary>Communication type</summary>
    public enum SwPlcCommType
    {
        /// <summary>Serial</summary>
        SWPLC_TYPE_SERIAL = 0,

        /// <summary>TCP</summary>
        SWPLC_TYPE_TCP = 1,

        /// <summary>UDP</summary>
        SWPLC_TYPE_UDP = 2,

        /// <summary>CUSTOM</summary>
        SWPLC_TYPE_CUSTOM = 3,
    }

    /// <summary>Message Id</summary>
    public enum SwPlcMessage
    {
        /// <summary>応答メッセージ識別番号</summary>
        SWPLC_MSG_RESPONSE = 0,

        /// <summary>通知メッセージ識別番号</summary>
        SWPLC_MSG_DATACHANGED = 1,
    }

    /// <summary>Error codes</summary>
    public enum SwPlcCode
    {
        SWPLC_ERROR_TRIAL_TIMEOVER = -2,        // 試用時間が超過しました
        SWPLC_INVALID_ID = -1,                  // 通信IDが不正です
        SWPLC_OK = 0,                           // 正常
        SWPLC_ERROR = 1,                        // 実行エラー
        SWPLC_ERROR_LOADFILE = 2,               // ファイルのロードに失敗しました
        SWPLC_ERROR_LOADLIBRARY = 3,            // 通信ライブラリのロードに失敗しました
        SWPLC_ERROR_PARAM = 4,                  // 通信パラメータが不正です
        SWPLC_ERROR_OPTIONPARAM = 5,            // オプションパラメータが不正です
        SWPLC_ERROR_PORT = 6,                   // 通信ポートの初期化に失敗しました
        SWPLC_ERROR_BUSY = 7,                   // 前回実行したコマンドが完了していません
        SWPLC_ERROR_NOCOMMAND = 8,              // 実行コマンドが登録されていません
        SWPLC_ERROR_OUTOFMEMORY = 9,            // 送受信用メモリが足りません（問合せデータ数を少なくしてください）
        SWPLC_ERROR_TAG_RANGE = 10,             // タグIDが範囲外です
        SWPLC_ERROR_TAG_NOTFIND = 11,           // タグIDが登録されていません
        SWPLC_ERROR_TAG_INVALIDTYPE = 12,       // タグのデータ型が不正です
        SWPLC_ERROR_DATATYPE_MISMATCH = 13,     // データ型が一致しません
        SWPLC_ERROR_SHAREMEM = 14,              // 共有データメモリの初期化に失敗しました(ポート名称を確認してください)
        SWPLC_ERROR_TAG_DATACOUNT = 15,         // タグのデータ数が不正です
        SWPLC_PORT_CLOSE = 100,                 // ポートクローズ
        SWPLC_PORT_OPEN = 101,                  // ポートオープン
        SWPLC_PORT_CONNECTED = 102,             // TCPコネクション確立
        SWPLC_TAG_STATUS_NONE = 200,            // タグステータス不明
        SWPLC_TAG_STATUS_ERROR = 201,           // タグステータスエラー
        SWPLC_RESPONSE_IDLE = 1000,             // 実行するコマンドがありません
        SWPLC_RESPONSE_DONE = 1001,             // コマンド実行完了
        SWPLC_RESPONSE_BUSY = 1002,             // コマンド実行中
        SWPLC_RESPONSE_ABORT = 1003,            // コマンド実行中断
        SWPLC_RESPONSE_TIMEOUT = 1004,          // コマンド応答タイムアウト
        SWPLC_RESPONSE_ERROR_PLC = 1005,        // PLCエラー
    }

    /// <summary>DataType</summary>
    public enum SwPlcDataType
    {
        SWPLC_DATATYPE_DEFAULT = 0,
        SWPLC_DATATYPE_SHORT = 1,
        SWPLC_DATATYPE_USHORT = 2,
        SWPLC_DATATYPE_INT = 3,
        SWPLC_DATATYPE_UINT = 4,
        SWPLC_DATATYPE_LONG = 5,
        SWPLC_DATATYPE_ULONG = 6,
        SWPLC_DATATYPE_FLOAT = 7,
        SWPLC_DATATYPE_DOUBLE = 8,
        SWPLC_DATATYPE_BIT = 9,
        SWPLC_DATATYPE_BIT2 = 10,
    }

    /// <summary>SwPlcTag</summary>
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct SwPlcTag
    {
        /// <summary>Tag ID</summary>
        [MarshalAs(UnmanagedType.I4)]
        public int TagId;

        /// <summary>Device name</summary>
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = SwPlcCom.DeviceNameLength)]
        public string Device;

        /// <summary>Device address</summary>
        [MarshalAs(UnmanagedType.I4)]
        public int Address;

        /// <summary>Data type</summary>
        [MarshalAs(UnmanagedType.I4)]
        public int DataType;

        /// <summary>Number of data points</summary>
        [MarshalAs(UnmanagedType.I4)]
        public int Count;

        /// <summary>Monitor 0:Off 1:On</summary>
        [MarshalAs(UnmanagedType.I4)]
        public int Monitor;

        /// <summary>Notify 0:Off 1:On</summary>
        [MarshalAs(UnmanagedType.I4)]
        public int Notify;

        /// <summary>コンストラクタ</summary>
        public SwPlcTag(int tagId, string device, int address, SwPlcDataType dataType, int count, bool monitor, bool notify)
        {
            this.TagId = tagId;
            this.Device = device;
            this.Address = address;
            this.DataType = (int)dataType;
            this.Count = count;
            this.Monitor = monitor ? 1 : 0;
            this.Notify = notify ? 1 : 0;
        }

        /// <summary>初期化</summary>
        public void Initialize()
        {
            this.TagId = 0;
            this.Device = string.Empty;
            this.Address = 0;
            this.DataType = 0;
            this.Count = 0;
            this.Monitor = 0;
            this.Notify = 0;
        }
    }

    /// <summary>SwPlcCom</summary>
    public static class SwPlcCom
    {
        public const int DeviceNameLength = 32;

        /// <summary>Callback function</summary>
        public delegate void SwPlcNotifyCallBackFunc(uint msgId, int handle, int param);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcLoadFile")]
        private static extern int SwPlcLoadFile_(out int handle, string fileName);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcLoadFileEx")]
        private static extern int SwPlcLoadFileEx_(out int handle, string fileName, string portName, string libFileName, int type, string param, string option);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcLoadTag")]
        private static extern int SwPlcLoadTag_(string fileName, IntPtr tags, out int tagCount);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcInitPort")]
        private static extern int SwPlcInitPort_(out int handle, string portName, string libFileName, int type, SwPlcTag[] tags, int tagCount, string param, string option);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcClosePort")]
        private static extern int SwPlcClosePort_(int handle);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcComStatus")]
        private static extern int SwPlcComStatus_(int handle);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcExecute")]
        private static extern int SwPlcExecute_(int handle);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcResponse")]
        private static extern int SwPlcResponse_(int handle, int wait);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcClear")]
        private static extern int SwPlcClear_(int handle);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetPlcErrorCode")]
        private static extern int SwPlcGetPlcErrorCode_(int handle, out int pErrorCode);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcAbort")]
        private static extern int SwPlcAbort_(int handle);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcSetNotify")]
        private static extern int SwPlcSetNotify_(int handle, SwPlcNotifyCallBackFunc callBackFunc);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcRead")]
        private static extern int SwPlcRead_(int handle, int tagId);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteBit")]
        private static extern int SwPlcWriteBit_(int handle, int tagId, byte data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteBitArray")]
        private static extern int SwPlcWriteBitArray_(int handle, int tagId, byte[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteShort")]
        private static extern int SwPlcWriteShort_(int handle, int tagId, short data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteShortArray")]
        private static extern int SwPlcWriteShortArray_(int handle, int tagId, short[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteUShort")]
        private static extern int SwPlcWriteUShort_(int handle, int tagId, ushort data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteUShortArray")]
        private static extern int SwPlcWriteUShortArray_(int handle, int tagId, ushort[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteInt")]
        private static extern int SwPlcWriteInt_(int handle, int tagId, int data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteIntArray")]
        private static extern int SwPlcWriteIntArray_(int handle, int tagId, int[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteUInt")]
        private static extern int SwPlcWriteUInt_(int handle, int tagId, uint data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteUIntArray")]
        private static extern int SwPlcWriteUIntArray_(int handle, int tagId, uint[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteLong")]
        private static extern int SwPlcWriteLong_(int handle, int tagId, long data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteLongArray")]
        private static extern int SwPlcWriteLongArray_(int handle, int tagId, long[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteULong")]
        private static extern int SwPlcWriteULong_(int handle, int tagId, ulong data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteULongArray")]
        private static extern int SwPlcWriteULongArray_(int handle, int tagId, ulong[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteFloat")]
        private static extern int SwPlcWriteFloat_(int handle, int tagId, float data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteFloatArray")]
        private static extern int SwPlcWriteFloatArray_(int handle, int tagId, float[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteDouble")]
        private static extern int SwPlcWriteDouble_(int handle, int tagId, double data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteDoubleArray")]
        private static extern int SwPlcWriteDoubleArray_(int handle, int tagId, double[] data, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetBit")]
        private static extern int SwPlcGetBit_(int handle, int tagId, ref byte data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetBitArray")]
        private static extern int SwPlcGetBitArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetShort")]
        private static extern int SwPlcGetShort_(int handle, int tagId, ref short data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetShortArray")]
        private static extern int SwPlcGetShortArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetUShort")]
        private static extern int SwPlcGetUShort_(int handle, int tagId, ref ushort data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetUShortArray")]
        private static extern int SwPlcGetUShortArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetInt")]
        private static extern int SwPlcGetInt_(int handle, int tagId, ref int data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetIntArray")]
        private static extern int SwPlcGetIntArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetUInt")]
        private static extern int SwPlcGetUInt_(int handle, int tagId, ref uint data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetUIntArray")]
        private static extern int SwPlcGetUIntArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetLong")]
        private static extern int SwPlcGetLong_(int handle, int tagId, ref long data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetLongArray")]
        private static extern int SwPlcGetLongArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetULong")]
        private static extern int SwPlcGetULong_(int handle, int tagId, ref ulong pData);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetULongArray")]
        private static extern int SwPlcGetULongArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetFloat")]
        private static extern int SwPlcGetFloat_(int handle, int tagId, ref float data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetFloatArray")]
        private static extern int SwPlcGetFloatArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetDouble")]
        private static extern int SwPlcGetDouble_(int handle, int tagId, ref double data);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetDoubleArray")]
        private static extern int SwPlcGetDoubleArray_(int handle, int tagId, IntPtr pData, int count);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcSetMonitorInterval")]
        private static extern int SwPlcSetMonitorInterval_(int handle, int ms);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcMonitorStatus")]
        private static extern int SwPlcMonitorStatus_(int handle);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcGetMonitorPlcErrorCode")]
        private static extern int SwPlcGetMonitorPlcErrorCode_(int handle, out int pErrorCode);

        [DllImport("SwPlcCom.dll", CallingConvention = CallingConvention.StdCall, EntryPoint = "SwPlcWriteLog")]
        private static extern int SwPlcWriteLog_(int handle, string logString);

        public static SwPlcCode SwPlcLoadFile(out int handle, string fileName)
        {
            int result = SwPlcLoadFile_(out handle, fileName);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcLoadFileEx(out int handle, string fileName, string portName, string libFileName, SwPlcCommType type, string param, string option)
        {
            int result = SwPlcLoadFileEx_(out handle, fileName, portName, libFileName, (int)type, param, option);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcLoadTag(string fileName, ref SwPlcTag[] tags, ref int tagCount)
        {
            int result = 0;
            if (tags == null)
            {
                result = SwPlcLoadTag_(fileName, IntPtr.Zero, out tagCount);
            }
            else
            {
                if (tags.Length < tagCount)
                {
                    tagCount = tags.Length;
                }

                IntPtr ptr = IntPtr.Zero;
                try
                {
                    int tagSize = Marshal.SizeOf(typeof(SwPlcTag));
                    ptr = Marshal.AllocCoTaskMem(tagSize * tagCount);
                    result = SwPlcLoadTag_(fileName, ptr, out tagCount);
                    IntPtr pArr = ptr;
                    for (int i = 0; i < tagCount; i++)
                    {
                        tags[i] = (SwPlcTag)Marshal.PtrToStructure(pArr, typeof(SwPlcTag));
                        pArr += tagSize;
                    }
                }
                finally
                {
                    if (ptr != IntPtr.Zero)
                    {
                        Marshal.FreeCoTaskMem(ptr);
                    }
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcInitPort(out int handle, string portName, string libFileName, SwPlcCommType type, SwPlcTag[] tags, string param, string option)
        {
            int result = SwPlcInitPort_(out handle, portName, libFileName, (int)type, tags, tags.Length, param, option);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcClosePort(int handle)
        {
            int result = SwPlcClosePort_(handle);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcComStatus(int handle)
        {
            int result = SwPlcComStatus_(handle);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcExecute(int handle)
        {
            int result = SwPlcExecute_(handle);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcResponse(int handle, int wait)
        {
            int result = SwPlcResponse_(handle, wait);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcClear(int handle)
        {
            int result = SwPlcClear_(handle);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetPlcErrorCode(int handle, out int errorCode)
        {
            int result = SwPlcGetPlcErrorCode_(handle, out errorCode);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcAbort(int handle)
        {
            int result = SwPlcAbort_(handle);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcSetNotify(int handle, SwPlcNotifyCallBackFunc callBackFunc)
        {
            int result = SwPlcSetNotify_(handle, callBackFunc);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcRead(int handle, int tagId)
        {
            int result = SwPlcRead_(handle, tagId);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteBit(int handle, int tagId, byte data)
        {
            int result = SwPlcWriteBit_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteBitArray(int handle, int tagId, byte[] data)
        {
            int result = SwPlcWriteBitArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteShort(int handle, int tagId, short data)
        {
            int result = SwPlcWriteShort_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteShortArray(int handle, int tagId, short[] data)
        {
            int result = SwPlcWriteShortArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteUShort(int handle, int tagId, ushort data)
        {
            int result = SwPlcWriteUShort_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteUShortArray(int handle, int tagId, ushort[] data)
        {
            int result = SwPlcWriteUShortArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteInt(int handle, int tagId, int data)
        {
            int result = SwPlcWriteInt_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteIntArray(int handle, int tagId, int[] data)
        {
            int result = SwPlcWriteIntArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteUInt(int handle, int tagId, uint data)
        {
            int result = SwPlcWriteUInt_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteUIntArray(int handle, int tagId, uint[] data)
        {
            int result = SwPlcWriteUIntArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteLong(int handle, int tagId, long data)
        {
            int result = SwPlcWriteLong_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteLongArray(int handle, int tagId, long[] data)
        {
            int result = SwPlcWriteLongArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteULong(int handle, int tagId, ulong data)
        {
            int result = SwPlcWriteULong_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteULongArray(int handle, int tagId, ulong[] data)
        {
            int result = SwPlcWriteULongArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteFloat(int handle, int tagId, float data)
        {
            int result = SwPlcWriteFloat_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteFloatArray(int handle, int tagId, float[] data)
        {
            int result = SwPlcWriteFloatArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteDouble(int handle, int tagId, double data)
        {
            int result = SwPlcWriteDouble_(handle, tagId, data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteDoubleArray(int handle, int tagId, double[] data)
        {
            int result = SwPlcWriteDoubleArray_(handle, tagId, data, data.Length);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetBit(int handle, int tagId, ref byte data)
        {
            int result = SwPlcGetBit_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetBitArray(int handle, int tagId, ref byte[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(byte)) * dataarray.Length);
                result = SwPlcGetBitArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length);
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetShort(int handle, int tagId, ref short data)
        {
            int result = SwPlcGetShort_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetShortArray(int handle, int tagId, ref short[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(short)) * dataarray.Length);
                result = SwPlcGetShortArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length);
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetUShort(int handle, int tagId, ref ushort data)
        {
            int result = SwPlcGetUShort_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetUShortArray(int handle, int tagId, ref ushort[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                byte[] bytearray = new byte[dataarray.Length * sizeof(ushort)];
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(byte)) * bytearray.Length);
                result = SwPlcGetUShortArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, bytearray, 0, bytearray.Length);

                for (int i = 0; i < dataarray.Length; i++)
                {
                    dataarray[i] = BitConverter.ToUInt16(bytearray, i * sizeof(ushort));
                }
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetInt(int handle, int tagId, ref int data)
        {
            int result = SwPlcGetInt_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetIntArray(int handle, int tagId, ref int[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(int)) * dataarray.Length);
                result = SwPlcGetIntArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length);
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetUInt(int handle, int tagId, ref uint data)
        {
            int result = SwPlcGetUInt_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetUIntArray(int handle, int tagId, ref uint[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                byte[] bytearray = new byte[dataarray.Length * sizeof(uint)];
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(byte)) * bytearray.Length);
                result = SwPlcGetUIntArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, bytearray, 0, bytearray.Length);

                for (int i = 0; i < dataarray.Length; i++)
                {
                    dataarray[i] = BitConverter.ToUInt32(bytearray, i * sizeof(uint));
                }
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetLong(int handle, int tagId, ref long data)
        {
            int result = SwPlcGetLong_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetLongArray(int handle, int tagId, ref long[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(long)) * dataarray.Length);
                result = SwPlcGetLongArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length);
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetULong(int handle, int tagId, ref ulong data)
        {
            int result = SwPlcGetULong_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetULongArray(int handle, int tagId, ref ulong[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                byte[] bytearray = new byte[dataarray.Length * sizeof(ulong)];
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(byte)) * bytearray.Length);
                result = SwPlcGetULongArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, bytearray, 0, bytearray.Length);

                for (int i = 0; i < dataarray.Length; i++)
                {
                    dataarray[i] = BitConverter.ToUInt64(bytearray, i * sizeof(ulong));
                }
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetFloat(int handle, int tagId, ref float data)
        {
            int result = SwPlcGetFloat_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetFloatArray(int handle, int tagId, ref float[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(float)) * dataarray.Length);
                result = SwPlcGetFloatArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length);
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetDouble(int handle, int tagId, ref double data)
        {
            int result = SwPlcGetDouble_(handle, tagId, ref data);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetDoubleArray(int handle, int tagId, ref double[] dataarray)
        {
            int result;
            IntPtr ptr = IntPtr.Zero;
            try
            {
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(double)) * dataarray.Length);
                result = SwPlcGetDoubleArray_(handle, tagId, ptr, dataarray.Length);
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length);
            }
            finally
            {
                if (ptr != IntPtr.Zero)
                {
                    Marshal.FreeCoTaskMem(ptr);
                }
            }

            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcSetMonitorInterval(int handle, int ms)
        {
            int result = SwPlcSetMonitorInterval_(handle, ms);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcMonitorStatus(int handle)
        {
            int result = SwPlcMonitorStatus_(handle);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcGetMonitorPlcErrorCode(int handle, out int errorCode)
        {
            int result = SwPlcGetMonitorPlcErrorCode_(handle, out errorCode);
            return (SwPlcCode)result;
        }

        public static SwPlcCode SwPlcWriteLog(int handle, string logString)
        {
            int result = SwPlcWriteLog_(handle, logString);
            return (SwPlcCode)result;
        }
    }
}
