﻿
' <auto-generated/>
Imports System.Runtime.InteropServices

Namespace SwPlcComSdk
    ''' <summary>Communication type</summary>
    Public Enum SwPlcCommType
        ''' <summary>Serial</summary>
        SWPLC_TYPE_SERIAL = 0

        ''' <summary>TCP</summary>
        SWPLC_TYPE_TCP = 1

        ''' <summary>UDP</summary>
        SWPLC_TYPE_UDP = 2

        ''' <summary>CUSTOM</summary>
        SWPLC_TYPE_CUSTOM = 3
    End Enum

    ''' <summary>Message Id</summary>
    Public Enum SwPlcMessage
        ''' <summary>応答メッセージ識別番号</summary>
        SWPLC_MSG_RESPONSE = 0

        ''' <summary>通知メッセージ識別番号</summary>
        SWPLC_MSG_DATACHANGED = 1
    End Enum

    ''' <summary>Error codes</summary>
    Public Enum SwPlcCode
        SWPLC_ERROR_TRIAL_TIMEOVER = -2
        ' 試用時間が超過しました
        SWPLC_INVALID_ID = -1
        ' 通信IDが不正です
        SWPLC_OK = 0
        ' 正常
        SWPLC_ERROR = 1
        ' 実行エラー
        SWPLC_ERROR_LOADFILE = 2
        ' ファイルのロードに失敗しました
        SWPLC_ERROR_LOADLIBRARY = 3
        ' 通信ライブラリのロードに失敗しました
        SWPLC_ERROR_PARAM = 4
        ' 通信パラメータが不正です
        SWPLC_ERROR_OPTIONPARAM = 5
        ' オプションパラメータが不正です
        SWPLC_ERROR_PORT = 6
        ' 通信ポートの初期化に失敗しました
        SWPLC_ERROR_BUSY = 7
        ' 前回実行したコマンドが完了していません
        SWPLC_ERROR_NOCOMMAND = 8
        ' 実行コマンドが登録されていません
        SWPLC_ERROR_OUTOFMEMORY = 9
        ' 送受信用メモリが足りません（問合せデータ数を少なくしてください）
        SWPLC_ERROR_TAG_RANGE = 10
        ' タグIDが範囲外です
        SWPLC_ERROR_TAG_NOTFIND = 11
        ' タグIDが登録されていません
        SWPLC_ERROR_TAG_INVALIDTYPE = 12
        ' タグのデータ型が不正です
        SWPLC_ERROR_DATATYPE_MISMATCH = 13
        ' データ型が一致しません
        SWPLC_ERROR_SHAREMEM = 14
        ' 共有データメモリの初期化に失敗しました(ポート名称を確認してください)
        SWPLC_ERROR_TAG_DATACOUNT = 15
        ' タグのデータ数が不正です
        SWPLC_PORT_CLOSE = 100
        ' ポートクローズ
        SWPLC_PORT_OPEN = 101
        ' ポートオープン
        SWPLC_PORT_CONNECTED = 102
        ' TCPコネクション確立
        SWPLC_TAG_STATUS_NONE = 200
        ' タグステータス不明
        SWPLC_TAG_STATUS_ERROR = 201
        ' タグステータスエラー
        SWPLC_RESPONSE_IDLE = 1000
        ' 実行するコマンドがありません
        SWPLC_RESPONSE_DONE = 1001
        ' コマンド実行完了
        SWPLC_RESPONSE_BUSY = 1002
        ' コマンド実行中
        SWPLC_RESPONSE_ABORT = 1003
        ' コマンド実行中断
        SWPLC_RESPONSE_TIMEOUT = 1004
        ' コマンド応答タイムアウト
        SWPLC_RESPONSE_ERROR_PLC = 1005
        ' PLCエラー
    End Enum

    ''' <summary>DataType</summary>
    Public Enum SwPlcDataType
        SWPLC_DATATYPE_DEFAULT = 0
        SWPLC_DATATYPE_SHORT = 1
        SWPLC_DATATYPE_USHORT = 2
        SWPLC_DATATYPE_INT = 3
        SWPLC_DATATYPE_UINT = 4
        SWPLC_DATATYPE_LONG = 5
        SWPLC_DATATYPE_ULONG = 6
        SWPLC_DATATYPE_FLOAT = 7
        SWPLC_DATATYPE_DOUBLE = 8
        SWPLC_DATATYPE_BIT = 9
        SWPLC_DATATYPE_BIT2 = 10
    End Enum

    ''' <summary>SwPlcTag</summary>
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)>
    Public Structure SwPlcTag
        ''' <summary>Tag ID</summary>
        <MarshalAs(UnmanagedType.I4)>
        Public TagId As Integer

        ''' <summary>Device name</summary>
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=SwPlcCom.DeviceNameLength)>
        Public Device As String

        ''' <summary>Device address</summary>
        <MarshalAs(UnmanagedType.I4)>
        Public Address As Integer

        ''' <summary>Data type</summary>
        <MarshalAs(UnmanagedType.I4)>
        Public DataType As Integer

        ''' <summary>Number of data points</summary>
        <MarshalAs(UnmanagedType.I4)>
        Public Count As Integer

        ''' <summary>Monitor 0:Off 1:On</summary>
        <MarshalAs(UnmanagedType.I4)>
        Public Monitor As Integer

        ''' <summary>Notify 0:Off 1:On</summary>
        <MarshalAs(UnmanagedType.I4)>
        Public Notify As Integer

        ''' <summary>コンストラクタ</summary>
        Public Sub New(tagId As Integer, device As String, address As Integer, dataType As SwPlcDataType, count As Integer, monitor As Boolean,
            notify As Boolean)
            Me.TagId = tagId
            Me.Device = device
            Me.Address = address
            Me.DataType = CInt(dataType)
            Me.Count = count
            Me.Monitor = If(monitor, 1, 0)
            Me.Notify = If(notify, 1, 0)
        End Sub

        ''' <summary>初期化</summary>
        Public Sub Initialize()
            Me.TagId = 0
            Me.Device = String.Empty
            Me.Address = 0
            Me.DataType = 0
            Me.Count = 0
            Me.Monitor = 0
            Me.Notify = 0
        End Sub
    End Structure

    ''' <summary>SwPlcCom</summary>
    Public NotInheritable Class SwPlcCom
        Private Sub New()
        End Sub
        Public Const DeviceNameLength As Integer = 32

        ''' <summary>Callback function</summary>
        Public Delegate Sub SwPlcNotifyCallBackFunc(msgId As UInteger, handle As Integer, param As Integer)

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcLoadFile")>
        Private Shared Function SwPlcLoadFile_(ByRef handle As Integer, fileName As String) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcLoadFileEx")>
        Private Shared Function SwPlcLoadFileEx_(ByRef handle As Integer, fileName As String, portName As String, libFileName As String, type As Integer, param As String,
            [option] As String) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcLoadTag")>
        Private Shared Function SwPlcLoadTag_(fileName As String, tags As IntPtr, ByRef tagCount As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcInitPort")>
        Private Shared Function SwPlcInitPort_(ByRef handle As Integer, portName As String, libFileName As String, type As Integer, tags As SwPlcTag(), tagCount As Integer,
            param As String, [option] As String) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcClosePort")>
        Private Shared Function SwPlcClosePort_(handle As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcComStatus")>
        Private Shared Function SwPlcComStatus_(handle As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcExecute")>
        Private Shared Function SwPlcExecute_(handle As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcResponse")>
        Private Shared Function SwPlcResponse_(handle As Integer, wait As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcClear")>
        Private Shared Function SwPlcClear_(handle As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetPlcErrorCode")>
        Private Shared Function SwPlcGetPlcErrorCode_(handle As Integer, ByRef pErrorCode As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcAbort")>
        Private Shared Function SwPlcAbort_(handle As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcSetNotify")>
        Private Shared Function SwPlcSetNotify_(handle As Integer, callBackFunc As SwPlcNotifyCallBackFunc) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcRead")>
        Private Shared Function SwPlcRead_(handle As Integer, tagId As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteBit")>
        Private Shared Function SwPlcWriteBit_(handle As Integer, tagId As Integer, data As Byte) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteBitArray")>
        Private Shared Function SwPlcWriteBitArray_(handle As Integer, tagId As Integer, data As Byte(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteShort")>
        Private Shared Function SwPlcWriteShort_(handle As Integer, tagId As Integer, data As Short) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteShortArray")>
        Private Shared Function SwPlcWriteShortArray_(handle As Integer, tagId As Integer, data As Short(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteUShort")>
        Private Shared Function SwPlcWriteUShort_(handle As Integer, tagId As Integer, data As UShort) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteUShortArray")>
        Private Shared Function SwPlcWriteUShortArray_(handle As Integer, tagId As Integer, data As UShort(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteInt")>
        Private Shared Function SwPlcWriteInt_(handle As Integer, tagId As Integer, data As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteIntArray")>
        Private Shared Function SwPlcWriteIntArray_(handle As Integer, tagId As Integer, data As Integer(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteUInt")>
        Private Shared Function SwPlcWriteUInt_(handle As Integer, tagId As Integer, data As UInteger) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteUIntArray")>
        Private Shared Function SwPlcWriteUIntArray_(handle As Integer, tagId As Integer, data As UInteger(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteLong")>
        Private Shared Function SwPlcWriteLong_(handle As Integer, tagId As Integer, data As Long) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteLongArray")>
        Private Shared Function SwPlcWriteLongArray_(handle As Integer, tagId As Integer, data As Long(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteULong")>
        Private Shared Function SwPlcWriteULong_(handle As Integer, tagId As Integer, data As ULong) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteULongArray")>
        Private Shared Function SwPlcWriteULongArray_(handle As Integer, tagId As Integer, data As ULong(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteFloat")>
        Private Shared Function SwPlcWriteFloat_(handle As Integer, tagId As Integer, data As Single) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteFloatArray")>
        Private Shared Function SwPlcWriteFloatArray_(handle As Integer, tagId As Integer, data As Single(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteDouble")>
        Private Shared Function SwPlcWriteDouble_(handle As Integer, tagId As Integer, data As Double) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteDoubleArray")>
        Private Shared Function SwPlcWriteDoubleArray_(handle As Integer, tagId As Integer, data As Double(), count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetBit")>
        Private Shared Function SwPlcGetBit_(handle As Integer, tagId As Integer, ByRef data As Byte) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetBitArray")>
        Private Shared Function SwPlcGetBitArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetShort")>
        Private Shared Function SwPlcGetShort_(handle As Integer, tagId As Integer, ByRef data As Short) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetShortArray")>
        Private Shared Function SwPlcGetShortArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetUShort")>
        Private Shared Function SwPlcGetUShort_(handle As Integer, tagId As Integer, ByRef data As UShort) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetUShortArray")>
        Private Shared Function SwPlcGetUShortArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetInt")>
        Private Shared Function SwPlcGetInt_(handle As Integer, tagId As Integer, ByRef data As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetIntArray")>
        Private Shared Function SwPlcGetIntArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetUInt")>
        Private Shared Function SwPlcGetUInt_(handle As Integer, tagId As Integer, ByRef data As UInteger) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetUIntArray")>
        Private Shared Function SwPlcGetUIntArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetLong")>
        Private Shared Function SwPlcGetLong_(handle As Integer, tagId As Integer, ByRef data As Long) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetLongArray")>
        Private Shared Function SwPlcGetLongArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetULong")>
        Private Shared Function SwPlcGetULong_(handle As Integer, tagId As Integer, ByRef pData As ULong) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetULongArray")>
        Private Shared Function SwPlcGetULongArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetFloat")>
        Private Shared Function SwPlcGetFloat_(handle As Integer, tagId As Integer, ByRef data As Single) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetFloatArray")>
        Private Shared Function SwPlcGetFloatArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetDouble")>
        Private Shared Function SwPlcGetDouble_(handle As Integer, tagId As Integer, ByRef data As Double) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetDoubleArray")>
        Private Shared Function SwPlcGetDoubleArray_(handle As Integer, tagId As Integer, pData As IntPtr, count As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcSetMonitorInterval")>
        Private Shared Function SwPlcSetMonitorInterval_(handle As Integer, ms As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcMonitorStatus")>
        Private Shared Function SwPlcMonitorStatus_(handle As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcGetMonitorPlcErrorCode")>
        Private Shared Function SwPlcGetMonitorPlcErrorCode_(handle As Integer, ByRef pErrorCode As Integer) As Integer
        End Function

        <DllImport("SwPlcCom.dll", CallingConvention:=CallingConvention.StdCall, EntryPoint:="SwPlcWriteLog")>
        Private Shared Function SwPlcWriteLog_(handle As Integer, logString As String) As Integer
        End Function

        Public Shared Function SwPlcLoadFile(ByRef handle As Integer, fileName As String) As SwPlcCode
            Dim result As Integer = SwPlcLoadFile_(handle, fileName)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcLoadFileEx(ByRef handle As Integer, fileName As String, portName As String, libFileName As String, type As SwPlcCommType, param As String,
            [option] As String) As SwPlcCode
            Dim result As Integer = SwPlcLoadFileEx_(handle, fileName, portName, libFileName, CInt(type), param,
                [option])
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcLoadTag(fileName As String, ByRef tags As SwPlcTag(), ByRef tagCount As Integer) As SwPlcCode
            Dim result As Integer = 0
            If tags Is Nothing Then
                result = SwPlcLoadTag_(fileName, IntPtr.Zero, tagCount)
            Else
                If tags.Length < tagCount Then
                    tagCount = tags.Length
                End If

                Dim ptr As IntPtr = IntPtr.Zero
                Try
                    Dim tagSize As Integer = Marshal.SizeOf(GetType(SwPlcTag))
                    ptr = Marshal.AllocCoTaskMem(tagSize * tagCount)
                    result = SwPlcLoadTag_(fileName, ptr, tagCount)
                    Dim pArr As IntPtr = ptr
                    For i As Integer = 0 To tagCount - 1
                        tags(i) = CType(Marshal.PtrToStructure(pArr, GetType(SwPlcTag)), SwPlcTag)
                        pArr += tagSize
                    Next
                Finally
                    If ptr <> IntPtr.Zero Then
                        Marshal.FreeCoTaskMem(ptr)
                    End If
                End Try
            End If

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcInitPort(ByRef handle As Integer, portName As String, libFileName As String, type As SwPlcCommType, tags As SwPlcTag(), param As String,
            [option] As String) As SwPlcCode
            Dim result As Integer = SwPlcInitPort_(handle, portName, libFileName, CInt(type), tags, tags.Length,
                param, [option])
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcClosePort(handle As Integer) As SwPlcCode
            Dim result As Integer = SwPlcClosePort_(handle)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcComStatus(handle As Integer) As SwPlcCode
            Dim result As Integer = SwPlcComStatus_(handle)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcExecute(handle As Integer) As SwPlcCode
            Dim result As Integer = SwPlcExecute_(handle)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcResponse(handle As Integer, wait As Integer) As SwPlcCode
            Dim result As Integer = SwPlcResponse_(handle, wait)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcClear(handle As Integer) As SwPlcCode
            Dim result As Integer = SwPlcClear_(handle)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetPlcErrorCode(handle As Integer, ByRef errorCode As Integer) As SwPlcCode
            Dim result As Integer = SwPlcGetPlcErrorCode_(handle, errorCode)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcAbort(handle As Integer) As SwPlcCode
            Dim result As Integer = SwPlcAbort_(handle)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcSetNotify(handle As Integer, callBackFunc As SwPlcNotifyCallBackFunc) As SwPlcCode
            Dim result As Integer = SwPlcSetNotify_(handle, callBackFunc)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcRead(handle As Integer, tagId As Integer) As SwPlcCode
            Dim result As Integer = SwPlcRead_(handle, tagId)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteBit(handle As Integer, tagId As Integer, data As Byte) As SwPlcCode
            Dim result As Integer = SwPlcWriteBit_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteBitArray(handle As Integer, tagId As Integer, data As Byte()) As SwPlcCode
            Dim result As Integer = SwPlcWriteBitArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteShort(handle As Integer, tagId As Integer, data As Short) As SwPlcCode
            Dim result As Integer = SwPlcWriteShort_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteShortArray(handle As Integer, tagId As Integer, data As Short()) As SwPlcCode
            Dim result As Integer = SwPlcWriteShortArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteUShort(handle As Integer, tagId As Integer, data As UShort) As SwPlcCode
            Dim result As Integer = SwPlcWriteUShort_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteUShortArray(handle As Integer, tagId As Integer, data As UShort()) As SwPlcCode
            Dim result As Integer = SwPlcWriteUShortArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteInt(handle As Integer, tagId As Integer, data As Integer) As SwPlcCode
            Dim result As Integer = SwPlcWriteInt_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteIntArray(handle As Integer, tagId As Integer, data As Integer()) As SwPlcCode
            Dim result As Integer = SwPlcWriteIntArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteUInt(handle As Integer, tagId As Integer, data As UInteger) As SwPlcCode
            Dim result As Integer = SwPlcWriteUInt_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteUIntArray(handle As Integer, tagId As Integer, data As UInteger()) As SwPlcCode
            Dim result As Integer = SwPlcWriteUIntArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteLong(handle As Integer, tagId As Integer, data As Long) As SwPlcCode
            Dim result As Integer = SwPlcWriteLong_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteLongArray(handle As Integer, tagId As Integer, data As Long()) As SwPlcCode
            Dim result As Integer = SwPlcWriteLongArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteULong(handle As Integer, tagId As Integer, data As ULong) As SwPlcCode
            Dim result As Integer = SwPlcWriteULong_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteULongArray(handle As Integer, tagId As Integer, data As ULong()) As SwPlcCode
            Dim result As Integer = SwPlcWriteULongArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteFloat(handle As Integer, tagId As Integer, data As Single) As SwPlcCode
            Dim result As Integer = SwPlcWriteFloat_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteFloatArray(handle As Integer, tagId As Integer, data As Single()) As SwPlcCode
            Dim result As Integer = SwPlcWriteFloatArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteDouble(handle As Integer, tagId As Integer, data As Double) As SwPlcCode
            Dim result As Integer = SwPlcWriteDouble_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteDoubleArray(handle As Integer, tagId As Integer, data As Double()) As SwPlcCode
            Dim result As Integer = SwPlcWriteDoubleArray_(handle, tagId, data, data.Length)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetBit(handle As Integer, tagId As Integer, ByRef data As Byte) As SwPlcCode
            Dim result As Integer = SwPlcGetBit_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetBitArray(handle As Integer, tagId As Integer, ByRef dataarray As Byte()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Byte)) * dataarray.Length)
                result = SwPlcGetBitArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length)
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetShort(handle As Integer, tagId As Integer, ByRef data As Short) As SwPlcCode
            Dim result As Integer = SwPlcGetShort_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetShortArray(handle As Integer, tagId As Integer, ByRef dataarray As Short()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Short)) * dataarray.Length)
                result = SwPlcGetShortArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length)
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetUShort(handle As Integer, tagId As Integer, ByRef data As UShort) As SwPlcCode
            Dim result As Integer = SwPlcGetUShort_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetUShortArray(handle As Integer, tagId As Integer, ByRef dataarray As UShort()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                Dim bytearray As Byte() = New Byte(dataarray.Length * 2 - 1) {}
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Byte)) * bytearray.Length)
                result = SwPlcGetUShortArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, bytearray, 0, bytearray.Length)

                For i As Integer = 0 To dataarray.Length - 1
                    dataarray(i) = BitConverter.ToUInt16(bytearray, i * 2)
                Next
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetInt(handle As Integer, tagId As Integer, ByRef data As Integer) As SwPlcCode
            Dim result As Integer = SwPlcGetInt_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetIntArray(handle As Integer, tagId As Integer, ByRef dataarray As Integer()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Integer)) * dataarray.Length)
                result = SwPlcGetIntArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length)
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetUInt(handle As Integer, tagId As Integer, ByRef data As UInteger) As SwPlcCode
            Dim result As Integer = SwPlcGetUInt_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetUIntArray(handle As Integer, tagId As Integer, ByRef dataarray As UInteger()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                Dim bytearray As Byte() = New Byte(dataarray.Length * 4 - 1) {}
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Byte)) * bytearray.Length)
                result = SwPlcGetUIntArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, bytearray, 0, bytearray.Length)

                For i As Integer = 0 To dataarray.Length - 1
                    dataarray(i) = BitConverter.ToUInt32(bytearray, i * 4)
                Next
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetLong(handle As Integer, tagId As Integer, ByRef data As Long) As SwPlcCode
            Dim result As Integer = SwPlcGetLong_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetLongArray(handle As Integer, tagId As Integer, ByRef dataarray As Long()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Long)) * dataarray.Length)
                result = SwPlcGetLongArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length)
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetULong(handle As Integer, tagId As Integer, ByRef data As ULong) As SwPlcCode
            Dim result As Integer = SwPlcGetULong_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetULongArray(handle As Integer, tagId As Integer, ByRef dataarray As ULong()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                Dim bytearray As Byte() = New Byte(dataarray.Length * 8 - 1) {}
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Byte)) * bytearray.Length)
                result = SwPlcGetULongArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, bytearray, 0, bytearray.Length)

                For i As Integer = 0 To dataarray.Length - 1
                    dataarray(i) = BitConverter.ToUInt64(bytearray, i * 8)
                Next
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetFloat(handle As Integer, tagId As Integer, ByRef data As Single) As SwPlcCode
            Dim result As Integer = SwPlcGetFloat_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetFloatArray(handle As Integer, tagId As Integer, ByRef dataarray As Single()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Single)) * dataarray.Length)
                result = SwPlcGetFloatArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length)
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetDouble(handle As Integer, tagId As Integer, ByRef data As Double) As SwPlcCode
            Dim result As Integer = SwPlcGetDouble_(handle, tagId, data)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetDoubleArray(handle As Integer, tagId As Integer, ByRef dataarray As Double()) As SwPlcCode
            Dim result As Integer
            Dim ptr As IntPtr = IntPtr.Zero
            Try
                ptr = Marshal.AllocCoTaskMem(Marshal.SizeOf(GetType(Double)) * dataarray.Length)
                result = SwPlcGetDoubleArray_(handle, tagId, ptr, dataarray.Length)
                Marshal.Copy(ptr, dataarray, 0, dataarray.Length)
            Finally
                If ptr <> IntPtr.Zero Then
                    Marshal.FreeCoTaskMem(ptr)
                End If
            End Try

            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcSetMonitorInterval(handle As Integer, ms As Integer) As SwPlcCode
            Dim result As Integer = SwPlcSetMonitorInterval_(handle, ms)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcMonitorStatus(handle As Integer) As SwPlcCode
            Dim result As Integer = SwPlcMonitorStatus_(handle)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcGetMonitorPlcErrorCode(handle As Integer, ByRef errorCode As Integer) As SwPlcCode
            Dim result As Integer = SwPlcGetMonitorPlcErrorCode_(handle, errorCode)
            Return CType(result, SwPlcCode)
        End Function

        Public Shared Function SwPlcWriteLog(handle As Integer, logString As String) As SwPlcCode
            Dim result As Integer = SwPlcWriteLog_(handle, logString)
            Return CType(result, SwPlcCode)
        End Function
    End Class
End Namespace
