# myWiki

This is a Wiki-style editor software that operates in a local environment.

With simple formatting, you can add text decorations and tables, making your documents more comprehensible than plain text.

It can also be used as a draft tool for writing documents on online Wiki or Markdown-based sites.


## How to Use

1. Create a Wiki by selecting **Wiki > Create New Wiki**.
2. Create a page by selecting **Wiki > Create Page**.
3. Enter text by selecting **Wiki > Edit Page**.


## Formatting

The following formats are available:

- Markdown style
- PukiWiki style
- Text


## System Requirements

- Windows 11

It may also be usable on Windows 10 if you install [Microsoft Edge WebView2](https://developer.microsoft.com/ja-jp/microsoft-edge/webview2/).


## Tips

### Using Mermaid Syntax

In Markdown style, you can enable Mermaid syntax by selecting **Settings > Template > default-mermaid**.

Once the template is set, specify the language as mermaid and write your code as follows:

    ```mermaid
    %%{init:{'themeCSS':"p {padding:0.5em}"}}%%
    
    graph LR
    S(((Start))) -- Select A --> A((A))
    S -- Select B --> B((B))
    ```

Note: An internet connection is required to load external JavaScript libraries.

### Writing Mathematical Expressions

By selecting **Settings > Template > default-math**, you can write mathematical expressions using MathJax.

Enclose expressions with `$` for inline mode and `$$` for block mode. In Markdown style, you can also specify the language as `math` as shown below.

    ```math
    \sum_{k=1}^nk=\frac{1}{2}n(n+1)
    ```

Note: An internet connection is required to load external JavaScript libraries.

### Syntax Highlighting

In Markdown style, you can enable syntax highlighting with Shiki by selecting **Settings > Template > default-syntax-highlight**.

Once the template is set, specify the language and write your code as follows:

    ```c
    #include <stdio.h>
    
    int main(void) {
        printf("Hello, World!\n");
        return 0;
    }
    ```

Note: An internet connection is required to load external JavaScript libraries.

### Using Mermaid Syntax, Mathematical Expressions, and Syntax Highlighting Simultaneously

Select **Settings > Template > default-all**.

### Using in Dark Mode

Follow the steps below to set up the color scheme for a dark mode environment:

1. Select **Settings > Style > Windows11 Modern Dark**.
2. Select **Settings > Design > dark**.
3. Exit the application.
4. Restart the application.

### Folding shortcuts

Although they are not displayed in the menu, the following shortcuts are available.

|Features  |Shortcuts       |
|----------|----------------|
|Fold      |Ctrl + Shift + [|
|Fold All  |Ctrl + Shift + -|
|Unfold    |Ctrl + Shift + ]|
|Unfold All|Ctrl + Shift + +|


## License

This software is licensed under the MIT License. It is available for free. For more details, please refer to LICENSE.txt.


## Author

* MASUDA Takashi <https://mas3lab.net/>
