# CommentOut

## Name

Comment Out

## Category

Format

## Notation

- Markdown
- PukiWiki

## Shortcut

Ctrl+/

## Code

```pascal
var BB := Editor.BlockBegin;
var BE := Editor.BlockEnd;

procedure MarkdownComment;
begin
  if (Editor.SelText = '') and (Editor.GetLine(BB.Y) = '') then
  begin
    Editor.SelText := '<!--  -->';
    Editor.CaretX := Editor.CaretX - 4;
    Exit;
  end;

  var
    EndLine: Integer;
  if (BE.X = 1) and (BB.Y < BE.Y) then
    EndLine := BE.Y - 1
  else
    EndLine := BE.Y;
  
  Editor.InsertTextAtLineStart(BB.Y, '<!-- ');
  Editor.AppendTextAtLine(EndLine, ' -->');
  
  Editor.ExecuteCommand(ecCaretsAtLineEnds);
  Editor.ExecuteCommand(ecRight);
end;

procedure PukiWikiComment;
var
  EndLine: Integer;
begin
  if (BE.X = 1) and (BB.Y < BE.Y) then
    EndLine := BE.Y - 1
  else
    EndLine := BE.Y;

  for var I := BB.Y to EndLine do
  begin
    Editor.InsertTextAtLineStart(I, '// ');
  end;
  
  Editor.ExecuteCommand(ecCaretsAtLineEnds);
  Editor.ExecuteCommand(ecRight);
end;

Editor.BeginUndoBlock;
try
  case Editor.Notation of
    NotationMarkdown: 
      MarkdownComment;
    NotationPukiWiki: 
      PukiWikiComment;
  end;
finally
  Editor.EndUndoBlock;
end;
```
