# UnorderedList

## Name

Unordered List

## Category

Format

## Notation

- Markdown
- PukiWiki
- Text

## Shortcut

## Code

```pascal
var BB := Editor.BlockBegin;
var BE := Editor.BlockEnd;

Editor.BeginUndoBlock;
try
  var EndLine := BE.Y;
  if (BE.X = 1) and (BB.Y < BE.Y) then
    Dec(EndLine);

  if (BB.Y = EndLine) and (Editor.GetLine(BB.Y) = '') then
  begin
    Editor.SetLine(BB.Y, '- ');
    Exit;
  end;

  for var I := BB.Y to EndLine do
  begin
    var Line := Editor.GetLine(I);
    if Line = '' then
      Continue;

    Line := RegEx.Replace(Line, '^(- )?', '- ', False, False);
    Editor.SetLine(I, Line);
  end;

  Editor.ExecuteCommand(ecRight);
finally
  Editor.EndUndoBlock;
end;
```
