# Komic Viewer v1.2

📖 軽量で使いやすいコミック・マンガビューアー

## 🎯 特徴

- **軽量・高速**: .NET 9.0ベースで軽快な動作
- **多彩な表示モード**: 単ページ・見開き表示に対応
- **豊富な対応形式**: ZIP, RAR, CBZ, CBR形式をサポート
- **テーマ切り替え**: ライト・ダークテーマ対応
- **直感的操作**: マウス・キーボード・ホイール・ツールバースクロールバーでの快適なナビゲーション
- **フルスクリーン対応**: 集中して読書を楽しめる（自動非表示ツールバー付き）
- **最前面表示**: 他のウィンドウの上に常に表示可能（ダイアログ表示も安全）
- **設定保存**: ウィンドウサイズ、表示モード、テーマなどを自動保存
- **ドラッグ&ドロップ**: ファイルを簡単に開ける

## 📥 インストール・使用方法

### 📦 パッケージ内容
本パッケージは **.NET同梱版（自己完結型）** です。
.NETランタイムを内蔵しており、インストール不要でどこでも実行可能です。

- **必要環境**: なし（追加のインストールは一切不要）
- **メリット**: ランタイムの有無を気にせず、ダブルクリックするだけで確実に起動します。

### インストール手順
1. ダウンロードしたZIPファイルを展開
2. `KomicViewer.exe` を実行

## 🚀 使い方

### ファイルを開く
- **ドラッグ&ドロップ**: ファイルをウィンドウにドロップ
- **メニューから**: 📁ファイル → 開く
- **ショートカット**: `Ctrl + O`

### ページナビゲーション
| 操作 | 説明 |
|------|------|
| `→` `↓` `Space` `PageDown` | 次のページ |
| `←` `↑` `PageUp` | 前のページ |
| `Home` | 最初のページ |
| `End` | 最後のページ |
| **マウスクリック** | 画面左端・右端（100px幅）で前/次のページ |
| **マウスホイール** | 上で前のページ、下で次のページ |
| **ツールバースクロールバー** | 上部ツールバーのスクロールバーで任意のページにジャンプ |

**クリック領域の視覚表示**: マウスが左右の端（100px幅）に入ると、半透明の青い矢印が表示されます。

### 見開きモード専用機能
| 操作 | 右開き時の動作 | 左開き時の動作 |
|------|---------------|---------------|
| **◁ ボタン** | 1ページ送る | 1ページ戻す |
| **▷ ボタン** | 1ページ戻す | 1ページ送る |
| **右開き/左開き** | 読み方向切り替えボタン | 読み方向切り替えボタン |
| `Shift + →` | 1ページ戻す | 1ページ送る |
| `Shift + ←` | 1ページ送る | 1ページ戻す |

**注意**: 見開きモード専用機能は単ページモード時には非表示になります。

### 表示モード
| キー | 機能 |
|------|------|
| `1` | 単ページモード |
| `2` | 見開きモード |
| `F11` | フルスクリーン切り替え |
| `Esc` | フルスクリーン終了 |

### フルスクリーン機能
- **自動非表示ツールバー**: フルスクリーン時、マウスを画面上部（52px以内）に移動するとツールバーが表示
- **1秒自動非表示**: マウスが上部から離れると1秒後に自動的にツールバーが非表示
- **動的ボタン**: フルスクリーンボタンが「⛶ フルスクリーン」↔「🗗 元のサイズ」に動的変更
- **ツールバースクロールバー**: フルスクリーン時もツールバーのスクロールバーでページナビゲーション可能

### その他の機能
- **読み方向切り替え**: ツールバーで右開き/左開きを変更
  - **右開き（日本式）**: 見開き時、右側に小さいページ番号、左側に大きいページ番号
  - **左開き（欧米式）**: 見開き時、左側に小さいページ番号、右側に大きいページ番号
- **テーマ切り替え**: 🌙ダーク / ☀️ライトテーマの切り替え
- **最前面表示**: 📌ボタンでウィンドウを常に最前面に表示
- **ファイルを閉じる**: `Ctrl + W`

## 📁 対応ファイル形式

### アーカイブ形式
- **ZIP** (`.zip`, `.cbz`)
- **RAR** (`.rar`, `.cbr`)

### 画像形式（アーカイブ内）
- JPEG (`.jpg`, `.jpeg`)
- PNG (`.png`)
- GIF (`.gif`)
- BMP (`.bmp`)
- WebP (`.webp`)

## 🔧 トラブルシューティング

### ファイルが開けない
- **対応形式を確認**: ZIP, RAR, CBZ, CBR のみ対応
- **ファイル破損**: 別のアーカイブツールで確認
- **パスワード保護**: 現在未対応

### 画像が表示されない
- **画像形式を確認**: JPEG, PNG, GIF, BMP, WebP のみ対応
- **ファイル名**: 日本語ファイル名でも対応

## 📞 サポート

- **E-Mail**: tikomo@gmail.com
- **HP**: https://tikomosoftware.github.io

## 📋 更新履歴

### v1.2 (2026-02-02)
**画像デコードの堅牢性向上と安定性の改善**
- **画像デコードのフォールバック機構**:
  - 標準のGDI+で読み込めないJPEGファイル等のデコードにSkiaSharpを使用するフォールバック処理を実装。
- **画像キャッシュとメモリ管理の最適化**:
  - 画像読み出し速度向上のためのキャッシュ機能を実装。
- **表示処理の効率化**:
  - 見開き表示時の画像取得・判定ロジックをリファクタリングし、パフォーマンスを改善。

---

**Komic Viewer** - シンプルで快適なコミック読書体験を提供します 📚✨

---

© 2026 tikomo software
