/** makepassword.cpp
 * pX[h𐶐iWindowsAvŁj
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-05-01.shtm
*/
//  ======================================================
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <richedit.h>
#include <random>
#include <boost/program_options.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/format.hpp>
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::program_options;
using namespace boost::property_tree;

#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"makepassword"			// AvP[ViGUIŁj
#define APPNAMEJP	"pX[h@"		// AvP[V
#define APPCMD		"mkpsw"					// AvP[ViCUIŁj
#define APPVERSION	"1.3.3"					// o[W
#define APPYEAR		"2020-2026"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-05-01.shtm"	// QlTCg

// char*obt@TCY
#define SIZE_BUFF		512

// WtHg
#define FONT_FACE		"MS UI Gothic"

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// IvV
#define OPTION_UPPER	'u'		// p啶
#define OPTION_LOWER	'a'		// p
#define OPTION_NUMBER	'n'		// 
#define OPTION_SYMBOL	's'		// L

// pX[hɎgZbg
const string Seed[] = {
	"ABCDEFGHIJKLMNOPQRSTUVWXYZ",		// p啶
	"abcdefghijklmnopqrstuvwxyz",		// p
	"0123456789"						// 
};
// pX[hɎgL
#define DEF_SYMBOL	"()%$#+-*"
string Symbol = DEF_SYMBOL;

// IvV̏l
#define OPTION_INIT		"an"

// pX[h̍ŏƍő包
#define MIN_PASSWORD	4
#define MAX_PASSWORD	20

// pX[h
unsigned PswLen = MIN_PASSWORD;

// ֌W
std::random_device rnd;			// 񌈒Iȗ𐶐
std::mt19937 mt((int)time(0));	// ZkEcCX^32rbgŁ{V[h

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

̃Cu𗘗pĂ܂D
MinGWig++j^Boost C++Cu
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// CUIwv
string Help = (boost::format(R"(
%1%  o[W %2%

%3%.exe -IvV
        -l, --len     pX[h̒il%4%j
    pX[hɊ܂߂镶
        -u, --upper   p啶
        -a, --alpha   p
        -n, --number  
        -s, --symbol  L
    ̑
        -p, --paste   Nbv{[h֏o
        -v, --version o[W
        -h, --help    ICwv

ij%3% -l11 -p  11̃pX[h𐶐CNbv{[hɃRs[
)")
% APPNAMEJP
% APPVERSION
% APPCMD
% MIN_PASSWORD).str();

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
*/
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, SIZE_BUFF);
	PTSTR pText = (PTSTR)GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

// pX[h ===========================================================
/**
 * pX[h𐶐
 * @param  unsigned	len pX[h̒
 * @param  string	str pX[hɎg̕
 * @return string	pX[h
*/
string make_password(unsigned len, string str) {
	int n;

	// ͈͎w̃ZkEcCX^
	std::uniform_int_distribution<> mt_rand(0, str.length() - 1);

	string psw = "";
	for (unsigned i = 0; i < len; i++) {
		n = mt_rand(mt);
		psw = psw + str.substr(n, 1);	// 1ǉ
	}
	return psw;
}

#ifndef CMDAPP
// GUI =================================================================
/**
 * eLXg{bNX琮擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return int 擾l
*/
int getIntEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));

	return atoi(buff);
}

/**
 * eLXg{bNXɐ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  int		i     ݒl
 * @return Ȃ
*/
void setIntEditBox(HWND hDlg, unsigned id, int i) {
	char buff[SIZE_BUFF];
	snprintf(buff, sizeof(buff), "%d", i);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * eLXg{bNX當擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
*/
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));
	return (string)buff;
}

/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
*/
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[SIZE_BUFF];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
*/
void CenterWindow(HWND hDlg) {
	int  x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

/**
 * pX[h\
 * @param  HWND   hDlg _CAOID
 * @return string	Ȃ
*/
void put_password(HWND hDlg) {
	// pX[h̒
	PswLen = getIntEditBox(hDlg, IDC_EDIT_NUM);
	if (PswLen < MIN_PASSWORD)		PswLen = MIN_PASSWORD;
	if (PswLen > MAX_PASSWORD)		PswLen = MAX_PASSWORD;
	setIntEditBox(hDlg, IDC_EDIT_NUM, PswLen);

	// pX[hΏە
	string str = "";
	// p啶
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT1), BM_GETCHECK, 0, 0)) {
		str = str + Seed[0];
	}
	// p
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT2), BM_GETCHECK, 0, 0)) {
		str = str + Seed[1];
	}
	// 
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT3), BM_GETCHECK, 0, 0)) {
		str = str + Seed[2];
	}
	// L
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT4), BM_GETCHECK, 0, 0)) {
		Symbol = getStrEditBox(hDlg, IDC_EDIT_OPT4);
		str = str + Symbol;
	}

	// pX[hƕ\
	if (str != "") {
		string psw = make_password(PswLen, str);
		setStrEditBox(hDlg,IDC_EDIT_PSW, psw);
	}
}

// IvVǍ^ۑ ====================================================
/**
 * AppDatãpX擾
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * IvV̓ǂݍ
 * @param	Ȃ
 * @return	string IvV
 */
string loadOption(void) {
	hParent_X = 0;
	hParent_Y = 0;
	PswLen = MIN_PASSWORD;
	string option = OPTION_INIT;
	ptree pt;

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (boost::optional<std::string>str = pt.get_optional<string>("parameter")) {
			} else {
				return OPTION_INIT;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "len") {
					PswLen = (unsigned)stoi(it.second.data());
				} else if (type == "option") {
					option = (string)it.second.data();
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				} else if (type == "symbol") {
					Symbol = (string)it.second.data();
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			hParent_X = 0;
			hParent_Y = 0;
			PswLen = MIN_PASSWORD;
			Symbol = DEF_SYMBOL;
			return OPTION_INIT;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		hParent_X = 0;
		hParent_Y = 0;
		PswLen = MIN_PASSWORD;
		Symbol = DEF_SYMBOL;
		return OPTION_INIT;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}

	return option;
}

/**
 * IvV̕ۑ
 * @param	string option IvV
 * @param	HWND   hDlg _CAOID
 * @return	Ȃ
 */
void saveOption(string option, HWND  hDlg) {
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
	// L̕擾
	Symbol = getStrEditBox(hDlg, IDC_EDIT_OPT4);

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", (string)to_string(PswLen));
	child1.add("<xmlattr>.type", "len");
	ptree& child2 = pt.add("parameter.param", option);
	child2.add("<xmlattr>.type", "option");
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_X));
	child3.add("<xmlattr>.type", "wx");
	ptree& child4 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child4.add("<xmlattr>.type", "wy");
	ptree& child5 = pt.add("parameter.param", Symbol);
	child5.add("<xmlattr>.type", "symbol");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

// IvV擾Eݒ ======================================================
/**
 * IvVݒ肷
 * @param	HWND hDlg	EBhEEnh
 * @param	string opt	IvV
 * @return	Ȃ
 */
void setOption(HWND hDlg, string opt) {
	for (int i = 0; i < (int)opt.length(); i++) {
		char* ch = (char*)opt.substr(i, 1).c_str();
		switch (*ch) {
		case OPTION_UPPER:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT1),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		case OPTION_LOWER:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT2),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		case OPTION_NUMBER:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT3),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		case OPTION_SYMBOL:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT4),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		default:
			break;
		}
	}
}

/**
 * IvV擾
 * @param	HWND hDlg	EBhEEnh
 * @return	string IvV
 */
string getOption(HWND hDlg) {
	string opt = "";
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT1), BM_GETCHECK, 0, 0)) {
		opt += OPTION_UPPER;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT2), BM_GETCHECK, 0, 0)) {
		opt += OPTION_LOWER;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT3), BM_GETCHECK, 0, 0)) {
		opt += OPTION_NUMBER;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_OPT4), BM_GETCHECK, 0, 0)) {
		opt += OPTION_SYMBOL;
	}

	return opt;
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg	EBhEEnh
 * @paramm	UINT uMsg
 * @param	WPARAM wParam
 * @paramL	PARAM lParam
 * @return	INT_PTR CALLBACK
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
	return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	LPNMUPDOWN lpnmud;
	HICON hIcon;
	static string option = OPTION_INIT;
	string psw = "";

    switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		// IvVǂݍ
		option = loadOption();
		setIntEditBox(hDlg, IDC_EDIT_NUM, PswLen);
		setOption(hDlg, option);
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		// LZbg
		setStrEditBox(hDlg,IDC_EDIT_OPT4, Symbol);
		// pX[h
		put_password(hDlg);
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
			// pX[h
			case IDM_EXEC:
			case IDC_BUTTON_EXEC:
				put_password(hDlg);
				break;
			// wv
			case IDM_HELP:
				ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
				break;
			// o[W\
			case IDM_VERSION:
				createHelp(hParent, processHelp);
				break;
			// TCg
			case IDM_PAHOO:
				ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
				break;
			// Rs[
			case IDM_COPY:
			case IDC_BUTTON_COPY:
				psw = getStrEditBox(hDlg, IDC_EDIT_PSW);
				setClipboardData(psw);
				break;
			// ؂
			case IDM_DELETE:
				setStrEditBox(hParent, IDC_EDIT_PSW, "");
				break;
			// vOI
			case IDM_QUIT:
				// IvVۑ
				option = getOption(hDlg);
				saveOption(option, hDlg);
				EndDialog(hParent, 0);
				return 0;
			default:
				break;
		}
		break;

	// Spin Control
	case WM_NOTIFY:
		if (wParam == (WPARAM)IDC_SPIN_NUM) {
			lpnmud = (LPNMUPDOWN)lParam;
			if (lpnmud->hdr.code == UDN_DELTAPOS) {
				PswLen = getIntEditBox(hDlg, IDC_EDIT_NUM);
				if ((lpnmud->iDelta) < 0) {
					PswLen++;
				} else if ((lpnmud->iDelta) > 0) {
					PswLen--;
				}
				if (PswLen < MIN_PASSWORD) {
					PswLen = MIN_PASSWORD;
				}
				if (PswLen > MAX_PASSWORD) {
					PswLen = MAX_PASSWORD;
				}
				setIntEditBox(hDlg, IDC_EDIT_NUM, PswLen);
			}
		}
		break;

	// vOI
	case WM_CLOSE:
		// IvVۑ
		option = getOption(hDlg);
		saveOption(option, hDlg);
		EndDialog(hDlg, 0);
		break;
	}
    return 0;
}

// GUICvO ======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");
	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);

	return 0;
}

#else
// CUICvO ======================================================
/**
 * CUIpCvO
 * @param	int argc
 * @paramm	char* argv[]
 * @return	int ^[R[h
 */
int main(int argc, char* argv[]) {
	string str = "";
	string psw = "";

	// R}hCEIvV̒`
	options_description options("R}hCEIvV");
	options.add_options()
		("len,l", value<unsigned>(), "")
		("upper,u",   "p啶")
		("alpha,a",   "p")
		("number,n",  "")
		("symbol,s",  "L")
		("paste,p",   "Nbv{[h֏o")
		("help,h",    "wv")
		("version,v", "o[W")
		;
	// R}hCEIvV̎擾
	variables_map vm;
	try {
		store(parse_command_line(argc, argv, options), vm);
	} catch(const boost::program_options::error_with_option_name& e) {
		ErrorMessage =  e.what();
		cerr << ErrorMessage << endl;
		return 1;
	}
	notify(vm);

	// wv
	if (vm.count("help")) {
		cout << Help;
	// o[W
	} else if (vm.count("version")) {
		cout << Version;

	// pX[h
	} else {
		// IvV߁pX[h
		if (vm.count("upper")) {
			str = str + Seed[0];
		}
		if (vm.count("alpha")) {
			str = str + Seed[1];
		}
		if (vm.count("number")) {
			str = str + Seed[2];
		}
		if (vm.count("symbol")) {
			str = str + Symbol;
		}
		// IvVw肪Ƃ
		if (str.length() == 0) {
			str = Seed[1] + Seed[2];
		}
		// 
		if (vm.count("len")) {
			PswLen = (unsigned)vm["len"].as<unsigned>();
		} else {
			PswLen = MIN_PASSWORD;
		}
		// pX[h
		if ((PswLen >= MIN_PASSWORD) && (PswLen <= MAX_PASSWORD)) {
			psw = make_password(PswLen, str);
		} else {
			ErrorMessage = " " + to_string(MIN_PASSWORD) + "ȏC" + to_string(MAX_PASSWORD) + "ȉ̐w肵Ă";
			cerr << ErrorMessage << endl;
			return 1;
		}

		// Nbv{[h֏o
		if (vm.count("paste")) {
			setClipboardData(psw);
		// Wo͂֏o
		} else {
			cout << psw;
		}
	}

	return 0;
}

#endif

/*
** o[WAbv =====================================================
 *
 * @version 1.3.3  2026/02/07 gpCuXV, optionalOՓˉ
 * @version 1.3.2  2025/10/11 gpCuXV
 * @version 1.3.1  2025/06/21 gpCuXV
 * @version 1.3.0  2025/02/24 L̕wł悤ɂCgpCuXV
 * @version 1.2.7  2024/11/03 gpCuXV
 * @version 1.2.6  2024/07/07 gpCuXV
 * @version 1.2.5  2024/02/17 gpCuXV
 * @version 1.2.4  2023/10/09 gpCuXV
 * @version 1.2.3  2023/06/03 gpCuXV
 * @version 1.2.2  2023/01/28 gpCuXV
 * @version 1.2.1  2022/10/31 gpCuXV
 * @version 1.2    2022/07/17 CUIłǉCgpCuVerUp
 * @version 1.1    2020/09/05 CXg[[Cwvt@CCj[ǉ
 * @version 1.0    2020/07/12 
*/
