# Redmine Time Tracker - ユーザーマニュアル

**[English](USER_GUIDE.en.md)** | 日本語

---

**バージョン**: 1.1  
**最終更新日**: 2026年2月14日

---

### 🎉 バージョン 1.1 の新機能

- **子チケットの一括作成機能の強化**:
  *   **階層構造（親子関係）の自動作成**: 行の先頭をインデントすることで、深い階層のチケットを一気に作成できるようになりました。
  *   **共通説明文の設定**: 全てのチケットの説明欄に共通のキーワードや定型文を挿入できるようになりました。
  *   **作成順序の保証**: 入力したテキストの並び順通りに正確にRedmineへ登録されます。
- **UI/UXの改善**:
  *   一括作成ダイアログのレイアウトを調整し、使い勝手を向上させました。
  *   各種エラーメッセージの日本語化と、コードの安定性を高めました。

## 📖 目次

1. [はじめに](#はじめに)
2. [インストール](#インストール)
3. [初期設定](#初期設定)
4. [基本的な使い方](#基本的な使い方)
5. [応用的な使い方](#応用的な使い方)
6. [トラブルシューティング](#トラブルシューティング)
7. [FAQ（よくある質問）](#faqよくある質問)

---

## はじめに

### このアプリケーションについて

**Redmine Time Tracker** は、Redmineへの作業時間入力を効率化するためのデスクトップアプリケーションです。

**主な目的**: 毎日の作業時間入力の**手間を省く**こと

このアプリは、時間エントリーの**作成・更新**に特化しています。削除や詳細な編集はRedmineの管理画面で行ってください。

### こんな方におすすめ

- ✅ 毎日同じチケットに作業時間を入力している
- ✅ 月末にまとめて作業時間を入力するのが面倒
- ✅ 定例会議や朝会など、定期的なタスクの入力を自動化したい
- ✅ 作業時間の入力漏れをなくしたい

### できること

1. **テンプレート機能**: よく使うチケットをテンプレートとして登録
2. **一括登録**: 1ヶ月分の作業時間をワンクリックで登録
3. **カレンダー表示**: 登録状況を視覚的に確認
4. **柔軟な頻度設定**: 毎日、毎週、月次など、様々なパターンに対応

---

## インストール

### 必要なもの

- **OS**: Windows 10 以降
- **ネットワーク**: Redmineサーバーへの接続環境
- **Redmine**: バージョン 3.0 以降（REST API対応）

### パッケージの選択

2種類のパッケージから選択できます：

#### 1. Standalone版（推奨）
- **ファイル名**: `RedmineSupTool-vX.X.X-standalone.zip`
- **特徴**: .NET Runtimeが同梱されているため、**すぐに使える**
- **こんな方に**: 「とにかく簡単に使いたい」という方

#### 2. Framework-dependent版（軽量版）
- **ファイル名**: `RedmineSupTool-vX.X.X-framework-dependent.zip`
- **特徴**: ファイルサイズが小さい
- **条件**: 別途 [.NET 9.0 Runtime](https://dotnet.microsoft.com/download/dotnet/9.0) のインストールが必要
- **こんな方に**: 「.NET Runtimeは既にインストール済み」という方

### インストール手順

1. **ZIPファイルをダウンロード**
   - GitHubのReleasesページから、お好みのパッケージをダウンロードします

2. **ZIPファイルを解凍**
   - ダウンロードしたZIPファイルを右クリック → 「すべて展開」
   - 任意のフォルダに解凍します（例: `C:\Apps\RedmineSupTool`）

3. **アプリケーションを起動**
   - 解凍したフォルダ内の `redmineSupTool.exe` をダブルクリック

> **💡 ヒント**: デスクトップにショートカットを作成しておくと便利です

---

## 初期設定

### 1. 初回起動時の設定

アプリケーションを初めて起動すると、自動的に設定画面が表示されます。

### 2. Redmine接続情報の入力

以下の情報を入力します：

#### Redmine URL
- あなたの組織のRedmineサーバーのURLを入力します
- **例**: `https://redmine.example.com`
- **注意**: 末尾の `/` は不要です

#### API Key
- RedmineのAPI Keyを入力します
- API Keyの取得方法:
  1. Redmineにログイン
  2. 右上のアカウント名をクリック → 「個人設定」
  3. 右側のメニューから「APIアクセスキー」をクリック
  4. 「表示」ボタンをクリックして、表示されたキーをコピー

> **⚠️ 重要**: API Keyはローカルに平文で保存されます。共有PCでの使用には注意してください。

### 3. 接続テスト

1. 「接続テスト」ボタンをクリック
2. 「接続に成功しました！」と表示されればOK
3. エラーが表示された場合は、URLとAPI Keyを確認してください

### 4. 設定を保存

「保存」ボタンをクリックして設定を保存します。

---

## 基本的な使い方

### ステップ1: 作業テンプレートを作成する

#### テンプレートとは？

よく使うチケットの情報（チケットID、時間、作業分類など）を保存しておく機能です。

#### テンプレートの作成手順

1. **「+ 追加」ボタンをクリック**
   - メイン画面上部の「作業テンプレート」セクションにあります

2. **テンプレート情報を入力**

   **名前**
   - テンプレートの識別名を入力します
   - 例: 「朝会」「設計作業」「週次ミーティング」

   **チケットID**
   - Redmineのチケット番号を入力します
   - 例: `1234`

   **時間(h)**
   - 作業時間を選択します
   - 0.5時間刻みで、最大8.0時間まで選択可能
   - 例: `0.5`（30分）、`4.0`（4時間）

   **作業分類**
   - Redmineの作業分類を選択します
   - 例: 「設計作業」「開発」「テスト」
   - ※ Redmineに登録されている作業分類が自動的に表示されます

   **頻度**
   - このテンプレートをいつ適用するかを選択します
   - 詳細は次のセクションで説明します

3. **「保存」ボタンをクリック**

#### テンプレートの有効/無効

テンプレート一覧の**左端にあるチェックボックス**で、テンプレートの有効/無効を切り替えられます。

**チェックON（☑）**:
- このテンプレートは**有効**
- 一括登録の**対象に含まれる**

**チェックOFF（☐）**:
- このテンプレートは**無効**
- 一括登録の**対象外**（登録されない）

**使用例**:
- 一時的に使わないテンプレートを無効化
- 特定の月だけ使うテンプレートを管理
- 削除せずに保管しておきたい場合

> **💡 ヒント**: チェックが外れていると登録されません。「登録されない」という問題があったら、まずチェックボックスを確認してください。


#### 頻度の設定方法

テンプレートをいつ適用するかを設定します。

##### 📅 毎日（月～金）
- 月曜日から金曜日の平日に毎日適用されます
- **使用例**: 朝会、日報作成など

##### 📅 毎週
- 指定した曜日に適用されます
- 複数の曜日を選択可能です
- **使用例**: 
  - 月曜日の週次ミーティング
  - 火・木のコードレビュー

**設定方法**:
1. 「毎週」を選択
2. 対象曜日のチェックボックスをON
   - 例: 月曜日だけなら「月」のみチェック
   - 例: 火・木なら「火」と「木」をチェック

##### 📅 月次
- 月に1回、指定した日に適用されます
- **使用例**: 月末の報告書作成、月初のミーティング

**設定方法**:
1. 「月次」を選択
2. 日付を選択
   - 「1」～「31」: その日に適用（例: 毎月5日）
   - 「月末」: その月の最終日に適用

> **💡 ヒント**: 31日がない月（2月、4月など）で「31」を選択した場合、その月では適用されません

---

### ステップ2: カレンダーで登録状況を確認する

#### カレンダーの見方

メイン画面の下半分に、月次カレンダーが表示されます。

#### 日付セルの色の意味

| 色 | 意味 |
|---|---|
| **緑色の背景** | 作業時間が登録済み |
| **白色の背景** | 平日で未登録 |
| **グレーの背景** | 土日（登録対象外） |
| **薄いオレンジの背景** | 除外日（休日設定） |
| **薄い青の背景** | 出勤日（土日を出勤日として設定） |

#### 日付セルの表示内容

各日付セルには、以下の情報が表示されます：

- **✓ 4.5h**: 作業時間が登録済み（合計4.5時間）
- **🚫 休日**: 除外日として設定されている
- **🏢 出勤日**: 土日を出勤日として設定
- **- 未登録**: 平日で未登録

#### 対象月の変更

画面上部の「対象月」ドロップダウンから、表示する月を変更できます。
- 前月、当月、翌月の3ヶ月分が選択可能です

---

### ステップ3: 一括登録を実行する

#### 一括登録とは？

作成したテンプレートに基づいて、1ヶ月分の作業時間を自動的にRedmineに登録する機能です。

#### 一括登録の手順

1. **プレビューで確認（推奨）**
   - 「プレビュー表示」ボタンをクリック
   - どの日にどのテンプレートが適用されるかを確認できます
   - 確認後、ウィンドウを閉じます

2. **一括登録を実行**
   - 「月全体に一括登録」ボタンをクリック
   - 確認ダイアログが表示されます

3. **確認ダイアログで内容を確認**
   - 対象月と登録件数が表示されます
   - 問題なければ「はい」をクリック

4. **登録処理の実行**
   - 登録処理が開始されます
   - 画面下部のステータスバーに進捗が表示されます
   - 処理中は画面を閉じないでください

5. **結果の確認**
   - 処理完了後、結果ダイアログが表示されます
   - 以下の情報が表示されます:
     - **新規**: 新しく登録された件数
     - **上書き**: 既存のエントリーを更新した件数
     - **スキップ**: 登録対象外だった日数（土日、除外日など）
     - **エラー**: エラーが発生した件数

#### 一括登録の対象日

以下の条件を満たす日のみが登録対象となります：

✅ **登録される日**
- 月曜日～金曜日の平日
- 出勤日として設定された土日

❌ **登録されない日**
- 土曜日・日曜日（出勤日設定されていない場合）
- 除外日として設定された日

#### 既存エントリーの扱い

- **同じ日・同じチケットIDのエントリーが既に存在する場合**: 上書き更新されます
- **同じ日に複数のテンプレートが適用される場合**: それぞれ別のエントリーとして登録されます

> **⚠️ 注意**: 一括登録を実行すると、既存のエントリーが上書きされる可能性があります。プレビューで事前確認することをおすすめします。

---

### ステップ4: テンプレートの編集・削除

#### テンプレートの編集

1. 編集したいテンプレートの「編集」ボタンをクリック
2. テンプレート情報を修正
3. 「保存」ボタンをクリック

#### テンプレートの削除

1. 削除したいテンプレートの「削除」ボタンをクリック
2. 確認ダイアログで「はい」をクリック

> **💡 ヒント**: テンプレートを削除せずに一時的に使わない場合は、チェックボックスを外して無効化してください（詳細は「ステップ1: 作業テンプレートを作成する」を参照）。

---

## 応用的な使い方

### 休日・出勤日の設定

#### 除外日（休日）の設定

平日を休日として設定し、一括登録の対象外にできます。

**設定方法**:
1. カレンダーで対象の日付を右クリック
2. 「休日に設定する（登録スキップ）」を選択

**使用例**:
- 有給休暇を取得した日
- 祝日
- 会社の休業日

**解除方法**:
1. 除外日に設定された日付を右クリック
2. 「除外を解除する」を選択

#### 出勤日の設定

土日を出勤日として設定し、一括登録の対象に含めることができます。

**設定方法**:
1. カレンダーで土曜日または日曜日を右クリック
2. 「出勤日に設定する」を選択

**使用例**:
- 休日出勤した日
- 振替出勤日

**解除方法**:
1. 出勤日に設定された日付を右クリック
2. 「出勤日設定を解除する」を選択

### 子チケットの一括作成

大量の子チケット（サブタスク）を一度に作成したい場合に便利な機能です。

**使用手順**:

1. **メニューから「ツール」→「子チケットの一括作成...」を選択**
2. **親チケットIDを入力**
   - これらのチケットの親となる既存チケットのIDを入力します。
   - 作成される子チケットは、親チケットと同じプロジェクト、トラッカー（タスクの種類）を継承します。
3. **チケットタイトルを入力**
   - 1行に1つのタイトルを入力します。
   - 入力した行数分だけ、順番にチケットが作成されます。
4. **説明（共通のキーワード）を入力（任意）**
   - 作成されるすべてのチケットの「説明」欄に挿入したい共通のテキスト（キーワードや定型文など）を入力できます。
5. **「一括作成」ボタンをクリック**
   - 順次作成が開始され、進捗が表示されます。

**特徴**:
- **正確な順番**: 入力されたテキストの並び順通りに作成されるため、Redmine上でもID順に並び、順番を固定しやすくなります。
- **階層構造（親子関係）の自動作成**: 行の先頭にスペースやタブを入れてインデントすることで、チケットの階層構造を表現できます。
  - インデントがない行は、指定した「親チケット」の直下の子として作成されます。
  - インデントされた行は、その直前にある上の階層のチケットの子（孫チケット）として作成されます。
- **大規模対応**: 10件、20件といった大量のチケットも数秒で作成可能です。

---

### プレビュー機能の活用

#### プレビュー機能とは？

一括登録を実行する前に、どの日にどのテンプレートが適用されるかを確認できる機能です。

#### プレビューの見方

「プレビュー表示」ボタンをクリックすると、以下のような内容が表示されます：

```
== 2026年2月 登録プレビュー ==

2/3 (月)
  朝会 (#1234) 0.5h
  設計作業 (#5678) 4.0h

2/4 (火)
  朝会 (#1234) 0.5h
  設計作業 (#5678) 4.0h

2/5 (水)
  朝会 (#1234) 0.5h
  設計作業 (#5678) 4.0h
  週次ミーティング (#9012) 1.0h

...

合計: 45件, 180.0h
```

#### プレビューの活用方法

- ✅ 登録漏れがないか確認
- ✅ 意図しない日に登録されていないか確認
- ✅ 合計時間が妥当か確認
- ✅ テンプレートの設定ミスがないか確認

---

### 通信ログの確認

#### 通信ログとは？

アプリケーションがRedmineと行っている通信（APIリクエスト）を確認できる機能です。

#### ログの表示方法

1. メニューバーの「表示」をクリック
2. 「通信ログを表示」にチェックを入れる
3. 画面右側にログパネルが表示されます

#### ログパネルの操作

**幅の調整**:
- メインコンテンツとログパネルの間の灰色の線をドラッグして、幅を調整できます

**ログのクリア**:
- ログパネル下部の「クリア」ボタンをクリック

#### ログの見方

ログには以下のような情報が記録されます：

```
[09:32:45] --- データ読込開始 ---
[09:32:45] テンプレート読込: 6件
[09:32:45] GET /enumerations/time_entry_activities.json
[09:32:46] 作業分類取得: 5件
[09:32:46] GET /time_entries.json?spent_on=>=2026-02-01&spent_on<=2026-02-29
[09:32:47] 既存時間取得: 45件
[09:32:47] --- データ読込完了 ---
```

#### ログの活用方法

- ✅ エラーが発生した時の原因調査
- ✅ どのAPIが呼ばれているか確認
- ✅ 通信が正常に行われているか確認

---

### 設定の変更

#### 接続設定の変更

Redmine URLやAPI Keyを変更したい場合：

1. メニューバーの「設定」をクリック
2. 「接続設定...」を選択
3. 設定ダイアログが表示されます
4. 必要な情報を変更
5. 「接続テスト」で確認（推奨）
6. 「保存」ボタンをクリック

---

## トラブルシューティング

### 接続エラーが発生する

#### エラーメッセージ: 「対象のコンピューターによって拒否されたため、接続できませんでした」

**原因**:
- Redmineサーバーが起動していない
- ネットワークに接続されていない
- Redmine URLが間違っている

**解決方法**:
1. ブラウザでRedmine URLにアクセスできるか確認
2. ネットワーク接続を確認
3. 設定画面でRedmine URLを確認
4. ファイアウォールやプロキシの設定を確認

---

#### エラーメッセージ: 「401 Unauthorized」

**原因**:
- API Keyが間違っている
- API Keyが無効化されている

**解決方法**:
1. Redmineにログインして、API Keyを再確認
2. 設定画面でAPI Keyを再入力
3. 接続テストを実行

---

#### エラーメッセージ: 「404 Not Found」

**原因**:
- Redmine URLが間違っている
- RedmineのREST APIが無効になっている

**解決方法**:
1. Redmine URLの末尾に `/` がないか確認（不要です）
2. Redmine管理者に、REST APIが有効になっているか確認

---

### 一括登録がうまくいかない

#### 「有効なテンプレートがありません」と表示される

**原因**:
- すべてのテンプレートが無効になっている

**解決方法**:
1. テンプレート一覧で、少なくとも1つのテンプレートのチェックボックスをONにする

---

#### 一部の日だけ登録されない

**原因**:
- その日が除外日として設定されている
- テンプレートの頻度設定が間違っている

**解決方法**:
1. カレンダーで対象の日を確認（オレンジ色の枠線がある場合は除外日）
2. 除外日の場合、右クリック → 「除外を解除する」
3. プレビュー機能で、テンプレートの適用状況を確認

---

#### 既存のエントリーが上書きされてしまう

**原因**:
- 一括登録は、同じ日・同じチケットIDのエントリーを上書きします

**解決方法**:
- 上書きしたくない場合は、該当するテンプレートを無効化するか、除外日を設定してください
- プレビュー機能で事前確認することをおすすめします

---

### テンプレートが保存できない

#### 「チケットIDを正しく入力してください」と表示される

**原因**:
- チケットIDに数字以外の文字が含まれている

**解決方法**:
- チケットIDは数字のみで入力してください（例: `1234`）

---

#### 「曜日を少なくとも1つ選択してください」と表示される

**原因**:
- 頻度を「毎週」に設定したが、曜日が1つも選択されていない

**解決方法**:
- 対象曜日のチェックボックスを少なくとも1つONにしてください

---

### カレンダーが表示されない

**原因**:
- データの読込中にエラーが発生した

**解決方法**:
1. 通信ログを表示して、エラー内容を確認
2. 「↻ 最新情報取得」ボタンをクリックして再読込
3. それでも解決しない場合は、アプリケーションを再起動

---

## FAQ（よくある質問）

### Q1: API Keyはどこで取得できますか？

**A**: Redmineにログイン後、以下の手順で取得できます：
1. 右上のアカウント名をクリック → 「個人設定」
2. 右側のメニューから「APIアクセスキー」をクリック
3. 「表示」ボタンをクリックして、表示されたキーをコピー

---

### Q2: API Keyは安全に保存されますか？

**A**: いいえ、API Keyはローカルに**平文で保存**されます。
- 保存場所: `C:\Users\{ユーザー名}\AppData\Local\RedmineSupTool\settings.json`
- 共有PCでの使用には注意してください

---

### Q3: 複数のプロジェクトに対応していますか？

**A**: 現在のバージョンでは、複数のプロジェクトに対応していません。
- ただし、異なるプロジェクトのチケットIDを指定することで、複数プロジェクトのチケットに時間を登録することは可能です

---

### Q4: 一括登録を実行すると、既存のエントリーはどうなりますか？

**A**: 同じ日・同じチケットIDのエントリーが存在する場合、**上書き更新**されます。
- 上書きしたくない場合は、該当するテンプレートを無効化するか、除外日を設定してください

---

### Q5: 土日に作業した場合はどうすればいいですか？

**A**: カレンダーで対象の土日を右クリック → 「出勤日に設定する」を選択してください。
- 出勤日に設定された土日は、一括登録の対象に含まれます

---

### Q6: 祝日を自動的に除外できますか？

**A**: 現在のバージョンでは、祝日の自動判定機能はありません。
- 手動で除外日として設定する必要があります
- 将来のバージョンで対応予定です

---

### Q7: 作業時間を0.5時間刻み以外で登録できますか？

**A**: 現在のバージョンでは、0.5時間刻みのみ対応しています。
- 選択肢: 0.5, 1.0, 1.5, 2.0, ..., 8.0

---

### Q8: テンプレートはいくつまで作成できますか？

**A**: 制限はありません。必要なだけ作成できます。

---

### Q9: データはどこに保存されますか？

**A**: すべてのデータはローカルに保存されます：
- 保存場所: `C:\Users\{ユーザー名}\AppData\Local\RedmineSupTool\`
- 保存されるデータ:
  - 接続設定（`settings.json`）
  - テンプレート（`templates.json`）
  - 除外日（`excluded_dates.json`）
  - 出勤日（`work_days.json`）

---

### Q10: アンインストール方法は？

**A**: 以下の手順でアンインストールできます：
1. アプリケーションフォルダを削除
2. （任意）設定ファイルも削除したい場合:
   - `C:\Users\{ユーザー名}\AppData\Local\RedmineSupTool\` フォルダを削除

---

### Q11: エラーが発生した場合、どこを確認すればいいですか？

**A**: 以下の順番で確認してください：
1. **ステータスバー**: 画面上部のステータスバーにエラーメッセージが表示されます（赤色・太字）
2. **通信ログ**: メニュー → 表示 → 通信ログを表示 で、詳細なログを確認できます
3. **エラーダイアログ**: 重要なエラーの場合、ダイアログが表示されます

---

### Q12: 複数のPCで同じ設定を使いたい

**A**: 設定ファイルをコピーすることで可能です：
1. PC1の設定ファイルをコピー:
   - `C:\Users\{ユーザー名}\AppData\Local\RedmineSupTool\`
2. PC2の同じ場所に貼り付け

> **⚠️ 注意**: API Keyが平文で保存されているため、セキュリティに注意してください

---

### Q13: 月の途中から使い始めた場合、過去の日付にも登録されますか？

**A**: はい、一括登録は対象月の**すべての日**を対象とします。
- 過去の日付にも登録されます
- 登録したくない日は、除外日として設定してください

---

### Q14: 同じ日に複数のチケットに時間を登録できますか？

**A**: はい、可能です。
- 複数のテンプレートを作成し、それぞれ異なるチケットIDを設定してください
- 同じ日に複数のテンプレートが適用される場合、それぞれ別のエントリーとして登録されます

---

### Q15: コメントを追加できますか？

**A**: 現在のバージョンでは、コメント機能はありません。
- 将来のバージョンで対応予定です

---

### Q16: 登録した時間エントリーを削除できますか？

**A**: いいえ、このアプリには削除機能はありません。

**理由**:
- このアプリの主な目的は、作業時間入力の**手間を省く**ことです
- 時間エントリーの**作成・更新**に特化しています
- このアプリで作成したデータと、手動で作成したデータを区別できないため
- 誤削除のリスクを避けるため

**時間エントリーの削除方法**:
- Redmineの管理画面から削除してください

**誤って登録した場合の対処**:
1. Redmineの管理画面から該当エントリーを削除
2. テンプレートを修正
3. このアプリで再度一括登録（正しい内容で上書き）

---

## サポート・お問い合わせ

問題が解決しない場合は、以下の情報を添えてお問い合わせください：

1. **エラーメッセージ**: ステータスバーやダイアログに表示されたエラー内容
2. **通信ログ**: 通信ログの内容（スクリーンショットまたはコピー）
3. **Redmineバージョン**: お使いのRedmineのバージョン
4. **操作手順**: エラーが発生するまでの操作手順

---

## ライセンス

© 2026 tikomo software

---

**マニュアル終了**

このマニュアルが、Redmine Support Toolを快適にご利用いただく一助となれば幸いです。
