/** mimetexwin.cpp
 * mimeTeXgĐ쐬
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW g++ + Boost C++ Libraries + mimeTeX
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-07-01.shtm
*/

//  ======================================================
#include <iostream>
#include <cstdio>
#include <string>
#include <sstream>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <gdiplus.h>
#include <tchar.h>
#include <stdio.h>
#include <stdlib.h>
#include <ole2.h>
#include <richedit.h>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/format.hpp>
#include "resource.h"

using namespace std;
using namespace Gdiplus;
using namespace boost;
using namespace boost::property_tree;

#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"mimetexwin"			// AvP[V
#define APPNAMEJP	"TEX摜t@C쐬"	// AvP[Vi{j
#define APPVERSION	"1.2.10"				// o[W
#define APPYEAR		"2020-2026"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-07-01.shtm"	// QlTCg

// char*obt@TCY
#define SIZE_BUFF		5120

// WtHg
#define FONT_FACE		"MS UI Gothic"

// ݂̃C^[tFCX
static HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// TeXi[p
string TeX;

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// mimeTex.exe
#define MIMETEX		".\\etc\\mimetex.exe"

// TeX̏l
#define TEX_DEF		"\\large f^\\prime(x)\\ = \\lim_{\\Delta x\\to0}\\frac{f(x+\\Delta x)-f(x)}{\\Delta x}"

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCvO𗘗pĂ܂D
@MinGWig++j^Boost C++Cu^mimeTeX
)")
% APPNAMEJP
% APPVERSION
% APPYEAR).str();

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
*/
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, SIZE_BUFF);
	PTSTR pText = (PTSTR)GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/**
 * Nbv{[h當擾
 * @param	Ȃ
 * @return	^NULL擾s
*/
char* getClipboardData(void) {
	static char buff[SIZE_BUFF + 1];

	OpenClipboard(NULL);
	HGLOBAL hText = GetClipboardData(CF_TEXT);

	if (hText == NULL) {
		return NULL;
	} else {
		PTSTR pText = (PTSTR)GlobalLock(hText);
		lstrcpy(buff, pText);
		GlobalUnlock(hText);
	}
	CloseClipboard();

	return buff;
}

// eLXgR[hϊ ======================================================
/**
 * eLXgER[hϊFSJISwstringiWindows APIgpj
 * @param  string src SJISeLXg
 * @return string ϊeLXg
*/
std::wstring __sjis_wstring(std::string src) {
	auto const dest_size = ::MultiByteToWideChar(CP_ACP, 0U, src.data(), -1, nullptr, 0U);
	std::vector<wchar_t> dest(dest_size, L'\0');

	if (::MultiByteToWideChar(CP_ACP, 0U, src.data(), -1, dest.data(), dest.size()) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<wchar_t>::length(dest.data()));
	dest.shrink_to_fit();

	return std::wstring(dest.begin(), dest.end());
}
#define _SW(s)	__sjis_wstring(s)

/**
 * eLXgER[hϊFwstringSJISiWindows APIgpj
 * @param  wstring src eLXg
 * @return string ϊeLXgiSJISj
*/
std::string __wstring_sjis(std::wstring src) {
	auto const dest_size = ::WideCharToMultiByte(CP_ACP, 0U, src.data(), -1, nullptr, 0, nullptr, nullptr);
	std::vector<char> dest(dest_size, '\0');
	if (::WideCharToMultiByte(CP_ACP, 0U, src.data(), -1, dest.data(), dest.size(), nullptr, nullptr) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<char>::length(dest.data()));
	dest.shrink_to_fit();

	return std::string(dest.begin(), dest.end());
}
#define _WS(s)	__wstring_sjis(s)

/**
 * eLXgER[hϊFUTF-8wstringiWindows APIgpj
 * @param  string src UTF-8eLXg
 * @return string ϊeLXg
*/
std::wstring __utf8_wstring(std::string src) {
	auto const dest_size = ::MultiByteToWideChar(CP_UTF8, 0U, src.data(), -1, nullptr, 0U);
	std::vector<wchar_t> dest(dest_size, L'\0');
	if (::MultiByteToWideChar(CP_UTF8, 0U, src.data(), -1, dest.data(), dest.size()) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<wchar_t>::length(dest.data()));
	dest.shrink_to_fit();

	return std::wstring(dest.begin(), dest.end());
}
#define _UW(s)	__utf8_wstring(s)

/**
 * eLXgER[hϊFwstringUTF-8iWindows APIgpj
 * @param  wstring src eLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string __wstring_utf8(std::wstring src) {
	auto const dest_size = ::WideCharToMultiByte(CP_UTF8, 0U, src.data(), -1, nullptr, 0, nullptr, nullptr);
	std::vector<char> dest(dest_size, '\0');

	if (::WideCharToMultiByte(CP_UTF8, 0U, src.data(), -1, dest.data(), dest.size(), nullptr, nullptr) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<char>::length(dest.data()));
	dest.shrink_to_fit();

	return std::string(dest.begin(), dest.end());
}
#define _WU(s)	__wstring_utf8(s)

/**
 * eLXgER[hϊFSJISUTF-8iWindows APIgpj
 * @param  wstring src SJISeLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string sjis_utf8(std::string src) {
	wstring const wide = __sjis_wstring(src);
	return __wstring_utf8(wide);
}

/**
 * eLXgER[hϊFUTF-8SJISiWindows APIgpj
 * @param  wstring src UTF-8eLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string utf8_sjis(std::string src) {
	wstring const wide = __utf8_wstring(src);
	return __wstring_sjis(wide);
}

// GUI =================================================================
/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
*/
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[SIZE_BUFF + 1];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * eLXg{bNX當擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
*/
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));
	return (string)buff;
}

/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
*/
void CenterWindow(HWND hDlg) {
	int  x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// IvVǍ^ۑ ====================================================
/**
 * AppDatãpX擾
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * p[^̏
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	hParent_X = 0;
	hParent_Y = 0;
	TeX       = TEX_DEF;
}

/**
 * IvV̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (boost::optional<std::string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "tex") {
					TeX = utf8_sjis((string)it.second.data());
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			hParent_X = 0;
			hParent_Y = 0;
			TeX = TEX_DEF;
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		hParent_X = 0;
		hParent_Y = 0;
		TeX = TEX_DEF;
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * IvV̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", sjis_utf8(TeX));
	child1.add("<xmlattr>.type", "tex");
	ptree& child2 = pt.add("parameter.param", (string)to_string(hParent_X));
	child2.add("<xmlattr>.type", "wx");
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child3.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg			EBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg,
					WPARAM wParam, LPARAM lParam) {
	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
	return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// TeX摜 =============================================================
/**
 * t@CERs[isystem֐gpj
 * @param	const char *from Rs[t@C
 * @param	const char *to   Rs[t@C
 * @return	Ȃ
*/
void copyFile(const char *from, const char *to) {
	char cmd[SIZE_BUFF + 1];
	for (int i = 0; i < SIZE_BUFF + 1; i++)		cmd[i] = 0;

	strcat(cmd, "copy ");
	strcat(cmd, "\"");
	strcat(cmd, from);
	strcat(cmd,  "\" \"");
	strcat(cmd, to);
	strcat(cmd, "\"");
	system(cmd);
}

/**
 * e|t@C擾iWindows APIgp{gq.gifj
 * @param	char* tpmname  e|t@Ci[itpXj
 * @return	Ȃ
*/
void getTempFname(char* tmpname) {
	char szTempPath[MAX_PATH + 1];

	GetTempPath(sizeof(szTempPath) / sizeof(szTempPath[0]), szTempPath);
	GetTempFileName(szTempPath, "mimetex", 0, tmpname);
	remove(tmpname);		// ݃t@C폜
	strcat(tmpname, ".gif");
}

/**
 * mimeTeXsisystem֐gpj
 * @param	const char *tex     TeX
 * @param	const char *tpmname ꎞo͂gift@C
 * @return	Ȃ
*/
void makeTeX(const char *tex, const char *tmpname) {
	char cmd[SIZE_BUFF + 1];
	for (int i = 0; i < SIZE_BUFF + 1; i++)		cmd[i] = 0;

	strcat(cmd, MIMETEX);
	strcat(cmd, " -e ");
	strcat(cmd, tmpname);
	strcat(cmd,  " \"");
	strcat(cmd, tex);
	strcat(cmd, "\"");
	system(cmd);
}

/**
 * 摜t@C̕\
 * @param	HWND  hWnd \EBhEEnh
 * @param	const char *tpmname \gift@C
 * @return	Ȃ
*/
void onPaint(HWND hWnd, const char *tmpname) {
	WCHAR szFileW[SIZE_BUFF + 1];
	IStream *pStream;

	TCHAR *szFile = TEXT((char *)tmpname);
	MultiByteToWideChar(932, 0, szFile,-1, szFileW, sizeof(szFileW) / sizeof(TCHAR));
	Graphics mygraphics(hWnd);
	// \̈NA
	mygraphics.Clear(Gdiplus::Color(255, 255, 255, 255));
	Bitmap *image;
	// Xg[ǂݍݏ
	HANDLE hFile = CreateFile(szFile, GENERIC_READ, 0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (!hFile)		return;
	DWORD dwFileSize = GetFileSize(hFile, NULL);
	HGLOBAL hGlobal = GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
	// bNă|C^擾
	LPVOID lpBuf = GlobalLock(hGlobal);
	// ǂݍ
	ReadFile(hFile, lpBuf, dwFileSize, &dwFileSize, NULL);
	CloseHandle(hFile);
	// AbN
	GlobalUnlock(hGlobal);
	// Xg[ϊ
	CreateStreamOnHGlobal(hGlobal, TRUE, &pStream);
	// Xg[ǂݍ
	image = Bitmap::FromStream(pStream);
	// ʕ\
	mygraphics.DrawImage(image, 10, 10);
	// 
	GlobalFree(hGlobal);
}

/**
 * 摜t@C̕ۑ
 * @param	const char *tpmname ꎞt@C
 * @return	Ȃ
*/
void saveTeX(const char* tmpname) {
	static char fname[MAX_PATH + 1];
	strcat(fname, "mimetex.gif");
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("*.gif\0*.gif\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("gif");
	// R_CAO̕\
	GetSaveFileName(&of);
	copyFile(tmpname, fname);
}

/**
 * tHgw
 * @param  HWND hWnd			Ώۃnh
 * @param  int fzie				tHgETCYiptj
 * @param  const char* fface	tHgEtF[X
 * @return Ȃ
*/
void setFont(HWND hWnd, int fsize, const char* fface) {
	HFONT hFont = CreateFont(fsize, 0, 0, 0, FW_NORMAL, FALSE, FALSE, 0,
			SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, DEFAULT_PITCH, fface);
	SendMessage(hWnd, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(FALSE, 0));
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HICON hIcon;
	GdiplusStartupInput gpSI;
	ULONG_PTR lpToken;
	static HWND hTex;
	static char tmpname[MAX_PATH + 1];
	char *str;

    switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		setFont(GetDlgItem(hParent, IDC_EDIT_TEX), 16, FONT_FACE);
		// IvVǂݍ
		loadParameter();
		setStrEditBox(hDlg, IDC_EDIT_TEX, TeX);
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		getTempFname(tmpname);
		// GDI+
		GdiplusStartup(&lpToken, &gpSI, NULL);
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_EXEC:
		case IDM_EXEC:
			TeX = getStrEditBox(hParent, IDC_EDIT_TEX);
			makeTeX(TeX.c_str(), tmpname);
			hTex = GetDlgItem(hParent, IDC_IMAGE_TEX);
			onPaint(hTex, tmpname);
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveTeX(tmpname);
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			// e|Et@C폜
			remove(tmpname);
			EndDialog(hParent, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
			setClipboardData(getStrEditBox(hParent, IDC_EDIT_TEX));
			break;
		// \t
		case IDM_PASTE:
			str = getClipboardData();
			if (str != NULL) {
				setStrEditBox(hParent, IDC_EDIT_TEX, str);
			}
			break;
		// ؂
		case IDM_DELETE:
			setStrEditBox(hParent, IDC_EDIT_TEX, "");
			break;
		// vOI
		case IDM_QUIT:
			// IvVۑ
			saveParameter();
			remove(tmpname);
			// GDI+I
			GdiplusShutdown(lpToken);
			EndDialog(hParent, 0);
			return 0;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		// IvVۑ
		saveParameter();
		remove(tmpname);
		// GDI+I
		GdiplusShutdown(lpToken);
		EndDialog(hParent, 0);
		return 0;
	}
	return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");
	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);

	return 0;
}

/*
** o[WAbv =====================================================
 *
 * @version 1.2.10 2026/02/07 gpCuXV, optionalOՓˉ
 * @version 1.2.9  2025/10/11 gpCuXV
 * @version 1.2.8  2025/06/21 gpCuXV
 * @version 1.2.7  2025/03/01 gpCuXV
 * @version 1.2.6  2024/11/09 gpCuXV
 * @version 1.2.5  2024/07/14 gpCuXV
 * @version 1.2.4  2024/03/06 gpCuXV
 * @version 1.2.3  2023/10/14 gpCuXV
 * @version 1.2.2  2023/06/03 gpCuXV
 * @version 1.2.1  2023/02/26 gpCuXV
 * @version 1.2.0  2022/11/03 EBhEʒuEL[ۑCgpCuXV
 * @version 1.11   2022/07/23 gpCuXV
 * @version 1.1    2020/08/25 CXg[[ǉCwvt@CꕔC
 * @version 1.0    2020/08/13 
*/
