# ごたくWin version 1.0.2

Windows11上で動作する5択クイズゲームです。

---

## 動作環境

- Windows 11
- 必要なDLLファイル（同梱）

---

## ファイル構成

```
gotaku_win/
  gotaku_win.exe          # ゲーム本体
  libraylib.dll           # Raylibライブラリ
  glfw3.dll               # GLFWライブラリ
  zlib1.dll               # zlibライブラリ
  libgcc_s_seh-1.dll      # GCCランタイム
  libwinpthread-1.dll     # GCCランタイム
  COPYING.RUNTIME         # GCCライセンスファイル
  quiz_data.zip           # 問題データ（サンプル）
  README.md               # 本ファイル
```

---

## 起動方法

### 通常起動

1. `gotaku_win.exe` をダブルクリックして起動する
2. タイトル画面の「ゲームスタート」をクリックする
3. ファイル選択ダイアログで問題データファイルを選択する
4. 問題データの読み込みが完了するとクイズ画面に遷移する

### 問題データを引数で指定して起動

コマンドラインの第1引数に問題データのファイルパスを指定して起動できます。

```
gotaku_win.exe <問題データのファイルパス>
```

例：

```
gotaku_win.exe C:\quiz\quiz_data.zip
gotaku_win.exe C:\quiz\quiz_data.5TQ
```

この方法で起動した場合、以下のように動作します。

- タイトル画面で「ゲームスタート」をクリックすると、ファイル選択ダイアログをスキップして指定されたファイルが自動的に読み込まれる
- ゲームオーバー・ゲームクリア後にタイトル画面に戻った後も、同様に指定されたファイルが読み込まれる

エクスプローラーで問題データファイルを `gotaku_win.exe` にドラッグ＆ドロップしても同じ動作になります。

---

## 対応問題データ形式

以下の2種類の問題データ形式に対応しています。

### ZIPファイル形式（*.zip）

ZIPファイルに `qtext_0.txt` 〜 `qtext_7.txt` の最大8ファイルを格納します。
各テキストファイルは **Shift_JIS** で以下のフォーマットで記述します。

```
ジャンル名
1問目の問題文
1問目の正解選択肢
1問目の誤り選択肢①
1問目の誤り選択肢②
1問目の誤り選択肢③
1問目の誤り選択肢④
2問目の問題文
2問目の正解選択肢
2問目の誤り選択肢①
2問目の誤り選択肢②
2問目の誤り選択肢③
2問目の誤り選択肢④
...（以下、任意の問題数分のデータ）
```

- 問題数は任意（10問以上推奨）
- 行末は `\r\n`（Windows改行）または `\n` どちらも対応

### 5TQファイル形式（*.5TQ）

ごたくシリーズ用の問題データである5TQフォーマットの問題データファイルに対応しています。

---

## ゲームの流れ

### タイトル画面

- 「ゲームスタート」ボタンをクリックしてファイル選択ダイアログを開く
- 問題データファイルを選択して読み込む
- 読み込みに失敗した場合はエラーメッセージを表示してタイトル画面に戻る

### クイズ画面

- 読み込んだ問題データの中からランダムにジャンルが選択される
- 1ステージにつき同一ジャンルから10問が出題される
- 同じステージで同じ問題は出題されない

画面構成は以下の通りです。

| 表示位置 | 内容 |
|---|---|
| 最上部 | タイマーバー（残り時間を色で表示） |
| 左上 | ジャンル名 / ステージ・出題数 |
| 中央上 | 問題文 |
| 右上 | 正解数 / クリアライン / 得点 |
| 下半分 | 5つの選択肢（①〜⑤） |

### 解答方法

- 5つの選択肢の中から正解と思うものをクリックする
- 正解：「ピンポーン」という効果音が鳴り、正解数と得点が加算される
- 不正解：「ブッブー」という効果音が鳴る
- 10秒以内に選択しなかった場合：タイムアウトとなり不正解扱いになる

### 得点システム

- 正解時に残り時間（秒数）がそのまま得点に加算される
- 例：残り7秒で正解した場合、7点が加算される
- 得点はゲームオーバーになるまでステージをまたいで加算され続ける
- ゲームオーバー時にタイトル画面に戻ると得点はリセットされる

### クリア条件

10問解答後、正解数がクリアラインを超えるとステージクリアになります。

| ステージ | クリアライン | 高成績ライン |
|---|---|---|
| Stage 1 | 5問以上 | 7問以上 |
| Stage 2 | 5問以上 | 7問以上 |
| Stage 3 | 6問以上 | 8問以上 |
| Stage 4 | 6問以上 | 8問以上 |
| Stage 5 | 7問以上 | 9問以上 |
| Stage 6 | 7問以上 | 9問以上 |
| Stage 7 | 8問以上 | 10問以上 |
| Stage 8 | 8問以上 | 10問以上 |
| Stage 9 | 9問以上 | 10問以上 |
| Stage 10 | 9問以上 | 10問以上 |

- クリアラインに届かない場合は「ゲームオーバー」となりタイトル画面に戻る
- Stage 10をクリアすると「ゲームクリア」となりタイトル画面に戻る

### ステージクリア評価（★）

| 評価 | 条件 |
|---|---|
| ★★★ | 10問全問正解 |
| ★★☆ | 高成績ライン以上の正解数 |
| ★☆☆ | クリアライン以上の正解数 |

---

## 使用ライブラリ

本ソフトウェアは以下のオープンソースライブラリを使用しています。

```
・Raylib (https://www.raylib.com/)
  Copyright (c) 2013-2024 Ramon Santamaria (@raysan5)
  Licensed under the zlib/libpng License.

・zlib (https://zlib.net/)
  Copyright (c) 1995-2024 Jean-loup Gailly and Mark Adler
  Licensed under the zlib License.

・GLFW (https://www.glfw.org/)
  Copyright (c) 2002-2006 Marcus Geelnard
  Copyright (c) 2006-2019 Camilla Löwy
  Licensed under the zlib/libpng License.
```

GCCランタイムライブラリ（`libgcc_s_seh-1.dll`・`libwinpthread-1.dll`）については
同梱の `COPYING.RUNTIME` を参照してください。

## 著作権・転載など

- このソフトはフリーソフトウェアです。
- ごたくWinの著作権は [礼場日郎](https://x.com/TaTaRa_) が留保します。
- ごたくWinの転載・再配布は自由ですが、zipファイルに含まれるパッケージ内容や形態に変更を加えてはいけません。
- ごたくWinを使用した結果として、いかなる不具合・不利益が発生しても、作者は一切の責任を負いません。
- ごたくWinで作成したごたくデータの著作権、配布条件等に関しては、作者は一切の制限を設けません。
- 「ごたくどす」「５ＴＡＫＵ」はＱ舎様( https://www.vector.co.jp/vpack/browse/person/an000516.html )の著作物です。

## 更新履歴

- 1.0.0 first release.
- 1.0.1 ゲーム実行時にアイコンがタイトルバー/タスクバーに表示されない不具合を修正
- 1.0.2
  - iconをリソース化
  - タイトル画面のタイトル文字のデザインを更新
  - 引数で問題データを指定した時、指定したファイルをタイトル画面で表示するように変更
