/*
 * Decompiled with CFR 0.152.
 */
package biz;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.sax.SecureContentHandler;
import org.apache.tika.sax.TaggedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import ui.UtilityClass;

public class MyAutoDetectParser
extends AutoDetectParser {
    private static final long serialVersionUID = 1L;

    public MyAutoDetectParser(Detector detector) {
        super(TikaConfig.getDefaultConfig());
        this.setDetector(detector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int MyParse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TemporaryResources tmp = new TemporaryResources();
        try {
            TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
            MediaType type = this.getDetector().detect((InputStream)tis, metadata);
            if ("application/zip".equals(type.toString())) {
                tis.close();
                tmp.dispose();
                int n = -1;
                return n;
            }
            String strFilename = metadata.get("resourceName");
            if ("image/x-portable-pixmap".equalsIgnoreCase(type.toString()) && "txt".equalsIgnoreCase(UtilityClass.getFileExtension(strFilename)) || "dat".equalsIgnoreCase(UtilityClass.getFileExtension(strFilename))) {
                metadata.set("Content-Type", "text/plain");
            } else {
                metadata.set("Content-Type", type.toString());
            }
            SecureContentHandler sch = handler != null ? new SecureContentHandler(handler, tis) : null;
            try {
                Parser parser = this.getParser(metadata, context);
                TemporaryResources tmpp = new TemporaryResources();
                try {
                    TaggedContentHandler taggedHandler;
                    TikaInputStream taggedStream = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmpp);
                    TaggedContentHandler taggedContentHandler = taggedHandler = handler != null ? new TaggedContentHandler(handler) : null;
                    if (parser instanceof ParserDecorator) {
                        metadata.add("X-Parsed-By", ((ParserDecorator)parser).getWrappedParser().getClass().getName());
                    } else {
                        metadata.add("X-Parsed-By", parser.getClass().getName());
                    }
                    try {
                        parser.parse((InputStream)taggedStream, (ContentHandler)taggedHandler, metadata, context);
                    }
                    catch (RuntimeException e) {
                        throw new TikaException("Unexpected RuntimeException from " + parser, (Throwable)e);
                    }
                    catch (IOException e) {
                        taggedStream.throwIfCauseOf((Throwable)e);
                        throw new TikaException("TIKA-198: Illegal IOException from " + parser, (Throwable)e);
                    }
                    catch (SAXException e) {
                        if (taggedHandler != null) {
                            taggedHandler.throwIfCauseOf((Exception)e);
                        }
                        throw new TikaException("TIKA-237: Illegal SAXException from " + parser, (Throwable)e);
                    }
                }
                finally {
                    tmpp.dispose();
                }
            }
            catch (SAXException e) {
                sch.throwIfCauseOf(e);
                throw e;
            }
            tis.close();
        }
        finally {
            tmp.dispose();
        }
        return 1;
    }
}

