/*
 * Decompiled with CFR 0.152.
 */
package biz;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import ui.UtilityClass;

public class RecentList {
    List<String> recentFileList;
    List<String> recentFileDateList;
    List<String> recentSearchKeyList;
    List<String> recentIndex;
    List<String> recentSearchType;
    private String strRecentFile;

    public RecentList() {
        block3: {
            this.recentFileList = new ArrayList<String>();
            this.recentFileDateList = new ArrayList<String>();
            this.recentSearchKeyList = new ArrayList<String>();
            this.recentIndex = new ArrayList<String>();
            this.recentSearchType = new ArrayList<String>();
            this.strRecentFile = ".RecentFileList";
            try {
                File file = new File(this.strRecentFile);
                if (!file.exists()) {
                    file.createNewFile();
                }
            }
            catch (Exception e) {
                if (!UtilityClass.DebugMode) break block3;
                System.out.println("file creating error: recent file list");
            }
        }
    }

    public void ReadFromFile() {
        try {
            File file = new File(this.strRecentFile);
            if (!file.exists()) {
                return;
            }
            String keys = FileUtils.readFileToString((File)file);
            if (!keys.isEmpty()) {
                String[] strCombinedKey;
                for (String str : strCombinedKey = keys.split("\\|")) {
                    if (str.isEmpty()) continue;
                    String[] combinedKeyRow = str.split(";");
                    this.Add(combinedKeyRow[0], combinedKeyRow[1], combinedKeyRow[2], combinedKeyRow[3], combinedKeyRow[4], false);
                }
            }
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public void WriteFile() {
        try {
            File file = new File(this.strRecentFile);
            String recentFileList = this.toString();
            FileUtils.writeStringToFile((File)file, (String)recentFileList);
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public void Add(String filename, String fileDate, String searchKey, String indexName, String isContentSearch, boolean isAddTop) {
        int iSize;
        int i = this.recentFileList.indexOf(filename);
        if (i != -1) {
            this.recentFileList.remove(i);
            this.recentFileDateList.remove(i);
            this.recentSearchKeyList.remove(i);
            this.recentIndex.remove(i);
            this.recentSearchType.remove(i);
        }
        if ((iSize = this.recentFileList.size()) >= UtilityClass.RecentFileMax) {
            this.recentFileList.remove(iSize - 1);
            this.recentFileDateList.remove(iSize - 1);
            this.recentSearchKeyList.remove(iSize - 1);
            this.recentIndex.remove(iSize - 1);
            this.recentSearchType.remove(iSize - 1);
        }
        if (isAddTop) {
            this.recentFileList.add(0, filename);
            this.recentFileDateList.add(0, fileDate);
            this.recentSearchKeyList.add(0, searchKey);
            this.recentIndex.add(0, indexName);
            this.recentSearchType.add(0, isContentSearch);
        } else {
            this.recentFileList.add(filename);
            this.recentFileDateList.add(fileDate);
            this.recentSearchKeyList.add(searchKey);
            this.recentIndex.add(indexName);
            this.recentSearchType.add(isContentSearch);
        }
    }

    public List<String> GetRecentFileList() {
        return this.recentFileList;
    }

    public List<String> GetRecentFileDateList() {
        return this.recentFileDateList;
    }

    public List<String> GetRecentSearchKeyList() {
        return this.recentSearchKeyList;
    }

    public List<String> GetSearchTypeList() {
        return this.recentSearchType;
    }

    public List<String> GetSearchIndexName() {
        return this.recentIndex;
    }

    public void Delete(String filename) {
        int i = this.recentFileList.indexOf(filename);
        this.recentFileList.remove(i);
        this.recentFileDateList.remove(i);
        this.recentSearchKeyList.remove(i);
        this.recentIndex.remove(i);
        this.recentSearchType.remove(i);
    }

    public void RemoveAll() {
        this.recentFileList.clear();
        this.recentFileDateList.clear();
        this.recentSearchKeyList.clear();
        this.recentIndex.clear();
        this.recentSearchType.clear();
    }

    public String toString() {
        StringBuffer strB = new StringBuffer();
        int iCnt = this.recentFileList.size();
        if (iCnt <= 0) {
            return "";
        }
        for (int i = 0; i < iCnt; ++i) {
            String strFilename = this.recentFileList.get(i);
            String strFileDatename = this.recentFileDateList.get(i);
            String strSearchKey = this.recentSearchKeyList.get(i);
            String strIndexName = this.recentIndex.get(i);
            String strSearchType = this.recentSearchType.get(i);
            if (strB.length() > 0) {
                strB.append("|" + strFilename + ";" + strFileDatename + ";" + strSearchKey + ";" + strIndexName + ";" + strSearchType);
                continue;
            }
            strB.append(strFilename + ";" + strFileDatename + ";" + strSearchKey + ";" + strIndexName + ";" + strSearchType);
        }
        return strB.toString();
    }
}

