/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.FilterDlgData;
import biz.HardDiskMap;
import biz.MyAnalyzer;
import biz.MySpanQuery;
import biz.TextExtractor;
import biz.configclass;
import biz.searchFolder;
import com.pff.PSTAttachment;
import com.pff.PSTFile;
import com.pff.PSTFolder;
import com.pff.PSTMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import ui.InterfaceAsynSearchDisplayEvent;
import ui.MyDetailData;
import ui.MySummaryData;
import ui.UtilityClass;

public class SearchBiz {
    public static InterfaceAsynSearchDisplayEvent myInterface;
    private static MyAnalyzer analyzer;
    private static IndexWriter indexWriter;
    private static MyAnalyzer subanalyzer;
    private static IndexWriter subIndexWriter;
    private static MyAnalyzer pageLinesubanalyzer;
    private static IndexWriter pageLineSubIndexWriter;
    public final String EXCEL_EXTENSION = "XLS";
    public final String EXCEL_NEWEXTENSION = "XLSX";
    public final String FILE_SEPARATOR = ".";
    private boolean cancel = false;
    private String _fatalErrFile = "";
    private String indexSavingFolder;
    private String baseFolder;
    private long createTime;
    private int maxLine = 5000;
    private int _File_content_maxLine = 567860;
    private String strExcludeFileType = "";
    private int iTotalFilecnt;
    private int iCurrentFileNo;
    private List<MySummaryData> searchResult = new ArrayList<MySummaryData>();
    private int searchOption;
    private String stopfile;
    private String stopPSTFolder;
    private int bskip;
    private int lasttimeRet = 0;
    private boolean bFoundStopFile = false;
    private boolean bResumeStart = false;
    private searchFolder _sf;
    int iPSTCnt;
    int iIndexLine;

    public boolean getResumeFileFound() {
        return this.bFoundStopFile;
    }

    public void setResumeFileFound(boolean b) {
        this.bFoundStopFile = b;
    }

    public boolean getResumeStart() {
        return this.bResumeStart;
    }

    public void setResumeStart(boolean b) {
        this.bResumeStart = b;
    }

    public void cancel() {
        this.cancel = true;
    }

    public static boolean checkIndexDataHD() {
        char aChar;
        char iChar;
        String strIndexFolder = configclass.getInstance("config.xml").getIndexDir();
        String strRealSerialNo = configclass.getInstance("config.xml").getIndexDataHDSerialNo();
        if (strRealSerialNo.isEmpty()) {
            if (new File(strIndexFolder).exists()) {
                HardDiskMap.saveIndexHDVolume();
            }
            return true;
        }
        boolean bFound = false;
        for (iChar = aChar = 'A'; iChar <= 'Z'; iChar = (char)(iChar + '\u0001')) {
            String str = HardDiskMap.getSerialNumber(String.valueOf(iChar));
            if (!strRealSerialNo.equalsIgnoreCase(str)) continue;
            bFound = true;
            break;
        }
        if (bFound) {
            if (!String.valueOf(iChar).equalsIgnoreCase(strIndexFolder.substring(0, 1))) {
                String strNewIndexFolder = String.valueOf(iChar) + strIndexFolder.substring(1);
                if (new File(strNewIndexFolder).exists()) {
                    configclass.getInstance("config.xml").setIndexDir(strNewIndexFolder);
                    configclass.getInstance("config.xml").Save();
                }
                myInterface.NotifyIndexFolderChange(strIndexFolder, strNewIndexFolder);
                return true;
            }
            return true;
        }
        myInterface.NotifyDiskChange(strIndexFolder);
        return false;
    }

    public boolean initFileContentsSearch(int searchOpt, searchFolder sf, String indexName) {
        block3: {
            try {
                this._sf = sf;
                this._fatalErrFile = "";
                this.createTime = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
                if (this.createTime < 0L && UtilityClass.DebugMode) {
                    System.out.println("invalid parameter: lcreated < 0");
                }
                this.maxLine = configclass.getInstance("config.xml").getMaxLine();
                this.strExcludeFileType = configclass.getInstance("config.xml").getExcludedFileType();
                this.baseFolder = configclass.getInstance("config.xml").getIndexDir();
                this.indexSavingFolder = UtilityClass.getFullname(this.baseFolder, String.valueOf(this.createTime));
                this.indexSavingFolder = UtilityClass.getFullname(this.indexSavingFolder, indexName);
                this.searchOption = searchOpt;
            }
            catch (Exception eee) {
                UtilityClass.OutputLogFile(eee.getMessage());
                if (!UtilityClass.DebugMode) break block3;
                System.out.println(eee.getMessage());
            }
        }
        return true;
    }

    public boolean Init(int searchOpt, searchFolder sf, String indexName) {
        block8: {
            try {
                this._sf = sf;
                this._fatalErrFile = "";
                if (!SearchBiz.checkIndexDataHD()) {
                    return false;
                }
                this.createTime = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
                if (this.createTime < 0L && UtilityClass.DebugMode) {
                    System.out.println("invalid parameter: lcreated < 0");
                }
                this.maxLine = configclass.getInstance("config.xml").getMaxLine();
                this.strExcludeFileType = configclass.getInstance("config.xml").getExcludedFileType();
                this.baseFolder = configclass.getInstance("config.xml").getIndexDir();
                this.indexSavingFolder = UtilityClass.getFullname(this.baseFolder, String.valueOf(this.createTime));
                this.indexSavingFolder = UtilityClass.getFullname(this.indexSavingFolder, indexName);
                this.searchOption = searchOpt;
                if (this.searchOption == UtilityClass.SearchOptionResumeIndexByCompareSnapshot || this.searchOption == UtilityClass.SearchOptionResumeIndexByFolder) {
                    this.bskip = configclass.getInstance("config.xml").getSkipFlag();
                    this.stopfile = configclass.getInstance("config.xml").getStopFile();
                    if (UtilityClass.DebugMode) {
                        System.out.println("stopfile=" + this.stopfile + " stopPST=" + this.stopPSTFolder);
                    }
                    this.lasttimeRet = configclass.getInstance("config.xml").getLastTimeReturnVal();
                    this.initSearchObjects();
                } else if (this.searchOption != 0) {
                    UtilityClass.OutputLogFile("service test searchOption" + this.searchOption);
                    this.initSearchObjects();
                }
            }
            catch (Exception eee) {
                UtilityClass.OutputLogFile(eee.getMessage());
                if (!UtilityClass.DebugMode) break block8;
                System.out.println(eee.getMessage());
            }
        }
        return true;
    }

    private void initSearchObjects() throws Exception {
        if (analyzer != null) {
            analyzer.close();
            analyzer = null;
        }
        analyzer = new MyAnalyzer();
        analyzer.SetMode(configclass.getInstance("config.xml").getLemminationOption());
        IndexWriterConfig idxConfig = new IndexWriterConfig((Analyzer)analyzer);
        if (indexWriter != null) {
            UtilityClass.OutputLogFile("close indexWriter");
            indexWriter.close();
            indexWriter = null;
        }
        if (UtilityClass.DebugMode) {
            System.out.println("Create IndexWriter:" + this.indexSavingFolder);
        }
        try {
            FSDirectory directory = FSDirectory.open((Path)Paths.get(this.indexSavingFolder, new String[0]));
            indexWriter = new IndexWriter((Directory)directory, idxConfig);
            UtilityClass.OutputLogFile("creating indexWriter " + indexWriter);
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile("failed in open folder: " + this.indexSavingFolder + " err:" + e.getMessage());
        }
        if (subanalyzer != null) {
            subanalyzer.close();
        }
        subanalyzer = new MyAnalyzer();
        subanalyzer.SetMode(configclass.getInstance("config.xml").getLemminationOption());
        if (pageLinesubanalyzer != null) {
            pageLinesubanalyzer.close();
        }
        pageLinesubanalyzer = new MyAnalyzer();
        pageLinesubanalyzer.SetMode(configclass.getInstance("config.xml").getLemminationOption());
        IndexWriterConfig subIdxConfig = new IndexWriterConfig((Analyzer)subanalyzer);
        if (subIndexWriter != null) {
            subIndexWriter.close();
        }
        IndexWriterConfig subIdxPageLineConfig = new IndexWriterConfig((Analyzer)pageLinesubanalyzer);
        if (pageLineSubIndexWriter != null) {
            pageLineSubIndexWriter.close();
        }
        if (UtilityClass.DebugMode) {
            System.out.println("Create IndexWriter:" + this.indexSavingFolder + "\\subIndex");
        }
        FSDirectory directory2 = FSDirectory.open((Path)Paths.get(this.indexSavingFolder + "\\subIndex", new String[0]));
        subIndexWriter = new IndexWriter((Directory)directory2, subIdxConfig);
        FSDirectory directory3 = FSDirectory.open((Path)Paths.get(this.indexSavingFolder + "\\subIndex2", new String[0]));
        pageLineSubIndexWriter = new IndexWriter((Directory)directory3, subIdxPageLineConfig);
    }

    public void finializeCreateIndex() {
        try {
            if (indexWriter != null) {
                indexWriter.close();
                indexWriter = null;
            }
            if (analyzer != null) {
                analyzer.close();
                analyzer = null;
            }
            if (subIndexWriter != null) {
                subIndexWriter.close();
                subIndexWriter = null;
            }
            if (subanalyzer != null) {
                subanalyzer.close();
                subanalyzer = null;
            }
            if (pageLineSubIndexWriter != null) {
                pageLineSubIndexWriter.close();
                pageLineSubIndexWriter = null;
            }
            if (pageLinesubanalyzer != null) {
                pageLinesubanalyzer.close();
                pageLinesubanalyzer = null;
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    private boolean isResumeIndexCreate(String filename) {
        if ((this.searchOption == UtilityClass.SearchOptionResumeIndexByCompareSnapshot || this.searchOption == UtilityClass.SearchOptionResumeIndexByFolder) && configclass.getInstance("config.xml").getLastTimeReturnVal() != 0) {
            if (this.bFoundStopFile) {
                this.bResumeStart = true;
            } else {
                this.bFoundStopFile = this.FoundStoppedFile(filename);
                if (this.bFoundStopFile && this.bskip != 1) {
                    this.bResumeStart = true;
                }
            }
        }
        return this.bResumeStart;
    }

    private boolean FoundStoppedFile(String strName) {
        boolean bRet = false;
        try {
            if (this.stopfile.equals(strName)) {
                if (UtilityClass.DebugMode) {
                    System.out.println("found the stopped file:" + strName);
                }
                bRet = true;
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
            return false;
        }
        return bRet;
    }

    public int _CreateIndex4Folder(String folder, PSTFolder pstfolder, String[] excludedir, boolean isPSTfile) {
        try {
            UtilityClass.OutputLogFile("createIndex4Folder:" + folder);
            File file = new File(folder);
            if (!(isPSTfile || file.exists() && file.isDirectory())) {
                UtilityClass.OutputLogFile("Parameter is not a directory");
                return 0;
            }
            if (this.cancel || myInterface.stop()) {
                return 1;
            }
            if (isPSTfile) {
                int bRet = 0;
                if (pstfolder.hasSubfolders()) {
                    Vector childFolders = pstfolder.getSubFolders();
                    for (PSTFolder childPSTFolder : childFolders) {
                        bRet = this._CreateIndex4Folder(folder, childPSTFolder, null, true);
                        if (bRet == 0) continue;
                        return bRet;
                    }
                }
                if (pstfolder.getContentCount() > 0) {
                    PSTMessage email = (PSTMessage)pstfolder.getNextChild();
                    while (email != null) {
                        if (email.getMessageDeliveryTime() != null) {
                            bRet = this.createIndex4File(file, email, this.iTotalFilecnt, this.iCurrentFileNo);
                            if (bRet != 0) {
                                return bRet;
                            }
                            ++this.iCurrentFileNo;
                        }
                        email = (PSTMessage)pstfolder.getNextChild();
                    }
                }
                return bRet;
            }
            this.bResumeStart = this.isResumeIndexCreate(folder);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    int iRet;
                    if (fileArray[i].isDirectory()) {
                        if (UtilityClass.IsExcludedFolder(fileArray[i].getAbsolutePath(), excludedir)) continue;
                        this.createIndex4File(fileArray[i], null, this.iTotalFilecnt, this.iCurrentFileNo);
                        int retval = this._CreateIndex4Folder(fileArray[i].getAbsolutePath(), null, excludedir, false);
                        if (retval == 0) continue;
                        return retval;
                    }
                    if ("pst".equalsIgnoreCase(UtilityClass.getFileExtension(fileArray[i].getCanonicalPath()))) {
                        PSTFile pstFile = new PSTFile(fileArray[i]);
                        iRet = this._CreateIndex4Folder(fileArray[i].getAbsolutePath(), pstFile.getRootFolder(), null, true);
                        pstFile.getFileHandle().close();
                    } else {
                        iRet = this.createIndex4File(fileArray[i], null, this.iTotalFilecnt, this.iCurrentFileNo);
                    }
                    if (iRet != 0) {
                        return iRet;
                    }
                    ++this.iCurrentFileNo;
                }
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
        return 0;
    }

    private String getFilenameOfMail(PSTMessage email) {
        String str = "";
        if (email != null) {
            str = "Subject: " + email.getSubject() + " To: " + email.getDisplayTo() + " Date: " + email.getMessageDeliveryTime().toString();
        }
        return str;
    }

    private String RetrieveAttachment(File file, PSTMessage email) {
        String str = "";
        try {
            if (email == null) {
                return str;
            }
            int numberOfAttachments = email.getNumberOfAttachments();
            for (int x = 0; x < numberOfAttachments; ++x) {
                UtilityClass.FileExcludedType fileExcludeType;
                PSTAttachment attach = email.getAttachment(x);
                InputStream attachmentStream = attach.getFileInputStream();
                String filename = attach.getLongFilename();
                if (filename.isEmpty()) {
                    filename = attach.getFilename();
                }
                if (UtilityClass.FileExcludedType.NameContentIndexable != (fileExcludeType = this.IsFileIndexable(new File(filename), true, "" + email.getMessageDeliveryTime().getTime()))) continue;
                FileOutputStream out = new FileOutputStream(filename);
                int bufferSize = 8176;
                byte[] buffer = new byte[bufferSize];
                int count = attachmentStream.read(buffer);
                while (count == bufferSize) {
                    out.write(buffer);
                    count = attachmentStream.read(buffer);
                }
                byte[] endBuffer = new byte[count];
                System.arraycopy(buffer, 0, endBuffer, 0, count);
                out.write(endBuffer);
                out.close();
                attachmentStream.close();
                str = "Attachment[" + String.valueOf(x + 1) + "]:" + filename + System.getProperty("line.separator") + TextExtractor.RetreiveTextFile(filename);
                FileUtils.deleteQuietly((File)new File(filename));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return str;
    }

    private String getContentOfMail(File file, PSTMessage email) {
        StringBuffer str = new StringBuffer();
        if (email != null) {
            str.append("[Subject]: ");
            str.append(email.getSubject());
            str.append(System.getProperty("line.separator"));
            str.append("[To]: ");
            str.append(email.getDisplayTo());
            str.append(System.getProperty("line.separator"));
            str.append("[Date]: ");
            str.append(email.getMessageDeliveryTime().toString());
            str.append(System.getProperty("line.separator"));
            str.append("[Body]: ");
            str.append(email.getBody());
            str.append(System.getProperty("line.separator"));
            str.append(this.RetrieveAttachment(file, email));
        }
        return str.toString();
    }

    private UtilityClass.FileExcludedType IsFileIndexable(File file, boolean bPSTfile, String deliveryTime) {
        UtilityClass.FileExcludedType ft = UtilityClass.FileExcludedType.NameContentIndexable;
        try {
            String fname;
            if (!bPSTfile) {
                String strObjFileExt = configclass.getInstance("config.xml").getObjectFileExt();
                if (!strObjFileExt.isEmpty() && !UtilityClass.isSpecifiedExtension(file.getCanonicalPath(), strObjFileExt)) {
                    return UtilityClass.FileExcludedType.Excluded;
                }
                ft = UtilityClass.isExcludeFileType(file.getCanonicalPath(), this.strExcludeFileType, configclass.getInstance("config.xml").getIndexDir(), false);
                if (UtilityClass.FileExcludedType.Excluded == ft) {
                    return ft;
                }
            }
            if (UtilityClass._LogFile.equals(fname = file.getName()) || "hook.log".equals(fname) || "unhandledFile.log".equals(fname)) {
                return UtilityClass.FileExcludedType.Excluded;
            }
            if (!(bPSTfile && fname.toLowerCase().endsWith("pst") || configclass.getInstance("config.xml").getMaxFileSize() <= 0L || file.length() <= 0L || file.length() <= configclass.getInstance("config.xml").getMaxFileSize())) {
                return UtilityClass.FileExcludedType.NameOnlyIndexable;
            }
            if (!(this.searchOption != UtilityClass.SearchOptionResumeIndexByCompareSnapshot && this.searchOption != UtilityClass.SearchOptionResumeIndexByFolder || this.bResumeStart)) {
                this.bResumeStart = this.isResumeIndexCreate(bPSTfile ? deliveryTime : file.getCanonicalPath());
                if (!this.bResumeStart) {
                    UtilityClass.OutputLogFile("skip:" + file.getCanonicalPath());
                    return UtilityClass.FileExcludedType.Excluded;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ft;
    }

    private long getFileModifiedDate(boolean bPSTfile, File file, PSTMessage email) throws Exception {
        long fileModifedDate;
        if (bPSTfile) {
            fileModifedDate = email.getMessageDeliveryTime().getTime();
        } else {
            fileModifedDate = UtilityClass.getFileLastModifiedDatelong(file);
            Metadata metadata = TextExtractor.getMetadata();
            if (metadata != null) {
                Date createDate = metadata.getDate(TikaCoreProperties.CREATED);
                Date modifyDate = metadata.getDate(TikaCoreProperties.MODIFIED);
                if (modifyDate == null) {
                    if (createDate != null) {
                        System.out.println("return created date : " + createDate.getTime());
                        return createDate.getTime();
                    }
                } else {
                    System.out.println("return modifydate : " + modifyDate.getTime());
                    return modifyDate.getTime();
                }
            }
        }
        return fileModifedDate;
    }

    private String getShortName(boolean bPSTfile, File file, PSTMessage email) {
        String str = file.getName().toLowerCase();
        return str;
    }

    private String getBasename(boolean bPSTfile, String filename, PSTMessage email) {
        String str = FilenameUtils.getBaseName((String)filename).toLowerCase();
        return str;
    }

    private String getExtension(boolean bPSTfile, String filename, PSTMessage email) {
        String extension = "pst";
        if (!bPSTfile) {
            extension = UtilityClass.getFileExtension(filename).toLowerCase();
        }
        return extension;
    }

    private String getMailSubstract(PSTMessage email) {
        StringBuffer str = new StringBuffer();
        if (email != null) {
            str.append("[Subject]: ");
            str.append(email.getSubject());
            str.append(System.getProperty("line.separator"));
            str.append("[To]: ");
            str.append(email.getDisplayTo());
            str.append(System.getProperty("line.separator"));
            str.append("[Date]: ");
            str.append(email.getMessageDeliveryTime().toString());
            str.append(System.getProperty("line.separator"));
            str.append("[Body]: ");
            str.append(email.getBody());
            str.append(System.getProperty("line.separator"));
            return this.getSubstract(str).toString();
        }
        return "";
    }

    private long GetMostRecentMailTime(File file) {
        long recentDate = 0L;
        try {
            FSDirectory directory = FSDirectory.open((Path)Paths.get(this.indexSavingFolder, new String[0]));
            DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher inSearcher = new IndexSearcher((IndexReader)indexReader);
            Term term = new Term("fileno", file.getCanonicalPath());
            TermQuery query = new TermQuery(term);
            SortField sortField = new SortField("filedate", SortField.Type.LONG, true);
            Sort sort = new Sort(sortField);
            TopFieldDocs collector = inSearcher.search((Query)query, this.maxLine, sort);
            ScoreDoc[] hits = collector.scoreDocs;
            if (hits.length == 0) {
                return recentDate;
            }
            int scoreId = hits[0].doc;
            Document document = inSearcher.doc(scoreId);
            String strMostRecentDate = document.get("filedate");
            recentDate = Long.valueOf(strMostRecentDate);
            indexReader.close();
            indexReader = null;
            inSearcher = null;
            directory.close();
            directory = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return recentDate;
    }

    public int updateIndex4PST(File file, int iTotal, int iCur) {
        int bRet = 0;
        try {
            long mostRecentTime = this.GetMostRecentMailTime(file);
            PSTFile pstFile = new PSTFile(file.getCanonicalPath());
            PSTFolder pstfolder = pstFile.getRootFolder();
            this.recursive(file, pstfolder, mostRecentTime, iTotal, iCur);
            pstFile.getFileHandle().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bRet;
    }

    private void recursive(File file, PSTFolder pstFolder, long mostRecentTime, int iTotal, int iCur) {
        try {
            if (pstFolder.hasSubfolders()) {
                Vector childFolders = pstFolder.getSubFolders();
                for (PSTFolder childPSTFolder : childFolders) {
                    this.recursive(file, childPSTFolder, mostRecentTime, iTotal, iCur);
                }
            }
            if (pstFolder.getContentCount() > 0) {
                PSTMessage email = (PSTMessage)pstFolder.getNextChild();
                while (email != null) {
                    Date mailtime = email.getMessageDeliveryTime();
                    if (mailtime != null && mostRecentTime < mailtime.getTime()) {
                        this.createIndex4File(file, email, iTotal, iCur);
                    }
                    email = (PSTMessage)pstFolder.getNextChild();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int createIndex4File(File file, PSTMessage email, int iTotal, int iCur) {
        try {
            boolean bPSTfile;
            boolean bl = bPSTfile = email != null;
            if (this.cancel || myInterface.stop()) {
                myInterface.NotifyStopAtFile(bPSTfile ? "" + email.getMessageDeliveryTime().getTime() : file.getCanonicalPath());
                System.out.println("notifyStopped, bPSTfile = " + bPSTfile);
                return 1;
            }
            UtilityClass.FileExcludedType iRet = UtilityClass.FileExcludedType.NameContentIndexable;
            if (bPSTfile || !file.isDirectory()) {
                String filename;
                iRet = this.IsFileIndexable(file, bPSTfile, bPSTfile ? "" + email.getMessageDeliveryTime().getTime() : "");
                if (iRet == UtilityClass.FileExcludedType.Excluded) {
                    return 0;
                }
                String fileStatus = filename = file.getCanonicalPath();
                if (email != null) {
                    fileStatus = filename + " - " + this.getFilenameOfMail(email);
                }
                UtilityClass.OutputLogFile("creating index:" + fileStatus + ", SearchOption=" + this.searchOption);
                myInterface.OnBeginCreatedFileIndex(fileStatus, iTotal, iCur, this.cancel || myInterface.stop());
                String content = "";
                if (!file.isDirectory() && iRet == UtilityClass.FileExcludedType.NameContentIndexable) {
                    content = bPSTfile ? this.getContentOfMail(file, email) : TextExtractor.RetreiveTextFile(filename);
                }
                if (UtilityClass.MEMORYOUT.equals(content)) {
                    this._fatalErrFile = email == null ? file.getCanonicalPath() : "" + email.getMessageDeliveryTime().getTime();
                    return -1;
                }
                if (UtilityClass.GENERALERR.equals(content)) {
                    this._fatalErrFile = email == null ? file.getCanonicalPath() : "" + email.getMessageDeliveryTime().getTime();
                    myInterface.NotifyStopAtFile(this._fatalErrFile);
                    myInterface.OnSkipCreatingFileIndex(this._fatalErrFile);
                    return 0;
                }
                Document document = new Document();
                if (!content.isEmpty()) {
                    document.add((IndexableField)new TextField("contents", content, Field.Store.NO));
                }
                long filedate = this.getFileModifiedDate(bPSTfile, file, email);
                document.add((IndexableField)new LongField("filedate", filedate, Field.Store.YES));
                document.add((IndexableField)new NumericDocValuesField("filedate", filedate));
                document.add((IndexableField)new StringField("fileno", filename, Field.Store.YES));
                long filelength = bPSTfile ? email.getMessageSize() : file.length();
                document.add((IndexableField)new LongField("filesize", filelength, Field.Store.YES));
                String strPage = TextExtractor.bHasPage() ? "PageInfoExtracted" : "";
                String substract = bPSTfile ? this.getMailSubstract(email) : strPage + this.getSubstract(new StringBuffer(content)).toString();
                document.add((IndexableField)new StringField("filesubstract", substract, Field.Store.YES));
                String strName = this.getShortName(bPSTfile, file, email);
                document.add((IndexableField)new StringField("shortname", strName, Field.Store.NO));
                document.add((IndexableField)new SortedDocValuesField("shortname", new BytesRef((CharSequence)strName)));
                String strBaseName = this.getBasename(bPSTfile, filename, email);
                document.add((IndexableField)new StringField("BaseNameTokenized", strBaseName, Field.Store.NO));
                String extension = this.getExtension(bPSTfile, filename, email);
                document.add((IndexableField)new StringField("extension", extension, Field.Store.NO));
                document.add((IndexableField)new SortedDocValuesField("extension", new BytesRef((CharSequence)extension)));
                indexWriter.addDocument((Iterable)document);
                if (filename.toLowerCase().endsWith(".pst")) {
                    this.createTextFileIndex(new StringBuffer(content), filename + "\\" + filedate);
                } else {
                    this.createTextFileIndex(new StringBuffer(content), filename);
                    if (TextExtractor.bHasPage()) {
                        this.createPageLineIndex(TextExtractor.pageLine(), filename);
                    }
                }
            } else {
                if (UtilityClass.DebugMode) {
                    System.out.println("indexing directory => " + file.getCanonicalPath());
                }
                Document document = new Document();
                long filedate = UtilityClass.getFileLastModifiedDatelong(file);
                document.add((IndexableField)new LongField("filedate", filedate, Field.Store.YES));
                document.add((IndexableField)new NumericDocValuesField("filedate", filedate));
                document.add((IndexableField)new StringField("fileno", file.getCanonicalPath(), Field.Store.YES));
                long filelength = file.length();
                document.add((IndexableField)new LongField("filesize", filelength, Field.Store.YES));
                String strName = file.getName().toLowerCase();
                document.add((IndexableField)new StringField("shortname", strName, Field.Store.NO));
                document.add((IndexableField)new SortedDocValuesField("shortname", new BytesRef((CharSequence)strName)));
                String strBaseName = FilenameUtils.getBaseName((String)strName).toLowerCase();
                document.add((IndexableField)new StringField("BaseNameTokenized", strBaseName, Field.Store.NO));
                String extension = UtilityClass.getFileExtension(strName).toLowerCase();
                document.add((IndexableField)new StringField("extension", extension, Field.Store.NO));
                document.add((IndexableField)new SortedDocValuesField("extension", new BytesRef((CharSequence)extension)));
                indexWriter.addDocument((Iterable)document);
                myInterface.OnEndCreatedFileIndex(file.getCanonicalPath(), iTotal, iCur, this.cancel || myInterface.stop());
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
            e.printStackTrace();
        }
        catch (OutOfMemoryError ee) {
            ee.printStackTrace();
        }
        return 0;
    }

    public void deleteIndex4File(File file, int iTotal, int iCur, boolean bDeleteAllFilesUnderDir) {
        block5: {
            if (this.cancel || myInterface.stop()) {
                return;
            }
            try {
                String filename = UtilityClass.getFileInfo(file);
                if (bDeleteAllFilesUnderDir) {
                    PrefixQuery query = new PrefixQuery(new Term("fileno", filename + "\\"));
                    indexWriter.deleteDocuments(new Query[]{query});
                    indexWriter.deleteDocuments(new Term[]{new Term("fileno", filename)});
                } else {
                    indexWriter.deleteDocuments(new Term[]{new Term("fileno", filename)});
                }
                indexWriter.commit();
                this.deleteTextFileIndex(filename, bDeleteAllFilesUnderDir);
                myInterface.OnDeleteIndexFile(filename, this.cancel || myInterface.stop(), iTotal, iCur);
            }
            catch (Exception e) {
                UtilityClass.OutputLogFile(e.getMessage());
                if (!UtilityClass.DebugMode) break block5;
                System.out.println("exception: deleteIndex4File: " + e.getMessage());
            }
        }
    }

    private void deleteTextFileIndex(String filename, boolean bDeleteAllFilesUnderDir) {
        if (this.cancel || myInterface.stop()) {
            return;
        }
        try {
            if (bDeleteAllFilesUnderDir) {
                PrefixQuery query = new PrefixQuery(new Term("fileno", filename + "\\"));
                subIndexWriter.deleteDocuments(new Query[]{query});
                subIndexWriter.deleteDocuments(new Term[]{new Term("fileno", filename)});
            } else {
                subIndexWriter.deleteDocuments(new Term[]{new Term("fileno", filename)});
            }
            subIndexWriter.commit();
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public int createDirIndex(String Include, String Exclude, int index) throws CorruptIndexException, LockObtainFailedException, IOException, Exception {
        myInterface.OnBeforeCreateDirIndex(Include, Exclude, this.cancel || myInterface.stop());
        String[] dirIncludeIndex = Include.split(";");
        String[] dirExcludeIndex = null;
        if (Exclude != null && Exclude.length() != 0) {
            dirExcludeIndex = Exclude.split(";");
        }
        this.totalFileNum(dirIncludeIndex, dirExcludeIndex);
        this.iCurrentFileNo = 0;
        int iRet = this.CreateIndex4Folder(dirIncludeIndex, dirExcludeIndex);
        UtilityClass.OutputLogFile("IndexWriter closing...");
        this.finializeCreateIndex();
        if (iRet < 0) {
            this._handleFatalErr(iRet, index);
        }
        return iRet;
    }

    public void _handleFatalErr(int iret, int index) throws Exception {
        configclass.getInstance("config.xml").setProgress("0");
        if (iret == -1) {
            if (configclass.getInstance("config.xml").getResidentMode() == UtilityClass.TimeMode.SERVICE.ordinal() && UtilityClass._ServiceIndexing) {
                configclass.getInstance("config.xml").setProgress("100");
                configclass.getInstance("config.xml").Save();
                UtilityClass.OutputErrLogFile("Out of memory err: failed in creating index, please increase the mem max Value", true);
                Thread.sleep(200L);
                System.exit(1);
            } else {
                configclass.getInstance("config.xml").setSkipFlag(0);
            }
        } else {
            configclass.getInstance("config.xml").setSkipFlag(1);
        }
        configclass.getInstance("config.xml").setSearchOption(this.searchOption);
        configclass.getInstance("config.xml").setErrFileIndex(index);
        if (!this._fatalErrFile.isEmpty()) {
            configclass.getInstance("config.xml").setStopFile(this._fatalErrFile);
        }
        configclass.getInstance("config.xml").setLastTimeReturnVal(iret);
        configclass.getInstance("config.xml").Save();
        if (iret == -1) {
            UtilityClass.StartAdminTool();
            Thread.sleep(100L);
            System.exit(1);
        }
    }

    public int CreateIndex4Folder(String[] dirInclude, String[] dirExclude) {
        if (UtilityClass.DebugMode) {
            System.out.println("searchoption = " + this.searchOption + "bResumeStart = " + this.bResumeStart);
        }
        if (myInterface != null) {
            myInterface.OnBeginCreateDirIndex();
        }
        int iret = 0;
        for (String folder : dirInclude) {
            this.createIndex4File(new File(folder), null, this.iTotalFilecnt, this.iCurrentFileNo);
            iret = this._CreateIndex4Folder(folder, null, dirExclude, false);
            if (iret != 0) break;
        }
        return iret;
    }

    public int totalFileNum(String[] filelistInclude, String[] filelistExclude) {
        myInterface.OnBeginEstimate(this.cancel || myInterface.stop());
        this.iTotalFilecnt = 0;
        for (String folder : filelistInclude) {
            if (!this.FileCnt(folder, filelistExclude)) break;
        }
        myInterface.OnEndEstimate(this.cancel || myInterface.stop());
        return this.iTotalFilecnt;
    }

    private int GetPSTFileCnt(File file) {
        this.iPSTCnt = 0;
        try {
            PSTFile pstFile = new PSTFile(file.getAbsolutePath());
            PSTFolder pstfolder = pstFile.getRootFolder();
            this.recursive2(pstfolder);
            pstFile.getFileHandle().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.iPSTCnt;
    }

    private void recursive2(PSTFolder pstFolder) {
        try {
            if (pstFolder.hasSubfolders()) {
                Vector childFolders = pstFolder.getSubFolders();
                for (PSTFolder childPSTFolder : childFolders) {
                    this.recursive2(childPSTFolder);
                }
            }
            this.iPSTCnt = pstFolder.getContentCount() + this.iPSTCnt;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean FileCnt(String folder, String[] filelistExclude) {
        try {
            File file = new File(folder);
            if (!file.exists() || !file.isDirectory()) {
                return true;
            }
            if (this.cancel || myInterface.stop()) {
                return false;
            }
            File[] fileArray = file.listFiles();
            int icnt = 0;
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        if (UtilityClass.IsExcludedFolder(fileArray[i].getAbsolutePath(), filelistExclude) || this.FileCnt(fileArray[i].getAbsolutePath(), filelistExclude)) continue;
                        return false;
                    }
                    if (fileArray[i].getCanonicalPath().toLowerCase().endsWith(".pst")) {
                        int pstFileNo = this.GetPSTFileCnt(fileArray[i]);
                        icnt += pstFileNo;
                        continue;
                    }
                    ++icnt;
                }
            }
            this.iTotalFilecnt += icnt;
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
        return true;
    }

    public StringBuffer getSubstract(StringBuffer strBuff) {
        String str = strBuff.toString();
        int maxLenofSubstract = 180;
        StringBuffer strB = str.length() <= 180 ? new StringBuffer(str.replaceAll("\\r\\n|\\r|\\n|\\t", " ")) : new StringBuffer(str.substring(0, 180).replaceAll("\\r\\n|\\r|\\n|\\t", " "));
        if ((strB = new StringBuffer(strB.toString().replaceAll(" +", " "))).length() <= 180) {
            return strB.append("...");
        }
        return new StringBuffer(strB.substring(0, 180)).append("...");
    }

    private void createTextFileIndex(StringBuffer strbuf, String filename) throws CorruptIndexException, LockObtainFailedException, IOException {
        int startIndex = 0;
        int mem = configclass.getInstance("config.xml").getJVMMem();
        if (mem != 0 && mem * 1000 < 2 * UtilityClass.BLOCKSize) {
            UtilityClass.BLOCKSize = mem * 500;
        }
        int endIndex = UtilityClass.BLOCKSize;
        this.iIndexLine = 0;
        while (startIndex >= 0 && (endIndex = strbuf.indexOf("\n", endIndex)) >= 0) {
            this.Indexing(filename, strbuf, startIndex, endIndex += "\n".length());
            startIndex = endIndex;
            endIndex = startIndex + UtilityClass.BLOCKSize;
        }
        this.Indexing(filename, strbuf, startIndex, strbuf.length());
    }

    private void Indexing(String filename, StringBuffer strB, int start, int end) throws CorruptIndexException, LockObtainFailedException, IOException {
        String str = strB.substring(start, end);
        String[] iLines = str.split("\r\n|\n|\r");
        for (int i = 0; i < iLines.length; ++i) {
            String stra = iLines[i];
            if (stra.trim().isEmpty()) continue;
            ++this.iIndexLine;
            Document ld = new Document();
            ld.add((IndexableField)new IntField("lineno", this.iIndexLine, Field.Store.YES));
            ld.add((IndexableField)new NumericDocValuesField("lineno", (long)this.iIndexLine));
            ld.add((IndexableField)new TextField("linecontent", stra, Field.Store.YES));
            ld.add((IndexableField)new StringField("fileno", filename, Field.Store.NO));
            subIndexWriter.addDocument((Iterable)ld);
        }
    }

    private void createPageLineIndex(ArrayList<Integer> pageLine, String filename) throws CorruptIndexException, LockObtainFailedException, IOException {
        int pageNo;
        String strPageline = pageLine.toString();
        if (strPageline.isEmpty()) {
            return;
        }
        Document ld = new Document();
        int startlineNo = 1;
        ld.add((IndexableField)new StringField("fileno", filename, Field.Store.NO));
        ld.add((IndexableField)new IntField("pageno", pageNo, Field.Store.YES));
        ld.add((IndexableField)new NumericDocValuesField("pageno", (long)pageNo));
        ld.add((IndexableField)new IntField("startlineno", startlineNo, Field.Store.YES));
        pageLineSubIndexWriter.addDocument((Iterable)ld);
        for (pageNo = 1; pageNo <= pageLine.size(); ++pageNo) {
            ld = new Document();
            ld.add((IndexableField)new StringField("fileno", filename, Field.Store.NO));
            ld.add((IndexableField)new IntField("pageno", pageNo + 1, Field.Store.YES));
            ld.add((IndexableField)new IntField("startlineno", startlineNo += pageLine.get(pageNo - 1).intValue(), Field.Store.YES));
            pageLineSubIndexWriter.addDocument((Iterable)ld);
        }
        pageLine.clear();
    }

    private void CreateMetaDataIndex(String fileName, byte[] thumbnail) {
    }

    private String CreateRegString(String str, String strOrigin) {
        String stTemp = strOrigin.replace("(", "");
        stTemp = stTemp.replace(")", "");
        stTemp = stTemp.replaceAll("AND |NOT |OR ", "");
        String[] strKeywordBeforeParsing = stTemp.split(" +");
        MyAnalyzer analyzer = null;
        if (stTemp.indexOf("*") == -1) {
            analyzer = new MyAnalyzer();
            analyzer.SetMode(configclass.getInstance("config.xml").getLemminationOption());
        }
        String strResult = "";
        for (String strItem : strKeywordBeforeParsing) {
            if (strItem.startsWith("\"")) {
                strItem = strItem.substring(1);
            }
            if (strItem.endsWith("\"")) {
                strItem = strItem.substring(0, strItem.length() - 1);
            }
            String strParsed = strItem;
            if (analyzer != null) {
                strParsed = analyzer.getParsedString(strItem);
            }
            strResult = strResult.isEmpty() ? strParsed : strResult + "|" + strParsed;
        }
        if ("0".equals(configclass.getInstance("config.xml").getIsFixedKeyword())) {
            strResult = strResult.replace(" ", "|");
        }
        if (analyzer != null) {
            analyzer.close();
        }
        return strResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean searchDirIndex(String searchString, String strOrderField, boolean isAscend, FilterDlgData filterDlgData, boolean bSearchContent, String strFilename, String strFileTime) throws IOException, Exception {
        DirectoryReader indexReader = null;
        IndexSearcher indexSearcher = null;
        FSDirectory directory = null;
        MyAnalyzer analyzer = null;
        long timeUsed = System.currentTimeMillis();
        int hitCount = 0;
        String queryString = "";
        this.searchResult.clear();
        int distance = -1;
        try {
            Object strFiles;
            BooleanQuery mainQuery;
            WildcardQuery query;
            UtilityClass.OutputLogFile("Search key:" + searchString);
            myInterface.OnBeforeSearchDirIndex(searchString, this.cancel || myInterface.stop());
            UtilityClass.OutputLogFile("inside thread - searchBiz::OnBeforeSearchDirIndex() : current time:" + System.currentTimeMillis());
            directory = FSDirectory.open((Path)Paths.get(this.indexSavingFolder, new String[0]));
            indexReader = DirectoryReader.open((Directory)directory);
            indexSearcher = new IndexSearcher((IndexReader)indexReader);
            UtilityClass.OutputLogFile("inside thread - searchBiz::open() : current time:" + System.currentTimeMillis());
            if (!bSearchContent) {
                analyzer = new MyAnalyzer();
                queryString = searchString;
                if (!searchString.startsWith("*")) {
                    searchString = "*" + searchString;
                }
                if (!searchString.endsWith("*")) {
                    searchString = searchString + "*";
                }
                if (UtilityClass.DebugMode) {
                    System.out.println("searchString = " + searchString);
                }
                Term term = new Term("BaseNameTokenized", searchString);
                query = new WildcardQuery(term);
                mainQuery = new BooleanQuery();
                mainQuery.add((Query)query, BooleanClause.Occur.MUST);
                if (filterDlgData != null) {
                    String strEscapeFolder;
                    if (filterDlgData.chkTimeFilter) {
                        NumericRangeQuery timeRangeQuery = NumericRangeQuery.newLongRange((String)"filedate", (Long)filterDlgData.getStartDate(), (Long)filterDlgData.getEndDate(), (boolean)true, (boolean)true);
                        mainQuery.add((Query)timeRangeQuery, BooleanClause.Occur.MUST);
                    }
                    if (filterDlgData.chkFileFilter) {
                        BooleanQuery exeFilter = new BooleanQuery();
                        exeFilter.setMinimumNumberShouldMatch(1);
                        for (String strExt : filterDlgData.fileExtArray()) {
                            exeFilter.add((Query)new TermQuery(new Term("extension", strExt)), BooleanClause.Occur.SHOULD);
                        }
                        mainQuery.add((Query)exeFilter, BooleanClause.Occur.MUST);
                    }
                    if (filterDlgData.chkFolderFilter) {
                        BooleanQuery folderFilter = new BooleanQuery();
                        String strPath = filterDlgData.txtFolderFilter;
                        if (!strPath.isEmpty()) {
                            strEscapeFolder = strPath.endsWith("\\") ? strPath.replace("\\", "\\\\") + "*" : strPath.replace("\\", "\\\\") + "\\\\*";
                            folderFilter.add((Query)new WildcardQuery(new Term("fileno", strEscapeFolder)), BooleanClause.Occur.SHOULD);
                        }
                        mainQuery.add((Query)folderFilter, BooleanClause.Occur.MUST);
                    }
                    if (filterDlgData.txtPathFilter != null && filterDlgData.txtPathFilter.length > 0) {
                        BooleanQuery pathFilter = new BooleanQuery();
                        ArrayList<String> strFolders = new ArrayList<String>();
                        strFiles = new ArrayList();
                        if (filterDlgData.txtPathFilter != null) {
                            for (String strPath : filterDlgData.txtPathFilter) {
                                File filetemp = new File(strPath);
                                if (filetemp.isDirectory()) {
                                    strFolders.add(strPath);
                                    continue;
                                }
                                ((ArrayList)strFiles).add(strPath);
                            }
                        }
                        Iterator iterator = ((ArrayList)strFiles).iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            pathFilter.add((Query)new TermQuery(new Term("fileno", string)), BooleanClause.Occur.SHOULD);
                        }
                        for (String string : strFolders) {
                            if (string.isEmpty()) continue;
                            strEscapeFolder = string.endsWith("\\") ? string.replace("\\", "\\\\") + "*" : string.replace("\\", "\\\\") + "\\\\*";
                            pathFilter.add((Query)new WildcardQuery(new Term("fileno", strEscapeFolder)), BooleanClause.Occur.SHOULD);
                        }
                        mainQuery.add((Query)pathFilter, BooleanClause.Occur.MUST);
                    }
                }
            } else {
                distance = UtilityClass.isSpanQueryPattern(searchString);
                if (-1 != distance) {
                    SpanQuery subQuery1 = MySpanQuery.CreateSpannearSearchQuery("contents", UtilityClass.SpanStrKey1);
                    SpanQuery subQuery2 = MySpanQuery.CreateSpannearSearchQuery("contents", UtilityClass.SpanStrKey2);
                    query = new SpanNearQuery(new SpanQuery[]{subQuery1, subQuery2}, distance, true);
                    queryString = MySpanQuery.CreateRegStringForSpanQuery(searchString);
                } else {
                    analyzer = new MyAnalyzer();
                    analyzer.SetMode(configclass.getInstance("config.xml").getLemminationOption());
                    QueryParser queryParser = new QueryParser("contents", (Analyzer)analyzer);
                    if (configclass.getInstance("config.xml").getOrOperator()) {
                        queryParser.setDefaultOperator(QueryParser.OR_OPERATOR);
                    } else {
                        queryParser.setDefaultOperator(QueryParser.AND_OPERATOR);
                    }
                    query = queryParser.parse(searchString);
                    queryString = this.CreateRegString(query.toString(), searchString);
                }
                UtilityClass.OutputLogFile("parsed query:" + queryString);
                mainQuery = new BooleanQuery();
                mainQuery.add((Query)query, BooleanClause.Occur.MUST);
                if (filterDlgData != null) {
                    String strEscapeFolder;
                    if (filterDlgData.chkTimeFilter) {
                        NumericRangeQuery timeRangeQuery = NumericRangeQuery.newLongRange((String)"filedate", (Long)filterDlgData.getStartDate(), (Long)filterDlgData.getEndDate(), (boolean)true, (boolean)true);
                        mainQuery.add((Query)timeRangeQuery, BooleanClause.Occur.MUST);
                    }
                    if (filterDlgData.chkFileFilter) {
                        BooleanQuery exeFilter = new BooleanQuery();
                        exeFilter.setMinimumNumberShouldMatch(1);
                        for (String strExt : filterDlgData.fileExtArray()) {
                            exeFilter.add((Query)new TermQuery(new Term("extension", strExt)), BooleanClause.Occur.SHOULD);
                        }
                        mainQuery.add((Query)exeFilter, BooleanClause.Occur.MUST);
                    }
                    if (filterDlgData.chkFolderFilter) {
                        BooleanQuery folderFilter = new BooleanQuery();
                        String strPath = filterDlgData.txtFolderFilter;
                        if (!strPath.isEmpty()) {
                            strEscapeFolder = strPath.endsWith("\\") ? strPath.replace("\\", "\\\\") + "*" : strPath.replace("\\", "\\\\") + "\\\\*";
                            folderFilter.add((Query)new WildcardQuery(new Term("fileno", strEscapeFolder)), BooleanClause.Occur.SHOULD);
                        }
                        mainQuery.add((Query)folderFilter, BooleanClause.Occur.MUST);
                    }
                    if (filterDlgData.txtPathFilter != null && filterDlgData.txtPathFilter.length > 0) {
                        BooleanQuery pathFilter = new BooleanQuery();
                        ArrayList<Object> strFolders = new ArrayList<Object>();
                        ArrayList<Object> strFiles2 = new ArrayList<Object>();
                        if (filterDlgData.txtPathFilter != null) {
                            void var25_36;
                            strFiles = filterDlgData.txtPathFilter;
                            int n = ((String[])strFiles).length;
                            boolean bl = false;
                            while (var25_36 < n) {
                                Object strPath = strFiles[var25_36];
                                File filetemp = new File((String)strPath);
                                if (filetemp.isDirectory()) {
                                    strFolders.add(strPath);
                                } else {
                                    strFiles2.add(strPath);
                                }
                                ++var25_36;
                            }
                        }
                        for (String string : strFiles2) {
                            pathFilter.add((Query)new TermQuery(new Term("fileno", string)), BooleanClause.Occur.SHOULD);
                        }
                        for (String string : strFolders) {
                            if (string.isEmpty()) continue;
                            strEscapeFolder = string.endsWith("\\") ? string.replace("\\", "\\\\") + "*" : string.replace("\\", "\\\\") + "\\\\*";
                            pathFilter.add((Query)new WildcardQuery(new Term("fileno", strEscapeFolder)), BooleanClause.Occur.SHOULD);
                        }
                        mainQuery.add((Query)pathFilter, BooleanClause.Occur.MUST);
                    }
                }
                if (UtilityClass.DebugMode) {
                    System.out.println("mainQuery =" + mainQuery.toString());
                }
            }
            SortField sortField = new SortField(strOrderField, strOrderField.equals("filedate") ? SortField.Type.LONG : SortField.Type.STRING, !isAscend);
            Sort sort = new Sort(sortField);
            UtilityClass.OutputLogFile("inside thread - before search() : current time:" + System.currentTimeMillis());
            TopFieldDocs collector = indexSearcher.search((Query)mainQuery, this.maxLine, sort);
            UtilityClass.OutputLogFile("inside thread - after search() : current time:" + System.currentTimeMillis());
            ScoreDoc[] hits = collector.scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                int n = hits[i].doc;
                Document document = indexSearcher.doc(n);
                if (bSearchContent && UtilityClass.FileExcludedType.Excluded == UtilityClass.isExcludeFileType(document.get("fileno"), this.strExcludeFileType, configclass.getInstance("config.xml").getIndexDir(), true)) {
                    if (!UtilityClass.DebugMode) continue;
                    System.out.println("skip " + document.get("fileno"));
                    continue;
                }
                MySummaryData data = new MySummaryData();
                data.fileID = document.get("fileno");
                data.time = document.get("filedate");
                data.description = document.get("filesubstract");
                this.searchResult.add(data);
                if (this.cancel || myInterface.stop()) break;
                if (!myInterface.OnFindLineData(data, this.cancel || myInterface.stop())) continue;
                ++hitCount;
            }
            UtilityClass.OutputLogFile("Number of hits:" + hitCount);
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
        }
        finally {
            if (analyzer != null) {
                analyzer.close();
                analyzer = null;
            }
            if (indexReader != null) {
                indexReader.close();
                indexReader = null;
            }
            if (indexSearcher != null) {
                indexSearcher = null;
            }
            if (directory != null) {
                directory.close();
                directory = null;
            }
        }
        timeUsed = System.currentTimeMillis() - timeUsed;
        UtilityClass.OutputLogFile("inside thread - search finished : current time:" + System.currentTimeMillis());
        return myInterface.OnSearchFinished(distance, queryString, this.searchResult, timeUsed, this.cancel || myInterface.stop(), strFilename, strFileTime);
    }

    public List<String> GetAllDocOfFiles() {
        boolean bCancel;
        myInterface.OnBeginNonRealItemIndexing();
        ArrayList<String> allIndexedFiles = new ArrayList<String>();
        try {
            FSDirectory directory = FSDirectory.open((Path)Paths.get(this.indexSavingFolder, new String[0]));
            DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
            for (int i = 0; i < indexReader.maxDoc(); ++i) {
                if (UtilityClass.DebugMode) {
                    System.out.println("indexSavingFolder, indexReader.maxDoc()=" + this.indexSavingFolder + indexReader.maxDoc());
                }
                if (this.cancel || myInterface.stop()) {
                    if (!UtilityClass.DebugMode) break;
                    System.out.println("myinterface.stop is true");
                    break;
                }
                Document doc = indexReader.document(i);
                String docInfo = doc.get("fileno") + ";" + doc.get("filedate") + ";" + doc.get("filesize");
                allIndexedFiles.add(docInfo);
                myInterface.OnCreateSnapshot(doc.get("fileno"));
            }
            indexReader.close();
            Object var3_5 = null;
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
        boolean bl = bCancel = this.cancel || myInterface.stop();
        if (!bCancel && allIndexedFiles != null && allIndexedFiles.size() != 0) {
            if (UtilityClass.DebugMode) {
                System.out.println("before sorting the indexing data: filename");
            }
            Collections.sort(allIndexedFiles);
            if (UtilityClass.DebugMode) {
                System.out.println("after sorting the indexing data: filename");
            }
        }
        return allIndexedFiles;
    }

    public int GetPageNobyLineNo(int lineNo, String filename) {
        int page = 1;
        try {
            FSDirectory _directory = FSDirectory.open((Path)Paths.get(this.indexSavingFolder + "\\subIndex2", new String[0]));
            DirectoryReader _indexReader = DirectoryReader.open((Directory)_directory);
            IndexSearcher _indexSearcher = new IndexSearcher((IndexReader)_indexReader);
            TermFilter filter = null;
            filter = new TermFilter(new Term("fileno", filename));
            NumericRangeQuery pageQueryRange = NumericRangeQuery.newIntRange((String)"startlineno", (Integer)1, (Integer)lineNo, (boolean)false, (boolean)true);
            SortField sortField = new SortField("pageno", SortField.Type.INT, true);
            Sort sort = new Sort(sortField);
            TopFieldDocs subcollector = _indexSearcher.search((Query)pageQueryRange, (Filter)filter, this._File_content_maxLine, sort);
            ScoreDoc[] hits = subcollector.scoreDocs;
            if (hits.length > 0) {
                int scoreId = hits[0].doc;
                Document document = _indexSearcher.doc(scoreId);
                page = Integer.valueOf(document.get("pageno"));
                System.out.println("find the correct page: " + page);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return page;
    }

    public String[] SearchFileFullText(String filename, String fileCreatedTime) throws IOException, Exception {
        FSDirectory _subdirectory = FSDirectory.open((Path)Paths.get(this.indexSavingFolder + "\\subIndex", new String[0]));
        DirectoryReader _subindexReader = DirectoryReader.open((Directory)_subdirectory);
        IndexSearcher _subindexSearcher = new IndexSearcher((IndexReader)_subindexReader);
        MyAnalyzer _subanalyzer = new MyAnalyzer();
        _subanalyzer.SetMode(configclass.getInstance("config.xml").getLemminationOption());
        TermQuery tq = filename.toLowerCase().endsWith(".pst") ? new TermQuery(new Term("fileno", filename + "\\" + fileCreatedTime)) : new TermQuery(new Term("fileno", filename));
        TopDocs subcollector = _subindexSearcher.search((Query)tq, this._File_content_maxLine);
        ScoreDoc[] hits = subcollector.scoreDocs;
        String[] fulltext = new String[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            if (Thread.currentThread().getName().endsWith(UtilityClass._THREADSTOP)) {
                return null;
            }
            int subScoreId = hits[i].doc;
            Document document = _subindexSearcher.doc(subScoreId);
            MyDetailData detailData = new MyDetailData();
            detailData.content = document.get("linecontent");
            detailData.lineno = document.get("lineno");
            fulltext[i] = detailData.content;
        }
        _subanalyzer.close();
        _subanalyzer = null;
        _subindexSearcher = null;
        _subindexReader.close();
        _subindexReader = null;
        _subdirectory.close();
        _subdirectory = null;
        return fulltext;
    }

    public MyDetailData[] searchFileIndex(String filename, String fileDate, String searchString) throws IOException, Exception {
        Query query;
        UtilityClass.OutputLogFile("searchFileIndex");
        FSDirectory _subdirectory = FSDirectory.open((Path)Paths.get(this.indexSavingFolder + "\\subIndex", new String[0]));
        DirectoryReader _subindexReader = DirectoryReader.open((Directory)_subdirectory);
        IndexSearcher _subindexSearcher = new IndexSearcher((IndexReader)_subindexReader);
        MyAnalyzer _subanalyzer = new MyAnalyzer();
        _subanalyzer.SetMode(configclass.getInstance("config.xml").getLemminationOption());
        int distance = UtilityClass.isSpanQueryPattern(searchString);
        if (-1 != distance) {
            SpanQuery subQuery1 = MySpanQuery.CreateSpannearSearchQuery("linecontent", UtilityClass.SpanStrKey1);
            SpanQuery subQuery2 = MySpanQuery.CreateSpannearSearchQuery("linecontent", UtilityClass.SpanStrKey2);
            query = new SpanNearQuery(new SpanQuery[]{subQuery1, subQuery2}, distance, true);
        } else {
            QueryParser qp = new QueryParser("linecontent", (Analyzer)_subanalyzer);
            qp.setDefaultOperator(QueryParser.OR_OPERATOR);
            query = qp.parse(searchString);
        }
        TermFilter filter = null;
        filter = filename.toLowerCase().endsWith(".pst") ? new TermFilter(new Term("fileno", filename + "\\" + fileDate)) : new TermFilter(new Term("fileno", filename));
        UtilityClass.OutputLogFile("filename:" + filename + " size:" + UtilityClass.getFilesize(new File(filename)) + " query=" + query.toString());
        SortField sortField = new SortField("lineno", SortField.Type.INT);
        Sort sort = new Sort(sortField);
        UtilityClass.OutputLogFile("sort=" + sort.toString());
        TopFieldDocs subcollector = _subindexSearcher.search(query, (Filter)filter, this._File_content_maxLine, sort);
        ScoreDoc[] hits = subcollector.scoreDocs;
        MyDetailData[] matchedLineData = new MyDetailData[hits.length];
        UtilityClass.OutputLogFile("loop the search result, hit length=" + hits.length);
        for (int i = 0; i < hits.length; ++i) {
            if (Thread.currentThread().getName().endsWith(UtilityClass._THREADSTOP)) {
                return null;
            }
            int subScoreId = hits[i].doc;
            Document document = _subindexSearcher.doc(subScoreId);
            MyDetailData detailData = new MyDetailData();
            detailData.content = document.get("linecontent");
            detailData.lineno = document.get("lineno").toString();
            matchedLineData[i] = new MyDetailData();
            matchedLineData[i].content = detailData.content;
            matchedLineData[i].lineno = detailData.lineno;
            if (!UtilityClass.DebugMode) continue;
            System.out.println("lineno:" + detailData.lineno);
        }
        _subanalyzer.close();
        _subanalyzer = null;
        _subindexSearcher = null;
        _subindexReader.close();
        _subindexReader = null;
        _subdirectory.close();
        _subdirectory = null;
        return matchedLineData;
    }

    public static void setInterface(InterfaceAsynSearchDisplayEvent inter) {
        myInterface = inter;
    }

    static {
        analyzer = null;
        indexWriter = null;
        subanalyzer = null;
        subIndexWriter = null;
        pageLinesubanalyzer = null;
        pageLineSubIndexWriter = null;
    }
}

