/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Interface.Mytranslator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import ui.InterfaceAsynSearchDisplayEvent;
import ui.MyCompositeTable;
import ui.copyFilesThread;
import ui.deleteFilesThread;

public class FileOperationsController {
    private static FileOperationsController instance;
    private Shell shell;
    private MyCompositeTable table;
    private InterfaceAsynSearchDisplayEvent eventHandler;

    private FileOperationsController() {
    }

    public static FileOperationsController getInstance() {
        if (instance == null) {
            instance = new FileOperationsController();
        }
        return instance;
    }

    public void init(Shell shell, MyCompositeTable table, InterfaceAsynSearchDisplayEvent eventHandler) {
        this.shell = shell;
        this.table = table;
        this.eventHandler = eventHandler;
    }

    public void setTable(MyCompositeTable table) {
        this.table = table;
    }

    public void onClickCopyButton() {
        TableItem[] curTableItem = this.table.getSelection();
        if (curTableItem != null && curTableItem.length != 0) {
            String[] srcfilelist = new String[curTableItem.length];
            for (int i = 0; i < curTableItem.length; ++i) {
                srcfilelist[i] = curTableItem[i].getText();
            }
            DirectoryDialog fd = new DirectoryDialog(this.shell);
            String destfolder = fd.open();
            if (destfolder != null) {
                copyFilesThread copyThread = new copyFilesThread();
                copyThread.init(this.eventHandler, srcfilelist, destfolder, true);
                copyThread.start();
            }
        } else {
            this.showAlert(this.getTranslate("noselection"), 32);
        }
    }

    public void onClickMoveButton() {
        TableItem[] curTableItem = this.table.getSelection();
        if (curTableItem != null && curTableItem.length != 0) {
            String[] srcfilelist = new String[curTableItem.length];
            for (int i = 0; i < curTableItem.length; ++i) {
                srcfilelist[i] = curTableItem[i].getText();
            }
            DirectoryDialog fd = new DirectoryDialog(this.shell);
            String destfolder = fd.open();
            if (destfolder != null) {
                copyFilesThread copyThread = new copyFilesThread();
                copyThread.init(this.eventHandler, srcfilelist, destfolder, false);
                copyThread.start();
            }
        } else {
            this.showAlert(this.getTranslate("noselection"), 32);
        }
    }

    public void onClickDeleteButton() {
        TableItem[] curTableItem = this.table.getSelection();
        if (curTableItem != null && curTableItem.length != 0) {
            if (256 == this.showAlert(this.getTranslate("onDeleteFiles"), 288)) {
                return;
            }
            String[] srcfilelist = new String[curTableItem.length];
            for (int i = 0; i < curTableItem.length; ++i) {
                srcfilelist[i] = curTableItem[i].getText();
            }
            deleteFilesThread deleteThread = new deleteFilesThread();
            deleteThread.init(this.eventHandler, srcfilelist);
            deleteThread.start();
        } else {
            this.showAlert(this.getTranslate("noselection"), 32);
        }
    }

    public int showAlert(String message, int style) {
        MessageBox messageBox = new MessageBox(this.shell, style | 2);
        messageBox.setMessage(message);
        return messageBox.open();
    }

    private String getTranslate(String key) {
        return Mytranslator.getInstance().getTranslate(key);
    }
}

