/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Interface.Mytranslator;
import biz.configclass;
import java.util.Locale;
import org.eclipse.nebula.widgets.pagination.AbstractPageControllerComposite;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.PaginationHelper;
import org.eclipse.nebula.widgets.pagination.Resources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import ui.MyProgress;
import ui.UtilityClass;

public class MyResultAndNavigationPageLinksRenderer
extends AbstractPageControllerComposite
implements SelectionListener {
    private static final RGB RED_COLOR = new RGB(255, 0, 0);
    private static final RGB DARK_MODE_TEXT_COLOR = new RGB(207, 207, 207);
    private boolean isDarkMode;
    private static final String END_HREF = "</a>";
    private static final String OPEN_START_HREF = "<a href=\"";
    private static final String OPEN_END_HREF = "\" >";
    private Label resultLabel;
    private Link previousLink;
    private Link nextLink;
    private Link pageLinks;
    private MyProgress myProgress;
    private Spinner spin;

    public Label getLabel() {
        return this.resultLabel;
    }

    public MyProgress getProgressBar() {
        return this.myProgress;
    }

    public MyResultAndNavigationPageLinksRenderer(Composite parent, int style, PageableController controller) {
        super(parent, style, controller);
        int iColorTheme = configclass.getInstance("config.xml").getColorTheme();
        this.isDarkMode = iColorTheme == 1;
    }

    public void refreshEnabled(PageableController controller) {
        long l;
        if (UtilityClass.DebugMode) {
            System.out.println("----refreshEnabled");
        }
        if ((l = controller.getTotalElements()) == 0L) {
            String strLabel = "0" + Mytranslator.getInstance().getTranslate("StatusTip1");
            this.spin.setEnabled(false);
            this.resultLabel.setText(strLabel);
        } else {
            long total;
            int start = controller.getPageOffset() + 1;
            int end = start + controller.getPageSize() - 1;
            if ((long)end > (total = controller.getTotalElements())) {
                end = (int)total;
            }
            if (UtilityClass.DebugMode) {
                System.out.println("status will be updated");
            }
            String strLabel = String.format(Mytranslator.getInstance().getTranslate("StatusTip2"), start, end, l);
            String strTime = (String)this.resultLabel.getData("time");
            if (strTime != null && !strTime.isEmpty()) {
                strLabel = strLabel + " " + strTime;
            }
            this.spin.setEnabled(true);
            this.resultLabel.setText(strLabel);
        }
        this.nextLink.setEnabled(controller.hasNextPage());
        this.previousLink.setEnabled(controller.hasPreviousPage());
    }

    protected void createUI(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout(layout);
        this.createProgressBar(parent);
        this.createLeftContainer(parent);
        this.createRightContainer(parent);
    }

    private void createProgressBar(Composite parent) {
        this.myProgress = new MyProgress(parent, 65536);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.heightHint = 2;
        this.myProgress.setLayoutData(data);
    }

    public void overrideProgressBar(int style) {
        int nstyle = this.myProgress.getStyle();
        if ((nstyle & style) != 0) {
            if (!this.myProgress.isVisible()) {
                this.myProgress.setVisible(true);
            }
        } else {
            GridData data = (GridData)this.myProgress.getLayoutData();
            MyProgress myProgress2 = new MyProgress(this.myProgress.getParent(), style);
            myProgress2.setLayoutData(data);
            myProgress2.moveAbove(this.myProgress);
            this.myProgress.dispose();
            this.myProgress = myProgress2;
            this.myProgress.getParent().layout(true);
        }
    }

    private void createLeftContainer(Composite parent) {
        Composite left = this.createComposite(parent, 0);
        GridData data = new GridData(768);
        left.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        left.setLayout(layout);
        this.resultLabel = new Label(left, 0);
        this.resultLabel.setLayoutData(new GridData(768));
        if (this.isDarkMode) {
            this.resultLabel.setForeground(Resources.getColor((RGB)DARK_MODE_TEXT_COLOR));
        }
    }

    private void createRightContainer(Composite parent) {
        Composite right = this.createComposite(parent, 0);
        right.setLayoutData(new GridData(131072, 0x1000000, false, false, 1, 1));
        GridLayout layout = new GridLayout(5, false);
        layout.marginHeight = 0;
        right.setLayout(layout);
        this.spin = new Spinner(right, 2048);
        this.spin.setMinimum(2);
        this.spin.setMaximum(200);
        this.spin.setSelection(UtilityClass.PageSize);
        this.spin.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                UtilityClass.PageSize = MyResultAndNavigationPageLinksRenderer.this.spin.getSelection();
                if (UtilityClass.DebugMode) {
                    System.out.println("Pagesize=" + UtilityClass.PageSize);
                }
                MyResultAndNavigationPageLinksRenderer.this.getController().setPageSize(UtilityClass.PageSize);
                long total = MyResultAndNavigationPageLinksRenderer.this.getController().getTotalElements();
                MyResultAndNavigationPageLinksRenderer.this.getController().setTotalElements(0L);
                MyResultAndNavigationPageLinksRenderer.this.getController().setTotalElements(total);
                MyResultAndNavigationPageLinksRenderer.this.getController().setCurrentPage(0);
            }
        });
        this.previousLink = this.createHyperlink(right, 0);
        this.setLinkText(this.previousLink, Resources.getText((String)"PaginationRenderer.previous", (Locale)this.getLocale()));
        this.previousLink.setLayoutData(new GridData(16384));
        this.previousLink.addSelectionListener(this);
        if (this.isDarkMode) {
            this.previousLink.setForeground(Resources.getColor((RGB)DARK_MODE_TEXT_COLOR));
        }
        this.pageLinks = this.createHyperlink(right, 0);
        this.pageLinks.setForeground(this.getColor());
        GridData gd_pageLink = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gd_pageLink.widthHint = UtilityClass.scaleForDpi(250);
        this.pageLinks.setLayoutData(gd_pageLink);
        this.pageLinks.addSelectionListener(this);
        this.nextLink = this.createHyperlink(right, 0);
        this.setLinkText(this.nextLink, Resources.getText((String)"PaginationRenderer.next", (Locale)this.getLocale()));
        this.nextLink.setLayoutData(new GridData(131072));
        this.nextLink.addSelectionListener(this);
        if (this.isDarkMode) {
            this.nextLink.setForeground(Resources.getColor((RGB)DARK_MODE_TEXT_COLOR));
        }
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Link hyperlink = (Link)e.getSource();
        int newCurrentPage = 0;
        if (hyperlink == this.previousLink) {
            newCurrentPage = this.getController().getCurrentPage() - 1;
        } else if (hyperlink == this.nextLink) {
            newCurrentPage = this.getController().getCurrentPage() + 1;
        } else if (hyperlink == this.pageLinks) {
            newCurrentPage = Integer.parseInt(e.text);
        }
        this.getController().setCurrentPage(newCurrentPage);
    }

    public void pageIndexChanged(int oldPageNumber, int newPageNumber, PageableController controller) {
        int[] indexes = PaginationHelper.getPageIndexes((int)controller.getCurrentPage(), (int)controller.getTotalPages(), (int)10);
        this.pageLinks.setText(this.rebuildLinks(indexes, newPageNumber));
        this.refreshEnabled(controller);
    }

    private String rebuildLinks(int[] indexes, int newPageNumber) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < indexes.length; ++i) {
            int j = indexes[i];
            if (i > 0) {
                s.append(' ');
            }
            if (j == -1) {
                s.append(Resources.getText((String)"PaginationRenderer.separator", (Locale)this.getLocale()));
                continue;
            }
            if (j == newPageNumber) {
                s.append(String.valueOf(j + 1));
                continue;
            }
            this.addA(String.valueOf(j), String.valueOf(j + 1), s);
        }
        return s.toString();
    }

    public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
        if (UtilityClass.DebugMode) {
            System.out.println("pageSizeChanged");
        }
    }

    public void totalElementsChanged(long oldTotalElements, long newTotalElements, PageableController controller) {
        int[] indexes = PaginationHelper.getPageIndexes((int)controller.getCurrentPage(), (int)controller.getTotalPages(), (int)10);
        this.pageLinks.setText(this.rebuildLinks(indexes, 0));
        this.refreshEnabled(controller);
    }

    public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController paginationController) {
    }

    protected Composite createComposite(Composite parent, int style) {
        return new Composite(parent, style);
    }

    protected Link createHyperlink(Composite parent, int style) {
        return new Link(parent, style);
    }

    protected void setLinkText(Link link, String text) {
        StringBuilder a = new StringBuilder();
        this.addA(text, text, a);
        link.setText(a.toString());
        if (UtilityClass.DebugMode) {
            System.out.println(a.toString());
        }
    }

    private void addA(String href, String content, StringBuilder a) {
        a.append(OPEN_START_HREF);
        a.append(href);
        a.append(OPEN_END_HREF);
        a.append(content);
        a.append(END_HREF);
    }

    protected Color getColor() {
        return Resources.getColor((RGB)RED_COLOR);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.setLinkText(this.previousLink, Resources.getText((String)"PaginationRenderer.previous", (Locale)this.getLocale()));
        this.setLinkText(this.nextLink, Resources.getText((String)"PaginationRenderer.next", (Locale)this.getLocale()));
        this.resultLabel.setText(PaginationHelper.getResultsText((PageableController)this.getController(), (Locale)this.getLocale()));
    }
}

