/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import ui.MainUI;
import ui.UtilityClass;

public class ResourceManager {
    private static ResourceManager instance;
    private Display display;
    private Image imgBuynow;
    private Image imgBuynowFocus;
    private Image imgRegister;
    private Image imgRegisterFocus;
    private Image logoImage;
    private Image logoImageTouched;
    private Image imgTB_History;
    private Image imgTB_A2Z;
    private Image imgTB_Z2A;
    private Image imgTB_ABCSortAsc;
    private Image imgTB_ABCSortDesc;
    private Image imgTB_ClockWise;
    private Image imgTB_AntiClockWise;
    private Image imgTB_Filter;
    private Image imgTB_Rubber;
    private Image imgFileDelete;
    private Image imgFileOpen;
    private Image imgFileMove;
    private Image imgFileCopy;
    private Image imgPDFPreview;
    private Image imgTextView;
    private Image imgAbstractView;
    private Image imgLineView;
    private Image imgFindNextKey;
    private Image imgFindPrevKey;
    private Image imgNotification1;
    private Image imgNotification1B;
    private Image imgNotification2;
    private Image imgNotification2B;

    private ResourceManager() {
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public void initResources(Display display) {
        this.display = display;
        try {
            this.imgBuynow = this.loadImage("buy.gif");
            this.imgRegister = this.loadImage("register.gif");
            this.imgBuynowFocus = this.loadImage("buyFocus.gif");
            this.imgRegisterFocus = this.loadImage("registerFocus.gif");
            this.imgTB_History = this.loadImage("History.gif");
            this.imgTB_A2Z = this.loadImage("AZ1.gif");
            this.imgTB_Z2A = this.loadImage("ZA1.gif");
            this.imgTB_ABCSortAsc = this.loadImage("ABCS1.gif");
            this.imgTB_ABCSortDesc = this.loadImage("ABCS2.gif");
            this.imgTB_ClockWise = this.loadImage("ClockWise1.gif");
            this.imgTB_AntiClockWise = this.loadImage("ClockWise2.gif");
            this.imgTB_Filter = this.loadImage("Filter.gif");
            this.imgTB_Rubber = this.loadImage("Rubber.gif");
            this.imgFileDelete = this.loadImage("deletefile.gif");
            this.imgFileCopy = this.loadImage("copyfile.gif");
            this.imgFileMove = this.loadImage("movefile.gif");
            this.imgFileOpen = this.loadImage("openfile.gif");
            this.imgPDFPreview = this.loadImage("Preview.gif");
            this.imgTextView = this.loadImage("Text.gif");
            this.imgAbstractView = this.loadImage("Abstract.gif");
            this.imgLineView = this.loadImage("Line.gif");
            this.imgFindNextKey = this.loadImage("NextKey.gif");
            this.imgFindPrevKey = this.loadImage("PrevKey.gif");
            this.imgNotification1 = this.loadImage("Notice.gif");
            this.imgNotification1B = this.loadImage("NoticeB.gif");
            this.imgNotification2 = this.loadImage("Notice2.gif");
            this.imgNotification2B = this.loadImage("Notice2B.gif");
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile("ResourceManager.initResources: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadImage(String resourceName) throws IOException {
        InputStream in = null;
        try {
            URL resourceUrl = MainUI.class.getResource(resourceName);
            if (resourceUrl == null) {
                UtilityClass.OutputLogFile("ResourceManager.loadImage: Resource not found: " + resourceName);
                throw new IOException("Resource not found: " + resourceName);
            }
            in = resourceUrl.openStream();
            Image image = new Image((Device)this.display, in);
            return image;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadLogoImages(String logoFileName, String logoTouchedFileName) {
        try {
            this.logoImage = this.loadImage(logoFileName);
            this.logoImageTouched = this.loadImage(logoTouchedFileName);
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile("ResourceManager.loadLogoImages: " + e.getMessage());
        }
    }

    public void disposeResources() {
        this.disposeImage(this.imgBuynow);
        this.disposeImage(this.imgBuynowFocus);
        this.disposeImage(this.imgRegister);
        this.disposeImage(this.imgRegisterFocus);
        this.disposeImage(this.logoImage);
        this.disposeImage(this.logoImageTouched);
        this.disposeImage(this.imgTB_History);
        this.disposeImage(this.imgTB_A2Z);
        this.disposeImage(this.imgTB_Z2A);
        this.disposeImage(this.imgTB_ABCSortAsc);
        this.disposeImage(this.imgTB_ABCSortDesc);
        this.disposeImage(this.imgTB_ClockWise);
        this.disposeImage(this.imgTB_AntiClockWise);
        this.disposeImage(this.imgTB_Filter);
        this.disposeImage(this.imgTB_Rubber);
        this.disposeImage(this.imgFileDelete);
        this.disposeImage(this.imgFileOpen);
        this.disposeImage(this.imgFileCopy);
        this.disposeImage(this.imgFileMove);
        this.disposeImage(this.imgPDFPreview);
        this.disposeImage(this.imgTextView);
        this.disposeImage(this.imgAbstractView);
        this.disposeImage(this.imgLineView);
        this.disposeImage(this.imgFindNextKey);
        this.disposeImage(this.imgFindPrevKey);
        this.disposeImage(this.imgNotification1);
        this.disposeImage(this.imgNotification2);
        this.disposeImage(this.imgNotification1B);
        this.disposeImage(this.imgNotification2B);
    }

    private void disposeImage(Image img) {
        if (img != null && !img.isDisposed()) {
            img.dispose();
        }
    }

    public Image getImgBuynow() {
        return this.imgBuynow;
    }

    public Image getImgBuynowFocus() {
        return this.imgBuynowFocus;
    }

    public Image getImgRegister() {
        return this.imgRegister;
    }

    public Image getImgRegisterFocus() {
        return this.imgRegisterFocus;
    }

    public Image getLogoImage() {
        return this.logoImage;
    }

    public Image getLogoImageTouched() {
        return this.logoImageTouched;
    }

    public Image getImgTB_History() {
        return this.imgTB_History;
    }

    public Image getImgTB_A2Z() {
        return this.imgTB_A2Z;
    }

    public Image getImgTB_Z2A() {
        return this.imgTB_Z2A;
    }

    public Image getImgTB_ABCSortAsc() {
        return this.imgTB_ABCSortAsc;
    }

    public Image getImgTB_ABCSortDesc() {
        return this.imgTB_ABCSortDesc;
    }

    public Image getImgTB_ClockWise() {
        return this.imgTB_ClockWise;
    }

    public Image getImgTB_AntiClockWise() {
        return this.imgTB_AntiClockWise;
    }

    public Image getImgTB_Filter() {
        return this.imgTB_Filter;
    }

    public Image getImgTB_Rubber() {
        return this.imgTB_Rubber;
    }

    public Image getImgFileDelete() {
        return this.imgFileDelete;
    }

    public Image getImgFileOpen() {
        return this.imgFileOpen;
    }

    public Image getImgFileMove() {
        return this.imgFileMove;
    }

    public Image getImgFileCopy() {
        return this.imgFileCopy;
    }

    public Image getImgPDFPreview() {
        return this.imgPDFPreview;
    }

    public Image getImgTextView() {
        return this.imgTextView;
    }

    public Image getImgAbstractView() {
        return this.imgAbstractView;
    }

    public Image getImgLineView() {
        return this.imgLineView;
    }

    public Image getImgFindNextKey() {
        return this.imgFindNextKey;
    }

    public Image getImgFindPrevKey() {
        return this.imgFindPrevKey;
    }

    public Image getImgNotification1() {
        return this.imgNotification1;
    }

    public Image getImgNotification1B() {
        return this.imgNotification1B;
    }

    public Image getImgNotification2() {
        return this.imgNotification2;
    }

    public Image getImgNotification2B() {
        return this.imgNotification2B;
    }
}

