/*
 * Decompiled with CFR 0.152.
 */
package ui;

import biz.HighlightWord;
import biz.ScrollDataProvider;
import biz.TextScrollDataProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import ui.UtilityClass;

public class StyledTextScroll
extends StyledText {
    static int i = 0;
    static ScrollBar vBar;
    protected TextScrollDataProvider m_dataProvider;
    static long bottonEventTime;
    static long topEventTime;

    public StyledTextScroll(Composite arg0, int arg1) {
        super(arg0, arg1);
    }

    public TextScrollDataProvider GetDataProvider() {
        return this.m_dataProvider;
    }

    @Override
    protected void checkSubclass() {
    }

    public void RollInNextPage() {
        if (this.m_dataProvider.getPaginationMode() && this.m_dataProvider.hasNextPage()) {
            int newIndex;
            int topIndex = this.getTopIndex();
            System.out.println("before : topIndex= " + topIndex + " " + this.getLine(0));
            ScrollDataProvider.Page page = this.m_dataProvider.getNextPageIndex();
            this.AppendPage(page);
            int removeline = this.getLineCount() - UtilityClass.InitViewMax;
            if (removeline > 0) {
                this.RemoveTopPage(removeline);
                this.m_dataProvider.UpdateViewIndex(false, removeline);
            }
            ScrollDataProvider.Page activeRangePage = this.m_dataProvider.getActiveRange();
            this.applyRange(activeRangePage);
            if (this.m_dataProvider.GetHighLineIndex() >= this.m_dataProvider.getCurrentDataScope().pageStartIndex && this.m_dataProvider.GetHighLineIndex() <= this.m_dataProvider.getCurrentDataScope().pageEndIndex) {
                int offset = this.m_dataProvider.GetHighLineIndex() - this.m_dataProvider.getCurrentDataScope().pageStartIndex;
                this.HighlightLine(this, offset, "", false);
            }
            if ((newIndex = topIndex - (page.pageEndIndex - page.pageStartIndex + 1)) > 0 && newIndex <= this.getLineCount() - 1) {
                this.setTopIndex(newIndex);
            }
        }
    }

    public void RemoveTopPage(int lines) {
        int range = lines;
        int offset = this.getOffsetAtLine(range);
        this.replaceTextRange(0, offset, "");
    }

    public void RollInPreviewPage() {
        System.out.println("--rolling in the previous top--");
        if (this.m_dataProvider.getPaginationMode() && this.m_dataProvider.hasPrevPage()) {
            int newIndex;
            ScrollDataProvider.Page page = this.m_dataProvider.getPrevPageIndex();
            this.InsertPageAtTop(page);
            System.out.println("Insert page: " + page.pageStartIndex + "-" + page.pageEndIndex);
            int removeline = this.getLineCount() - UtilityClass.InitViewMax;
            if (removeline > 0) {
                this.RemoveBottomPage(removeline);
                this.m_dataProvider.UpdateViewIndex(true, removeline);
            }
            ScrollDataProvider.Page activeRangePage = this.m_dataProvider.getActiveRange();
            System.out.println("ActiveRange: " + activeRangePage.pageStartIndex + "-" + activeRangePage.pageEndIndex);
            System.out.println("start =" + this.m_dataProvider.getCurrentDataScope().pageStartIndex + "end = " + this.m_dataProvider.getCurrentDataScope().pageEndIndex);
            this.applyRange(activeRangePage);
            if (this.m_dataProvider.GetHighLineIndex() >= this.m_dataProvider.getCurrentDataScope().pageStartIndex && this.m_dataProvider.GetHighLineIndex() <= this.m_dataProvider.getCurrentDataScope().pageEndIndex) {
                int offset = this.m_dataProvider.GetHighLineIndex() - this.m_dataProvider.getCurrentDataScope().pageStartIndex;
                this.HighlightLine(this, offset, "", false);
            }
            if ((newIndex = page.pageEndIndex - page.pageStartIndex + 1) > 0 && newIndex <= this.getLineCount() - 1) {
                this.setTopIndex(newIndex);
            }
        }
    }

    public void RemoveBottomPage(int lines) {
        int range = lines;
        int totalCnt = this.getLineCount();
        int rangeStart = totalCnt - range - 1;
        int offsetStart = this.getOffsetAtLine(rangeStart);
        int offsetEnd = this.getText().length();
        this.replaceTextRange(offsetStart, offsetEnd - offsetStart, "");
    }

    private void AppendPage(ScrollDataProvider.Page page) {
        List<String> alldata = this.m_dataProvider.getTotalData();
        if (page.pageStartIndex < this.m_dataProvider.getTotalNumberOfLine()) {
            StringBuffer strB = new StringBuffer();
            for (int i = page.pageStartIndex; i <= page.pageEndIndex; ++i) {
                strB.append(alldata.get(i));
                strB.append(System.getProperty("line.separator"));
            }
            this.append(strB.toString());
        }
    }

    private void InsertPageAtTop(ScrollDataProvider.Page page) {
        List<String> alldata = this.m_dataProvider.getTotalData();
        if (page.pageStartIndex >= 0) {
            StringBuffer strB = new StringBuffer();
            for (int i = page.pageStartIndex; i <= page.pageEndIndex; ++i) {
                strB.append(alldata.get(i));
                strB.append(System.getProperty("line.separator"));
            }
            this.setSelection(0);
            this.insert(strB.toString());
        }
    }

    public void HighlightLine(StyledText text, int lineIndex, String prefix, boolean setTopIndex) {
    }

    protected void populateTextControl(int startline, boolean bUnderline) {
        ScrollDataProvider.Page pageone = this.m_dataProvider.GetPage1Pos(startline < 0 ? 0 : startline);
        this.setText("");
        this.AppendPage(pageone);
        ScrollDataProvider.Page activeRangePage = this.m_dataProvider.getActiveRange();
        this.applyRange(activeRangePage);
        if (bUnderline && startline >= 0) {
            this.HighlightLine(this, 0, "", false);
        }
    }

    private void applyRange(ScrollDataProvider.Page page) {
        int rangeStart;
        if (page.pageStartIndex == -1 && page.pageEndIndex == -1) {
            return;
        }
        List<HighlightWord> allRanges = this.m_dataProvider.getAllRanges();
        ScrollDataProvider.Page scope = this.m_dataProvider.getCurrentDataScope();
        ArrayList<StyleRange> arr = new ArrayList<StyleRange>();
        System.out.println("linecount in text control =" + this.getLineCount());
        int rangeEnd = page.pageEndIndex;
        for (int i = rangeStart = page.pageStartIndex; i <= rangeEnd; ++i) {
            HighlightWord oneRange = allRanges.get(i);
            StyleRange lineRange = new StyleRange();
            int lineInView = oneRange.lineIndex - scope.pageStartIndex;
            lineRange.start = oneRange.offsetLine + this.getOffsetAtLine(lineInView);
            lineRange.length = oneRange.length;
            lineRange.rise = oneRange.rise;
            lineRange.underline = oneRange.underline;
            lineRange.underlineStyle = oneRange.underlineStyle;
            lineRange.background = oneRange.background;
            lineRange.foreground = oneRange.foreground;
            System.out.println(lineRange.toString());
            arr.add(lineRange);
        }
        StyleRange[] stylearrays = new StyleRange[arr.size()];
        arr.toArray(stylearrays);
        this.setStyleRanges(stylearrays);
    }

    static {
        bottonEventTime = 0L;
        topEventTime = 0L;
    }
}

