/*
 * Decompiled with CFR 0.152.
 */
package ui;

import biz.SearchBiz;
import biz.TextScrollDataProvider;
import biz.searchFolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import ui.MyDetailData;
import ui.MyText;
import ui.UtilityClass;

public class TextPreviewThread
extends Thread {
    private MyText _myText;
    private TextScrollDataProvider _dataProvider;
    private int _showMode;
    private boolean _isShowLineChecked;
    private int iline = -1;
    private searchFolder _sf;
    private String _queryString;
    private String _searchkey2;
    private String _filename;
    private String _fileTime;
    private boolean _bSearchContent;

    public TextPreviewThread(MyText myText, TextScrollDataProvider dataProvider, int showMode, boolean isShowLineChecked, int line, searchFolder sf, String queryString, String searchkey2, String filename, String fileTime, boolean bSearchContent) {
        this._myText = myText;
        this._dataProvider = dataProvider;
        this._showMode = showMode;
        this._isShowLineChecked = isShowLineChecked;
        this.iline = line;
        this._sf = sf;
        this._queryString = queryString;
        this._searchkey2 = searchkey2;
        this._filename = filename;
        this._fileTime = fileTime;
        this._bSearchContent = bSearchContent;
        String[] strKeyArrElement = queryString.replace("*", "").split("\\|| ");
        ArrayList<String> strList = new ArrayList<String>(Arrays.asList(strKeyArrElement));
        HashSet<String> strSet = new HashSet<String>();
        strSet.addAll(strList);
        this._dataProvider.setSearchKeyWordSet(strSet);
        UtilityClass.ChangeThreadName(UtilityClass._threadTextViewThread, UtilityClass._threadTextViewThread + UtilityClass._THREADSTOP);
    }

    @Override
    public void run() {
        try {
            this.setName(UtilityClass._threadTextViewThread);
            this._dataProvider.initThread();
            if (this._showMode == 1) {
                SearchBiz searchBiz = new SearchBiz();
                if (!searchBiz.initFileContentsSearch(0, this._sf, this._sf.getCurrentIndexName())) {
                    return;
                }
                MyDetailData[] hitLines = null;
                if (this._bSearchContent) {
                    hitLines = searchBiz.searchFileIndex(this._filename, this._fileTime, this._searchkey2);
                }
                this._dataProvider.initData(UtilityClass.ViewType.FullTextView, this._queryString, this._filename, hitLines);
                String[] strFullText = searchBiz.SearchFileFullText(this._filename, this._fileTime);
                if (strFullText != null && strFullText.length != 0) {
                    this._dataProvider.setFileContent(strFullText);
                    this._dataProvider.TextModeChanged(UtilityClass.ViewType.FullTextView);
                    this._myText._DrawFullText(this._isShowLineChecked, this.iline);
                }
            } else if (this._showMode == 2) {
                UtilityClass.OutputLogFile("thread run : showabstract : 2");
                SearchBiz searchBiz = new SearchBiz();
                if (!searchBiz.initFileContentsSearch(0, this._sf, this._sf.getCurrentIndexName())) {
                    return;
                }
                MyDetailData[] hitLines = searchBiz.searchFileIndex(this._filename, this._fileTime, this._searchkey2);
                this._dataProvider.initData(UtilityClass.ViewType.TextRangeView, this._queryString, this._filename, hitLines);
                String[] strFullText = searchBiz.SearchFileFullText(this._filename, this._fileTime);
                this._dataProvider.setFileContent(strFullText);
                this._dataProvider.TextModeChanged(UtilityClass.ViewType.TextRangeView);
                this._myText._ShowSelectedTextRange(this.iline);
            } else if (this._showMode == 3) {
                SearchBiz searchBiz = new SearchBiz();
                if (!searchBiz.initFileContentsSearch(0, this._sf, this._sf.getCurrentIndexName())) {
                    return;
                }
                MyDetailData[] hitLines = searchBiz.searchFileIndex(this._filename, this._fileTime, this._searchkey2);
                this._dataProvider.initData(UtilityClass.ViewType.LineView, this._queryString, this._filename, hitLines);
                this._dataProvider.TextModeChanged(UtilityClass.ViewType.LineView);
                this._myText._showMatchedLines(-1);
            } else if (this._showMode == 4) {
                this._dataProvider.setQueryRegString(this._queryString);
                this._myText.setShowLineNo(this._isShowLineChecked);
                this._dataProvider.TextModeChanged(UtilityClass.ViewType.FullTextView);
                this._myText._DrawFullText(this._isShowLineChecked, this.iline);
            } else if (this._showMode == 5) {
                UtilityClass.OutputLogFile("thread run : showabstract : 5");
                this._dataProvider.setQueryRegString(this._queryString);
                this._dataProvider.TextModeChanged(UtilityClass.ViewType.TextRangeView);
                this._myText._ShowSelectedTextRange(this.iline);
            } else if (this._showMode == 6) {
                this._dataProvider.setQueryRegString(this._queryString);
                this._dataProvider.TextModeChanged(UtilityClass.ViewType.LineView);
                this._myText._showMatchedLines(this.iline);
            }
            this._dataProvider.endThread();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

