/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination;

import java.util.Locale;
import org.eclipse.nebula.widgets.pagination.AbstractPageControllerComposite;
import org.eclipse.nebula.widgets.pagination.IPageContentProvider;
import org.eclipse.nebula.widgets.pagination.IPageLoader;
import org.eclipse.nebula.widgets.pagination.IPageLoaderHandler;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.PaginationHelper;
import org.eclipse.nebula.widgets.pagination.renderers.ICompositeRendererFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPaginationWidget<W extends Widget>
extends AbstractPageControllerComposite {
    private W widget;
    private ICompositeRendererFactory pageRendererTopFactory;
    private ICompositeRendererFactory pageRendererBottomFactory;
    private Composite compositeTop;
    private Composite compositeBottom;
    private IPageLoader pageLoader;
    private IPageLoaderHandler pageLoaderHandler;

    public AbstractPaginationWidget(Composite parent, int style, IPageContentProvider pageContentProvider, ICompositeRendererFactory pageRendererTopFactory, ICompositeRendererFactory pageRendererBottomFactory) {
        this(parent, style, 10, pageContentProvider, pageRendererTopFactory, pageRendererBottomFactory, true);
    }

    public AbstractPaginationWidget(Composite parent, int style, int pageSize, IPageContentProvider pageContentProvider, ICompositeRendererFactory pageRendererTopFactory, ICompositeRendererFactory pageRendererBottomFactory) {
        this(parent, style, pageSize, pageContentProvider, pageRendererTopFactory, pageRendererBottomFactory, true);
    }

    protected AbstractPaginationWidget(Composite parent, int style, int pageSize, IPageContentProvider pageContentProvider, ICompositeRendererFactory pageRendererTopFactory, ICompositeRendererFactory pageRendererBottomFactory, boolean createUI) {
        super(parent, style, null, pageSize, pageContentProvider, false);
        this.pageRendererTopFactory = pageRendererTopFactory;
        this.pageRendererBottomFactory = pageRendererBottomFactory;
        if (createUI) {
            this.createUI(this);
        }
    }

    @Override
    protected void createUI(Composite parent) {
        this.setLayout((Layout)new GridLayout());
        this.compositeTop = this.createCompositeTop(parent);
        this.widget = this.createWidget(parent);
        PaginationHelper.setController(this.widget, this.getController());
        this.compositeBottom = this.createCompositeBottom(parent);
        super.setLocale(Locale.getDefault());
    }

    protected Composite createCompositeTop(Composite parent) {
        Composite compositeTop;
        ICompositeRendererFactory pageRendererTopFactory = this.getPageRendererTopFactory();
        if (pageRendererTopFactory != null && (compositeTop = pageRendererTopFactory.createComposite(parent, 0, this.getController())) != null) {
            compositeTop.setLayoutData((Object)new GridData(768));
            return compositeTop;
        }
        return null;
    }

    protected Composite createCompositeBottom(Composite parent) {
        ICompositeRendererFactory pageRendererBottomFactory = this.getPageRendererBottomFactory();
        if (pageRendererBottomFactory != null) {
            Composite compositeBottom = pageRendererBottomFactory.createComposite(parent, 0, this.getController());
            if (compositeBottom != null) {
                compositeBottom.setLayoutData((Object)new GridData(768));
            }
            return compositeBottom;
        }
        return null;
    }

    public ICompositeRendererFactory getPageRendererTopFactory() {
        return this.pageRendererTopFactory;
    }

    public ICompositeRendererFactory getPageRendererBottomFactory() {
        return this.pageRendererBottomFactory;
    }

    public Composite getCompositeTop() {
        return this.compositeTop;
    }

    public Composite getCompositeBottom() {
        return this.compositeBottom;
    }

    @Override
    public void pageIndexChanged(int oldPageNumber, int newPageNumber, PageableController controller) {
        this.internalRefreshPage();
    }

    @Override
    public void totalElementsChanged(long oldTotalElements, long newTotalElements, PageableController controller) {
    }

    @Override
    public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController paginationController) {
        this.refreshPage(true);
    }

    @Override
    public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController paginationController) {
        this.refreshPage(false);
    }

    public void refreshPage(boolean reset) {
        if (reset) {
            this.getController().reset();
        } else {
            this.refreshPage();
        }
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.compositeTop != null && this.compositeTop instanceof AbstractPageControllerComposite) {
            ((AbstractPageControllerComposite)this.compositeTop).setLocale(locale);
        }
        if (this.compositeBottom != null && this.compositeBottom instanceof AbstractPageControllerComposite) {
            ((AbstractPageControllerComposite)this.compositeBottom).setLocale(locale);
        }
    }

    private void internalRefreshPage() {
        if (this.pageLoaderHandler == null) {
            this.refreshPage();
        } else {
            PageableController controller = this.getController();
            this.pageLoaderHandler.onBeforePageLoad(controller);
            try {
                this.refreshPage();
                this.pageLoaderHandler.onAfterPageLoad(controller, null);
            }
            catch (Throwable e) {
                this.pageLoaderHandler.onAfterPageLoad(controller, e);
            }
        }
    }

    public void setPageLoaderHandler(IPageLoaderHandler pageLoaderHandler) {
        this.pageLoaderHandler = pageLoaderHandler;
    }

    public IPageLoaderHandler getPageLoaderHandler() {
        return this.pageLoaderHandler;
    }

    public void setPageLoader(IPageLoader pageLoader) {
        this.pageLoader = pageLoader;
    }

    public IPageLoader getPageLoader() {
        return this.pageLoader;
    }

    public W getWidget() {
        return this.widget;
    }

    protected abstract W createWidget(Composite var1);

    public abstract void refreshPage();
}

