/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.renderers.navigation;

import org.eclipse.nebula.widgets.pagination.AbstractPageControllerComposite;
import org.eclipse.nebula.widgets.pagination.PageableController;
import org.eclipse.nebula.widgets.pagination.PaginationHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NavigationPageComboRenderer
extends AbstractPageControllerComposite
implements SelectionListener {
    private Combo pageCombo;

    public NavigationPageComboRenderer(Composite parent, int style, PageableController controller) {
        super(parent, style, controller);
    }

    public void pageIndexChanged(int oldPageIndex, int newPageIndex, PageableController controller) {
        this.populateCombo(controller);
    }

    public void totalElementsChanged(long oldTotalElements, long newTotalElements, PageableController controller) {
    }

    public void sortChanged(String oldPopertyName, String propertyName, int oldSortDirection, int sortDirection, PageableController paginationController) {
    }

    public void pageSizeChanged(int oldPageSize, int newPageSize, PageableController controller) {
        this.populateCombo(controller);
    }

    private void populateCombo(PageableController controller) {
        int totalPages = controller.getTotalPages();
        String[] items = new String[totalPages];
        int i = 0;
        while (i < items.length) {
            items[i] = PaginationHelper.getPageText(i + 1, totalPages, this.getLocale());
            ++i;
        }
        this.pageCombo.setItems(items);
        if (this.pageCombo.getItemCount() > 0) {
            this.pageCombo.select(controller.getCurrentPage());
        }
    }

    protected void createUI(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.pageCombo = new Combo(parent, 8);
        this.pageCombo.setLayoutData((Object)new GridData(768));
        this.pageCombo.addSelectionListener((SelectionListener)this);
    }

    public void dispose() {
        this.pageCombo.removeSelectionListener((SelectionListener)this);
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int newCurrentPage = this.pageCombo.getSelectionIndex();
        super.setCurrentPage(newCurrentPage);
    }
}

