/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.nebula.widgets.pagination.Resources;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.BlueNavigationPageGraphicsConfigurator;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.INavigationPageGraphicsConfigurator;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.NavigationPageGraphicsItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class NavigationPageGraphics
extends Canvas {
    private List<NavigationPageGraphicsItem> items;
    private NavigationPageGraphicsItem selectedItem;
    private Integer round = null;
    private Color selectedItemForeground;
    private Color selectedItemBackground;
    private Color selectedItemBorderColor;
    private Color itemForeground;
    private Color itemBackground;
    private Color itemBorderColor;
    private Color disabledItemForeground;
    private Color disabledItemBackground;
    private Color disabledItemBorderColor;
    private Integer totalWidth;
    private final NavigationPageGraphicsItem previousItem = new NavigationPageGraphicsItem(this, -2);
    private final NavigationPageGraphicsItem nextItem;

    public NavigationPageGraphics(Composite parent, int style) {
        this(parent, style, BlueNavigationPageGraphicsConfigurator.getInstance());
    }

    public NavigationPageGraphics(Composite parent, int style, INavigationPageGraphicsConfigurator configurator) {
        super(parent, style);
        this.previousItem.setText(Resources.getText("PaginationRenderer.previous", Locale.getDefault()));
        this.nextItem = new NavigationPageGraphicsItem(this, -3);
        this.nextItem.setText(Resources.getText("PaginationRenderer.next", Locale.getDefault()));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                NavigationPageGraphics.this.onPaint(e.gc);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                NavigationPageGraphicsItem selectedItem = NavigationPageGraphics.this.getItem(e.x, e.y);
                if (selectedItem != null) {
                    NavigationPageGraphics.this.select(selectedItem);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        if (configurator != null) {
            configurator.configure(this);
        }
    }

    private void onPaint(GC gc) {
        gc.setAdvanced(true);
        if (gc.getAdvanced()) {
            gc.setTextAntialias(1);
        }
        if (this.items == null) {
            return;
        }
        this.computeBoundsIfNeeded(gc);
        Color fg = this.getDisplay().getSystemColor(21);
        Color bg = this.getDisplay().getSystemColor(22);
        boolean separator = false;
        int height = 0;
        boolean selected = false;
        boolean enabled = false;
        for (NavigationPageGraphicsItem pageItem : this.items) {
            Color textColor;
            Color borderRectangleColor;
            selected = ((Object)((Object)pageItem)).equals((Object)this.selectedItem);
            enabled = pageItem.isEnabled();
            separator = pageItem.isSeparator();
            int x = pageItem.getBounds().x;
            int y = pageItem.getBounds().y;
            int width = pageItem.getBounds().width;
            height = pageItem.getBounds().height;
            Color filledRectangleColor = this.getFilledRectangleColor(selected, !separator ? enabled : true, bg);
            if (filledRectangleColor != null) {
                gc.setBackground(filledRectangleColor);
                if (this.round != null) {
                    gc.fillRoundRectangle(x, y, width, height, this.round.intValue(), this.round.intValue());
                } else {
                    gc.fillRectangle(x, y, width, height);
                }
            }
            if (!separator && (borderRectangleColor = this.getBorderRectangleColor(selected, enabled, bg)) != null) {
                gc.setForeground(borderRectangleColor);
                if (this.round != null) {
                    gc.drawRoundRectangle(x, y, width, height, this.round.intValue(), this.round.intValue());
                } else {
                    gc.drawRectangle(x, y, width, height);
                }
            }
            if ((textColor = this.getTextColor(selected, enabled)) != null) {
                gc.setForeground(textColor);
            } else {
                gc.setForeground(fg);
            }
            gc.drawString(pageItem.getText(), x + 3, y, true);
        }
    }

    private Color getFilledRectangleColor(boolean selected, boolean enabled, Color bg) {
        if (selected) {
            return this.selectedItemBackground;
        }
        if (!enabled) {
            return this.disabledItemBackground;
        }
        return this.itemBackground;
    }

    private Color getBorderRectangleColor(boolean selected, boolean enabled, Color bg) {
        if (selected) {
            return this.selectedItemBorderColor;
        }
        if (!enabled) {
            return this.disabledItemBorderColor;
        }
        return this.itemBorderColor;
    }

    private Color getTextColor(boolean selected, boolean enabled) {
        if (selected) {
            return this.selectedItemForeground;
        }
        if (!enabled) {
            return this.disabledItemForeground;
        }
        return this.itemForeground;
    }

    public void update(int[] pageIndexes, int currentPage) {
        this.update(pageIndexes, currentPage, Locale.getDefault());
    }

    public void update(int[] pageIndexes, int currentPage, Locale locale) {
        this.items = new ArrayList<NavigationPageGraphicsItem>(pageIndexes.length + 2);
        int index = -1;
        this.items.add(this.previousItem);
        NavigationPageGraphicsItem item = null;
        int i = 0;
        while (i < pageIndexes.length) {
            index = pageIndexes[i];
            item = new NavigationPageGraphicsItem(this, index);
            if (index == -1) {
                item.setText(Resources.getText("PaginationRenderer.separator", locale));
            }
            this.items.add(item);
            if (currentPage == index) {
                this.selectedItem = item;
            }
            ++i;
        }
        this.items.add(this.nextItem);
        this.totalWidth = null;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint == -1 || hHint == -1) {
            this.computeBoundsIfNeeded(null);
            if (this.totalWidth != null) {
                return new Point(this.totalWidth.intValue(), 15);
            }
            return new Point(wHint, 15);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    private void computeBoundsIfNeeded(GC gc) {
        if (this.items == null || this.totalWidth != null) {
            return;
        }
        GC tempGC = null;
        if (gc == null) {
            gc = tempGC = new GC((Drawable)this);
        }
        this.totalWidth = 0;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        String text = null;
        for (NavigationPageGraphicsItem pageItem : this.items) {
            text = pageItem.getText();
            Point size = gc.stringExtent(text);
            width = size.x + 4;
            height = size.y;
            pageItem.setBounds(new Rectangle(x, y, width, height));
            x += width + 3;
        }
        this.totalWidth = x + width - 3;
        if (tempGC != null) {
            tempGC.dispose();
        }
    }

    private NavigationPageGraphicsItem getItem(int x, int y) {
        this.checkWidget();
        if (this.items == null) {
            return null;
        }
        for (NavigationPageGraphicsItem pageItem : this.items) {
            if (!pageItem.contains(x, y)) continue;
            if (!pageItem.isEnabled()) {
                return null;
            }
            return pageItem;
        }
        return null;
    }

    public void select(NavigationPageGraphicsItem pageItem) {
        if (!pageItem.isSeparator()) {
            this.selectedItem = pageItem;
            this.redraw();
            this.getDisplay().update();
        }
        this.handleSelection(pageItem);
    }

    protected void handleSelection(NavigationPageGraphicsItem selectedItem) {
    }

    public void setSelectedItemBackground(Color selectedItemBackground) {
        this.selectedItemBackground = selectedItemBackground;
    }

    public Color getSelectedItemBackground() {
        return this.selectedItemBackground;
    }

    public void setSelectedItemForeground(Color selectedItemForeground) {
        this.selectedItemForeground = selectedItemForeground;
    }

    public Color getSelectedItemForeground() {
        return this.selectedItemForeground;
    }

    public Color getItemForeground() {
        return this.itemForeground;
    }

    public void setItemForeground(Color itemForeground) {
        this.itemForeground = itemForeground;
    }

    public Color getItemBackground() {
        return this.itemBackground;
    }

    public void setItemBackground(Color itemBackground) {
        this.itemBackground = itemBackground;
    }

    public Color getItemBorderColor() {
        return this.itemBorderColor;
    }

    public void setItemBorderColor(Color itemBorderColor) {
        this.itemBorderColor = itemBorderColor;
    }

    public Color getSelectedItemBorderColor() {
        return this.selectedItemBorderColor;
    }

    public void setSelectedItemBorderColor(Color selectedItemBorderColor) {
        this.selectedItemBorderColor = selectedItemBorderColor;
    }

    public Color getDisabledItemForeground() {
        return this.disabledItemForeground;
    }

    public void setDisabledItemForeground(Color disabledItemForeground) {
        this.disabledItemForeground = disabledItemForeground;
    }

    public Color getDisabledItemBorderColor() {
        return this.disabledItemBorderColor;
    }

    public void setDisabledItemBorderColor(Color disabledItemBorderColor) {
        this.disabledItemBorderColor = disabledItemBorderColor;
    }

    public void setDisabledItemBackground(Color disabledItemBackground) {
        this.disabledItemBackground = disabledItemBackground;
    }

    public Color getDisabledItemBackground() {
        return this.disabledItemBackground;
    }

    public void setConfigurator(INavigationPageGraphicsConfigurator configurator) {
        this.round = null;
        configurator.configure(this);
        this.redraw();
    }

    public void setRound(int round) {
        this.round = round;
    }

    public void setText(String previousText, String nextText) {
        this.previousItem.setText(previousText);
        this.nextItem.setText(nextText);
        this.totalWidth = null;
        this.redraw();
    }

    public void setEnabled(boolean hasPreviousPage, boolean hasNextPage) {
        this.previousItem.setEnabled(hasPreviousPage);
        this.nextItem.setEnabled(hasNextPage);
        this.redraw();
    }
}

