/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.HSSFHtmlHelper;
import biz.HtmlHelper;
import biz.XSSFHtmlHelper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ui.UtilityClass;

public class ExcelPreview {
    private Workbook wb;
    private Appendable output;
    private boolean completeHTML;
    private Formatter out;
    private boolean gotBounds;
    private int firstColumn;
    private int endColumn;
    private HtmlHelper helper;
    private static final String DEFAULTS_CLASS = "excelDefaults";
    private static final String COL_HEAD_CLASS = "colHeader";
    private static final String ROW_HEAD_CLASS = "rowHeader";
    private int iCur = 1;
    private int sheetCnt = 0;
    private static final Map<HorizontalAlignment, String> HALIGN = ExcelPreview.mapFor(HorizontalAlignment.LEFT, "left", HorizontalAlignment.CENTER, "center", HorizontalAlignment.RIGHT, "right", HorizontalAlignment.FILL, "left", HorizontalAlignment.JUSTIFY, "left", HorizontalAlignment.CENTER_SELECTION, "center");
    private static final Map<VerticalAlignment, String> VALIGN = ExcelPreview.mapFor(VerticalAlignment.BOTTOM, "bottom", VerticalAlignment.CENTER, "middle", VerticalAlignment.TOP, "top");
    private static final Map<BorderStyle, String> BORDER = ExcelPreview.mapFor(BorderStyle.DASH_DOT, "dashed 1pt", BorderStyle.DASH_DOT_DOT, "dashed 1pt", BorderStyle.DASHED, "dashed 1pt", BorderStyle.DOTTED, "dotted 1pt", BorderStyle.DOUBLE, "double 3pt", BorderStyle.HAIR, "solid 1px", BorderStyle.MEDIUM, "solid 2pt", BorderStyle.MEDIUM_DASH_DOT, "dashed 2pt", BorderStyle.MEDIUM_DASHED, "dashed 2pt", BorderStyle.NONE, "none", BorderStyle.SLANTED_DASH_DOT, "dashed 2pt", BorderStyle.THICK, "solid 3pt", BorderStyle.THIN, "dashed 1pt");

    public boolean hasNext() {
        return this.iCur < this.sheetCnt;
    }

    public boolean hasPrevious() {
        return this.iCur > 1;
    }

    public int getSheetNumber() {
        return this.sheetCnt;
    }

    public int getCurSheetNo() {
        return this.iCur;
    }

    public String previewFile(String filename) throws Exception {
        String prefix = UtilityClass.GetUniqTempFile(filename);
        this.iCur = 1;
        String htmlFile = prefix + this.iCur + ".html";
        this.create(filename, htmlFile);
        this.sheetCnt = this.wb.getNumberOfSheets();
        this.setCompleteHTML(true);
        this.printPage();
        this.wb.close();
        return htmlFile;
    }

    public String Next(String filename) throws Exception {
        ++this.iCur;
        if (this.iCur <= this.sheetCnt) {
            String prefix = UtilityClass.GetUniqTempFile(filename);
            String htmlFile = prefix + this.iCur + ".html";
            this.create(filename, htmlFile);
            this.setCompleteHTML(true);
            this.printPage();
            this.wb.close();
            return htmlFile;
        }
        return "";
    }

    public String Previous(String filename) throws Exception {
        --this.iCur;
        if (this.iCur >= 1) {
            String prefix = UtilityClass.GetUniqTempFile(filename);
            String htmlFile = prefix + this.iCur + ".html";
            this.create(filename, htmlFile);
            this.setCompleteHTML(true);
            this.printPage();
            this.wb.close();
            return htmlFile;
        }
        return "";
    }

    private static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public void create(String path, String strFilename) throws IOException {
        try {
            Workbook wb;
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(strFilename), Charset.forName("UTF-8").newEncoder());
            FileInputStream in = new FileInputStream(path);
            this.wb = wb = WorkbookFactory.create((InputStream)in);
            this.output = output;
            this.setupColorMap();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create workbook from stream", e);
        }
    }

    private void setupColorMap() {
        if (this.wb instanceof HSSFWorkbook) {
            this.helper = new HSSFHtmlHelper((HSSFWorkbook)this.wb);
        } else if (this.wb instanceof XSSFWorkbook) {
            this.helper = new XSSFHtmlHelper();
        } else {
            throw new IllegalArgumentException("unknown workbook type: " + this.wb.getClass().getSimpleName());
        }
    }

    public void setCompleteHTML(boolean completeHTML) {
        this.completeHTML = completeHTML;
    }

    public void printPage() throws IOException {
        try {
            this.ensureOut();
            if (this.completeHTML) {
                this.out.format("<META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">%n", new Object[0]);
                this.out.format("<html>%n", new Object[0]);
                this.out.format("<head>%n", new Object[0]);
                this.out.format("</head>%n", new Object[0]);
                this.out.format("<body>%n", new Object[0]);
            }
            this.print();
            if (this.completeHTML) {
                this.out.format("</body>%n", new Object[0]);
                this.out.format("</html>%n", new Object[0]);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.out);
            if (this.output instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)this.output)));
            }
        }
    }

    public void print() {
        this.printInlineStyle();
        this.printSheets();
    }

    private void printInlineStyle() {
        this.out.format("<style type=\"text/css\">%n", new Object[0]);
        this.printStyles();
        this.out.format("</style>%n", new Object[0]);
    }

    private void ensureOut() {
        this.out = new Formatter(this.output);
    }

    public void printStyles() {
        this.ensureOut();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("excelStyle.css")));
            while ((line = in.readLine()) != null) {
                this.out.format("%s%n", line);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Reading standard css", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        HashSet<CellStyle> seen = new HashSet<CellStyle>();
        for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
            Sheet sheet = this.wb.getSheetAt(i);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                for (Cell cell : row) {
                    CellStyle style = cell.getCellStyle();
                    if (seen.contains(style)) continue;
                    this.printStyle(style);
                    seen.add(style);
                }
            }
        }
    }

    private void printStyle(CellStyle style) {
        this.out.format(".%s .%s {%n", DEFAULTS_CLASS, this.styleName(style));
        this.styleContents(style);
        this.out.format("}%n", new Object[0]);
    }

    private void styleContents(CellStyle style) {
        VerticalAlignment align1;
        String strVer;
        HorizontalAlignment align = style.getAlignment();
        String strHor = HorizontalAlignment.LEFT == align ? HALIGN.get(HorizontalAlignment.LEFT) : (HorizontalAlignment.CENTER == align ? HALIGN.get(HorizontalAlignment.CENTER) : (HorizontalAlignment.CENTER_SELECTION == align ? HALIGN.get(HorizontalAlignment.CENTER_SELECTION) : (HorizontalAlignment.RIGHT == align ? HALIGN.get(HorizontalAlignment.RIGHT) : HALIGN.get(HorizontalAlignment.LEFT))));
        if (strHor != null && !strHor.isEmpty()) {
            this.out.format("  %s: %s;%n", "text-align", strHor);
        }
        if ((strVer = VerticalAlignment.TOP == (align1 = style.getVerticalAlignment()) ? VALIGN.get(VerticalAlignment.TOP) : (VerticalAlignment.CENTER == align1 ? VALIGN.get(VerticalAlignment.CENTER) : (VerticalAlignment.BOTTOM == align1 ? VALIGN.get(VerticalAlignment.BOTTOM) : VALIGN.get(VerticalAlignment.CENTER)))) != null && !strVer.isEmpty()) {
            this.out.format("  %s: %s;%n", "vertical-align", strVer);
        }
        this.fontStyle(style);
        this.borderStyles(style);
        this.helper.colorStyles(style, this.out);
    }

    private void borderStyles(CellStyle style) {
        this.InnerBorderStyle("border-left", style.getBorderLeft(), BORDER);
        this.InnerBorderStyle("border-right", style.getBorderRight(), BORDER);
        this.InnerBorderStyle("border-top", style.getBorderTop(), BORDER);
        this.InnerBorderStyle("border-bottom", style.getBorderBottom(), BORDER);
    }

    private void InnerBorderStyle(String attr, BorderStyle type, Map<BorderStyle, String> mapping) {
        String borderValue = BorderStyle.NONE == type ? mapping.get(BorderStyle.NONE) : (BorderStyle.THIN == type ? mapping.get(BorderStyle.THIN) : (BorderStyle.MEDIUM == type ? mapping.get(BorderStyle.MEDIUM) : (BorderStyle.DASHED == type ? mapping.get(BorderStyle.DASHED) : (BorderStyle.HAIR == type ? mapping.get(BorderStyle.HAIR) : (BorderStyle.THICK == type ? mapping.get(BorderStyle.THICK) : (BorderStyle.DOUBLE == type ? mapping.get(BorderStyle.DOUBLE) : (BorderStyle.DOTTED == type ? mapping.get(BorderStyle.DOTTED) : (BorderStyle.MEDIUM_DASHED == type ? mapping.get(BorderStyle.MEDIUM_DASHED) : (BorderStyle.DASH_DOT == type ? mapping.get(BorderStyle.DASH_DOT) : (BorderStyle.DASH_DOT_DOT == type ? mapping.get(BorderStyle.DASH_DOT_DOT) : (BorderStyle.MEDIUM_DASH_DOT == type ? mapping.get(BorderStyle.MEDIUM_DASH_DOT) : (BorderStyle.SLANTED_DASH_DOT == type ? mapping.get(BorderStyle.SLANTED_DASH_DOT) : mapping.get(BorderStyle.NONE)))))))))))));
        if (borderValue != null && !borderValue.isEmpty()) {
            this.out.format("  %s: %s;%n", attr, borderValue);
        }
    }

    private void fontStyle(CellStyle style) {
        int fontheight;
        Font font = this.wb.getFontAt(style.getFontIndex());
        if (font.getBold()) {
            this.out.format("  font-weight: bold;%n", new Object[0]);
        }
        if (font.getItalic()) {
            this.out.format("  font-style: italic;%n", new Object[0]);
        }
        if ((fontheight = font.getFontHeightInPoints()) == 9) {
            fontheight = 10;
        }
        this.out.format("  font-size: %dpt;%n", fontheight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String styleName(CellStyle style) {
        if (style == null) {
            style = this.wb.getCellStyleAt(0);
        }
        StringBuilder sb = new StringBuilder();
        try (Formatter fmt = new Formatter(sb);){
            fmt.format("style_%02x", style.getIndex());
            String string = fmt.toString();
            return string;
        }
    }

    private <K> void styleOut(String attr, K key, Map<K, String> mapping) {
        String value = mapping.get(key);
        if (value != null) {
            this.out.format("  %s: %s;%n", attr, value);
        }
    }

    private void printSheets() {
        this.ensureOut();
        Sheet sheet = this.wb.getSheetAt(this.iCur - 1);
        this.printSheet(sheet);
    }

    public void printSheet(Sheet sheet) {
        this.ensureOut();
        this.out.format("<table class=%s>%n", DEFAULTS_CLASS);
        this.printCols(sheet);
        this.printSheetContent(sheet);
        this.out.format("</table>%n", new Object[0]);
    }

    private void printCols(Sheet sheet) {
        this.out.format("<col/>%n", new Object[0]);
        this.ensureColumnBounds(sheet);
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            this.out.format("<col/>%n", new Object[0]);
        }
    }

    private void ensureColumnBounds(Sheet sheet) {
        if (this.gotBounds) {
            return;
        }
        Iterator iter = sheet.rowIterator();
        this.firstColumn = iter.hasNext() ? Integer.MAX_VALUE : 0;
        this.endColumn = 0;
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            short firstCell = row.getFirstCellNum();
            if (firstCell < 0) continue;
            this.firstColumn = Math.min(this.firstColumn, firstCell);
            this.endColumn = Math.max(this.endColumn, row.getLastCellNum());
        }
        this.gotBounds = true;
    }

    private void printColumnHeads() {
        this.out.format("<thead>%n", new Object[0]);
        this.out.format("  <tr class=%s>%n", COL_HEAD_CLASS);
        this.out.format("    <th class=%s>&#x25CA;</th>%n", COL_HEAD_CLASS);
        StringBuilder colName = new StringBuilder();
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            colName.setLength(0);
            int cnum = i;
            do {
                colName.insert(0, (char)(65 + cnum % 26));
            } while ((cnum /= 26) > 0);
            this.out.format("    <th class=%s>%s</th>%n", COL_HEAD_CLASS, colName);
        }
        this.out.format("  </tr>%n", new Object[0]);
        this.out.format("</thead>%n", new Object[0]);
    }

    private void printSheetContent(Sheet sheet) {
        this.printColumnHeads();
        this.out.format("<tbody>%n", new Object[0]);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            this.out.format("  <tr>%n", new Object[0]);
            this.out.format("    <td class=%s>%d</td>%n", ROW_HEAD_CLASS, row.getRowNum() + 1);
            for (int i = this.firstColumn; i < this.endColumn; ++i) {
                Cell cell;
                String content = "&nbsp;";
                String attrs = "";
                CellStyle style = null;
                if (i >= row.getFirstCellNum() && i < row.getLastCellNum() && (cell = row.getCell(i)) != null) {
                    style = cell.getCellStyle();
                    attrs = this.tagStyle(cell, style);
                    System.out.println("style.getDataFormatString()= " + style.getDataFormatString());
                    if (style.getDataFormatString() == null) continue;
                    CellFormat cf = CellFormat.getInstance((String)style.getDataFormatString());
                    CellFormatResult result = cf.apply(cell);
                    content = result.text;
                    if (content.equals("")) {
                        content = "&nbsp;";
                    }
                }
                this.out.format("    <td class=%s %s>%s</td>%n", this.styleName(style), attrs, content);
            }
            this.out.format("  </tr>%n", new Object[0]);
        }
        this.out.format("</tbody>%n", new Object[0]);
    }

    private String tagStyle(Cell cell, CellStyle style) {
        if (style.getAlignment() == HorizontalAlignment.GENERAL) {
            switch (cell.getCellType()) {
                case STRING: {
                    return "style=\"text-align: left;\"";
                }
                case BOOLEAN: 
                case ERROR: {
                    return "style=\"text-align: center;\"";
                }
            }
        }
        return "";
    }
}

