/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.HighlightWord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyleRange;
import ui.UtilityClass;

public class ScrollDataProvider {
    protected List<String> allData = new ArrayList<String>();
    protected List<HighlightWord> allKeywords = new ArrayList<HighlightWord>();
    private int curViewStartIndex = -1;
    private int curViewEndIndex = -1;
    private boolean iPaginationMode = false;

    private int countLines(StringBuffer strBuffer) {
        String checkWord = System.getProperty("line.separator");
        Matcher m = Pattern.compile(checkWord).matcher(strBuffer);
        int lines = 0;
        while (m.find()) {
            ++lines;
        }
        return lines;
    }

    public boolean InitScrollPara(List<HighlightWord> allWords, StringBuffer strBuff) {
        int lines = this.countLines(strBuff);
        this.allKeywords = allWords;
        if (lines > UtilityClass.InitViewMax) {
            String[] tempArrary = strBuff.toString().split(System.getProperty("line.separator"));
            this.allData = Arrays.asList(tempArrary);
            this.iPaginationMode = true;
            return true;
        }
        this.iPaginationMode = false;
        return false;
    }

    public boolean isPaginationMode() {
        return this.iPaginationMode;
    }

    public ScrollDataProvider() {
    }

    public ScrollDataProvider(List<String> all) {
        this.setDataSource(all);
    }

    public ScrollDataProvider(List<String> all, List<HighlightWord> allRanges) {
        this.setDataSource(all, allRanges);
    }

    public void setDataSource(List<String> all) {
        this.allData = all;
        this.curViewStartIndex = -1;
        this.curViewEndIndex = -1;
    }

    public void setDataSource(List<String> all, List<HighlightWord> allRanges) {
        this.setDataSource(all);
        this.allKeywords = allRanges;
    }

    public List<String> getTotalData() {
        return this.allData;
    }

    public List<HighlightWord> getAllRanges() {
        return this.allKeywords;
    }

    public StyleRange[] GetAllStyleRange() {
        if (this.allKeywords.size() == 0) {
            return null;
        }
        StyleRange[] SR = new StyleRange[this.allKeywords.size()];
        int i = 0;
        for (HighlightWord wd : this.allKeywords) {
            SR[i] = new StyleRange();
            SR[i].background = wd.background;
            SR[i].start = wd.start;
            SR[i].length = wd.length;
            SR[i].foreground = wd.foreground;
            SR[i].rise = wd.rise;
            SR[i].fontStyle = wd.fontStyle;
            SR[i].underline = wd.underline;
            SR[i].underlineStyle = wd.underlineStyle;
            ++i;
        }
        return SR;
    }

    public int getTotalNumberOfLine() {
        return this.allData.size();
    }

    public void setCurrentDataScope(int viewStart, int viewEnd) {
        this.curViewStartIndex = viewStart;
        this.curViewEndIndex = viewEnd;
    }

    public Page getCurrentDataScope() {
        Page allScope = new Page();
        allScope.setPage(this.curViewStartIndex, this.curViewEndIndex);
        return allScope;
    }

    public Page getActiveRange() {
        int i;
        Page activeRange = new Page();
        int startIndex = -1;
        int endIndex = -1;
        boolean bFound = false;
        for (i = 0; i < this.allKeywords.size(); ++i) {
            if (this.allKeywords.get((int)i).lineIndex < this.curViewStartIndex) continue;
            if (this.allKeywords.get((int)i).lineIndex <= this.curViewEndIndex) {
                startIndex = i;
                bFound = true;
                break;
            }
            bFound = false;
            break;
        }
        if (bFound) {
            for (i = startIndex; i < this.allKeywords.size(); ++i) {
                if (this.allKeywords.get((int)i).lineIndex <= this.curViewEndIndex) continue;
                endIndex = i - 1;
                break;
            }
            if (endIndex == -1) {
                endIndex = this.allKeywords.size() - 1;
            }
        }
        activeRange.setPage(startIndex, endIndex);
        return activeRange;
    }

    public Page getSpecifiedlinePage(int lineIndex) {
        Page newAllData = new Page();
        this.curViewStartIndex = lineIndex - UtilityClass.InitViewMax / 2;
        this.curViewEndIndex = lineIndex + UtilityClass.InitViewMax / 2;
        this.setCurrentDataScope(this.validatelineIndex(this.curViewStartIndex), this.validatelineIndex(this.curViewEndIndex));
        newAllData.setPage(this.curViewStartIndex, this.curViewEndIndex);
        return newAllData;
    }

    public Page GetPage1Pos(int startline) {
        Page PageOne = new Page();
        if (this.getTotalNumberOfLine() > UtilityClass.InitViewMax) {
            int iEnd = UtilityClass.InitViewMax - 1 + startline;
            if (UtilityClass.InitViewMax + startline > this.getTotalNumberOfLine()) {
                iEnd = this.getTotalNumberOfLine() - 1;
            }
            this.setCurrentDataScope(startline, iEnd);
        } else {
            this.setCurrentDataScope(0, this.getTotalNumberOfLine() - 1);
        }
        PageOne.setPage(this.curViewStartIndex, this.curViewEndIndex);
        return PageOne;
    }

    private int validatelineIndex(int lineIndex) {
        int lineIndexWithinScope = lineIndex;
        if (lineIndex >= this.allData.size()) {
            lineIndexWithinScope = this.allData.size() - 1;
        } else if (lineIndex < 0) {
            lineIndexWithinScope = 0;
        }
        return lineIndexWithinScope;
    }

    public boolean hasNextPage() {
        return this.curViewEndIndex < this.allData.size() - 1;
    }

    public boolean hasPrevPage() {
        return this.curViewStartIndex > 0;
    }

    public Page getNextPageIndex() {
        Page nextPage = new Page();
        if (this.hasNextPage()) {
            nextPage.pageStartIndex = this.curViewEndIndex + 1;
            nextPage.pageEndIndex = nextPage.pageStartIndex + UtilityClass.pagelines;
            this.curViewEndIndex = nextPage.pageEndIndex = this.validatelineIndex(nextPage.pageEndIndex);
        } else {
            nextPage.setPage(this.allData.size(), this.allData.size());
        }
        return nextPage;
    }

    public void UpdateViewIndex(boolean deleteBottom, int range) {
        if (deleteBottom) {
            this.curViewEndIndex -= range;
        } else {
            this.curViewStartIndex += range;
        }
    }

    public Page getPrevPageIndex() {
        Page prevPage = new Page();
        if (this.hasPrevPage()) {
            prevPage.pageEndIndex = this.curViewStartIndex - 1;
            prevPage.pageStartIndex = prevPage.pageEndIndex - UtilityClass.pagelines;
            this.curViewStartIndex = prevPage.pageStartIndex = this.validatelineIndex(prevPage.pageStartIndex);
        } else {
            prevPage.setPage(-1, -1);
        }
        return prevPage;
    }

    public class Page {
        public int pageStartIndex;
        public int pageEndIndex;

        public void setPage(int start, int end) {
            this.pageStartIndex = start;
            this.pageEndIndex = end;
        }

        public int pageRange() {
            return this.pageEndIndex - this.pageStartIndex + 1;
        }
    }
}

