/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Interface.Mytranslator;
import biz.configclass;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import ui.FileFilterWindow;
import ui.MainUI;
import ui.SearchText;
import ui.UtilityClass;

public class CompositeSearchText {
    Boolean bOriginalImage = true;
    Image buttonImage1 = null;
    Image buttonImage2 = null;
    Image buttonImage3 = null;
    Label lblFileFilter;
    SearchText text;
    Label lblClear;
    Label lblSearch;
    MainUI mainUI;
    Composite baseComposite;
    Color lblFileFilterclr;
    Color lblFileFilterBKclr;
    Color borderColor = null;
    Color bgColor = null;

    public SearchText GetTextControl() {
        return this.text;
    }

    public Label GetlblSearch() {
        return this.lblSearch;
    }

    public Label GetlblFileFilter() {
        return this.lblFileFilter;
    }

    public Label GetLabelSearchClear() {
        return this.lblClear;
    }

    public Composite getBaseComposite() {
        return this.baseComposite;
    }

    public void UpdateFileFitlerLabel(int cnt) {
        try {
            if (cnt == 0) {
                this.lblFileFilter.setForeground(this.lblFileFilterclr);
                this.lblFileFilter.setBackground(this.lblFileFilterBKclr);
                this.lblFileFilter.setImage(this.buttonImage3);
                this.lblFileFilter.setToolTipText(Mytranslator.getInstance().getTranslate("FilterTipNoFile"));
                this.lblFileFilter.setEnabled(false);
            } else {
                this.lblFileFilter.setEnabled(true);
                this.lblFileFilter.setImage(null);
                this.lblFileFilter.setText("");
                Display display = this.baseComposite.getShell().getDisplay();
                this.lblFileFilter.setBackground(display.getSystemColor(6));
                this.lblFileFilter.setForeground(display.getSystemColor(1));
                this.lblFileFilter.setAlignment(0x1000000);
                this.lblFileFilter.setText(Integer.toString(cnt));
                this.lblFileFilter.setToolTipText(String.format(Mytranslator.getInstance().getTranslate("FilterTip"), cnt));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateThemeColors() {
        if (this.baseComposite == null || this.baseComposite.isDisposed()) {
            return;
        }
        try {
            int iColorTheme = configclass.getInstance("config.xml").getColorTheme();
            Display display = this.baseComposite.getDisplay();
            if (this.borderColor != null && !this.borderColor.isDisposed()) {
                this.borderColor.dispose();
            }
            if (this.bgColor != null && !this.bgColor.isDisposed()) {
                this.bgColor.dispose();
            }
            if (iColorTheme == 1) {
                this.borderColor = new Color((Device)display, new RGB(87, 87, 87));
                this.bgColor = new Color((Device)display, new RGB(37, 37, 38));
            } else {
                this.borderColor = new Color((Device)display, new RGB(204, 204, 204));
                this.bgColor = new Color((Device)display, new RGB(255, 255, 255));
            }
            this.baseComposite.setBackground(this.bgColor);
            if (this.text != null && !this.text.isDisposed()) {
                if (iColorTheme == 1) {
                    this.text.setBackground(new Color((Device)display, new RGB(37, 37, 38)));
                } else {
                    this.text.setBackground(new Color((Device)display, new RGB(255, 255, 255)));
                }
            }
            this.baseComposite.redraw();
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile("CompositeSearchText.updateThemeColors error: " + e.getMessage());
        }
    }

    public CompositeSearchText(MainUI mainU, Composite parent, GridData gd, Display display) {
        this.mainUI = mainU;
        this.baseComposite = new Composite(parent, 0);
        this.baseComposite.setLayoutData(gd);
        GridLayout baseCompositeGridLayout = new GridLayout(4, false);
        baseCompositeGridLayout.marginHeight = 2;
        baseCompositeGridLayout.marginWidth = 2;
        this.baseComposite.setLayout(baseCompositeGridLayout);
        int iColorTheme = configclass.getInstance("config.xml").getColorTheme();
        this.borderColor = iColorTheme == 1 ? new Color((Device)parent.getDisplay(), new RGB(87, 87, 87)) : new Color((Device)parent.getDisplay(), new RGB(204, 204, 204));
        this.bgColor = iColorTheme == 1 ? new Color((Device)parent.getDisplay(), new RGB(37, 37, 38)) : new Color((Device)parent.getDisplay(), new RGB(255, 255, 255));
        this.baseComposite.setBackground(this.bgColor);
        this.baseComposite.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                if (CompositeSearchText.this.baseComposite.isDisposed() || CompositeSearchText.this.borderColor == null || CompositeSearchText.this.borderColor.isDisposed()) {
                    return;
                }
                Rectangle bounds = CompositeSearchText.this.baseComposite.getBounds();
                e.gc.setForeground(CompositeSearchText.this.borderColor);
                e.gc.setLineWidth(1);
                e.gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            }
        });
        this.baseComposite.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                if (CompositeSearchText.this.borderColor != null && !CompositeSearchText.this.borderColor.isDisposed()) {
                    CompositeSearchText.this.borderColor.dispose();
                }
                if (CompositeSearchText.this.bgColor != null && !CompositeSearchText.this.bgColor.isDisposed()) {
                    CompositeSearchText.this.bgColor.dispose();
                }
            }
        });
        this.baseComposite.setBackground(new Color((Device)parent.getDisplay(), new RGB(255, 255, 255)));
        this.baseComposite.setBackgroundMode(2);
        final Cursor cursor = new Cursor(Display.getCurrent(), 21);
        try {
            InputStream in = this.getClass().getResource("searchmag.gif").openStream();
            this.buttonImage1 = new Image((Device)parent.getDisplay(), in);
            in.close();
            in = this.getClass().getResource("SearchDelete.gif").openStream();
            this.buttonImage2 = new Image((Device)parent.getDisplay(), in);
            in.close();
            in = this.getClass().getResource("SearchFilter.gif").openStream();
            this.buttonImage3 = new Image((Device)parent.getDisplay(), in);
            in.close();
        }
        catch (MalformedURLException e) {
            this.buttonImage1 = null;
            this.buttonImage2 = null;
            this.buttonImage3 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblFileFilter = new Label(this.baseComposite, 0);
        this.lblFileFilter.setLayoutData(new GridData(4, 4, false, true));
        if (this.buttonImage3 != null) {
            this.lblFileFilter.setImage(this.buttonImage3);
        }
        this.text = new SearchText(this, this.baseComposite, 4);
        this.text.init(display, this.baseComposite.getShell());
        this.text.setLayoutData(new GridData(4, 4, true, true));
        if (iColorTheme == 1) {
            this.text.setBackground(new Color((Device)parent.getDisplay(), new RGB(37, 37, 38)));
        } else {
            this.text.setBackground(new Color((Device)parent.getDisplay(), new RGB(255, 255, 255)));
        }
        this.lblClear = new Label(this.baseComposite, 0);
        this.lblClear.setLayoutData(new GridData(4, 4, false, true));
        if (this.buttonImage2 != null) {
            this.lblClear.setImage(this.buttonImage2);
        }
        this.lblSearch = new Label(this.baseComposite, 0);
        this.lblSearch.setLayoutData(new GridData(4, 4, false, true));
        if (this.buttonImage1 != null) {
            this.lblSearch.setImage(this.buttonImage1);
        }
        this.lblSearch.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                CompositeSearchText.this.text.Search();
            }
        });
        this.lblClear.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                CompositeSearchText.this.mainUI.clearSearchResult();
            }
        });
        this.lblFileFilter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                FileFilterWindow w = new FileFilterWindow();
                w.open(CompositeSearchText.this.mainUI);
            }
        });
        this.lblFileFilterBKclr = this.lblFileFilter.getBackground();
        this.lblFileFilterclr = this.lblFileFilter.getForeground();
        this.lblSearch.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent e) {
                CompositeSearchText.this.lblSearch.setCursor(cursor);
            }
        });
        this.lblClear.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent e) {
                CompositeSearchText.this.lblClear.setCursor(cursor);
            }
        });
        this.lblFileFilter.addMouseTrackListener(new MouseTrackAdapter(){

            @Override
            public void mouseEnter(MouseEvent e) {
                CompositeSearchText.this.lblFileFilter.setCursor(cursor);
            }
        });
    }
}

