/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import net.contentobjects.jnotify.JNotifyListener;
import ui.RealTimeFileIndexingQueue;
import ui.UtilityClass;

public class JNotifyMonitor
implements JNotifyListener {
    public RealTimeFileIndexingQueue _Que;

    public void init(RealTimeFileIndexingQueue que) {
        this._Que = que;
    }

    private void OnRenameDir(File parent, String newNameFix, String oldNameFix) throws Exception {
        for (File children : parent.listFiles()) {
            String childrenName = children.getCanonicalPath();
            String oldName = childrenName.replace(newNameFix, oldNameFix);
            this._Que.AddFileDeleteQue(oldName);
            this._Que.AddFileCreateQue(childrenName);
            if (!children.isDirectory()) continue;
            this.OnRenameDir(children, newNameFix, oldNameFix);
        }
    }

    private void AddFile2Que(File file) throws Exception {
        if (!file.exists()) {
            return;
        }
        this._Que.AddFileCreateQue(file.getCanonicalPath());
        if (file.isDirectory()) {
            for (File fileone : file.listFiles()) {
                this.AddFile2Que(fileone);
            }
        }
    }

    public void fileCreated(int wd, String rootPath, String name) {
        try {
            String filename = UtilityClass.getFullname(rootPath, name);
            if (UtilityClass.DebugMode) {
                System.out.println("creating " + filename);
            }
            File file = new File(filename);
            this.AddFile2Que(file);
            if (UtilityClass.DebugMode) {
                System.out.println(this._Que.toString());
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public void fileDeleted(int wd, String rootPath, String name) {
        block4: {
            try {
                String filename = UtilityClass.getFullname(rootPath, name);
                if (UtilityClass.DebugMode) {
                    System.out.println("deleting " + filename + "root:" + rootPath);
                }
                this._Que.AddFileDeleteQue(filename);
            }
            catch (Exception e) {
                if (!UtilityClass.DebugMode) break block4;
                System.out.println(e.getMessage());
            }
        }
        if (UtilityClass.DebugMode) {
            System.out.println(this._Que.toString());
        }
    }

    public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
        try {
            String fileOldName = UtilityClass.getFullname(rootPath, oldName);
            String fileNewName = UtilityClass.getFullname(rootPath, newName);
            if (UtilityClass.DebugMode) {
                System.out.println("wd=" + String.valueOf(wd) + "renaming " + fileOldName + "->" + fileNewName);
            }
            File file = new File(fileNewName);
            this._Que.AddFileDeleteQue(fileOldName);
            this._Que.AddFileCreateQue(fileNewName);
            if (file.isDirectory()) {
                this.OnRenameDir(file, fileNewName, fileOldName);
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
        if (UtilityClass.DebugMode) {
            System.out.println(this._Que.toString());
        }
    }

    public void fileModified(int wd, String rootPath, String name) {
        File file;
        String filename = UtilityClass.getFullname(rootPath, name);
        if (UtilityClass.DebugMode) {
            System.out.println("Modifying " + filename);
        }
        if ((file = new File(filename)).exists()) {
            this._Que.AddFileCreateQue(filename);
        }
        if (UtilityClass.DebugMode) {
            System.out.println(this._Que.toString());
        }
    }
}

