/*
 * Decompiled with CFR 0.152.
 */
package ui;

import biz.SearchBiz;
import biz.configclass;
import biz.searchFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ui.UtilityClass;

public class NonRealTimeFileIndexingQueue {
    private Map<String, String> IndexingTargetFile = new HashMap<String, String>();

    public void AddFileCreateQue(String filename) {
        try {
            File file = new File(filename);
            this.IndexingTargetFile.put(file.getCanonicalPath(), "1");
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public void AddFileDeleteQue(String filename) {
        try {
            File file = new File(filename);
            this.IndexingTargetFile.put(file.getCanonicalPath(), "0");
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public Map<String, String> getMap() {
        return this.IndexingTargetFile;
    }

    public void clearAll() {
        this.IndexingTargetFile.clear();
    }

    public void QueHandlerNonRealTime(SearchBiz searchBiz, searchFolder sf, int iCurIndex) {
        boolean bRet = false;
        try {
            if (UtilityClass.DebugMode) {
                System.out.println(this.getClass().getName() + " files:" + this.toString());
            }
            Thread.currentThread().setName(UtilityClass._threadNonRealTimeFileHandle);
            try {
                if (UtilityClass.IsThreadRunning(UtilityClass._threadCreateIndexThreadOrSearch)) {
                    return;
                }
            }
            catch (Exception e) {
                UtilityClass.OutputLogFile("error in detecting the running thread of non real time file eventhandle().");
            }
            String strIndex = sf.getIndexName(iCurIndex);
            String strInclude = sf.getIncludeFolder(iCurIndex);
            if (strInclude == null || strInclude.isEmpty()) {
                bRet = true;
            }
            if (!sf.isEnable(iCurIndex)) {
                bRet = true;
            }
            if (configclass.getInstance("config.xml").getNewestDataIndexFolderLong(strIndex).isEmpty()) {
                bRet = true;
            }
            if (!bRet) {
                int iTotal = this.IndexingTargetFile.size();
                int iCur = 0;
                ArrayList<String> sortedKeys = new ArrayList<String>(this.IndexingTargetFile.keySet());
                Collections.sort(sortedKeys);
                for (String strKey : sortedKeys) {
                    File file = new File(strKey);
                    if (UtilityClass.DebugMode) {
                        System.out.println("-----NonRealTimeFileIndexing : " + strKey);
                    }
                    ++iCur;
                    String strOP = this.IndexingTargetFile.get(strKey);
                    if ("0".equals(strOP)) {
                        searchBiz.deleteIndex4File(file, iTotal, iCur, true);
                        continue;
                    }
                    int bCreate = 0;
                    if (".pst".equalsIgnoreCase(file.getCanonicalPath())) {
                        bCreate = searchBiz.updateIndex4PST(file, iTotal, iCur);
                    } else {
                        searchBiz.deleteIndex4File(file, iTotal, iCur, false);
                        bCreate = searchBiz.createIndex4File(file, null, iTotal, iCur);
                    }
                    if (bCreate != -1) continue;
                    searchBiz._handleFatalErr(bCreate, iCurIndex);
                }
                searchBiz.finializeCreateIndex();
            }
            this.clearAll();
        }
        catch (Exception e) {
            if (UtilityClass.DebugMode) {
                System.out.println(e.getMessage());
            }
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }

    public String toString() {
        String str = "Data in the map:";
        int i = 0;
        int iMax = 300;
        for (String strKey : this.IndexingTargetFile.keySet()) {
            if (i > iMax) break;
            str = str + "\r\n" + strKey + ":" + this.IndexingTargetFile.get(strKey);
            ++i;
        }
        return str;
    }
}

