/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.InputStream;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import ui.UtilityClass;

public class NotifyDialog
extends Dialog {
    protected Object result;
    protected Shell shlNotifyDialog;
    private String m_str;
    private String m_imgStr;

    public NotifyDialog(Shell parent, int style) {
        super(parent, style);
    }

    public NotifyDialog(Shell parent) {
        this(parent, 0);
    }

    public void setMessage(String str) {
        this.m_str = str;
    }

    public void setLogoFile(String imgStr) {
        this.m_imgStr = imgStr;
    }

    public Object open() {
        try {
            this.createContents();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shlNotifyDialog.open();
        this.shlNotifyDialog.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shlNotifyDialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void Centerize() {
        Monitor primary = Display.getDefault().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shlNotifyDialog.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shlNotifyDialog.setLocation(x, y);
    }

    private void createContents() throws Exception {
        this.shlNotifyDialog = new Shell(this.getParent(), 65632);
        this.shlNotifyDialog.setText(this.getText());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = UtilityClass.scaleForDpi(5);
        gridLayout.marginWidth = UtilityClass.scaleForDpi(10);
        gridLayout.horizontalSpacing = UtilityClass.scaleForDpi(10);
        gridLayout.numColumns = 2;
        this.shlNotifyDialog.setLayout(gridLayout);
        Label label = new Label(this.shlNotifyDialog, 0);
        GridData gridData2 = new GridData();
        gridData2.widthHint = UtilityClass.scaleForDpi(74);
        gridData2.verticalAlignment = 128;
        label.setLayoutData(gridData2);
        InputStream in = this.getClass().getResource(this.m_imgStr).openStream();
        final Image img = new Image((Device)this.getParent().getDisplay(), in);
        in.close();
        label.setImage(img);
        Link link = new Link(this.shlNotifyDialog, 0);
        GridData gridData = new GridData();
        gridData.widthHint = UtilityClass.scaleForDpi(400);
        link.setLayoutData(gridData);
        Button OKBtn = new Button(this.shlNotifyDialog, 0);
        OKBtn.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent arg0) {
                if (!img.isDisposed()) {
                    img.dispose();
                }
                NotifyDialog.this.shlNotifyDialog.close();
            }
        });
        GridData gridData1 = new GridData();
        gridData1.widthHint = UtilityClass.scaleForDpi(100);
        gridData1.horizontalAlignment = 0x1000000;
        gridData1.horizontalSpan = 2;
        OKBtn.setText("OK");
        OKBtn.setLayoutData(gridData1);
        link.setText(this.m_str);
        link.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (!e.text.isEmpty()) {
                    Program.launch(e.text);
                }
            }
        });
        this.shlNotifyDialog.pack();
        this.Centerize();
    }
}

