/*
 * Decompiled with CFR 0.152.
 */
package biz;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseBaseFormFilter;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class MyAnalyzer
extends JapaneseAnalyzer {
    static boolean isbConjunctionIncluded = true;
    static String dict = "Searchplusplusdict.txt";

    public void SetMode(boolean bConjunctionIncluded) {
        isbConjunctionIncluded = bConjunctionIncluded;
    }

    public boolean GetMode() {
        return isbConjunctionIncluded;
    }

    protected Analyzer.TokenStreamComponents createComponents(String field) {
        JapaneseBaseFormFilter stream;
        UserDictionary userDict = null;
        try {
            FileInputStream fileStream = new FileInputStream(dict);
            InputStreamReader in = new InputStreamReader(fileStream);
            userDict = new UserDictionary((Reader)in);
            ((Reader)in).close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(userDict, true, JapaneseTokenizer.Mode.SEARCH);
        if (!isbConjunctionIncluded) {
            stream = new JapaneseBaseFormFilter((TokenStream)tokenizer);
            stream = new JapanesePartOfSpeechStopFilter((TokenStream)stream, MyAnalyzer.getDefaultStopTags());
            stream = new CJKWidthFilter((TokenStream)stream);
            stream = new StopFilter((TokenStream)stream, this.stopwords);
            stream = new JapaneseKatakanaStemFilter((TokenStream)stream);
            stream = new LowerCaseFilter((TokenStream)stream);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
        }
        stream = new LowerCaseFilter((TokenStream)tokenizer);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
    }

    public String getParsedString(String searchWord) {
        String strResult = "";
        try {
            TokenStream stream = this.tokenStream(null, new StringReader(searchWord));
            stream.reset();
            while (stream.incrementToken()) {
                if (strResult.isEmpty()) {
                    strResult = ((CharTermAttribute)stream.getAttribute(CharTermAttribute.class)).toString();
                    continue;
                }
                strResult = strResult + " " + ((CharTermAttribute)stream.getAttribute(CharTermAttribute.class)).toString();
            }
            stream.close();
        }
        catch (Exception e) {
            strResult = "";
        }
        return strResult;
    }
}

