/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.MyAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import ui.UtilityClass;

public class MySpanQuery {
    public static String CreateRegStringForSpanQuery(String searchString) {
        String[] strKeys = searchString.split(" ");
        if (strKeys.length != 3) {
            return "";
        }
        if (strKeys[0].startsWith("\"")) {
            strKeys[0] = strKeys[0].substring(1);
        }
        if (strKeys[0].endsWith("\"")) {
            strKeys[0] = strKeys[0].substring(0, strKeys[0].length() - 1);
        }
        if (strKeys[2].startsWith("\"")) {
            strKeys[2] = strKeys[2].substring(1);
        }
        if (strKeys[2].endsWith("\"")) {
            strKeys[2] = strKeys[2].substring(0, strKeys[2].length() - 1);
        }
        return UtilityClass.nearSearchKey + "|" + strKeys[0] + "|" + strKeys[2];
    }

    public static SpanQuery CreateSpannearSearchQuery(String fId, String strQuery) {
        MyAnalyzer analyzer = new MyAnalyzer();
        String st = analyzer.getParsedString(strQuery);
        String[] strSubKeywords = st.split(" ");
        if (strSubKeywords.length == 1) {
            return new SpanTermQuery(new Term(fId, strSubKeywords[0]));
        }
        SpanTermQuery subQuery = new SpanTermQuery(new Term(fId, strSubKeywords[0]));
        for (int i = 0; i < strSubKeywords.length; ++i) {
            if (i <= 0) continue;
            subQuery = new SpanNearQuery(new SpanQuery[]{subQuery, new SpanTermQuery(new Term(fId, strSubKeywords[i]))}, 0, true);
        }
        return subQuery;
    }
}

