/*
 * Decompiled with CFR 0.152.
 */
package ui;

import biz.HardDiskMap;
import biz.SearchBiz;
import biz.configclass;
import java.util.List;
import ui.InterfaceUI;
import ui.NonRealTimeFileIndexingQueue;
import ui.NonRealTimeFileMonitor;
import ui.NonRealTimeObserver;
import ui.UtilityClass;

public class NonRealTimeIndexUpdateThread
extends Thread {
    InterfaceUI baseUI;
    int _searchOption;

    public void init(InterfaceUI mainUI, int searchOption) {
        this.baseUI = mainUI;
        this._searchOption = searchOption;
    }

    @Override
    public void run() {
        int iRet = 0;
        boolean bResumeStart = false;
        boolean bFoundStop = false;
        int startResumeIndex = 0;
        if (this._searchOption == UtilityClass.SearchOptionResumeIndexByCompareSnapshot) {
            startResumeIndex = configclass.getInstance("config.xml").getErrFileIndex();
        }
        for (int i = startResumeIndex; i < this.baseUI.getSearchFolder().getIndexNumber(); ++i) {
            SearchBiz searchBiz;
            if (!this.baseUI.getSearchFolder().isEnable(i)) continue;
            this.baseUI.SetStopSignal(false);
            String strIndex = this.baseUI.getSearchFolder().getIndexName(i);
            String strInclude = this.baseUI.getSearchFolder().getIncludeFolder(i);
            String strExclude = this.baseUI.getSearchFolder().getExcludeFolder(i);
            long lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
            UtilityClass.CreateBaseFolder(configclass.getInstance("config.xml").getIndexDir(), lCreatedDate, strIndex, false);
            HardDiskMap.saveIndexHDVolume();
            if (UtilityClass.DebugMode) {
                System.out.println("NonRealTimeIndexUpdateThread: run " + strIndex);
            }
            if (!(searchBiz = new SearchBiz()).Init(this._searchOption, this.baseUI.getSearchFolder(), strIndex)) {
                return;
            }
            List<String> strSnapshot = searchBiz.GetAllDocOfFiles();
            NonRealTimeObserver nonTimeOb = new NonRealTimeObserver(this.baseUI, strSnapshot, null);
            NonRealTimeFileIndexingQueue que = new NonRealTimeFileIndexingQueue();
            nonTimeOb.addListener(new NonRealTimeFileMonitor(que));
            iRet = nonTimeOb.checkAndNotify(strInclude, strExclude);
            searchBiz.setResumeStart(bResumeStart);
            searchBiz.setResumeFileFound(bFoundStop);
            que.QueHandlerNonRealTime(searchBiz, this.baseUI.getSearchFolder(), i);
            bResumeStart = searchBiz.getResumeStart();
            bFoundStop = searchBiz.getResumeFileFound();
        }
        this.baseUI.getInterfaceAsynSearchDisplayEvent().OnCreateDirIndexFinished(iRet, this._searchOption);
        this.baseUI.OnCompleteNonRealTimeUpdateIndex(UtilityClass.TimeMode.NOTTRAYMODE, this.baseUI.stop());
        super.run();
        long lCreatedDate = configclass.getInstance("config.xml").getNewestDataIndexFolderLong();
        long loldDate = configclass.getInstance("config.xml").getIndexDataFolderlong();
        if (loldDate != lCreatedDate) {
            configclass.getInstance("config.xml").SetIndexDataFolderlong(lCreatedDate);
            configclass.getInstance("config.xml").Save();
        }
    }
}

