/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.IOCase;
import ui.InterfaceUI;
import ui.NonRealTimeFileListener;
import ui.UtilityClass;

public class NonRealTimeObserver
implements Serializable {
    private static List listeners;
    private final FileFilter fileFilter;
    InterfaceUI baseUI;
    private List<String> snapshotList;
    private List<String> currentList;

    private void CurrentImage(String include, String exclude) {
        String[] dirIncludeIndex = include.split(";");
        String[] dirExcludeIndex = null;
        if (exclude != null && exclude.length() != 0) {
            dirExcludeIndex = exclude.split(";");
        }
        try {
            if (UtilityClass.IsThreadRunning(UtilityClass._threadCreateIndexThreadOrSearch)) {
                return;
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile("error in detecting the running thread of fileeventhandle().");
        }
        for (String parentName : dirIncludeIndex) {
            File parent = new File(parentName);
            if (!parent.exists()) continue;
            if (this.baseUI.stop()) {
                return;
            }
            this._CreateCurrentImage(parent, dirIncludeIndex, dirExcludeIndex);
        }
    }

    private void _CreateCurrentImage(File parent, String[] dirIncludeIndex, String[] dirExcludeIndex) {
        block9: {
            try {
                if (this.baseUI.stop()) {
                    return;
                }
                String name = parent.getCanonicalPath();
                if (UtilityClass.IsFileInIncludeList(name, dirIncludeIndex, dirExcludeIndex)) {
                    String modifyDate = String.valueOf(parent.lastModified());
                    String length = String.valueOf(parent.length());
                    String strFileInfo = name + ";" + modifyDate + ";" + length;
                    this.currentList.add(strFileInfo);
                    this.baseUI.onCreateCurrentImage(name);
                    if (parent.isDirectory()) {
                        if (UtilityClass.DebugMode) {
                            System.out.println("Access the folder: " + parent.getCanonicalPath());
                        }
                        for (File file : parent.listFiles()) {
                            this._CreateCurrentImage(file, dirIncludeIndex, dirExcludeIndex);
                        }
                    }
                } else if (UtilityClass.DebugMode) {
                    System.out.println("skip " + parent.getCanonicalPath());
                }
            }
            catch (Exception e) {
                if (!UtilityClass.DebugMode) break block9;
                System.out.println("error: " + e.getLocalizedMessage());
            }
        }
    }

    public NonRealTimeObserver(InterfaceUI _main, List<String> snapshot, FileFilter filter) {
        listeners = new CopyOnWriteArrayList();
        this.baseUI = _main;
        this.fileFilter = filter;
        this.snapshotList = snapshot;
    }

    public void addListener(NonRealTimeFileListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    public void removeListener(NonRealTimeFileListener listener) {
        if (listener != null) {
            while (listeners.remove(listener)) {
            }
        }
    }

    public Iterable getListeners() {
        return listeners;
    }

    private void CreateCurrentImage(String include, String exclude) {
        this.currentList = new ArrayList<String>();
        this.CurrentImage(include, exclude);
        if (this.currentList != null && this.currentList.size() != 0) {
            if (UtilityClass.DebugMode) {
                System.out.println("before sorting the image of folder");
            }
            Collections.sort(this.currentList);
            if (UtilityClass.DebugMode) {
                System.out.println("after sorting the image of folder");
            }
        }
    }

    public int checkAndNotify(String include, String exclude) {
        int iRet = 0;
        this.CreateCurrentImage(include, exclude);
        int i = 0;
        int j = 0;
        boolean currentOver = false;
        int iTotal = this.snapshotList.size();
        int iCur = 0;
        block0: for (String strSnapshot : this.snapshotList) {
            ++iCur;
            if (!currentOver && !this.baseUI.stop()) {
                for (i = j; i < this.currentList.size() && !this.baseUI.stop(); ++i) {
                    String[] current;
                    String strCurrent = this.currentList.get(i);
                    if (IOCase.SENSITIVE.checkCompareTo(strSnapshot, strCurrent) == 0) {
                        j = i;
                        if (++j < this.currentList.size()) continue block0;
                        currentOver = true;
                        continue block0;
                    }
                    String[] snap = strSnapshot.split(";");
                    int compResult = IOCase.SENSITIVE.checkCompareTo(snap[0], (current = strCurrent.split(";"))[0]);
                    if (compResult == 0) {
                        if (!this.baseUI.stop()) {
                            this.doChange(current[0], iTotal, iCur);
                        }
                        j = i;
                        if (++j < this.currentList.size()) continue block0;
                        currentOver = true;
                        continue block0;
                    }
                    if (compResult > 0) {
                        if (this.baseUI.stop()) continue;
                        this.doCreate(current[0], iTotal, iCur);
                        continue;
                    }
                    if (!this.baseUI.stop()) {
                        this.doDelete(snap[0], iTotal, iCur);
                    }
                    j = i;
                    continue block0;
                }
                continue;
            }
            String[] snap = strSnapshot.split(";");
            if (this.baseUI.stop()) continue;
            this.doDelete(snap[0], iTotal, iCur);
        }
        iTotal = this.currentList.size() - 1;
        iCur = j;
        if (!currentOver) {
            for (i = j; i < this.currentList.size(); ++i) {
                iCur = i;
                String strCurrent = this.currentList.get(i);
                String[] current = strCurrent.split(";");
                if (this.baseUI.stop()) continue;
                this.doCreate(current[0], iTotal, iCur);
            }
        }
        this.snapshotList.clear();
        this.currentList.clear();
        if (this.baseUI.stop()) {
            iRet = -1;
        }
        this.doCompleted(iRet);
        if (UtilityClass.DebugMode) {
            System.out.println("docompleted: files have been compared");
        }
        return iRet;
    }

    private void doCompleted(int iRet) {
        for (NonRealTimeFileListener listener : listeners) {
            listener.onUpdateCompleted(iRet);
        }
    }

    private void doCreate(String filename, int iTotal, int iCur) {
        for (NonRealTimeFileListener listener : listeners) {
            listener.onFileCreate(new File(filename), iTotal, iCur);
        }
    }

    private void doChange(String filename, int iTotal, int iCur) {
        for (NonRealTimeFileListener listener : listeners) {
            listener.onFileChange(new File(filename), iTotal, iCur);
        }
    }

    private void doDelete(String filename, int iTotal, int iCur) {
        for (NonRealTimeFileListener listener : listeners) {
            listener.onFileDelete(new File(filename), iTotal, iCur);
        }
    }
}

