/*
 * Decompiled with CFR 0.152.
 */
package DataTool;

import DataTool.DataToolConfig;
import DataTool.LicenseInputDlg;
import Interface.Mytranslator;
import biz.Certificate;
import biz.FilterDlgData;
import biz.SearchBiz;
import biz.searchFolder;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.tika.detect.AutoDetectReader;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ui.InterfaceAsynSearchDisplayEvent;
import ui.LangSelectDlg;
import ui.MySummaryData;
import ui.SearchThread;
import ui.UtilityClass;

public class DataToolMain
implements InterfaceAsynSearchDisplayEvent {
    private static Shell shlmain;
    private static DataToolConfig config;
    private static Properties prop;
    private static DataToolMain DataToolMainUI;
    private static int searchOption;
    public static ServerSocket socket;
    private static searchFolder _sf;
    private static FilterDlgData filterDlgData;
    private static Combo comboIndex;
    private static Text txtKeyWordFile;
    private static boolean AsynStop;
    private static int indexKeyWord;
    private static List<String> listKeyWords;
    private static String exportFolder;
    private static ProgressBar progressBar;
    private static Button buyButton;
    private static Button RegisterBtn;
    private static Label MsgArea;

    public static boolean Search(String Searchkey) {
        if (Searchkey == null || Searchkey.isEmpty()) {
            return true;
        }
        if (!DataToolMain.indexDataExist()) {
            MessageBox messageBox = new MessageBox(shlmain, 290);
            messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
            messageBox.setMessage(Mytranslator.getInstance().getTranslate("DataToolNoIndexData"));
            return false;
        }
        searchOption = UtilityClass.SearchOptionOnlySearch;
        String str = DataToolMainUI.AdjustSearchString(Searchkey);
        String _searchKey = DataToolMain.getSearchKey(str);
        DataToolMain.StartIndexThread(_searchKey, searchOption, "filedate", false, filterDlgData, "", "");
        return true;
    }

    private static String getSearchKey(String strTextCtrlKey) {
        String strSearchKey = strTextCtrlKey;
        if ("1".equals(config.getIsFixedKeyword())) {
            String[] strsplit = strSearchKey.split("\"");
            for (int i = 0; i < strsplit.length; ++i) {
                if (strsplit[i].isEmpty()) continue;
                int imod = i % 2;
                strsplit[i] = imod == 0 ? DataToolMain.addQuotation(strsplit[i].trim()) : "\"" + strsplit[i] + "\"";
            }
            strSearchKey = "";
            for (String str : strsplit) {
                strSearchKey = strSearchKey.isEmpty() ? str : strSearchKey + " " + str;
            }
        }
        return strSearchKey;
    }

    private static void StartIndexThread(String strSearchKey, int strOption, String sortField, boolean bAsc, FilterDlgData filterDlgData, String strFilename, String strFileTime) {
        if (!"0".equals(config.getIndexAgent())) {
            for (int i = 0; i < _sf.getIndexNumber(); ++i) {
                if (!_sf.isEnable(i)) continue;
                String str = _sf.getIncludeFolder(i);
                String[] dirIncludeIndex = str.split(";");
                for (int j = 0; j < dirIncludeIndex.length; ++j) {
                    File file = new File(dirIncludeIndex[j]);
                    String strMsg = "";
                    if (!file.isDirectory()) {
                        strMsg = dirIncludeIndex[j] + "\r\n" + Mytranslator.getInstance().getTranslate("ErrInSearchFolder");
                    }
                    if (strMsg.isEmpty()) continue;
                    strMsg = Mytranslator.getInstance().getTranslate("error") + "\r\n" + strMsg + "\r\n" + Mytranslator.getInstance().getTranslate("UseOptionDlg");
                    UtilityClass.ErrMsgFromShell(shlmain, strMsg);
                    return;
                }
            }
        }
        SearchThread aThread = new SearchThread();
        aThread.init(DataToolMainUI, _sf, strSearchKey, strOption, true, UtilityClass._threadCreateIndexThreadOrSearch, strFilename, strFileTime);
        aThread.start();
    }

    private static void initIndexCombox() {
        if (_sf.getIndexNumber() == 0) {
            MsgArea.setText(Mytranslator.getInstance().getTranslate("DataToolNoIndexData"));
            return;
        }
        if (comboIndex != null && !comboIndex.isDisposed()) {
            comboIndex.removeAll();
            String strCurIndex = _sf.getCurrentIndexName();
            int j = 0;
            int cur = 0;
            for (int i = 0; i < _sf.getIndexNumber(); ++i) {
                if (!_sf.isEnable(i)) continue;
                String strIndex = _sf.getIndexName(i);
                comboIndex.add(strIndex);
                if (strCurIndex.equals(strIndex)) {
                    cur = j;
                    if (UtilityClass.DebugMode) {
                        System.out.println("sf.current = " + i);
                    }
                }
                ++j;
            }
            comboIndex.select(cur);
            DataToolMain.OnCombIndexSelectChange();
            String tooltip = DataToolMain.getTooltipString();
            comboIndex.setToolTipText(tooltip);
        }
    }

    private static void createIndexCombo() {
        comboIndex = new Combo(shlmain, 0);
        comboIndex.setBounds(0, UtilityClass.scaleForDpi(10), UtilityClass.scaleForDpi(620), UtilityClass.scaleForDpi(26));
        comboIndex.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DataToolMain.OnCombIndexSelectChange();
            }
        });
        DataToolMain.initIndexCombox();
    }

    private static void OnCombIndexSelectChange() {
        if (UtilityClass.DebugMode) {
            System.out.println("combIndex.SelectionListening");
        }
        String str = comboIndex.getText();
        for (int i = 0; i < _sf.getIndexNumber(); ++i) {
            if (!str.equals(_sf.getIndexName(i))) continue;
            _sf.setCurrentIndex(i);
            break;
        }
        String tooltip = DataToolMain.getTooltipString();
        comboIndex.setToolTipText(tooltip);
    }

    private static void InitConfig() {
        try {
            File newFile;
            File file = new File("config.xml");
            boolean configValid = true;
            if (!file.exists()) {
                configValid = false;
            } else if (file.length() < 10L) {
                configValid = false;
            }
            if (!configValid && (newFile = new File("config.xml.tmp")).exists()) {
                FileUtils.copyFile((File)newFile, (File)file);
            }
            config = new DataToolConfig("config.xml");
            DataToolMainUI = new DataToolMain();
            _sf = new searchFolder();
            config.getSearchFolder(_sf);
            DataToolMain.InitLanguage();
            UtilityClass.initSecurity();
            Certificate.init(config.getVer());
        }
        catch (Exception e) {
            e.printStackTrace();
            UtilityClass.ErrMsgFromShell(shlmain, "Exception happened in reading the config.xml," + e.getLocalizedMessage());
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        shlmain = new Shell(display);
        shlmain.setSize(UtilityClass.scaleForDpi(636), UtilityClass.scaleForDpi(190));
        DataToolMain.InitConfig();
        DataToolMain.InitBizObjects();
        DataToolMain.CreateContents(display);
        shlmain.open();
        while (shlmain != null && !shlmain.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    static INIT_STATE Licjudge() {
        String strLic = config.getD_L();
        if (!strLic.isEmpty() && DataToolMain.checkC(strLic)) {
            return INIT_STATE.VALID_LICENSE;
        }
        return INIT_STATE.TRIAL_PERIOD;
    }

    private static boolean checkC(String strLic) {
        boolean bRet;
        block3: {
            bRet = false;
            try {
                String[] str = strLic.split("-");
                if (str.length == 2) {
                    bRet = config.check(str[0], str[1]);
                }
            }
            catch (Exception e) {
                if (!UtilityClass.DebugMode) break block3;
                System.out.println(e.getMessage());
            }
        }
        return bRet;
    }

    private static void SetMainWindowTitle(boolean isTrialVer) {
        String strTitle = Mytranslator.getInstance().getTranslate("DataToolTitle") + "-" + Mytranslator.getInstance().getTranslate("Version");
        strTitle = isTrialVer ? strTitle + " : " + Mytranslator.getInstance().getTranslate("Trying") : strTitle + " : " + Mytranslator.getInstance().getTranslate("ValidLic");
        shlmain.setText(strTitle);
    }

    @Override
    public void NotifyIndexFolderChange(String oldFolder, String newFolder) {
    }

    @Override
    public void NotifyDiskChange(String strFolder) {
    }

    @Override
    public void OnDeleteIndexFile(String filename, boolean stopSignal, int iTotal, int iCur) {
    }

    @Override
    public void OnCompleteHandleAllFiles(String strCmd, String destFolderName) {
    }

    @Override
    public void OnHandleFile(String strCmd, String filename) {
    }

    @Override
    public void OnBeginEstimate(boolean stopSignal) {
    }

    @Override
    public void OnEndEstimate(boolean stopSignal) {
    }

    private static void CreateContents(Display display) {
        String strTitle = Mytranslator.getInstance().getTranslate("DataToolTitle");
        shlmain.setText(strTitle);
        Button BtnSearchKeyFile = new Button(shlmain, 0);
        BtnSearchKeyFile.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(shlmain, 4096);
                String str = fd.open();
                if (str != null && !str.isEmpty()) {
                    txtKeyWordFile.setText(str);
                    progressBar.setSelection(0);
                }
            }
        });
        BtnSearchKeyFile.setBounds(UtilityClass.scaleForDpi(506), UtilityClass.scaleForDpi(56), UtilityClass.scaleForDpi(114), UtilityClass.scaleForDpi(28));
        BtnSearchKeyFile.setText(Mytranslator.getInstance().getTranslate("DataToolSearchfile"));
        txtKeyWordFile = new Text(shlmain, 2048);
        txtKeyWordFile.setEditable(false);
        txtKeyWordFile.setBounds(0, UtilityClass.scaleForDpi(58), UtilityClass.scaleForDpi(500), UtilityClass.scaleForDpi(24));
        progressBar = new ProgressBar(shlmain, 0);
        progressBar.setBounds(0, UtilityClass.scaleForDpi(83), UtilityClass.scaleForDpi(500), UtilityClass.scaleForDpi(2));
        Button btnOK = new Button(shlmain, 0);
        btnOK.setBounds(UtilityClass.scaleForDpi(444), UtilityClass.scaleForDpi(110), UtilityClass.scaleForDpi(79), UtilityClass.scaleForDpi(28));
        btnOK.setText("OK");
        btnOK.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (!txtKeyWordFile.getText().isEmpty()) {
                    DataToolMain.SearchWords(txtKeyWordFile.getText());
                }
            }
        });
        Button BtnCancel = new Button(shlmain, 0);
        BtnCancel.setText(Mytranslator.getInstance().getTranslate("Cancel"));
        BtnCancel.setBounds(UtilityClass.scaleForDpi(529), UtilityClass.scaleForDpi(110), UtilityClass.scaleForDpi(91), UtilityClass.scaleForDpi(28));
        BtnCancel.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DataToolMain.exit();
            }
        });
        buyButton = new Button(shlmain, 0);
        buyButton.setText(Mytranslator.getInstance().getTranslate("Buy"));
        buyButton.setBounds(UtilityClass.scaleForDpi(359), UtilityClass.scaleForDpi(110), UtilityClass.scaleForDpi(79), UtilityClass.scaleForDpi(28));
        buyButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                try {
                    Desktop desktop;
                    if (!Desktop.isDesktopSupported() || !(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
                        throw new RuntimeException("not support direct mail");
                    }
                    URI mailto = new URI("mailto:support@searchplusplus.jp?subject=Purchase DataTool license-" + config.getl());
                    desktop.mail(mailto);
                }
                catch (Exception ee) {
                    MessageBox messageBox = new MessageBox(shlmain, 34);
                    messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                    messageBox.setMessage(Mytranslator.getInstance().getTranslate("DataToolBuy") + "-" + config.getl());
                    messageBox.open();
                }
            }
        });
        RegisterBtn = new Button(shlmain, 0);
        RegisterBtn.setText(Mytranslator.getInstance().getTranslate("Validate"));
        RegisterBtn.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                LicenseInputDlg dlg = new LicenseInputDlg(shlmain);
                dlg.Init(config);
                if (dlg.open()) {
                    DataToolMain.ButtonStatus(false);
                } else {
                    DataToolMain.ButtonStatus(true);
                }
            }
        });
        RegisterBtn.setBounds(UtilityClass.scaleForDpi(274), UtilityClass.scaleForDpi(110), UtilityClass.scaleForDpi(79), UtilityClass.scaleForDpi(28));
        MsgArea = new Label(shlmain, 0);
        MsgArea.setBounds(0, UtilityClass.scaleForDpi(110), UtilityClass.scaleForDpi(268), UtilityClass.scaleForDpi(28));
        DataToolMain.createIndexCombo();
        SearchBiz.setInterface(DataToolMainUI);
        if (DataToolMain.Licjudge() == INIT_STATE.VALID_LICENSE) {
            DataToolMain.ButtonStatus(false);
        } else {
            DataToolMain.ButtonStatus(true);
        }
    }

    static void ButtonStatus(boolean isTrial) {
        if (isTrial) {
            buyButton.setVisible(true);
            RegisterBtn.setVisible(true);
            DataToolMain.SetMainWindowTitle(true);
        } else {
            buyButton.setVisible(false);
            RegisterBtn.setVisible(false);
            DataToolMain.SetMainWindowTitle(false);
        }
    }

    private static void SearchWords(String filename) {
        try {
            File file = new File(filename);
            String parentString = file.getParent();
            File parentFile = new File(parentString);
            if (!parentString.endsWith("\\")) {
                parentString = parentString + "\\";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
            String date = dateFormat.format(new Date());
            exportFolder = parentString + date;
            boolean isWritable = new File(exportFolder).mkdirs();
            if (!isWritable) {
                MessageBox messageBox = new MessageBox(shlmain, 34);
                messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                messageBox.setMessage(Mytranslator.getInstance().getTranslate("NeedWriteAccessRight") + parentString);
                messageBox.open();
                return;
            }
            Charset charset = new AutoDetectReader((InputStream)new FileInputStream(file)).getCharset();
            listKeyWords = FileUtils.readLines((File)file, (Charset)charset);
            String strKeyWord = listKeyWords.get(indexKeyWord = 0);
            if (!strKeyWord.isEmpty()) {
                progressBar.setMaximum(listKeyWords.size());
                DataToolMain.Search(strKeyWord);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean indexDataExist() {
        boolean bRet = true;
        long lCreatedDate = config.getNewestDataIndexFolderLong();
        if (lCreatedDate == -1L) {
            bRet = false;
        } else {
            String str = UtilityClass.getFullname(config.getIndexDir(), String.valueOf(lCreatedDate));
            str = UtilityClass.getFullname(str, _sf.getCurrentIndexName());
            String subStr = UtilityClass.getFullname(str, "subIndex");
            File file = new File(str);
            File subFile = new File(subStr);
            if (!(file.exists() && file.isDirectory() && subFile.exists() && subFile.isDirectory())) {
                bRet = false;
            }
        }
        return bRet;
    }

    private static String getTooltipString() {
        String includeTip = _sf.getIncludeFolder(_sf.getCurrentIndex());
        String excludeTip = _sf.getExcludeFolder(_sf.getCurrentIndex());
        return UtilityClass.tooltip(includeTip, excludeTip);
    }

    public static void exit() {
        AsynStop = true;
        if (shlmain != null && !shlmain.isDisposed()) {
            shlmain.close();
        }
    }

    private static String addQuotation(String str) {
        str = str.replace(" ", "\" \"");
        str = "\"" + str + "\"";
        str = str.replace("\"AND\"", "AND");
        str = str.replace("\"OR\"", "OR");
        str = str.replace("\"NOT\"", "NOT");
        str = str.replace("\"\"", "\"");
        return str;
    }

    public String AdjustSearchString(String strSearchString) {
        if (!strSearchString.isEmpty()) {
            char[] c = new char[]{'\u3000'};
            String wspace = new String(c);
            strSearchString = strSearchString.replaceAll(wspace, " ");
            if ((strSearchString = strSearchString.replaceAll(" +", " ")).startsWith("not ")) {
                strSearchString = "NOT " + strSearchString.substring(4);
            }
            String[] Common_keyword = new String[]{" and ", " or ", " not "};
            String[] Capital_keyword = new String[]{" AND ", " OR ", " NOT "};
            for (int i = 0; i <= 2; ++i) {
                strSearchString = strSearchString.replace(Common_keyword[i], Capital_keyword[i]);
            }
            return strSearchString;
        }
        return "";
    }

    private static void InitBizObjects() {
    }

    private static void InitLanguage() {
        if ("none".equals(config.getIndexDir())) {
            String strInitLang = config.getLang();
            LangSelectDlg langDlg = new LangSelectDlg(shlmain, strInitLang);
            String strLang = langDlg.open();
            if (strLang.equalsIgnoreCase("Japanese")) {
                config.setLang(1);
            } else if (strLang.equalsIgnoreCase("English")) {
                config.setLang(2);
            } else if (strLang.equalsIgnoreCase("Chinese Simplified")) {
                config.setLang(0);
            } else if (strLang.equalsIgnoreCase("Chinese Traditional")) {
                config.setLang(3);
            } else {
                config.setLang(2);
            }
        }
        DataToolMain.InitLangPack();
    }

    private static void InitLangPack() {
        String strLangType = config.getLang();
        prop = new Properties();
        try {
            if ("0".equals(strLangType)) {
                FileInputStream in = new FileInputStream("chinese.properties");
                prop.load(in);
                in.close();
                UtilityClass.init("GBK");
            } else if ("1".equals(strLangType)) {
                FileInputStream in = new FileInputStream("japanese.properties");
                prop.load(in);
                in.close();
                UtilityClass.init("SJIS");
            } else if ("2".equals(strLangType)) {
                FileInputStream in = new FileInputStream("english.properties");
                prop.load(in);
                in.close();
                UtilityClass.init("SJIS");
            } else if ("3".equals(strLangType)) {
                FileInputStream in = new FileInputStream("chinese_FT.properties");
                prop.load(in);
                in.close();
                UtilityClass.init("BIG5");
            } else {
                FileInputStream in = new FileInputStream("english.properties");
                prop.load(in);
                in.close();
                UtilityClass.init("SJIS");
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile("initlanguage:" + e.getLocalizedMessage());
        }
    }

    @Override
    public void OnBizInit(String str) {
    }

    @Override
    public void OnBeginCreateDirIndex() {
    }

    @Override
    public boolean OnFindLineData(MySummaryData data, boolean stopSignal) {
        return false;
    }

    @Override
    public void OnBeginCreatedFileIndex(String filename, int totalFileNum, int currentNum, boolean stopSignal) {
    }

    @Override
    public void OnEndCreatedFileIndex(String filename, int totalFileNum, int currentNum, boolean stopSignal) {
    }

    @Override
    public void OnSkipCreatingFileIndex(String filename) {
    }

    @Override
    public boolean OnSearchFinished(int distance, String strQueryKey, List<MySummaryData> resultList, long time, boolean cancel, String strFilename, String strFileTime) {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    progressBar.setSelection(indexKeyWord + 1);
                }
            });
            StringBuffer strBuf = new StringBuffer();
            if (INIT_STATE.TRIAL_PERIOD == DataToolMain.Licjudge()) {
                strBuf.append(Mytranslator.getInstance().getTranslate("DataToolTrialVersionLmit"));
                strBuf.append(System.getProperty("line.separator"));
            }
            int i = 0;
            for (MySummaryData my : resultList) {
                ++i;
                long l = Long.valueOf(my.time);
                String strDate = UtilityClass.getDatefromLong(l);
                File file = new File(my.fileID);
                String strDirorNot = file.isDirectory() ? "<DIR>" : " ";
                String strSize = file.isDirectory() ? " " : UtilityClass.getFilesize(file);
                strBuf.append(strDate);
                strBuf.append("\t");
                strBuf.append(strDirorNot);
                strBuf.append("\t");
                strBuf.append(strSize);
                strBuf.append("\t");
                strBuf.append(my.fileID);
                strBuf.append(System.getProperty("line.separator"));
                if (INIT_STATE.TRIAL_PERIOD != DataToolMain.Licjudge() || i < 10) continue;
                break;
            }
            if (resultList.size() != 0) {
                File file = new File(exportFolder + "\\" + listKeyWords.get(indexKeyWord) + ".txt");
                FileUtils.write((File)file, (CharSequence)strBuf, (String)"UTF-8");
            }
            if (++indexKeyWord < listKeyWords.size()) {
                String strKeyWord = listKeyWords.get(indexKeyWord);
                if (!strKeyWord.isEmpty()) {
                    DataToolMain.Search(strKeyWord);
                }
            } else {
                Desktop.getDesktop().open(new File(exportFolder));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void OnCreateDirIndexFinished(int iRet, int searchOption) {
    }

    @Override
    public void NotifyStopAtFile(String filename) {
    }

    @Override
    public boolean stop() {
        return AsynStop;
    }

    @Override
    public void setStop(boolean b) {
        AsynStop = b;
    }

    @Override
    public void UponThreadEnd() {
    }

    @Override
    public void OnBeginNonRealItemIndexing() {
    }

    @Override
    public void OnCreateSnapshot(String filename) {
    }

    @Override
    public void OnBeforeCreateDirIndex(String strIndir, String strExDir, boolean stopSignal) {
    }

    @Override
    public void OnBeforeSearchDirIndex(String strSearchKey, boolean stopSignal) {
    }

    static {
        prop = null;
        DataToolMainUI = null;
        socket = null;
        filterDlgData = null;
        AsynStop = false;
        indexKeyWord = 0;
        listKeyWords = null;
        exportFolder = "";
    }

    public static enum INIT_STATE {
        VALID_LICENSE,
        TRIAL_PERIOD,
        TRIAL_OVERDUE;

    }
}

