/*
 * Decompiled with CFR 0.152.
 */
package biz;

import biz.iFilePreview;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import ui.UtilityClass;

public class PDFPreview
implements iFilePreview {
    private int iCur = 1;
    private int sheetCnt = 0;
    private String suffix;
    private int resolution = 1;

    public int getSheetNumber() {
        return this.sheetCnt;
    }

    public int getCurSheetNo() {
        return this.iCur;
    }

    @Override
    public boolean hasNext() {
        return this.iCur < this.sheetCnt;
    }

    @Override
    public boolean hasPrevious() {
        return this.iCur > 1;
    }

    @Override
    public String Next(String filename) throws Exception {
        ++this.iCur;
        if (this.iCur <= this.sheetCnt) {
            this.CreatePreview(filename, this.iCur, this.iCur);
            return this.suffix + this.iCur + ".png";
        }
        return "";
    }

    @Override
    public String Previous(String filename) throws Exception {
        --this.iCur;
        if (this.iCur >= 1) {
            this.CreatePreview(filename, this.iCur, this.iCur);
            return this.suffix + this.iCur + ".png";
        }
        return "";
    }

    @Override
    public String previewFile(String filename) throws Exception {
        String str = this.CreatePreview(filename, 1, 1);
        return str;
    }

    private String CreatePreview(String filename, int startPage, int endPage) {
        try {
            File file = new File(filename);
            PDDocument document = PDDocument.load((File)file);
            PDFRenderer renderer = new PDFRenderer(document);
            this.suffix = UtilityClass.GetUniqTempFile(filename);
            BufferedImage combinedImage = null;
            int combinedHeight = 0;
            int combinedWidth = 0;
            this.sheetCnt = document.getNumberOfPages();
            int pages = endPage - startPage + 1;
            for (int pageNum = 0; pageNum < pages; ++pageNum) {
                int curPage = pageNum + startPage - 1;
                BufferedImage image = renderer.renderImageWithDPI(curPage, (float)(this.resolution * 72), ImageType.RGB);
                if (combinedImage == null) {
                    combinedHeight = image.getHeight();
                    combinedWidth = image.getWidth();
                    combinedImage = new BufferedImage(combinedWidth, combinedHeight * pages, 1);
                }
                combinedImage.createGraphics().drawImage((Image)image, 0, combinedHeight * pageNum, null);
            }
            ImageIO.write(combinedImage, "png", new File(this.suffix + this.iCur + ".png"));
            document.close();
            return this.suffix + this.iCur + ".png";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

