/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Interface.Mytranslator;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import ui.ColorManager;
import ui.InterfaceTableEvent;
import ui.MainUI;
import ui.UtilityClass;

public class MyTable
extends Table {
    final int TEXT_MARGIN = 1;
    final int MAXLINES_INAROW = 4;
    final int COLUMN_MAX = 3;
    final int MAXNO_INLINE = 80;
    String strFilename = "";
    private InterfaceTableEvent interfaceEvent;
    public static Color pdfcolor;
    public static Color wordcolor;
    public static Color xlscolor;
    public static Color htmlcolor;
    public static Color visiocolor;
    public static Color pptcolor;
    public static Color docucolor;

    @Override
    protected void checkSubclass() {
    }

    private void hideScrollbarsInternal() {
        if (this.isDisposed()) {
            return;
        }
        if (this.getVerticalBar() != null && this.getVerticalBar().getVisible()) {
            this.getVerticalBar().setVisible(false);
        }
        if (this.getHorizontalBar() != null && this.getHorizontalBar().getVisible()) {
            this.getHorizontalBar().setVisible(false);
        }
    }

    public MyTable(Composite parent, int style) {
        super(parent, style & 0xFFFFFEFF & 0xFFFFFDFF);
        this.initTable();
        this.hideScrollbarsInternal();
        this.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event e) {
                MyTable.this.hideScrollbarsInternal();
            }
        });
        if (pdfcolor == null) {
            pdfcolor = new Color(null, 234, 75, 81);
        }
        if (wordcolor == null) {
            wordcolor = new Color(null, 33, 95, 172);
        }
        if (xlscolor == null) {
            xlscolor = new Color(null, 40, 158, 72);
        }
        if (htmlcolor == null) {
            htmlcolor = new Color(null, 18, 172, 243);
        }
        if (visiocolor == null) {
            visiocolor = new Color(null, 41, 82, 188);
        }
        if (pptcolor == null) {
            pptcolor = new Color(null, 239, 88, 35);
        }
        if (docucolor == null) {
            docucolor = new Color(null, 52, 188, 186);
        }
    }

    public void setInterface(MainUI mainobj) {
        this.interfaceEvent = mainobj;
    }

    public void pageChange(int curPage) {
        this.setChecked(this.interfaceEvent.getFileFilterList());
    }

    public void onSearch(String str) {
    }

    private void setChecked(List<String> strArray) {
        if (strArray != null && strArray.size() > 0) {
            block0: for (String strItem : strArray) {
                for (TableItem tableItem : this.getItems()) {
                    if (!tableItem.getText(0).equals(strItem)) continue;
                    tableItem.setChecked(true);
                    continue block0;
                }
            }
        }
    }

    private void initTable() {
    }

    public void AddEvents() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    MyTable.this.selectAll();
                    MyTable.this.interfaceEvent.OnPressCtrlA();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){
            boolean bmousedown = false;

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                Point pt = new Point(e.x, e.y);
                int itemCnt = MyTable.this.getItemCount();
                for (int index = MyTable.this.getTopIndex(); index < itemCnt; ++index) {
                    TableItem item = MyTable.this.getItem(index);
                    for (int i = 0; i < MyTable.this.getColumnCount(); ++i) {
                        Rectangle rect = item.getBounds(i);
                        if (!rect.contains(pt)) continue;
                        if (i == 0) {
                            MyTable.this.interfaceEvent.OnclickIcon(item.getText(0), item.getText(2));
                            continue;
                        }
                        if (i == 1) {
                            MyTable.this.interfaceEvent.OnclickFileText(item.getText(0), item.getText(2));
                            continue;
                        }
                        MyTable.this.interfaceEvent.OnclickFileDetail(item.getText(0), item.getText(2), false);
                    }
                }
            }

            @Override
            public void mouseUp(MouseEvent e) {
                TableItem ti = MyTable.this.getItem(new Point(e.x, e.y));
                if (ti != null && ti.getBounds((int)0).x > e.x) {
                    TableItem item = MyTable.this.getItem(new Point(e.x, e.y));
                    boolean b = item.getChecked();
                    if (this.bmousedown) {
                        this.bmousedown = false;
                    } else {
                        b = !b;
                        item.setChecked(b);
                    }
                    System.out.println("item:" + item.getText() + (b ? " true" : " false"));
                    MyTable.this.interfaceEvent.onTableItemChecked(b, item.getText(0));
                }
                super.mouseUp(e);
            }

            @Override
            public void mouseDown(MouseEvent e) {
                TableItem ti = MyTable.this.getItem(new Point(e.x, e.y));
                if (ti != null && ti.getBounds((int)0).x > e.x) {
                    this.bmousedown = true;
                }
                super.mouseDown(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseScrolled(MouseEvent e) {
                if (MyTable.this.getItemCount() > 0) {
                    int currentTopIndex = MyTable.this.getTopIndex();
                    int itemsToScroll = -e.count * 1;
                    int newTopIndex = currentTopIndex + itemsToScroll;
                    if ((newTopIndex = Math.max(0, Math.min(newTopIndex, MyTable.this.getItemCount() - 1))) != currentTopIndex) {
                        MyTable.this.setTopIndex(newTopIndex);
                    }
                }
            }
        });
        this.addListener(41, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.index == 0 && event.height != UtilityClass.tableHeight + 2) {
                    event.height = UtilityClass.tableHeight + 2;
                }
            }
        });
        this.addListener(40, new Listener(){

            @Override
            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                Table table = (Table)event.widget;
                int clientWidth = table.getClientArea().width;
                GC gc = event.gc;
                Color oldBackground = gc.getBackground();
                gc.setBackground(ColorManager.GethighlightColor());
                gc.fillRectangle(0, event.y, clientWidth, event.height);
                if (UtilityClass.DebugMode) {
                    System.out.println("EraseItem::----height=" + event.height);
                }
                gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFFD;
            }
        });
        this.addListener(42, new Listener(){

            @Override
            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                if (event.index == 0) {
                    MyTable.this.strFilename = item.getText(0);
                    MyTable.this.DisplayIcon(event);
                } else if (event.index == 1) {
                    MyTable.this.strFilename = item.getText(0);
                    String desc = item.getText(event.index);
                    MyTable.this.DisplayFileSubstract(desc, event);
                } else if (event.index == 2) {
                    MyTable.this.strFilename = item.getText(0);
                    MyTable.this.DisplayFileInfo(event, item);
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                if (!pdfcolor.isDisposed()) {
                    pdfcolor.dispose();
                }
                if (!wordcolor.isDisposed()) {
                    wordcolor.dispose();
                }
                if (!xlscolor.isDisposed()) {
                    xlscolor.dispose();
                }
                if (!htmlcolor.isDisposed()) {
                    htmlcolor.dispose();
                }
                if (!visiocolor.isDisposed()) {
                    visiocolor.dispose();
                }
                if (!pptcolor.isDisposed()) {
                    pptcolor.dispose();
                }
                if (!docucolor.isDisposed()) {
                    docucolor.dispose();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DisplayIcon(Event event) {
        String fileExtension;
        File file = new File(this.strFilename);
        if (file.isDirectory()) {
            fileExtension = "dir";
        } else {
            fileExtension = UtilityClass.getFileExtension(this.strFilename);
            if (fileExtension.isEmpty()) {
                fileExtension = "nul";
            }
        }
        String iconFile = UtilityClass.getIconfromExtension(fileExtension);
        Display display = Display.getDefault();
        InputStream in = null;
        Image image = null;
        try {
            in = this.getClass().getResource(iconFile).openStream();
            image = new Image((Device)display, in);
            event.gc.drawImage(image, event.x + 1, event.y + 6);
            if (!iconFile.equals("newFolder.png")) {
                if (iconFile.equals("newPDF.png")) {
                    event.gc.setBackground(pdfcolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else if (iconFile.equals("newDoc.png") || iconFile.equals("newRTF.png")) {
                    event.gc.setBackground(wordcolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else if (iconFile.equals("newPST.png")) {
                    event.gc.setBackground(wordcolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else if (iconFile.equals("newExcel.png") || iconFile.equals("newcsv.png") || iconFile.equals("newMsg.png") || iconFile.equals("newEml.png")) {
                    event.gc.setBackground(xlscolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else if (iconFile.equals("newHtml.png") || iconFile.equals("xps.png")) {
                    event.gc.setBackground(htmlcolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else if (iconFile.equals("newVisio.png")) {
                    event.gc.setBackground(visiocolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else if (iconFile.equals("newPpt.png")) {
                    event.gc.setBackground(pptcolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else if (iconFile.equals("docuworks.png")) {
                    event.gc.setBackground(docucolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else if (iconFile.equals("ichitaro.png")) {
                    event.gc.setBackground(pdfcolor);
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                } else {
                    event.gc.setBackground(Display.getDefault().getSystemColor(16));
                    event.gc.setForeground(Display.getDefault().getSystemColor(2));
                }
                try {
                    event.gc.setForeground(ColorManager.GettextColor());
                    event.gc.drawText(fileExtension.toUpperCase(), event.x + 1, event.y + 1, true);
                    event.gc.setAlpha(100);
                    event.gc.fillRectangle(event.x + 1, event.y + 1, event.width, 20);
                }
                catch (SWTException e) {
                    event.gc.setForeground(ColorManager.GettextColor());
                    UtilityClass.OutputLogFile(e.getMessage());
                    event.gc.fillRectangle(event.x + 1, event.y + 1, event.width, 20);
                    event.gc.drawText(fileExtension.toUpperCase(), event.x + 1, event.y + 1, true);
                }
            }
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
        finally {
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    UtilityClass.OutputLogFile("Error closing image stream: " + e.getMessage());
                }
            }
        }
    }

    private void DisplayFileSubstract(String description, Event event) {
        String strKey;
        FontData[] fd = event.gc.getFont().getFontData();
        float oldFontHeight = fd[0].height;
        fd[0].height += 1.0f;
        String onlyFilename = UtilityClass.getFilename(this.strFilename);
        if (!description.isEmpty()) {
            int i;
            String strKey2;
            Font f = new Font((Device)Display.getDefault(), fd);
            event.gc.setFont(f);
            event.gc.setForeground(ColorManager.GettextColor());
            event.gc.drawText(onlyFilename, event.x + 1, event.y + 1, true);
            if (!this.interfaceEvent.isSearchContent() && !(strKey2 = this.interfaceEvent.getSearchKey()).isEmpty() && (i = FilenameUtils.getBaseName((String)onlyFilename).toLowerCase().lastIndexOf(strKey2.toLowerCase())) > -1) {
                Point pt0 = event.gc.textExtent(onlyFilename.substring(0, i));
                Point pt1 = event.gc.textExtent(onlyFilename.substring(i, i + strKey2.length()));
                event.gc.setForeground(ColorManager.GettextColor());
                int startx = event.x + 1 + pt0.x;
                int starty = event.y + 1;
                int endx = pt1.x;
                int endy = pt1.y;
                event.gc.setLineWidth(2);
                event.gc.drawLine(startx, starty + endy - 2, startx + endx, starty + endy - 2);
            }
            f.dispose();
        }
        event.gc.setForeground(ColorManager.GettextColor());
        fd[0].height = oldFontHeight;
        Font oldf = new Font((Device)Display.getDefault(), fd);
        event.gc.setFont(oldf);
        int pathStart_x = event.x + 1;
        int pathStart_y = event.y + 1;
        if (!description.isEmpty()) {
            if (description.startsWith("PageInfoExtracted")) {
                description = description.substring("PageInfoExtracted".length());
            }
            if (description.length() > 80) {
                event.gc.drawText(description.substring(0, 79), event.x + 1, event.y + 2 + event.gc.getFontMetrics().getHeight(), true);
                event.gc.drawText(description.substring(80, description.length()), event.x + 1, event.y + 1 + 2 * event.gc.getFontMetrics().getHeight(), true);
                pathStart_y = event.y + 3 * event.gc.getFontMetrics().getHeight();
            } else {
                event.gc.drawText(description, event.x + 1, event.y + 2 + event.gc.getFontMetrics().getHeight(), true);
                pathStart_y = event.y + 2 * event.gc.getFontMetrics().getHeight();
            }
        }
        event.gc.setForeground(ColorManager.GettextColor());
        event.gc.drawText(this.strFilename, pathStart_x, pathStart_y, true);
        if (description.isEmpty() && !this.interfaceEvent.isSearchContent() && !(strKey = this.interfaceEvent.getSearchKey()).isEmpty()) {
            int j = this.strFilename.lastIndexOf(".");
            int k = FilenameUtils.getName((String)this.strFilename).lastIndexOf(".");
            int i = -1;
            i = k > -1 ? this.strFilename.substring(0, j).toLowerCase().lastIndexOf(strKey.toLowerCase()) : this.strFilename.toLowerCase().lastIndexOf(strKey.toLowerCase());
            if (i > -1) {
                Point pt0 = event.gc.textExtent(this.strFilename.substring(0, i));
                Point pt1 = event.gc.textExtent(this.strFilename.substring(i, i + strKey.length()));
                event.gc.setForeground(ColorManager.GettextColor());
                int startx = pathStart_x + pt0.x;
                int starty = pathStart_y;
                int endx = pt1.x;
                int endy = pt1.y;
                event.gc.setLineWidth(2);
                event.gc.drawLine(startx, starty + endy - 2, startx + endx, starty + endy - 2);
            }
        }
        oldf.dispose();
    }

    private void DisplayFileInfo(Event event, TableItem item) {
        try {
            File file = new File(this.strFilename);
            String strTime = item.getText(event.index);
            String strDate = UtilityClass.getDatefromLong(Long.valueOf(strTime));
            FontData[] fd = event.gc.getFont().getFontData();
            Font oldf = new Font((Device)Display.getDefault(), fd);
            event.gc.setFont(oldf);
            event.gc.setForeground(ColorManager.GettextColor());
            String dateText = Mytranslator.getInstance().getTranslate("UpdatedDate") + strDate;
            String sizeText = Mytranslator.getInstance().getTranslate("Size") + UtilityClass.getFilesize(file);
            Point dateSize = event.gc.textExtent(dateText);
            Point sizeSize = event.gc.textExtent(sizeText);
            Rectangle cellBounds = item.getBounds(event.index);
            int rightEdge = cellBounds.x + cellBounds.width;
            event.gc.drawText(dateText, rightEdge - dateSize.x, event.y + 1, true);
            event.gc.drawText(sizeText, rightEdge - sizeSize.x, event.y + 1 + event.gc.getFontMetrics().getHeight(), true);
            oldf.dispose();
        }
        catch (Exception e) {
            UtilityClass.OutputLogFile(e.getMessage());
        }
    }
}

