/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;

public class MultiCollector
implements Collector {
    private final Collector[] collectors;

    public static Collector wrap(Collector ... collectors) {
        return MultiCollector.wrap(Arrays.asList(collectors));
    }

    public static Collector wrap(Iterable<? extends Collector> collectors) {
        int n = 0;
        for (Collector collector : collectors) {
            if (collector == null) continue;
            ++n;
        }
        if (n == 0) {
            throw new IllegalArgumentException("At least 1 collector must not be null");
        }
        if (n == 1) {
            Collector col = null;
            for (Collector collector : collectors) {
                if (collector == null) continue;
                col = collector;
                break;
            }
            return col;
        }
        Collector[] colls = new Collector[n];
        n = 0;
        for (Collector collector : collectors) {
            if (collector == null) continue;
            colls[n++] = collector;
        }
        return new MultiCollector(colls);
    }

    private MultiCollector(Collector ... collectors) {
        this.collectors = collectors;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        LeafCollector[] leafCollectors = new LeafCollector[this.collectors.length];
        for (int i = 0; i < this.collectors.length; ++i) {
            leafCollectors[i] = this.collectors[i].getLeafCollector(context);
        }
        return new MultiLeafCollector(leafCollectors);
    }

    private static class MultiLeafCollector
    implements LeafCollector {
        private final LeafCollector[] collectors;

        private MultiLeafCollector(LeafCollector[] collectors) {
            this.collectors = collectors;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            for (LeafCollector c : this.collectors) {
                c.setScorer(scorer);
            }
        }

        @Override
        public void collect(int doc) throws IOException {
            for (LeafCollector c : this.collectors) {
                c.collect(doc);
            }
        }
    }
}

