/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;

public class SortRescorer
extends Rescorer {
    private final Sort sort;

    public SortRescorer(Sort sort) {
        this.sort = sort;
    }

    @Override
    public TopDocs rescore(IndexSearcher searcher, TopDocs firstPassTopDocs, int topN) throws IOException {
        ScoreDoc[] hits = (ScoreDoc[])firstPassTopDocs.scoreDocs.clone();
        Arrays.sort(hits, new Comparator<ScoreDoc>(){

            @Override
            public int compare(ScoreDoc a, ScoreDoc b) {
                return a.doc - b.doc;
            }
        });
        List<LeafReaderContext> leaves = searcher.getIndexReader().leaves();
        TopFieldCollector collector = TopFieldCollector.create(this.sort, topN, true, true, true);
        int readerUpto = -1;
        int endDoc = 0;
        int docBase = 0;
        LeafCollector leafCollector = null;
        FakeScorer fakeScorer = new FakeScorer();
        for (int hitUpto = 0; hitUpto < hits.length; ++hitUpto) {
            ScoreDoc hit = hits[hitUpto];
            int docID = hit.doc;
            LeafReaderContext readerContext = null;
            while (docID >= endDoc) {
                readerContext = leaves.get(++readerUpto);
                endDoc = readerContext.docBase + readerContext.reader().maxDoc();
            }
            if (readerContext != null) {
                leafCollector = collector.getLeafCollector(readerContext);
                leafCollector.setScorer(fakeScorer);
                docBase = readerContext.docBase;
            }
            fakeScorer.score = hit.score;
            fakeScorer.doc = docID - docBase;
            leafCollector.collect(fakeScorer.doc);
        }
        return collector.topDocs();
    }

    @Override
    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        TopDocs oneHit = new TopDocs(1, new ScoreDoc[]{new ScoreDoc(docID, firstPassExplanation.getValue())});
        TopDocs hits = this.rescore(searcher, oneHit, 1);
        assert (hits.totalHits == 1);
        Explanation result = new Explanation(0.0f, "sort field values for sort=" + this.sort.toString());
        Explanation first = new Explanation(firstPassExplanation.getValue(), "first pass score");
        first.addDetail(firstPassExplanation);
        result.addDetail(first);
        FieldDoc fieldDoc = (FieldDoc)hits.scoreDocs[0];
        SortField[] sortFields = this.sort.getSort();
        for (int i = 0; i < sortFields.length; ++i) {
            result.addDetail(new Explanation(0.0f, "sort field " + sortFields[i].toString() + " value=" + fieldDoc.fields[i]));
        }
        return result;
    }
}

