/*
 * Decompiled with CFR 0.152.
 */
package ui;

import Interface.Mytranslator;
import biz.searchFolder;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ui.UtilityClass;

public class SearchPathDlg
extends Dialog {
    boolean bOKRet = false;
    private Shell shlOption;
    CTabFolder tabFolder;
    private int tabFolderWidth = 700;
    private int tabFolderHeight = 500;
    private searchFolder _sf;
    private Image addImage = null;
    private Image deleteImage = null;
    private Image resetImage = null;

    public SearchPathDlg(Shell parent, int style, searchFolder sf) {
        super(parent, style);
        this._sf = sf;
        this.InitResource(parent);
    }

    private void SetSearchFolderData() {
        this._sf.init();
        int iCnt = this.tabFolder.getItemCount();
        int iCurrent = this.tabFolder.getSelectionIndex();
        for (int i = 0; i < iCnt; ++i) {
            CTabItem tbm = this.tabFolder.getItem(i);
            TabContents tb = (TabContents)tbm.getData();
            String strIndex = tb.getIndexDataName();
            String strInclude = tb.getIncludePath();
            String strExclude = tb.getExcludePath();
            boolean active = tb.getActive();
            this._sf.initData(strIndex, strInclude, strExclude, active, false, tb.getReIndex() ? 1 : 0);
        }
        this._sf.setCurrentIndex(iCurrent);
    }

    private void InitResource(Shell shell) {
        try {
            InputStream in = this.getClass().getResource("addicon.gif").openStream();
            this.addImage = new Image((Device)shell.getDisplay(), in);
            in.close();
            in = this.getClass().getResource("reseticon.gif").openStream();
            this.resetImage = new Image((Device)shell.getDisplay(), in);
            in.close();
            in = this.getClass().getResource("deleteicon.gif").openStream();
            this.deleteImage = new Image((Device)shell.getDisplay(), in);
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ReleaseResource() {
        if (this.addImage != null) {
            this.addImage.dispose();
        }
        if (this.resetImage != null) {
            this.resetImage.dispose();
        }
        if (this.deleteImage != null) {
            this.deleteImage.dispose();
        }
    }

    public boolean open() {
        CTabItem tbtmNewItem;
        String strCaption = Mytranslator.getInstance().getTranslate("SearchPathDlg");
        Shell parent = this.getParent();
        this.shlOption = new Shell(parent, 65568);
        this.shlOption.setText(strCaption);
        FormLayout frmlayout = new FormLayout();
        frmlayout.marginLeft = 1;
        frmlayout.marginTop = 1;
        frmlayout.marginRight = 1;
        frmlayout.marginBottom = 1;
        this.shlOption.setLayout(frmlayout);
        this.tabFolder = new CTabFolder(this.shlOption, 2048);
        this.tabFolder.setSimple(false);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.tabFolder.setTabHeight(26);
        ToolBar toolBar = new ToolBar(this.tabFolder, 0x820000);
        ToolItem toolItem1 = new ToolItem(toolBar, 8);
        toolItem1.setText(Mytranslator.getInstance().getTranslate("Add"));
        if (this.addImage != null) {
            toolItem1.setImage(this.addImage);
        }
        ToolItem toolItem2 = new ToolItem(toolBar, 8);
        toolItem2.setText(Mytranslator.getInstance().getTranslate("Delete"));
        if (this.deleteImage != null) {
            toolItem2.setImage(this.deleteImage);
        }
        ToolItem toolItem3 = new ToolItem(toolBar, 8);
        toolItem3.setText(Mytranslator.getInstance().getTranslate("Reset"));
        if (this.resetImage != null) {
            toolItem3.setImage(this.resetImage);
        }
        this.tabFolder.setTopRight(toolBar);
        this.tabFolder.setTabHeight(Math.max(toolBar.computeSize((int)-1, (int)-1).y, this.tabFolder.getTabHeight()));
        Listener toolbarListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                ToolItem toolItem = (ToolItem)event.widget;
                String caption = toolItem.getText();
                if (Mytranslator.getInstance().getTranslate("Add").equals(caption)) {
                    CTabItem tbtmNewItem = new CTabItem(SearchPathDlg.this.tabFolder, 0);
                    TabContents tabContent = new TabContents(tbtmNewItem, "", null, null, true, 1);
                    tbtmNewItem.setData(tabContent);
                    SearchPathDlg.this.tabFolder.setSelection(tbtmNewItem);
                } else if (Mytranslator.getInstance().getTranslate("Delete").equals(caption)) {
                    int iItem = SearchPathDlg.this.tabFolder.getSelectionIndex();
                    int iCount = SearchPathDlg.this.tabFolder.getItemCount();
                    if (iCount <= 1) {
                        if (UtilityClass.DebugMode) {
                            System.out.println("can't delete last tab");
                        }
                        MessageBox messageBox = new MessageBox(SearchPathDlg.this.shlOption, 34);
                        messageBox.setText("Info");
                        messageBox.setMessage(Mytranslator.getInstance().getTranslate("LastTabDeleteNot"));
                        messageBox.open();
                    } else {
                        SearchPathDlg.this.tabFolder.getItem(iItem).dispose();
                    }
                } else {
                    int i = SearchPathDlg.this.tabFolder.getSelectionIndex();
                    if (UtilityClass.DebugMode) {
                        System.out.println("i=" + String.valueOf(i));
                    }
                    CTabItem tbm = SearchPathDlg.this.tabFolder.getItem(i);
                    tbm.setText("");
                    TabContents tb = (TabContents)tbm.getData();
                    tb.ResetList();
                }
            }
        };
        toolItem1.addListener(13, toolbarListener);
        toolItem2.addListener(13, toolbarListener);
        toolItem3.addListener(13, toolbarListener);
        for (int i = 0; i < this._sf.getIndexNumber(); ++i) {
            String strIndexname = this._sf.getIndexName(i);
            String strInclude = this._sf.getIncludeFolder(i);
            String strExclude = this._sf.getExcludeFolder(i);
            boolean enabled = this._sf.isEnable(i);
            int isDirty = this._sf.getDirty(i);
            tbtmNewItem = new CTabItem(this.tabFolder, 0);
            tbtmNewItem.setText(Mytranslator.getInstance().getTranslate("NewItem"));
            tbtmNewItem.setData(new TabContents(tbtmNewItem, strIndexname, strInclude, strExclude, enabled, isDirty));
        }
        if (this._sf.isEmpty()) {
            tbtmNewItem = new CTabItem(this.tabFolder, 0);
            tbtmNewItem.setText(Mytranslator.getInstance().getTranslate("NewItem"));
            tbtmNewItem.setData(new TabContents(tbtmNewItem, Mytranslator.getInstance().getTranslate("NewItem"), null, null, true, 1));
        }
        this.tabFolder.setSelection(this._sf.getCurrentIndex());
        Button btnCancel = new Button(this.shlOption, 0);
        btnCancel.setText(Mytranslator.getInstance().getTranslate("Cancel"));
        btnCancel.addListener(13, event -> {
            this.ReleaseResource();
            this.shlOption.close();
        });
        Button btnOK = new Button(this.shlOption, 0);
        btnOK.addListener(13, event -> {
            this.SetSearchFolderData();
            this._sf.replaceInvalidChar();
            if (this._sf.isIndexNameListEmpty()) {
                MessageBox messageBox = new MessageBox(this.shlOption, 34);
                messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                messageBox.setMessage(Mytranslator.getInstance().getTranslate("IndexNameListEmpty"));
                messageBox.open();
                return;
            }
            if (this._sf.isIndexPathListEmpty()) {
                MessageBox messageBox = new MessageBox(this.shlOption, 34);
                messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                messageBox.setMessage(Mytranslator.getInstance().getTranslate("IndexPathListEmpty"));
                messageBox.open();
                return;
            }
            if (!this._sf.isSizeCorrect()) {
                MessageBox messageBox = new MessageBox(this.shlOption, 34);
                messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                messageBox.setMessage(Mytranslator.getInstance().getTranslate("SizeCorrect"));
                messageBox.open();
                return;
            }
            String strErrPath = this._sf.IsIndexPathValid();
            if (!strErrPath.isEmpty()) {
                MessageBox messageBox = new MessageBox(this.shlOption, 34);
                messageBox.setText(Mytranslator.getInstance().getTranslate("Info"));
                messageBox.setMessage(Mytranslator.getInstance().getTranslate("IndexPathValid") + strErrPath);
                messageBox.open();
                return;
            }
            this.bOKRet = true;
            this.ReleaseResource();
            this.shlOption.close();
        });
        btnOK.setText("OK");
        Link lnkMapDrive = new Link(this.shlOption, 0);
        lnkMapDrive.setVisible(true);
        lnkMapDrive.addListener(13, event -> {
            try {
                String strCmd = "cmd /c start " + UtilityClass._MapDrive;
                Runtime.getRuntime().exec(strCmd);
                this.ReleaseResource();
                this.shlOption.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        lnkMapDrive.setText("<a>" + Mytranslator.getInstance().getTranslate("MapDrive") + "</a>");
        FormData formData = new FormData();
        formData.width = this.tabFolderWidth;
        formData.height = this.tabFolderHeight;
        this.tabFolder.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(this.tabFolder, 0, 0x1000000);
        formData.right = new FormAttachment(this.tabFolder, 0, 131072);
        toolBar.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(this.tabFolder, UtilityClass.scaleForDpi(10));
        lnkMapDrive.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(lnkMapDrive, 0, 0x1000000);
        formData.right = new FormAttachment(this.tabFolder, 0, 131072);
        formData.width = 80;
        btnCancel.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(lnkMapDrive, 0, 0x1000000);
        formData.width = 80;
        formData.left = new FormAttachment(btnCancel, -10 - formData.width, 16384);
        btnOK.setLayoutData(formData);
        this.shlOption.pack(true);
        Point parentPt = parent.getSize();
        Point parentLoc = parent.getLocation();
        Point shellPt = this.shlOption.getSize();
        this.shlOption.setLocation(parentLoc.x + parentPt.x / 2 - shellPt.x / 2, parentLoc.y + parentPt.y / 2 - shellPt.y / 2);
        this.shlOption.open();
        Display display = parent.getDisplay();
        while (!this.shlOption.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.bOKRet;
    }

    void CheckExpandedChildren(TreeItem ti, boolean state) {
        TreeItem[] items;
        if (ti.getExpanded() && (items = ti.getItems()) != null) {
            for (int i = 0; i < items.length; ++i) {
                TreeItem it = items[i];
                if (it.getData() == null || !(it instanceof TreeItem)) continue;
                TreeItem treeItem = it;
                treeItem.setChecked(state);
                this.CheckExpandedChildren(treeItem, state);
            }
        }
    }

    class TabContents {
        Text txtIndexData;
        CheckboxTreeViewer tv;
        CTabItem _tabItem;
        Text TxtInclude;
        Text TxtExclude;
        Button ChkActive;
        Button ChkReIndex;
        ArrayList<TreeItem> includeList = new ArrayList();
        ArrayList<TreeItem> excludeList = new ArrayList();

        public String getUniqueName(CTabFolder tabFold, CTabItem curItem, String strText) {
            for (CTabItem tabItem : tabFold.getItems()) {
                if (curItem == tabItem) continue;
                if (strText.isEmpty()) {
                    strText = tabItem.getText() + "_Data";
                    continue;
                }
                if (!strText.equalsIgnoreCase(tabItem.getText())) continue;
                strText = strText + "_Data";
            }
            return strText;
        }

        private void ActivateControls(boolean isEnable) {
            if (this.txtIndexData != null && !this.txtIndexData.isDisposed()) {
                this.txtIndexData.setEnabled(isEnable);
            }
            if (this.TxtInclude != null && !this.TxtInclude.isDisposed()) {
                this.TxtInclude.setEnabled(isEnable);
            }
            if (this.TxtExclude != null && !this.TxtExclude.isDisposed()) {
                this.TxtExclude.setEnabled(isEnable);
            }
            if (this.tv != null) {
                this.tv.getTree().setEnabled(isEnable);
            }
            if (this.ChkReIndex != null && !this.ChkReIndex.isDisposed()) {
                this.ChkReIndex.setEnabled(isEnable);
            }
        }

        private void initTree() {
            for (TreeItem ti : this.includeList) {
                ti.setChecked(false);
            }
            for (TreeItem ti : this.excludeList) {
                ti.setChecked(false);
            }
            this.includeList.clear();
            this.excludeList.clear();
        }

        public TabContents(CTabItem tbtmNewItem, String indexName, String strInclude, String strExclude, boolean bEnable, int bIsDirty) {
            this._tabItem = tbtmNewItem;
            FillLayout fillLayout = new FillLayout();
            fillLayout.type = 768;
            SearchPathDlg.this.tabFolder.setLayout(fillLayout);
            Composite composite_1 = new Composite(SearchPathDlg.this.tabFolder, 0);
            composite_1.setLayout(new FormLayout());
            Label lblNewLabel = new Label(composite_1, 0);
            lblNewLabel.setText(Mytranslator.getInstance().getTranslate("IndexName"));
            this.txtIndexData = new Text(composite_1, 2048);
            String strText = indexName;
            strText = this.getUniqueName(SearchPathDlg.this.tabFolder, tbtmNewItem, indexName);
            this.setIndexDataName(strText);
            this.txtIndexData.setMessage(Mytranslator.getInstance().getTranslate("SetIndexData"));
            this.txtIndexData.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        String strText = TabContents.this.txtIndexData.getText();
                        if (!strText.isEmpty()) {
                            String strInvalidChar = "[:\\\\/?/*<>\"]";
                            strText = strText.replaceAll(strInvalidChar, "_");
                            for (CTabItem tabItem : SearchPathDlg.this.tabFolder.getItems()) {
                                if (TabContents.this._tabItem == tabItem || !strText.equalsIgnoreCase(tabItem.getText())) continue;
                                strText = strText + "_Data";
                            }
                        }
                        TabContents.this.txtIndexData.setText(strText);
                        TabContents.this._tabItem.setText(strText);
                    }
                }
            });
            this.ChkActive = new Button(composite_1, 32);
            this.ChkActive.addListener(13, event -> {
                String strTextt = this.ChkActive.getText();
                if (Mytranslator.getInstance().getTranslate("Active").equals(strTextt)) {
                    this.ChkActive.setText(Mytranslator.getInstance().getTranslate("Deactive"));
                    this.ActivateControls(true);
                    this.ChkReIndex.setSelection(true);
                } else {
                    this.ChkActive.setText(Mytranslator.getInstance().getTranslate("Active"));
                    this.ActivateControls(false);
                    this.ChkReIndex.setSelection(false);
                }
            });
            this.ChkReIndex = new Button(composite_1, 32);
            this.ChkReIndex.setText(Mytranslator.getInstance().getTranslate("DlgBtnReIndex"));
            this.tv = new CheckboxTreeViewer(composite_1, 2048);
            Tree tree = this.tv.getTree();
            DropTarget target = new DropTarget(tree, 17);
            FileTransfer fileTransfer = FileTransfer.getInstance();
            Transfer[] tt = new Transfer[]{fileTransfer};
            target.setTransfer(tt);
            target.addDropListener(new DropTargetAdapter(){

                @Override
                public void dragEnter(DropTargetEvent evt) {
                    evt.detail = 1;
                }

                @Override
                public void drop(DropTargetEvent evt) {
                    String[] files;
                    for (String dropFile : files = (String[])evt.data) {
                        TabContents.this.dropFiletoTreeView(dropFile);
                    }
                }
            });
            this.tv.setContentProvider((IContentProvider)new FileTreeContentProvider());
            this.tv.setLabelProvider((IBaseLabelProvider)new FileTreeLabelProvider());
            this.tv.setInput((Object)"root");
            Label includeText = new Label(composite_1, 2048);
            this.TxtInclude = new Text(composite_1, 2048);
            this.TxtInclude.setMessage(Mytranslator.getInstance().getTranslate("DoDrop"));
            this.TxtInclude.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        for (TreeItem it : TabContents.this.includeList) {
                            it.setChecked(false);
                        }
                        TabContents.this.initTree();
                        String str = TabContents.this.TxtInclude.getText().trim();
                        if (UtilityClass.DebugMode) {
                            System.out.println("--" + str);
                        }
                        if (str.contains(";")) {
                            String[] dropfiles;
                            for (String aFile : dropfiles = str.split(";")) {
                                TabContents.this.dropFiletoTreeView(aFile);
                            }
                        } else {
                            TabContents.this.dropFiletoTreeView(str);
                        }
                    }
                }
            });
            Label excludeText = new Label(composite_1, 2048);
            this.TxtExclude = new Text(composite_1, 2048);
            this.TxtExclude.setEditable(false);
            includeText.setText(Mytranslator.getInstance().getTranslate("JIAN_FULL"));
            excludeText.setText(Mytranslator.getInstance().getTranslate("PAI_FULL"));
            tbtmNewItem.setControl(composite_1);
            this.InitIncludeExcludeList(strInclude, strExclude);
            this.tv.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    TreeItem ti = (TreeItem)TabContents.this.tv.testFindItem(event.getElement());
                    TabContents.this.In_Ex_cludeItem(ti, event.getChecked());
                    if (ti.getExpanded()) {
                        SearchPathDlg.this.CheckExpandedChildren(ti, event.getChecked());
                    }
                }
            });
            this.tv.addTreeListener(new ITreeViewerListener(){

                public void treeCollapsed(TreeExpansionEvent arg0) {
                }

                public void treeExpanded(TreeExpansionEvent arg0) {
                    TreeItem ti = (TreeItem)TabContents.this.tv.testFindItem(arg0.getElement());
                    TreeItem[] items = ti.getItems();
                    if (items != null) {
                        for (int i = 0; i < items.length; ++i) {
                            TreeItem it = items[i];
                            if (it.getData() == null || !(it instanceof TreeItem)) continue;
                            TreeItem treeItem = it;
                            if (ti.getChecked()) {
                                if (TabContents.this.excludeList.contains(treeItem)) continue;
                                treeItem.setChecked(true);
                                continue;
                            }
                            if (TabContents.this.includeList.contains(treeItem)) continue;
                            treeItem.setChecked(false);
                        }
                    }
                }
            });
            if (bEnable) {
                this.ChkActive.setText(Mytranslator.getInstance().getTranslate("Deactive"));
                this.ChkActive.setSelection(false);
                this.ActivateControls(true);
            } else {
                this.ChkActive.setText(Mytranslator.getInstance().getTranslate("Active"));
                this.ChkActive.setSelection(true);
                this.ActivateControls(false);
            }
            this.ChkReIndex.setSelection(bIsDirty == 1);
            FormData formData = new FormData();
            lblNewLabel.setLayoutData(formData);
            formData = new FormData();
            formData.top = new FormAttachment(lblNewLabel, 0, 0x1000000);
            formData.right = new FormAttachment(100, 0);
            this.ChkReIndex.setLayoutData(formData);
            formData = new FormData();
            formData.top = new FormAttachment(lblNewLabel, 0, 0x1000000);
            formData.right = new FormAttachment(this.ChkReIndex, -10, 16384);
            this.ChkActive.setLayoutData(formData);
            formData = new FormData();
            formData.top = new FormAttachment(lblNewLabel, 0, 0x1000000);
            formData.right = new FormAttachment(this.ChkActive, -10, 16384);
            formData.left = new FormAttachment(lblNewLabel, 10, 131072);
            this.txtIndexData.setLayoutData(formData);
            formData = new FormData();
            formData.bottom = new FormAttachment(100, -5);
            excludeText.setLayoutData(formData);
            formData = new FormData();
            formData.top = new FormAttachment(excludeText, 0, 0x1000000);
            formData.left = new FormAttachment(excludeText, 10, 131072);
            formData.right = new FormAttachment(100, 0);
            this.TxtExclude.setLayoutData(formData);
            formData = new FormData();
            formData.bottom = new FormAttachment(excludeText, -10, 128);
            includeText.setLayoutData(formData);
            formData = new FormData();
            formData.top = new FormAttachment(includeText, 0, 0x1000000);
            formData.left = new FormAttachment(includeText, 10, 131072);
            formData.right = new FormAttachment(100, 0);
            this.TxtInclude.setLayoutData(formData);
            formData = new FormData();
            formData.top = new FormAttachment(lblNewLabel, 2);
            formData.left = new FormAttachment(lblNewLabel, 0, 16384);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment(includeText, -5, 128);
            tree.setLayoutData(formData);
        }

        TreeItem dropFiletoTreeView(String dropFile) {
            File file = new File(dropFile);
            TreeItem tis = null;
            if (file.isDirectory() && file.exists()) {
                if (UtilityClass.DebugMode) {
                    System.out.println(dropFile);
                }
                TreeItem ti = this.findTreeItemByFolderName(dropFile);
                this.tv.getTree().setSelection(ti);
                if (!ti.getChecked()) {
                    this.In_Ex_cludeItem(ti, true);
                    ti.setExpanded(false);
                    ti.setChecked(true);
                }
                tis = ti;
            } else {
                MessageBox messageBox = new MessageBox(SearchPathDlg.this.shlOption, 34);
                messageBox.setText("Info");
                messageBox.setMessage(Mytranslator.getInstance().getTranslate("FolderNotExist") + " " + dropFile);
                messageBox.open();
            }
            return tis;
        }

        void InitIncludeExcludeList(String strIncludeList, String strExcludeList) {
            this._InitTreeItemList(strIncludeList, this.includeList, true);
            if (strExcludeList != null && !strExcludeList.isEmpty()) {
                this._InitTreeItemList(strExcludeList, this.excludeList, false);
            }
            this.tv.collapseAll();
            if (strIncludeList == null) {
                this.TxtInclude.setText("");
            } else {
                this.TxtInclude.setText(strIncludeList);
            }
            if (strExcludeList == null) {
                this.TxtExclude.setText("");
            } else {
                this.TxtExclude.setText(strExcludeList);
            }
        }

        private TreeItem findTreeItemByFolderName(String pathname) {
            File filemember;
            File file = new File(pathname);
            Stack<File> tempFileStack = new Stack<File>();
            tempFileStack.push(file);
            while (file.getParentFile() != null) {
                file = file.getParentFile();
                tempFileStack.push(file);
            }
            int size = tempFileStack.size();
            TreeItem ti = null;
            for (int i = 0; i < size && (ti = (TreeItem)this.tv.testFindItem((Object)(filemember = (File)tempFileStack.pop()))) != null; ++i) {
                if (i >= size - 1) continue;
                this.tv.expandToLevel((Object)filemember, 1);
            }
            return ti;
        }

        private void _InitTreeItemList(String pathString, ArrayList<TreeItem> arraylist, boolean bcheck) {
            String[] path;
            if (pathString == null || pathString.isEmpty()) {
                return;
            }
            for (String pathname : path = pathString.split(";")) {
                TreeItem ti = this.findTreeItemByFolderName(pathname);
                if (ti == null) continue;
                ti.setExpanded(false);
                this.tv.getTree().setSelection(ti);
                arraylist.add(ti);
                if ((!bcheck || ti.getChecked()) && (bcheck || !ti.getChecked())) continue;
                ti.setChecked(bcheck);
            }
        }

        private void In_Ex_cludeItem(TreeItem ti, boolean state) {
            boolean bCurItemBeforeState = !state;
            TreeItem parentItem = ti.getParentItem();
            if (parentItem != null && parentItem.getChecked()) {
                if (bCurItemBeforeState) {
                    this.RemoveChildren(ti, this.includeList);
                    this.RemoveChildren(ti, this.excludeList);
                    this.excludeList.add(ti);
                    this.displaylist(this.includeList, true);
                    this.displaylist(this.excludeList, false);
                } else {
                    this.RemoveChildren(ti, this.includeList);
                    this.RemoveChildren(ti, this.excludeList);
                    this.excludeList.remove(ti);
                    this.displaylist(this.includeList, true);
                    this.displaylist(this.excludeList, false);
                }
            } else if (bCurItemBeforeState) {
                this.RemoveChildren(ti, this.includeList);
                this.RemoveChildren(ti, this.excludeList);
                this.includeList.remove(ti);
                this.displaylist(this.includeList, true);
                this.displaylist(this.excludeList, false);
            } else {
                this.RemoveChildren(ti, this.includeList);
                this.RemoveChildren(ti, this.excludeList);
                this.includeList.add(ti);
                this.displaylist(this.includeList, true);
                this.displaylist(this.excludeList, false);
            }
        }

        void RemoveChildren(TreeItem parentItem, ArrayList<TreeItem> list) {
            ArrayList<TreeItem> excludelistdelete = new ArrayList<TreeItem>();
            for (TreeItem tChild : list) {
                if (!this.IsParent(parentItem, tChild)) continue;
                excludelistdelete.add(tChild);
            }
            list.removeAll(excludelistdelete);
        }

        private boolean IsParent(TreeItem parentItem, TreeItem childItem) {
            if (childItem.getParentItem() == null) {
                return false;
            }
            if (childItem.getParentItem() == parentItem) {
                return true;
            }
            return this.IsParent(parentItem, childItem.getParentItem());
        }

        private void displaylist(ArrayList<TreeItem> arrlist, boolean isIncludeArray) {
            String str = "";
            for (TreeItem telement : arrlist) {
                str = str + ((File)telement.getData()).getAbsolutePath();
                str = str + ";";
            }
            if (str.endsWith(";")) {
                str = str.substring(0, str.length() - 1);
            }
            if (isIncludeArray) {
                this.TxtInclude.setText(str);
            } else {
                this.TxtExclude.setText(str);
            }
        }

        private void ResetList() {
            for (TreeItem item : this.includeList) {
                item.setChecked(false);
            }
            this.excludeList.clear();
            this.includeList.clear();
            this.TxtInclude.setText("");
            this.TxtExclude.setText("");
            this.txtIndexData.setText("");
            this.tv.collapseAll();
        }

        public CTabItem getIabItem() {
            return this._tabItem;
        }

        public String getIndexDataName() {
            return this.txtIndexData.getText();
        }

        public void setIndexDataName(String str) {
            this.txtIndexData.setText(str);
            this._tabItem.setText(str);
        }

        public String getIncludePath() {
            return this.TxtInclude.getText();
        }

        public String getExcludePath() {
            return this.TxtExclude.getText();
        }

        public boolean getActive() {
            return !this.ChkActive.getSelection();
        }

        public boolean getReIndex() {
            return this.ChkReIndex.getSelection();
        }
    }

    class FileTreeLabelProvider
    implements ILabelProvider {
        private List listeners = new ArrayList();
        private Image dir;

        public FileTreeLabelProvider() {
            try {
                this.dir = new Image((Device)Display.getCurrent(), this.getClass().getResource("folder20.png").openStream());
            }
            catch (Exception e) {
                UtilityClass.OutputLogFile(e.getMessage());
            }
        }

        public Image getImage(Object arg0) {
            return this.dir;
        }

        public String getText(Object arg0) {
            String text = ((File)arg0).getName();
            if (text.length() == 0) {
                text = ((File)arg0).getPath();
            }
            return text;
        }

        public void addListener(ILabelProviderListener arg0) {
            this.listeners.add(arg0);
        }

        public void dispose() {
            if (this.dir != null) {
                this.dir.dispose();
            }
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
            this.listeners.remove(arg0);
        }
    }

    class FileTreeContentProvider
    implements ITreeContentProvider {
        FileTreeContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            File[] fileArray = ((File)arg0).listFiles();
            ArrayList<File> subfolderlist = new ArrayList<File>();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isDirectory()) continue;
                    subfolderlist.add(fileArray[i]);
                }
                if (!subfolderlist.isEmpty()) {
                    Object[] stylearrays = new File[subfolderlist.size()];
                    subfolderlist.toArray(stylearrays);
                    return stylearrays;
                }
            }
            return null;
        }

        public Object getParent(Object arg0) {
            return ((File)arg0).getParentFile();
        }

        public boolean hasChildren(Object arg0) {
            File[] fileArray = ((File)arg0).listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isDirectory()) continue;
                    return true;
                }
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            return File.listRoots();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }
}

